/* @(#) dk.h 1.1@(#) Solbourne id 9/21/93 23:48:49 */
/*
 * Copyright 1990 Solbourne Computer, Inc.
 * All rights reserved.
 */

/*	@(#)dk.h 2.8 88/08/19 SMI; from UCB 4.2 81/02/19	*/

/*
 * Instrumentation
 */

#ifndef _sys_dk_h
#define _sys_dk_h

#define	CPUSTATES	4

#define	CP_USER		0
#define	CP_NICE		1
#define	CP_SYS		2
#define	CP_IDLE		3

#ifdef	MULTIPROCESSOR
/*
 * Extended Processor Status Detail
 */
#define	XPSTATES	8	/* lots of room for expansion */
#define	XP_SPIN		0	/* blocked on kernel lock */
#define	XP_DISK		1	/* idle with disk active */
#define	XP_SERV		2	/* in crosscall service loop */
#ifdef	solbourne
#define	XP_L2_REFS	3
#define	XP_L2_HITS	4
#define	XP_L3_REFS	5
#define	XP_L3_HITS	6
#endif	solbourne
#endif	MULTIPROCESSOR

#ifdef	solbourne
/* 
 * Keep stats on lots of disks inside the kernel. Outside the kernel 
 * this define can not be changed without breaking rstatd.  iostat reads
 * the kernel variable dk_ndrive to deternine how many drives there are.
 * any other utility that want more than the first 10 drives needs to 
 * do the same.  Drives that are configured in the kernel but are not
 * found at bootup still take a slot so that dynamic attach stuff will work.
 * NOTE: sun changed this from 10 to 32 in 4.1.2, this should break rup-
 * we will be compatible...
 */
#ifdef	KERNEL
#define	DK_NDRIVE	256
#else	KERNEL
#define	DK_NDRIVE	32
#endif	KERNEL
#else	solbourne
#define	DK_NDRIVE	32
#endif	solbourne

#ifdef KERNEL

long	cp_time[CPUSTATES];

#ifdef solbourne
long	cp_mp_time[MAXNCPUS][CPUSTATES];
#endif solbourne

#ifdef	MULTIPROCESSOR
#include <machine/param.h>		/* to get NCPU */
long	mp_time[NCPU][CPUSTATES];	/* holds actual ticks for all cpus */
long	xp_time[NCPU][XPSTATES];	/* extended cpu states */
#endif	MULTIPROCESSOR

int	dk_busy;
#ifdef	solbourne
#define	DK_BUSY_BITS	DK_NDRIVE		/* number of drives */
/* NOTE: only use one drive per byte to avoid needing a lock for writers! */
char	dk_busy_bits[DK_BUSY_BITS];
#define	DK_BUSY_BITS_SET(b) {						\
	    if ((b) < 32) dk_busy |= (1 << (b));			\
	    dk_busy_bits[(b)] = 1;}
#define	DK_BUSY_BITS_CLR(b) {						\
	    if ((b) < 32) dk_busy &= ~(1 << (b));			\
	    dk_busy_bits[(b)] = 0;}
#define	DK_BUSY_BITS_ISSET(b)	(dk_busy_bits[(b)])
#endif	solbourne

long	dk_time[DK_NDRIVE];
long	dk_seek[DK_NDRIVE];
long	dk_xfer[DK_NDRIVE];
long	dk_wds[DK_NDRIVE];
long	dk_bps[DK_NDRIVE];
long	dk_read[DK_NDRIVE];

long	tk_nin;
long	tk_nout;
#endif

#endif /*!_sys_dk_h*/
