/* @(#) if_fddi.h 1.1@(#) Solbourne id 9/21/93 23:30:01 */
/*
 * Copyright 1990 Solbourne Computer, Inc.
 * All rights reserved.
 */

#ifndef	_if_if_fddi_h
#define	_if_if_fddi_h

#include <netinet/if_ether.h>
#include <if/if_llc.h>

/*
 * FDDI address - 6 octets, clone ethernet definitions
 */
#define	fddi_addr	ether_addr
#define fddi_addr_octet	ether_addr_octet
#define fddi_arp	ether_arp			/* protocol */
#define	fddi_sprintf	ether_sprintf
#define	fddi_copy	ether_copy
#define	fddi_error	ether_error
#define	fddi_attach	ether_attach

/*
 * Structure of a 100Mb/s FDDI header.
 */
struct	fddi_header {
    u_char		fddi_pad[3];	/* preambl(2), start_del (PSEUDO) */
    u_char		fddi_type;	/* frame_ctl */
#define	FDDI_TYPE_FRAME_CTL_MSK	0xFF /* default type for async */
#define	FDDI_TYPE_ASYNC_LOWEST	0x50 /* default type for async */
#define	FDDI_TYPE_ASYNC_HIGHEST	0x57
#define	FDDI_TYPE_SMT_4F	0x4F
#define	FDDI_TYPE_SMT_41	0x41
    struct fddi_addr	fddi_dhost;
    struct fddi_addr	fddi_shost;
    struct llc_snap_hdr	fddi_snap;
};

struct fddi_mac_header {
	u_long	fddi_type;
	struct	fddi_addr fddi_dhost;
	struct	fddi_addr fddi_shost;
};

#define	FDDI_HEADER_SZ	(4 + 6 + 6 + LLC_SNAP_HDR_LEN)

#define	FDDI_MAX_F_SZ	4500	/* Maximum frame size */
#define	FDDI_POST_SZ	6	/* FCS(4) + end delim/frame status */

#define	FDDIMTU		(4096+256) /* Per RFC 1188 */
#define	FDDIMIN		0

/*
 * Copies from src to dst for len bytes, doing a bit swap on the bits.
 * Thus bit 1 for each byte of src becomes bit 8 of each byte of dst, etc
 */
extern u_char fddi_bitswaptbl[256];

#define fddi_bitswapcopy(src, dst, len) {				\
	register int __i = (len);					\
	register u_char *__s = (u_char *)(src), *__d = (u_char *)(dst);	\
	while (--__i >= 0)						\
		*__d++ = fddi_bitswaptbl[*__s++];			\
}

#define	fddi_addr_convert(addr)						\
	fddi_bitswapcopy((addr), (addr), sizeof(struct fddi_addr))

#endif	_if_if_fddi_h
