#ifndef lint
static char *Solbourne_id =
"@(#) stconf.c 1.1@(#) Solbourne id 9/22/93 00:08:32\n";
#endif
/*
 * Copyright 1988 Solbourne Computer, Inc.
 * All rights reserved.
 */

#include <sys/param.h>
#include <sys/types.h>
#include <sys/buf.h>
#include <mfg/dkio.h>
#include <sys/mtio.h>
#include <dev/scsivar.h>
#include <dev/stvar.h>

#include "st.h"

#if NST > 0
/* tape target specific error codes */
char *st_hp_err[] = {
	"\003write fault",		/* 0x03 */
	"\004drive not ready",		/* 0x04 */
	"\005drive not selected",	/* 0x05 */
	"\010logical unit fault",	/* 0x08 */
	"\012error log overflow",	/* 0x0a */
	"\013time-out error",		/* 0x0b */
	"\015soft write error",		/* 0x0d */
	"\016soft interface error",	/* 0x0e */
	"\021hard read error",		/* 0x11 */
	"\023space command error",	/* 0x13 */
	"\024no record found",		/* 0x14 */
	"\025locate error",		/* 0x15 */
	"\027soft read error",		/* 0x17 */
	"\030soft write error",		/* 0x18 */
	"\032parameter overrun",	/* 0x1a */
	"\033synch. xfer error",	/* 0x1b */
	"\035verify error",		/* 0x1d */
	"\037hard write error",		/* 0x1f */
	"\040invalid command",		/* 0x20 */
	"\041invalid block address",	/* 0x21 */
	"\043space cmd error",		/* 0x23 */
	"\045invalid cdb lun",		/* 0x25 */
	"\046invalid cdb field",	/* 0x26 */
	"\047write protected",		/* 0x27 */
	"\050media changed",		/* 0x28 */
	"\051drive reset",		/* 0x29 */
	"\052mode select changed",	/* 0x2a */
	"\053block length error",	/* 0x2b */
	"\054cmd sequence error",	/* 0x2c */
	"\055overwrite error",		/* 0x2d */
	"\056blank tape error",		/* 0x2e */
	"\060unknown tape format",	/* 0x30 */
	"\061format failed",		/* 0x31 */
	"\063tape length error",	/* 0x33 */
	"\064invalid cdb",		/* 0x34 */
	"\065undetected ecc error",	/* 0x35 */
	"\066no gap found",		/* 0x36 */
	"\067miscorrected error",	/* 0x37 */
	"\070block sequence error",	/* 0x38 */
	"\071tape not ready",		/* 0x39 */
	"\072no tape installed",	/* 0x3a */
	"\073tape position error",	/* 0x3b */
	0
};

char *st_emulex_err[] = {
	"\004drive not ready",		/* 0x04 */
	"\011no tape",			/* 0x09 */
	"\012tape too short",		/* 0x0a */
	"\013drive timeout",		/* 0x0b */
	"\021hard data error",		/* 0x11 */
	"\024block not found",		/* 0x14 */
	"\026dma timeout",		/* 0x16 */
	"\027write protected",		/* 0x17 */
	"\030soft data error",		/* 0x18 */
	"\031bad block",		/* 0x19 */
	"\034file mark detected",	/* 0x1c */
	"\035compare error",		/* 0x1d */
	"\040invalid command",		/* 0x20 */
	"\060unit attention",		/* 0x30 */
	"\061command timeout",		/* 0x31 */
	"\063append error",		/* 0x33 */
	"\064end-of-media",		/* 0x34 */
	0
};

/* tape target specific error rate log formats */
/*
 * Tape error rate log (HP-88780).
 */
struct st_log_hp {
	u_char	page_code;	/* Page code */
	u_char	length[2];	/* Page length */
	u_char	entry_num;	/* Current entry number */
	u_char	log_entries;	/* Number of log entries */
	u_char	rsvd1;		/* Currently displayed log */
	u_char	density;	/* Density */
	u_char	wr_hard[2];	/* Write hard errors */
	u_char	wr_soft[2];	/* Write soft errors */
	u_char	wr_data[6];	/* Data bytes written */
	u_char	rd_hard[2];	/* Read hard errors */
	u_char	rd_soft[2];	/* Read soft errors */
	u_char	rd_data[6];	/* Data bytes read */
	u_char	rsvd2;		/* For even byte alignment */
};

/* tape configuration/capability table */
struct st_tp	st_tp[] = {

#ifdef	template
    {"vendor/model device",	vendor/model_match_length,	
	Drive type string,	MT_drive_type,	TP_MEDIA_type,
	TP_FLAGS_*,
	kdump_density,	#file_marks,	max_retries,
	bsize_den0,	bsize_den1,	bsize_den2,	bsize_den3,
	rd_den0_code,	rd_den1_code,	rd_den2_code,	rd_den3_code,	
	wr_den0_code,	wr_den1_code,	wr_den2_code,	wr_den3_code,	
	low_speed, hi_speed, rew_t, seek_t, erase_t, max_rec_size, dev_code }
#endif	template

/* Supported Drives... */
    {"ARCHIVE VIPER 150",	8+9,	
	0,			MT_ISVIPER1,	TP_MEDIA_QIC,
	TP_FLAGS_FIXED|TP_FLAGS_RETEN|TP_FLAGS_PREVENT,
	1,	1,	400,
	512,	512,	512,	512,
	0x00,	0x00,	0x00,	0x00,	
	0x00,	0x00,	0x00,	0x00,	
	0,	0,	10,	30,	30,	0,		0},
    {"ARCHIVE VIPER 60",	8+8,	
	0,			MT_ISVIPER2,	TP_MEDIA_QIC,
	TP_FLAGS_FIXED|TP_FLAGS_RETEN|TP_FLAGS_PREVENT|TP_FLAGS_NOAUTO,
	1,	1,	130,
	512,	512,	512,	512,
	0x00,	0x00,	0x00,	0x00,	
	0x04,	0x05,	0x04,	0x05,	
	0,	0,	10,	30,	30,	0,		0},
    {"EXABYTE EXB-82",		14,	
	0,			MT_ISEXABYTE,	TP_MEDIA_RDAT,
	TP_FLAGS_BSF|TP_FLAGS_BSR,
	0,	1,	60000,			/* 3% error rate on tape */
	0,	0,	0,	0,
	0x00,	0x00,	0x00,	0x00,	
	0x00,	0x00,	0x00,	0x00,	
	0,	0,	10,	30,	3*60,	0,		0},
    {"HP      ",		8,	
	0,			MT_ISHP,	TP_MEDIA_REEL,
	TP_FLAGS_BSF|TP_FLAGS_BSR,
	1,	2,	400,
	0,	0,	0,	0,
	0x02,	0x03,	0x01,	0xC3,
	0x02,	0x03,	0x01,	0xC3,
	0,	0,	10,	30,	30,	0,		st_hp_err},
    {"EXABYTE EXB-85",		14,
	0,			MT_ISEXABYTE2,	TP_MEDIA_RDAT,
	TP_FLAGS_BSF|TP_FLAGS_BSR,
	0,	1,	80000,			/* 4% error rate on tape */
	0,	0,	0,	0,
	0x00,	0x00,	0x00,	0x00,	
	0x14,   0x15,   0x90,   0x8C,           /* write density: 14 == 8200 */
			/* 8200-compression */
			        /* 8500-compression */
	0,	0,	10,	30,	3*60,	0,		0},

/* Non-Supported Drives... */
    {"\000\000",	2,	
	"EMULEX MT02 Q11/Q24",	MT_ISMT02,	TP_MEDIA_QIC,
	TP_FLAGS_FIXED|TP_FLAGS_RETEN|TP_FLAGS_PREVENT,
	1,	1,	130,
	512,	512,	512,	512,
	0x04,	0x05,	0x04,	0x05,	
	0x04,	0x05,	0x04,	0x05,	
	0,	0,	10,	30,	30,	0,		st_emulex_err},
    {"WANGTEK ",		8,	
	0,			MT_ISWANGTEK1,	TP_MEDIA_QIC,
	TP_FLAGS_FIXED|TP_FLAGS_RETEN|TP_FLAGS_DEN_SENSE|TP_FLAGS_PREVENT,
	1,	1,	400,
	512,	512,	512,	512,
	0x00,	0x00,	0x00,	0x00,	
	0x00,	0x00,	0x00,	0x00,	
	0,	0,	10,	30,	30,	0,		0},
    {"M4 DATA ",		8,			/* StorageTek 9914 */
	0,			MT_ISSTK1,	TP_MEDIA_REEL,
	TP_FLAGS_BSF|TP_FLAGS_BSR|TP_FLAGS_BIG_REC,
	1,	2,	400,
	0,	0,	0,	0,
	0x02,	0x03,	0x01,	0x06,
	0x02,	0x03,	0x01,	0x06,
	0,	0,	10,	30,	30,	0x0ffffff,	0},
    {"STK     ",                8,			/* StorageTek 4280 */
	0,                      MT_ISSTK2,	TP_MEDIA_LCM,
	TP_FLAGS_BSF|TP_FLAGS_BSR|TP_FLAGS_REW_IMM,
	0,      2,      400,
	0,	0,	0,	0,
	0x00,   0x00,   0x00,   0x00,
	0x00,   0x00,   0x00,   0x00,
	0,      0,      10,     30,     30,     0/*0x07cff3*/,	0},
    {"FUJITSU ",                4,
	0,                      MT_ISFUJI,	TP_MEDIA_LCM,
	TP_FLAGS_BSF|TP_FLAGS_BSR|TP_FLAGS_REW_IMM,
	0,      2,      400,
	0,	0,	0,	0,
	0x00,   0x00,   0x00,   0x00,
	0x00,   0x00,   0x00,   0x00,
	0,      0,      10,     30,     30,     0/*0x03fffb*/,	0},
    {"ARCHIVE VIPER 2320",	8+10,	
	0,			MT_ISVIPER1,	TP_MEDIA_QIC,
	TP_FLAGS_FIXED|TP_FLAGS_RETEN|TP_FLAGS_PREVENT,
	1,	1,	400,
	/*Q24	Q120	Q150	Q525*/
	512,	512,	512,	1024,
	0x05,	0x0F,	0x10,	0x11,	
	0x05,	0x0F,	0x10,	0x11,	
	0,	0,	10,	30,	30,	0,		0},
    {"WangDAT Model 2600",		18,
	0,			MT_ISRDAT_W,	TP_MEDIA_RDAT,
	TP_FLAGS_BSF|TP_FLAGS_BSR|TP_FLAGS_RETEN|TP_FLAGS_PREVENT,
	0,	1,	30000,			/* 3% error rate on tape */
	0,	0,	0,	0,
	0x00,	0x00,	0x00,	0x00,	
	0x00,	0x00,	0x00,	0x00,	
	0,	0,	10,	30,	3*60,	0,		0},
    {"ARCHIVE Python 25501",		20,
	0,			MT_ISRDAT_A,	TP_MEDIA_RDAT,
	TP_FLAGS_BSF|TP_FLAGS_BSR|TP_FLAGS_RETEN|TP_FLAGS_PREVENT,
	0,	1,	30000,			/* 3% error rate on tape */
	0,	0,	0,	0,
	0x00,	0x00,	0x00,	0x00,	
	0x00,	0x00,	0x00,	0x00,	
	0,	0,	10,	30,	3*60,	0,		0},
};

/* patch st_retry_limit to 1 to see all soft errors */
int	st_retry_limit = 0;

/* 
 * define max. record blocking.
 */
int	max_st_dev_size = MAX_ST_DEV_SIZE;

/*
 * The routines are used to handle things which tend to be very vendor unique.
 */
extern struct scsi_tape		stape[];

/* 
 * Return the retry count from device maintained error log, or sense information
 * Called when closing the device.  scsi_get_sbuf has already been called!
 */
st_get_retries(dev, un, reset)
register struct scsi_unit	*un;
{
	register struct scsi_tape	*st = &stape[un->un_unit];
	register struct un_cmd		*cmd = &un->un_special_cmd;
	int				ret = st->st_mtget.mt_dsreg;
	struct st_log_hp		*log = 0;
	union scsi_sns			*sns = 0;
	extern int			st_debug;

	if (st_debug >= 2)
		mprintf("st%d: st_get_retries un %x reset %x\n",
		    un->un_unit, un, reset);
	/* 
	 * If device supports error logs then read log information
	 */
	cmd->cmd_flags = CMD_FLAGS_SILENT;
	switch (st->st_mtget.mt_type) {
	    case MT_ISHP:
		/* read and reset tape specific log information */
		SET_CDB_0_TAPE(cmd->cmd_cdb, SC_READ_LOG,
		    un->un_lun, reset ? 0 : 1, 
		    (0x12 << 16) | sizeof(struct st_log_hp));
		if (scsi_cmd_special(un, dev, (caddr_t *)&log, 
		    sizeof(struct st_log_hp), 30, 1, 0) == 0)
			ret = ((log->wr_soft[0] << 8) | log->wr_soft[1]) +
				((log->rd_soft[0] << 8) | log->rd_soft[1]);
		if (log)
		    kmem_free((caddr_t)log, (u_int)sizeof(struct st_log_hp));
		break;

	    default:
		SET_CDB_0(cmd->cmd_cdb, SC_SENSE, un->un_lun,
			0, sizeof(union scsi_sns));
		if (scsi_cmd_special(un, dev, (caddr_t *)&sns, 
			    sizeof(union scsi_sns), 30, 1, 0) == 0)
		    ret = st_get_retries_sns(un, sns);
		if (sns)
		    kmem_free((caddr_t)sns, (u_int)sizeof(union scsi_sns));
		break;
	}

	if (reset)
		st->st_mtget.mt_dsreg = 0;

	return (ret);
}

/* 
 * Return the retry count from the sense buffer. Called at interrupt time.
 */
st_get_retries_sns(un, sns)
register struct scsi_unit	*un;
register union scsi_sns		*sns;
{
	register struct scsi_tape	*st = &stape[un->un_unit];

	/*
	 * These devices maintain their own soft error logging
	 * statistics.  For them, we'll just use their data.
	 */
	switch (st->st_mtget.mt_type) {
	    case MT_ISVIPER1:
	    case MT_ISVIPER2:
		return ((sns->sns_ext.sns_ext_code << 8) | 
			sns->sns_ext.sns_ext_vu_13);
	    case MT_ISWANGTEK1:
		return ((sns->sns_ext.sns_ext_vu_10 << 8) | 
			sns->sns_ext.sns_ext_vu_11);
	    case MT_ISMT02:
		return ((sns->sns_ext.sns_ext_vu_9 << 8) | 
			sns->sns_ext.sns_ext_vu_10);
	    case MT_ISEXABYTE:
	    case MT_ISEXABYTE2:
		return ((sns->sns_ext.sns_ext_vu_16 << 16) | 
			(sns->sns_ext.sns_ext_vu_17 << 8) | 
			sns->sns_ext.sns_ext_vu_18);
	}

	/* Otherwise, count number of recoverable error sense keys */
	if (sns->sns_ext.sns_ext_key == SNS_EXT_KEY_RECOVERED)
		return (st->st_mtget.mt_dsreg + 1);
	else
		return (st->st_mtget.mt_dsreg);
}
#endif
