#ifndef lint
static char *Solbourne_id =
"@(#) swapgeneric.c 1.2@(#) Solbourne id 10/18/93 17:36:32\n";
#endif
/*
 * Copyright 1988 Solbourne Computer, Inc.
 * All rights reserved.
 */

#ifndef lint
static  char sccsid[] = "@(#)swapgeneric.c 1.2 89/08/03 SMI";
#endif

/*
 * Copyright (c) 1987 by Sun Microsystems, Inc.
 *
 * XXX - This stuff is no longer generic or swap related
 * and should probably be moved to autoconf.c.
 */

#include <sys/param.h>
#include <sys/conf.h>
#include <sys/buf.h>
#include <sys/vm.h>
#include <sys/systm.h>
#include <sys/reboot.h>
#include <sys/file.h>
#include <sys/vfs.h>
#include <sys/bootconf.h>
#undef NFSCLIENT
#include <sys/mount.h>

#include <machine/pte.h>
#include <dev/mbvar.h>
#include <machine/mmu.h>
#ifndef twin
# include <machine/prom.h>
#endif 
#include <machine/environ.h>
#include <smpdefs.h>
#ifdef twin
# ifdef OPENPROMS
static int bootpath_debug = 0;
#  define	DPRINTF		if (bootpath_debug) printf
# endif
# include <mon/sunromvec.h>
# include <sys/mtio.h>
# include <mfg/autoconf.h>
#endif

/*
 * Generic configuration;  all in one
 */
dev_t	rootdev;
struct vnode *rootvp;
int	noprintf;

#include "ip.h"
#if NIPI > 0
extern  struct mb_driver ipidriver;
#endif

#include "xd.h"
#if NXD > 0
extern	struct mb_driver xdcdriver;
#endif

#include "xy.h"
#if NXY > 0
extern	struct mb_driver xycdriver;
#endif

# include "xt.h"
#if NXT > 0
extern	struct mb_driver xtcdriver;
#endif

# include "mt.h"
#if NMT > 0
extern	struct mb_driver tmdriver;
#endif

#include "sc.h"
#if NSC > 0
extern	struct mb_driver scdriver;
#endif

#include "si.h"
#if NSI > 0
extern	struct mb_driver sidriver;
#endif

#include "sv.h"
#if NSV > 0
extern	struct mb_driver svdriver;
#endif

#include "ns.h"
#if NNS > 0
extern	struct mb_driver nsdriver;
#endif

#include "rd.h"
#if NRD > 0
extern	struct mb_driver rddriver;
#endif

#include "ft.h"
#if NFT > 0
extern	struct mb_driver ftdriver;
#endif

#include "di.h"
#if NDI > 0
extern	struct mb_driver dicdriver;
#endif

#include "sm.h"
#if NSM > 0
extern	struct mb_driver smdriver;
#endif

#include "fd.h"
#if NFD > 0
extern	struct mb_driver fdcdriver;
#endif

#ifndef OPENPROMS
struct	bdevlist {
	char	*bl_name;
	char	*bl_defname;
	struct mb_driver *bl_driver;
	dev_t	bl_root;
	int	bl_npart;
	int	bl_flags;
#define	BL_FLAGS_ROOT	0x01
#define	BL_FLAGS_SWAP	0x02
#define	BL_FLAGS_DUMP	0x04
#define	BL_FLAGS_RSD	(BL_FLAGS_ROOT|BL_FLAGS_SWAP|BL_FLAGS_DUMP)
	int	bl_exists;
} bdevlist[] = {

#if NIPI > 0
        {"ip", "ip", &ipidriver, makedev(22, 0), 8, BL_FLAGS_RSD},
#endif

#if NXD > 0
	{"xd", "xd", &xdcdriver, makedev(10, 0), 8, BL_FLAGS_RSD},
#endif

#if NXY > 0
	{"xy", "xy", &xycdriver, makedev(3, 0), 8, BL_FLAGS_RSD}, 
#endif

#if NSC > 0
	{"sd", "sd.sr", &scdriver, makedev(7, 0), 8, BL_FLAGS_RSD}, /* compat */
	{"sd", "sd.sc", &scdriver, makedev(7, 0), 8, BL_FLAGS_RSD},
#endif

#if NSI > 0
	{"sd", "sd.si", &sidriver, makedev(7, 0), 8, BL_FLAGS_RSD},
#endif

#if NSV > 0
	{"sd", "sd.sv", &svdriver, makedev(7, 0), 8, BL_FLAGS_RSD},
#endif

#if NNS > 0
	{"ns", "ns", &nsdriver, makedev(12, 0), 8, BL_FLAGS_RSD},
#endif

#if NDI > 0
	{"di", "di", &dicdriver, makedev(22, 0), 8, BL_FLAGS_RSD},
#endif

#define	STMINOR	8	/* minor dev 8 => QIC24 SCSI tape */
#ifdef	solbourne
/* add these so that we can support dump to tape... */
#define ROOT_ON_FLOPPY
#define ROOT_ON_TAPE
#endif	solbourne

#ifdef ROOT_ON_FLOPPY
#if NFD > 0
	{"fd", "fd", &fdcdriver, makedev(16, 0), 8, BL_FLAGS_RSD},
#endif
#endif ROOT_ON_FLOPPY

#ifdef ROOT_ON_TAPE
#include "st.h"
#if NST > 0
#   if NSC > 0
	{"st", "st.sr", &scdriver, makedev(11, STMINOR), 1, BL_FLAGS_DUMP},
	{"st", "st.sc", &scdriver, makedev(11, STMINOR), 1, BL_FLAGS_DUMP},
#   endif
#   if NSI > 0
	{"st", "st.si", &sidriver, makedev(11, STMINOR), 1, BL_FLAGS_DUMP},
#   endif
#   if NSV > 0
	{"st", "st.sv", &svdriver, makedev(11, STMINOR), 1, BL_FLAGS_DUMP},
#   endif
#endif NST > 0

#if NXT > 0
	{"xt", "xt", &xtcdriver, makedev(8, 0), 1, BL_FLAGS_DUMP},
#endif

#if NMT > 0
	{"mt", "mt", &tmdriver, makedev(1, 0), 1, BL_FLAGS_DUMP},
#endif
#endif ROOT_ON_TAPE

#if NRD > 0
	{"rd", "rd", &rddriver, makedev(13, 0), 8, BL_FLAGS_RSD},
#endif

	{0}
};
#else !OPENPROMS
#include "rd.h"
#if	NRD > 0

static struct dev_ops pseudo_ops = { 0 };


/*
 * slightly nonportable C- cdevlist will point to a  kmem_alloc'ed
 * area of memory which will then be an array of cdevlist structures.
 * The terminator for this list will be signalled by a null cl_dev pointer
 *
 */
static struct cdevlist {
	struct	dev_info *cl_dev;
	dev_t	cl_croot;
	dev_t	cl_broot;
	int	cl_exists;		/* bit pattern of attached units */
	struct	cdevlist *cl_next;	/* successor */
} *cdevlist = NULL;

#endif	NRD

/*
 * XXX FIX ME FIX ME FIX ME
 * XXX THIS IS GROSS
 * XXX THERE MUST BE A BETTER WAY TO DO THIS
 * XXX PERHAPS SOMETHING IN sun/conf.c THAT TIES NAMESPACE TO {b, c}devsw
 * XXX ENTRIES. THIS COULD ALSO REDUCE THE LOAD IN sun/wscons.c
 *
 * XXX Also, shouldn't the [bc]maptabs be in REVERSE order of preference,
 * XXX as the [bc]devlists are built in LIFO order?
 */

static struct bmaptab {
	char	*m_name;	/* device name */
	dev_t 	m_bmajor;	/* major device number */
} bmaptab[] = {

#include "sd.h"
#if	NSD > 0
	{ "sd", makedev(7, 0) },
#endif	NSD > 0

#include "fd.h"
#if	NFD > 0
	{ "fd", makedev(16, 0)	},
#endif	NFD

/* rd.h included above */
#if	NRD > 0
	{ "rd", makedev(13, 0)	},
#endif	NRD

#include "ns.h"
#if	NNS > 0
	{ "ns", makedev(12, 0)	},
#endif	NNS

#ifdef	ROOT_ON_TAPE
#include "st.h"
#if	NST > 0
	{ "st", makedev(11, MT_NOREWIND) },
#endif	NST > 0
#endif	ROOT_ON_TAPE

#include "sr.h"
#if	NSR > 0
	{ "sr", makedev(18, 0) },
#endif	NSR > 0

	{ 0 },
};

#if	NRD > 0
static struct cmaptab
{
	char	*m_name;	/* device name */
	dev_t 	m_bmajor;	/* major device number - block */
	dev_t 	m_cmajor;	/* major device number - char */
} cmaptab[] = {

#if	NSD > 0
	{ "sd", makedev(7, 0), makedev(17, 0) },
#endif	NSD > 0

#if	NFD > 0
	{ "fd", makedev(16, 0),	makedev(54, 0)	},
#endif	NFD

#if	NST > 0
	{ "st", makedev(11, MT_NOREWIND), makedev(18, MT_NOREWIND)	},
#endif	NST > 0

#include "ft.h"
#if	NFT > 0
	{ "ft", makedev(14, 0),	-1		},
#endif	NFT

#if	NSR > 0
	{ "sr", makedev(18, 0), makedev(58, 0) },
#endif	NSR > 0

	{ 0 },
};
#endif	NRD
#endif !OPENPROMS

#include "rd.h"
#if NRD > 0
/*
 * If the ram disk is intialized from tape, it needs to
 * use the character device to skip to the right file.
 */
struct	cdevlist {
	char	*cl_name;
	struct mb_driver *cl_driver;
	dev_t	cl_croot;
	dev_t	cl_broot;
	int	cl_exists;
} cdevlist[] = {

#if NIPI > 0
        {"ip", &ipidriver, makedev(65, 0), makedev(22, 0)},
#endif

#include "st.h"
#if NST > 0
#  if NSC > 0
	{"st", &scdriver, makedev(18, STMINOR), makedev(11, STMINOR)},
#  endif
#  if NSI > 0
	{"st", &sidriver, makedev(18, STMINOR), makedev(11, STMINOR)},
#  endif
#  if NSV > 0
	{"st", &svdriver, makedev(18, STMINOR), makedev(11, STMINOR)},
#  endif
#endif NST > 0

#if NXT > 0
	{"xt", &xtcdriver, makedev(30, 0), makedev(8, 0)},
#endif

#if NMT > 0
	{"mt", &tmdriver, makedev(5, 0), makedev(1, 0)},
#endif

#if NXD > 0
	{"xd", &xdcdriver, makedev(42, 0), makedev(10, 0)},
#endif

#if NXY > 0
	{"xy", &xycdriver, makedev(9, 0), makedev(3, 0)},
#endif

#if NSC > 0
	{"sd", &scdriver, makedev(17, 0), makedev(7, 0)},
#endif

#if NSI > 0
	{"sd", &sidriver, makedev(17, 0), makedev(7, 0)},
#endif

#if NSV > 0
	{"sd", &svdriver, makedev(17, 0), makedev(7, 0)},
#endif

#if NFT > 0
	{"ft", &ftdriver, -1, makedev(14, 0)},
#endif

#if NDI > 0
	{"di", &dicdriver, makedev(63, 0)},
#endif

#if NSM > 0
	{"sm", &smdriver, -1, makedev(23, 0)},
#endif

	{0}
};
#endif NRD > 0

struct vfssw *
getfstype(askfor, fsname)
	char *askfor;
	char *fsname;
{
	int fstype, noprintf_save = noprintf;

#ifdef notdef
	return (&vfssw[MOUNT_NFS]);
#endif
	if (boothowto & RB_ASKNAME) {
		if (boothowto & RB_QUIET)
			noprintf = 0;
		for (fsname[0] = '\0'; fsname[0] == '\0'; ) {
#ifdef INTERNALRD
			if (strcmp(askfor, "root") == 0)
				strcpy(fsname, "4.2");
			else
				strcpy(fsname, "spec");
#else
			printf("%s filesystem type ( ", askfor);
			for (fstype = 0; fstype < MOUNT_MAXTYPE; fstype++) {
				if (!vfssw[fstype].vsw_name)
					continue;
				if (!strcmp("swap", askfor) &&
				    !strcmp("4.2", vfssw[fstype].vsw_name))
					continue;	/* "swap" can't be on "4.2" */
				if (!strcmp("root", askfor) &&
				    !strcmp("spec", vfssw[fstype].vsw_name))
					continue;	/* "root" can't be on "spec" */
				printf("%s ", vfssw[fstype].vsw_name);
			}
			printf(" ): ");
			gets(fsname);
#endif INTERNALRD
			for (fstype = 0; fstype < MOUNT_MAXTYPE; fstype++) {
				if (vfssw[fstype].vsw_name == 0)
					continue;
				if (!strcmp("swap", askfor) &&
				    !strcmp("4.2", vfssw[fstype].vsw_name))
					continue;	/* "swap" can't be on "4.2" */
				if (!strcmp("root", askfor) &&
				    !strcmp("spec", vfssw[fstype].vsw_name))
					continue;	/* "root" can't be on "spec" */
				if (*fsname == '\0') {
							/* default, grab the first */
					(void) strcpy(fsname,
					    vfssw[fstype].vsw_name);
					return (&vfssw[fstype]);
				}
				if (strcmp(vfssw[fstype].vsw_name, fsname)==0) {
					return (&vfssw[fstype]);
				}
			}
			printf("Unknown filesystem type '%s'\n", fsname);
			*fsname = '\0';
		}
		if (boothowto & RB_QUIET)
			noprintf = noprintf_save;
	} else if (*fsname) {
		for (fstype = 0; fstype < MOUNT_MAXTYPE; fstype++) {
			if (vfssw[fstype].vsw_name == 0) {
				continue;
			}
			if (strcmp(vfssw[fstype].vsw_name, fsname) == 0) {
				return (&vfssw[fstype]);
			}
		}
	}
	return ((struct vfssw *)0);
}

/*
 * If booted with ASKNAME, prompt on the console for a filesystem
 * name and return it.
 */
getfsname(askfor, name)
	char *askfor;
	char *name;
{
	int	noprintf_save = noprintf;
#ifdef	solbourne
/* 
 * KLUDGE XXX	To avoid adding another vfsop switch... 
 * !!! if askfor == swap and swap already set up set askfor == dump!
 */
	if ((strcmp(askfor, "swap") == 0) && (swapfile.bo_flags & BO_VALID))
		askfor = "dump";
#endif	solbourne
	if (boothowto & RB_QUIET)
		noprintf = 0;
	if (boothowto & RB_ASKNAME) {
		printf("%s name: ", askfor);
		gets(name);
	}
	if (boothowto & RB_QUIET)
		noprintf = noprintf_save;
}

#ifndef OPENPROMS

/*
 * Return the device number and name of the first
 * block device in the bdevlist that can be opened.
 * If booted with the -a flag, ask user for device name.
 * Name must be at most 128 bytes long.
 * askfor is one of "root" or "swap", or "dump".
 */
dev_t
getblockdev(askfor, name)
	char *askfor;
	char *name;
{
	register struct bdevlist *bl, *blp;
	int iobus = 0, ctlr = 0, unit = 0, part = 0;
	int minor_num, namlen, bl_flags;
	char *devname, *ptr;
	char defname[MAXENVSTR];
	int	noprintf_save = noprintf;

#ifdef	solbourne
/* 
 * KLUDGE XXX	To avoid adding another vfsop switch... 
 * !!! if askfor == swap and swap already set up set askfor == dump!
 */
	if ((strcmp(askfor, "swap") == 0) && ( swapfile.bo_flags & BO_VALID))
	    askfor = "dump";
#endif	solbourne
	if (strcmp(askfor, "root") == 0)
		bl_flags = BL_FLAGS_ROOT;
	else if (strcmp(askfor, "swap") == 0)
		bl_flags = BL_FLAGS_SWAP;
	else if (strcmp(askfor, "dump") == 0)
		bl_flags = BL_FLAGS_DUMP;

	if (boothowto & RB_ASKNAME) {
	    if (boothowto & RB_QUIET)
		noprintf = 0;
	    for (bl = bdevlist; bl->bl_name; bl++)
		if (bl_flags & bl->bl_flags) {
		    /* 
		     * In the case of shared drivers (sd.si and sd.sv), 
		     * only mark the first as exists for this type of
		     * operation.
		     */
		    for (blp = bdevlist; blp != bl; blp++) {
			if (strcmp(bl->bl_name, blp->bl_name) == 0)
				break;
		    }
		    if (blp != bl)
			continue;
		    bl->bl_exists = chkroot(bl, -1);
		}

	    while (1) {
#ifdef INTERNALRD
		if (strcmp(askfor, "root") == 0)
			strcpy(name, "rd0a");
#ifdef	INTERNALRD_USE_DEFAULTDUMP
		else if (strcmp(askfor, "swap") == 0)
			strcpy(name, "ns0b");
		else if (strcmp(askfor, "dump") == 0) {
			if ((ptr = getenv(DEFAULTDUMP)) == NULL)
				strcpy(name, "ns0b");
			else
				goto fromenv;
		}
#else	INTERNALRD_USE_DEFAULTDUMP
		else
			strcpy(name, "ns0b");
#endif	INTERNALRD_USE_DEFAULTDUMP
#else
		printf("%s device ( ", askfor);
		for (bl = bdevlist; bl->bl_name; bl++)
		    if (bl->bl_exists)
			printf("%s%%d[a-h] ", bl->bl_name);
		printf("): ");
		gets(name);
#endif INTERNALRD
		if (*name == '\0')
		    continue;
		for (bl = bdevlist; bl->bl_name; bl++) {
		    if (!bl->bl_exists)
			continue;
		    if (strncmp(bl->bl_name, name, strlen(bl->bl_name)) != 0)
			continue;
		    unit = 0;
		    namlen = strlen(bl->bl_name);
		    ptr = &name[namlen];
		    while(*ptr >= '0' && *ptr <= '9')
			unit = unit*10 + *ptr++ - '0';
		    if (ptr == &name[namlen]) {
			printf("bad/missing unit number\n");
			continue;
		    }
		    if (*ptr == '\0')
			part = 0;
		    else if (*ptr >= 'a' && *ptr <= 'h')
			part = *ptr++ - 'a';
		    else {
			printf("bad partition (use a-h)\n");
			continue;
		    }
		    *ptr = 0;
		    minor_num = unit * bl->bl_npart + part;
		    if (chkroot(bl, minor_num))
			goto found;
		}
		printf("unknown device name %s\n", name);
	    }
	}

	/* If a name was given, find that block device */
	if (*name != '\0') {
	    for (bl = bdevlist; bl->bl_name; bl++) {
		if (strncmp(bl->bl_name, name, strlen(bl->bl_name)) != 0)
		    continue;
		unit = 0;
		namlen = strlen(bl->bl_name);
		ptr = &name[namlen];
		while(*ptr >= '0' && *ptr <= '9')
		    unit = unit*10 + *ptr++ - '0';
		if (*ptr == '\0')
		    part = 0;
		else
		    part = *ptr++ - 'a';
		*ptr = 0;
		minor_num = unit * bl->bl_npart + part;
		if (chkroot(bl, minor_num))
		    goto found;
	    }
	    return((dev_t)0);
	}
#ifdef	INTERNALRD_USE_DEFAULTDUMP
fromenv:
#endif	INTERNALRD_USE_DEFAULTDUMP
	/* Use default root/swap device from the environment */
	if (bl_flags & BL_FLAGS_ROOT) {
	    if ((ptr = getenv(DEFAULTROOT)) == NULL)
		panic("set rom environment variable DEFAULTROOT!");
	    (void) strncpy(defname, ptr, MAXENVSTR);
	    rompath(defname, &devname, (char **)NULL,
		&iobus, &ctlr, &unit, &part, (char **)NULL);
	} else if (bl_flags & BL_FLAGS_SWAP) {
swap:	    if ((ptr = getenv(DEFAULTSWAP)) == NULL)
		panic("set rom environment variable DEFAULTSWAP!");
	    (void) strncpy(defname, ptr, MAXENVSTR);
	    rompath(defname, &devname, (char **)NULL,
		&iobus, &ctlr, &unit, &part, (char **)NULL);
	} else if (bl_flags & BL_FLAGS_DUMP) {
	    if ((ptr = getenv(DEFAULTDUMP)) == NULL)
		goto swap;
	    (void) strncpy(defname, ptr, MAXENVSTR);
	    rompath(defname, &devname, (char **)NULL,
		&iobus, &ctlr, &unit, &part, (char **)NULL);
	}
	if (devname == NULL)
	    return ((dev_t)0);
	if ((part < 0) || (part > 7))
	    part = 0;
	for (bl = bdevlist; bl->bl_name; bl++)
	    if (strcmp(bl->bl_defname, devname) == 0) /* unique! */
		break;
	if (!bl->bl_name)
	    return((dev_t)0);
	minor_num = unit = romminor(bl, iobus, ctlr, unit, part);
	if (unit == -1 || chkroot(bl, minor_num) == 0)
	    return((dev_t)0);
	/* do a rom to unix name construction */
	namlen = strlen(bl->bl_name);
	if (namlen >= (MAXOBJNAME-3))
	    return ((dev_t)0);
	(void) strncpy(name, bl->bl_name, namlen);
	unit = unit / bl->bl_npart;
	if (unit >= 10) {
	    name[namlen++] = '0' + (unit / 10);
	    unit %= 10;
	}
	name[namlen++] = '0' + unit;
	if (bl->bl_npart > 1)
	    name[namlen++] = 'a' + part;
	name[namlen++] = '\0';
found:	if (boothowto & RB_QUIET)
		noprintf = noprintf_save;
	return makedev(major(bl->bl_root), minor(bl->bl_root)|minor_num);
}

#else	!OPENPROMS

/*
 * slightly nonportable C- bdevlist will point to a  kmem_alloc'ed
 * area of memory which will then be an array of bdevlist structures.
 * The terminator for this list will be signalled by a null bl_dev pointer
 *
 * There will only be one entry per device kind- that is, the bl_dev
 * will point to the devinfo structure for the first valid and attached
 * device found.
 */
static struct bdevlist {
	struct	dev_info *bl_dev;
	dev_t	bl_root;
	int	bl_exists;		/*
					 * bl_exists contains a bit pattern
					 * for valid units for this device.
					 */

	struct	bdevlist *bl_next;	/* successor */
} *bdevlist = NULL;

/*
 * Return the device number and name of the first
 * block device in the bdevlist that can be opened.
 * If booted with the -a flag, ask user for device name.
 * Name must be at least 128 bytes long.
 * askfor is one of "root" or "swap".
 */
dev_t
getblockdev(askfor, name)
	char *askfor;
	char *name;
{
	register struct bdevlist *bl;
	int unit, part, askme = (boothowto & RB_ASKNAME);
	register struct bootparam *bp;
	struct dev_info *dip;

	if (!bdevlist) {
		if (build_bdevlist() == 0) {
			panic("getblockdev: No Devices to boot off of?");
			/*NOTREACHED*/
		}
	}
tryagain:

	if (askme) {
		for (unit = -1; unit == -1; /* empty */) {
			printf("%s device (", askfor);
			for (bl = bdevlist; bl != NULL; bl = bl->bl_next) {
				if (bl->bl_exists) {
					printf("%s%%d[a-h] ",
						bl->bl_dev->devi_name);
				}
			}
			printf("): ");
			gets(name);
			if (*name == '\0') {
				bl = bdevlist;
				unit = 0;
				part = 0;
				break;
			}
			for (bl = bdevlist; bl->bl_next; bl = bl->bl_next) {
				if (strncmp(
				    bl->bl_dev->devi_name, name, 2) == 0)
					break;
			}
			if (!bl) {
				printf("Unknown device name '%c%c'\n",
				    name[0], name[1]);
				continue;
			}
			if (name[2] < '0' || name[2] > '7') {
				printf("bad/missing unit number\n");
				continue;
			}
			unit = name[2] - '0';
			if (name[3] == '\0') {
				part = 0;
			} else if (name[3] >= 'a' && name[3] <= 'h') {
				part = name[3] - 'a';
			} else {
				printf("bad partition (use a-h)\n");
				unit = -1;
			}
		}
	} else {
		unit = 0;
		/*
		 * If we are looking for swap, assume
		 * that the second partition is needed.
		 */
		if (strcmp (askfor, "swap") == 0)
			part = 1;
		else
			part = 0;
		/*
		 * If a name was given, find that block device
		 */
		if (*name != '\0') {
			for (bl = bdevlist; bl != NULL; bl = bl->bl_next) {
				if (strncmp(bl->bl_dev->devi_name, name, 2))
					continue;
				if (bl->bl_exists) {
					if (name[2] != '\0')
						unit = name[2] - '0';
					if (name[3] != '\0')
						part = name[3] - 'a';
					goto found;
				}
			}
			return ((dev_t)0);
		}
		/*
		 * Look for device we booted from
		 */
		if (romp->v_romvec_version > 0) {
			DPRINTF("getblockdev: path %s --> ", *romp->bootpath);
			dip = path_to_devi(*romp->bootpath);
			if (dip == NULL) {
				DPRINTF("NULL devinfo!\n");
				goto usefirst;
			}
			DPRINTF("device %s unit %x nodeid %x\n",
			    dip->devi_name, dip->devi_unit, dip->devi_nodeid);
			for (bl = bdevlist; bl != NULL; bl = bl->bl_next) {
				if (strcmp(bl->bl_dev->devi_name,
				    dip->devi_name))
					continue;
				if (bl->bl_exists & (1 << dip->devi_unit)) {
					unit = dip->devi_unit;
					part =
					    get_part_from_path(*romp->bootpath);
					goto found;
				}
			}
		} else {
			bp = (*romp->v_bootparam);
			for (bl = bdevlist; bl != NULL; bl = bl->bl_next) {
				if (strncmp(bl->bl_dev->devi_name, bp->bp_dev,
				    2))
					continue;
				if (bl->bl_exists & (1 << bp->bp_unit)) {
					unit = bp->bp_unit;
					part = bp->bp_part;
					goto found;
				}
			}
		}
		/*
		 * Use the first device that can be opened.
		 */
usefirst:
		for (bl = bdevlist; bl != NULL; bl = bl->bl_next) {
			if (bl->bl_exists == 0)
				continue;
			/*
			 * if some user has a floppy in their drive, and they
			 * are booting a GENERIC kernel over the net, they
			 * expect to NOT swap on the floppy.  Since there is
			 * nothing intrinsically "illegal" about it - it is
			 * just too small for normal operations, we put in
			 * a special HACK here, to disallow swapping on "fd"
			 */
			if ((bl->bl_dev->devi_name[0] == 'f') &&
			    (bl->bl_dev->devi_name[1] == 'd') &&
			    (strcmp (askfor, "swap") == 0))
				continue;
			while (unit < sizeof (bl->bl_exists)) {
				if (bl->bl_exists&(1<<unit)) {
					dev_t dev = makedev(major(bl->bl_root),
					    (unit * 8 + part));

					if (chkopenable(dev))
						goto found;
				}
				unit++;
			}
		}
		return ((dev_t)0);
	}

found:
	name[0] = bl->bl_dev->devi_name[0];
	name[1] = bl->bl_dev->devi_name[1];
	name[2] = '0' + unit;
	name[3] = 'a' + part;
	name[4] = '\0';

	/*
	 * Make sure that you can open the device
	 * the user ended up specifying (unless it's rd.c)
	 */
	if (strncmp("rd0", name, 3) != 0) {
		dev_t chk = makedev(major(bl->bl_root), (unit * 8 + part));

		if (chkopenable(chk)) {
			return (chk);
		} else {
			printf("Cannot open '%s'\n", name);
			askme = 1;
			goto tryagain;
		}
	} else
	return (makedev(major(bl->bl_root), minor(bl->bl_root)|(unit*8+part)));
}

/*
 * check if dev is openable, 0 no, 1 yes
 */
static
chkopenable(dev)
	dev_t	dev;
{
	short maj = major(dev);

	if ((*bdevsw[maj].d_open)(dev, FREAD) == 0) {
		(void)(*bdevsw[maj].d_close)(dev, FREAD);
		return (1);
	} else
		return (0);
}

/*
 * Check to see whether name is already in bdevlist
 */

static struct bdevlist *
chkdup_b(name)
register char *name;
{
	register struct bdevlist *tp = bdevlist;

	while (tp) {
		if (strcmp(name, tp->bl_dev->devi_name) == 0)
			break;
		else
			tp = tp->bl_next;
	}
	return (tp);
}

/*
 * If this dev structure refers to this bmaptab entry,
 * and an equivalent name (i.e., another unit) is not
 * already in the bdevlist, add it in.
 */

static
add_to_blist(dev, op)
register struct dev_info *dev;
char *op;
{
	register struct bmaptab *bmp = (struct bmaptab *) op;

	if (strcmp(dev->devi_name, bmp->m_name) == 0 &&	dev->devi_driver) {
		register struct bdevlist *tp;

		/*
		 * If there is a devlist entry allready in the list,
		 * then only add a notation to it that there is another
		 * unit available.
		 */
		if (tp = chkdup_b(dev->devi_name)) {
			tp->bl_exists |= (1<<dev->devi_unit);
		} else {
			tp = bdevlist;
			bdevlist = (struct bdevlist *)new_kmem_zalloc(
				sizeof (*tp), KMEM_NOSLEEP);
			if (!bdevlist)
				panic("add_to_blist: no memory");
			bdevlist->bl_dev = dev;
			bdevlist->bl_next = tp;
			bdevlist->bl_root = bmp->m_bmajor;
			bdevlist->bl_exists |= (1<<dev->devi_unit);
		}
	}
}

static int
build_bdevlist()
{
	extern struct dev_info *top_devinfo;
	register struct bmaptab *bmp;

	for (bmp = bmaptab; bmp->m_name; bmp++) {
#if	NRD > 0
		if (strcmp("rd", bmp->m_name) == 0 ||
		    strcmp("ns", bmp->m_name) == 0 ||
		    strcmp("ft", bmp->m_name) == 0) {
			register struct dev_info *dev =
				(struct dev_info *)new_kmem_zalloc(
					sizeof (struct dev_info), KMEM_NOSLEEP);
			if (!dev)
				panic("build_bdevlist: no memory");
			dev->devi_name = bmp->m_name;
			dev->devi_driver = &pseudo_ops;
			add_to_blist(dev, (char *) bmp);
		} else
#endif	NRD > 0
		walk_devs(top_devinfo, add_to_blist, (char *) bmp);
	}
	return (bdevlist != NULL);
}

#if	NRD > 0
/*
 * Check to see whether name is already in cdevlist
 */
static struct cdevlist *
chkdup_c(name)
register char *name;
{
	register struct cdevlist *tp = cdevlist;

	while (tp) {
		if (strcmp(name, tp->cl_dev->devi_name) == 0)
			break;
		else
			tp = tp->cl_next;
	}
	return (tp);
}

/*
 * If this dev structure refers to this cmaptab entry,
 * and an equivalent name (i.e., another unit) is not
 * already in the cdevlist, add it in.
 */
static
add_to_clist(dev, op)
register struct dev_info *dev;
char *op;
{
	register struct cmaptab *cmp = (struct cmaptab *) op;

	if (strcmp(dev->devi_name, cmp->m_name) == 0 &&	dev->devi_driver) {
		register struct cdevlist *tp;

		/*
		 * If there is a devlist entry allready in the list,
		 * then only add a notation to it that there is another
		 * unit available.
		 */
		if (tp = chkdup_c(dev->devi_name)) {
			tp->cl_exists |= (1<<dev->devi_unit);
		} else {
			tp = cdevlist;
			cdevlist = (struct cdevlist *)
				new_kmem_zalloc(sizeof (*tp), KMEM_NOSLEEP);
			if (!cdevlist)
				panic("add_to_clist: no memory");
			cdevlist->cl_dev = dev;
			cdevlist->cl_next = tp;
			cdevlist->cl_croot = cmp->m_cmajor;
			cdevlist->cl_broot = cmp->m_bmajor;
			cdevlist->cl_exists |= (1<<dev->devi_unit);
		}
	}
}

static
build_cdevlist()
{
	extern struct dev_info *top_devinfo;
	register struct cmaptab *cmp;

	for (cmp = cmaptab; cmp->m_name; cmp++) {
		if (strcmp("rd", cmp->m_name) == 0 ||
		    strcmp("ns", cmp->m_name) == 0 ||
		    strcmp("ft", cmp->m_name) == 0) {
			register struct dev_info *dev =
				(struct dev_info *)new_kmem_zalloc(
				sizeof (struct dev_info), KMEM_NOSLEEP);
			if (!dev)
				panic("build_cdevlist: no memory");
			dev->devi_driver = &pseudo_ops;
			dev->devi_name = cmp->m_name;
			add_to_clist(dev, (char *) cmp);
		} else
		walk_devs(top_devinfo, add_to_clist, (char *) cmp);
	}
	return (cdevlist != NULL);
}
#endif	NRD
#endif	!OPENPROMS

#if NRD > 0
/*
 * for ease of use - we can patch the kernel with where to get the munixfs.
 * yes, I *know* this is a HORRIBLE HACK - the alternative is to build
 * 4 different (1/4", 1/2", floppy, net) MUNIX kernels.
 * if you make changes here, be so kind as to fixup things in ...src/sundist
 * XXX - toss the string by making getchardev smarter and just parse the
 * 	boot args
 */
char	loadramdiskfrom[16] = { 0 };

/*
 * loadramdiskfile is used for both tape and cdrom; for tape is file
 * number, for cdrom is offset in bytes from start of boot partition
 * to munixfs image.
 * NOTE: this is patched via adb in the various scripts in ...src/sundist
 */
int	loadramdiskfile = -1;

#ifndef OPENPROMS
/*
 * The ram disk driver is initialized from another device
 * that contains the image of a 4.2 file system.
 *
 * Return the device number and name of the first
 * char device in the cdevlist that can be opened.
 * Name must be at least 128 bytes long.
 */
int
getchardev(askfor, name, fileno, cdev, bdev)
	char	*askfor,
		*name;
	int	*fileno;	/* -1 or file number on tape */
	dev_t	*cdev, *bdev;
{
	register struct cdevlist *cl;
	char	*ptr;
	int	unit, part;
	int namlen;

	for (cl = cdevlist; cl->cl_name; cl++)
	    cl->cl_exists = chkcdev(cl);

	for (unit = -1; unit == -1; ) {
	    printf("%s device ( ", askfor);
	    for (cl = cdevlist; cl->cl_name; cl++)
		if (cl->cl_exists)
		    printf("%s%%d[a-h] ", cl->cl_name);
	    printf("): ");
	    gets(name);
	    if (*name == '\0') {
		cl = cdevlist;
		unit = 0;
		part = 0;
		break;
	    }
	    for (cl = cdevlist; cl->cl_name; cl++)
		if (strncmp(cl->cl_name, name, strlen(cl->cl_name)) == 0)
		    break;
	    if (!cl->cl_name) {
		printf("unknown device name %s\n", name);
		continue;
	    }
	    namlen = strlen(cl->cl_name);
	    ptr = &name[namlen];
	    unit = 0;
	    part = 0;
	    while(*ptr >= '0' && *ptr <= '9')
		unit = unit*10 + *ptr++ - '0';
	    if (ptr == &name[namlen]) {
		printf("bad/missing unit number\n");
		continue;
	    }
	    if (*ptr == '\0')
		part = 0;
	    else if (*ptr >= 'a' && *ptr <= 'h')
		part = *ptr++ - 'a';
	    else {
		printf("bad partition (use a-h)\n");
		unit = -1;
	    }
	    *ptr = 0;
	}

	/* If the device is a tape, prompt for the file number */
	if ((bdevsw[major(cl->cl_broot)].d_flags & B_TAPE) != 0) {
		char	buf[40];
		register char	*p = buf;
		register int	num;

		p = buf;
		do {
			printf("Tape file number? ");
			gets(p);
		} while (!*p || *p < '0' || *p > '9');

		for (num = 0; *p && *p >= '0' && *p <= '9'; ++p)
			num = (num * 10) + *p - '0';

		*fileno = num;
		*bdev = makedev(major(cl->cl_broot),
	    		minor(cl->cl_broot) | (unit));
		*cdev = makedev(major(cl->cl_croot),
	    		minor(cl->cl_croot) | (unit));
	} else {
		*fileno = -1;
		*bdev = makedev(major(cl->cl_broot),
	    		minor(cl->cl_broot) | (unit*8+part));
		*cdev = makedev(major(cl->cl_croot),
	    		minor(cl->cl_croot) | (unit*8+part));
	}
}

chkcdev(cl)
	register struct cdevlist *cl;
{
	register struct mb_device *md;

	for (md = mbdinit; md->md_driver; md++) {
		if ((md->md_alive == 0) || 
		    (md->md_driver != cl->cl_driver) ||
		    (strcmp(md->md_dname, cl->cl_name) != 0) ||
		    (md->md_unit != 0))
			continue;
		return (1);
	}

	/*
	 * The device was not in the system maintained list of mainbus devices.
	 * Check for a pseudo device that is usable as a root or swap device.
	 */
	if ((cl->cl_driver->mdr_flags & MDR_PSEUDO) != 0)
		return (1);
	return (0);
}


#else	!OPENPROMS

/*
 * The ram disk driver is initialized from another device
 * that contains the image of a 4.2 file system.
 *
 * Return the device number and name of the first
 * char device in the cdevlist that can be opened.
 * Name must be at least 128 bytes long.
 */
int
getchardev(askfor, name, fileno, cdev, bdev)
	char	*askfor,
		*name;
	int	*fileno;	/* -1 or file number on tape */
	dev_t	*cdev, *bdev;
{
	register struct cdevlist *cl;
	int	unit,
		part;
	struct dev_info *dip;

	if (!cdevlist) {
		if (build_cdevlist() == 0) {
			panic("getchardev: No Devices to boot off of?");
			/*NOTREACHED*/
		}
	}
	/*
	 * see if a default is defined or if we can just use the bootargs
	 */
	if (!(boothowto & RB_ASKNAME)) {
		if (loadramdiskfrom[0] == '\0') {
			if (romp->v_romvec_version > 0) {
				DPRINTF("getchardev: path %s --> ",
				    *romp->bootpath);
				dip = path_to_devi(*romp->bootpath);
				if (dip == NULL) {
					DPRINTF("NULL devinfo!\n");
					goto tryagain;
				}
				DPRINTF("device %s unit %x nodeid %x\n",
				    dip->devi_name, dip->devi_unit,
				    dip->devi_nodeid);
				unit = dip->devi_unit;
				part = get_part_from_path(*romp->bootpath);
				loadramdiskfrom[0] = dip->devi_name[0];
				loadramdiskfrom[1] = dip->devi_name[1];
			} else {
				unit = (char)((*romp->v_bootparam)->bp_unit);
				part = (char)((*romp->v_bootparam)->bp_part);
				loadramdiskfrom[0] =
				    (*romp->v_bootparam)->bp_dev[0];
				loadramdiskfrom[1] =
				    (*romp->v_bootparam)->bp_dev[1];
			}
			/*
			 * XXX bad cause IPI has lots of units!
			 */
			loadramdiskfrom[2] = '0' + unit;
			loadramdiskfrom[3] = 'a' + part;
			loadramdiskfrom[4] = '\0';
		}
		(void)strncpy(name, loadramdiskfrom, 16);

		for (cl = cdevlist; cl != NULL; cl = cl->cl_next) {
			if (!(cl->cl_exists & (1 << unit)))
				continue;
			if (strncmp(cl->cl_dev->devi_name, name, 2) == 0) {
				printf("Loading ram disk from %s\n", name);
				goto got_name;
			}
		}
		/*
		 * maybe, if it was "sd" and the unit didn't exist, it
		 * was really "sr" (we boot "sr" as "sd")
		 */
		if ((name[0] == 's') && (name[1] == 'd')) {
			for (cl = cdevlist; cl != NULL; cl = cl->cl_next) {
				if (strncmp(cl->cl_dev->devi_name, "sr", 2))
					continue;
				/* we found "sr", does it exist? */
				/* XXX NOTE: ASSUMES only 1 cdrom! */
				if (!(cl->cl_exists))
					continue;
				/* it lives, so fix things up */
				name[1] = 'r';
				unit = 0;	/* XXX ASSUMES only 1 CDROM */
				/*
				 * we leave partition as is, for rd.c rd_offset
				 * rd.c will strip out before doing open
				 */
				printf("Loading ram disk from %s\n", name);
				goto got_name;
			}
		}
	}
tryagain:

	for (unit = -1; unit == -1; /* empty */) {
		printf("%s device (", askfor);
		for (cl = cdevlist; cl != NULL; cl = cl->cl_next)
			if (cl->cl_exists)
				printf("%s%%d[a-h] ", cl->cl_dev->devi_name);
		printf("): ");
		gets(name);
		if (*name == '\0') {
			cl = cdevlist;
			unit = 0;
			part = 0;
			break;
		}

		for (cl = cdevlist; cl != NULL; cl = cl->cl_next) {
			if (strncmp(cl->cl_dev->devi_name, name, 2) == 0)
				break;
		}
		if (!cl) {
			printf(
			    "Unknown device name '%c%c'\n", name[0], name[1]);
			continue;
		}
		if (name[2] < '0' || name[2] > '7') {
			printf("bad/missing unit number\n");
			continue;
		}
		unit = name[2] - '0';
		if (name[3] == '\0') {
			part = 0;
		} else if (name[3] >= 'a' && name[3] <= 'h') {
			part = name[3] - 'a';
		} else {
			printf("bad partition (use a-h)\n");
			unit = -1;
		}
	}

	name[0] = cl->cl_dev->devi_name[0];
	name[1] = cl->cl_dev->devi_name[1];
	name[2] = '0' + unit;
	name[3] = 'a' + part;
	name[4] = '\0';

got_name:

	/* If the device is a tape, prompt for the file number */
	if ((bdevsw[major(cl->cl_broot)].d_flags & B_TAPE) != 0) {
		char	buf[40];
		register char	*p = buf;
		register int	num;

		if (!(boothowto & RB_ASKNAME) && (loadramdiskfile != -1)) {
			*fileno = loadramdiskfile;
		} else {
			p = buf;
			do {
				printf("Tape file number? ");
				gets(p);
			} while (!*p || *p < '0' || *p > '9');

			for (num = 0; *p && *p >= '0' && *p <= '9'; ++p)
				num = (num * 10) + *p - '0';

			*fileno = num;
		}
		*bdev = makedev(major(cl->cl_broot),
			minor(cl->cl_broot)|unit|part);
		*cdev = makedev(major(cl->cl_croot),
			minor(cl->cl_croot)|unit|part);
	} else {
		*fileno = -1;

		*bdev = makedev(major(cl->cl_broot), (unit * 8 + part));
		*cdev = makedev(major(cl->cl_croot), (unit * 8 + part));
	}


	/*
	 * This should be also be pertinent for
	 * sun3x/80 or other ejectable floppy machines.
	 *
	 *
	 * if an auto ejectable floppy, we must eject the one we booted
	 * off of so the filesystem can be loaded
	 * NOTE: we can't open/do ioctls to the device - it isn't mapped in yet.
	 */
	/*
	 * FIXME FIX ME XXX should really do either...
	 * if (cmajor(cdev) == 54 || cmajor(cdev) == Maj#of_sf)
	 */
	if (name[0] == 'f' && name[1] == 'd') {
		/* turn on drive select and (later eject) */
#ifdef twin
		Auxio = AUX_EJECT; /* pre-set eject ?proms broke?*/
		DELAY(100);
		Auxio = Auxio & ~AUX_EJECT; /* eject is low true */
		DELAY(100);
		/* now turn off both eject and select */
		Auxio = Auxio | AUX_EJECT;
		printf(
		    "please insert diskette \"B\", press any key to continue:");
#else twin
#ifdef sun4c
		Auxio |= (AUX_MBO | AUX_EJECT); /* pre-set eject ?proms broke?*/
		Auxio |= (AUX_MBO | AUX_DRVSELECT);
		DELAY(100);
		Auxio = (Auxio | AUX_MBO) & ~AUX_EJECT; /* eject is low true */
		DELAY(100);
		/* now turn off both eject and select, MBO = Must Be Ones! */
		Auxio = (Auxio | AUX_MBO | AUX_EJECT) & ~AUX_DRVSELECT;
		printf(
		    "please insert diskette \"B\", press any key to continue:");
#else sun4c
		printf("please insert next diskette, type any key to continue");
#endif sun4c
#endif twin
		if (getchar() != '\n')
			printf("\n");
	}
}
#endif	!OPENPROMS
#endif NRD > 0

#ifndef OPENPROMS
/* 
 * convert a rom based (iobus, ctlr, unit, part) into kernel dev_t 
 * (major, minor).  NOTE: Dont look at bl_driver, it may not be correct for 
 * sd.si vs sd.sv!.
 */
romminor(bl, iobus, ctlr, unit, part)
	register struct bdevlist *bl;
{
	register struct mb_device *md;
	int mn;

	for (md = mbdinit; md->md_driver; md++) {
		if (md->md_alive == 0 ||
		    (strcmp(md->md_dname, bl->bl_name) != 0) ||
		    md->md_iobus != iobus || 
		    md->md_ctlr != ctlr || md->md_slave != unit)
			continue;
		mn = (minor(md->md_unit) * bl->bl_npart) + part;
		if (mn < 0x100)
			return mn;
		printf("\n\nromminor:can't convert rom device '%s(%d,%d,%d,%d)' to kernel form\n\n",
		    bl->bl_defname, iobus, ctlr, unit, part);
		panic("minor number overflow...\n");
	}
	return (-1);
}

chkroot(bl, orig_min_dev)
	register struct bdevlist *bl;
	register int orig_min_dev;	/* minor dev number or -1 */
{
	register struct mb_device *md;

	for (md = mbdinit; md->md_driver; md++) {
		short	min_dev;
		short	maj_dev;
		dev_t	dev;

		if ((md->md_alive == 0) || 
		    (strcmp(md->md_dname, bl->bl_name) != 0))
			continue;
		if ((orig_min_dev != -1) &&
		    (md->md_unit != (orig_min_dev / bl->bl_npart)))
			continue;
		maj_dev = major(bl->bl_root);
		if (orig_min_dev == -1)
			min_dev = minor(md->md_unit) * bl->bl_npart;
		else
			min_dev = orig_min_dev;
		dev = makedev(maj_dev, min_dev);
#ifdef	solbourne
		/* allow tapes to be inserted later... for dump to tape */
		if (bdevsw[maj_dev].d_flags & B_TAPE)
			return (1);
#endif	solbourne

#if	NCPUS > 1
		if (io_bcall (maj_dev, bdevsw[maj_dev].d_open, dev, FREAD, 0)
		    ==0)
		{
		    (void) io_bcall (maj_dev, bdevsw[maj_dev].d_close, 
				     dev, FREAD, 0);
		    return (1);
		}
#else
		if ((*bdevsw[maj_dev].d_open)(dev, FREAD) == 0) {
			(void)(*bdevsw[maj_dev].d_close)(dev, FREAD);
			return (1);
		}
#endif	NCPUS > 1
	}

	/*
	 * The device was not in the system maintained list of mainbus devices.
	 * Check for a pseudo device that is usable as a root or swap device.
	 */
	if ((bl->bl_driver->mdr_flags & MDR_PSEUDO) != 0)
		return (1);
	return (0);
}
#endif !OPENPROMS

getchar()
{
	register c;

	c = cngetc() & 0177;
	if (c == '\r')
		c = '\n';
	cnputc(c);
	return (c);
}

gets(cp)
	char *cp;
{
	register char *lp;
	register c;

	lp = cp;
	for (;;) {
		c = getchar();
		switch (c) {

		case '\n':
			*lp++ = '\0';
			return;

		case 0177:
			cnputc('\b');
		case '\b':
			cnputc(' ');
			cnputc('\b');
		case '#':
			lp--;
			if (lp < cp)
				lp = cp;
			continue;

		case '@':
		case 'u'&037:
			lp = cp;
			cnputc('\n');
			continue;

		default:
			*lp++ = c;
		}
	}
}
