/* @(#) thread.h 1.1@(#) Solbourne id 9/22/93 00:02:10 */
/*
 * File: thread.h - Thread library to support asynchronous I/O
 * 
 * Started 8/17/90 by drb
 * 
 * Copyright (c) 1990 by Solbourne Computer, Inc. All rights reserved.
 */

#ifndef _thread_h_
#define _thread_h_ 1

#include <sys/asynch.h>
/* 
 * root thread - only fields needed by parent thread
 * this structure must correlate to the head of the struct thread.
 */
struct rthread	
{
	struct thread	*next;		/* doubly-linked list of threads */
	struct thread	*prev;		/* in this process */
	struct thead	*wnext;		/* wait hash linklist */
	struct thead	*wprev; 
	int		flags;
	unsigned	sp;		/* "saved context" */
	unsigned	fp;              
	unsigned	ra;
	struct page	*stack;		/* this thread's stack seg */
	unsigned	spte[2];	/* max CLSIZE for all machines */
/* XXX [2] breaks the alignment of the proc struct! breaks ps, etc */
	label_t		qsave;		/* save area for u.u_qsave */
};

#ifdef KERNEL

struct thread	
{
	/* same as root thread data - see above */
	struct thread	*next;		/* doubly-linked list of threads */
	struct thread	*prev;		/* in this process */
	struct thead	*wnext;		/* wait hash linklist */
	struct thead	*wprev; 
	int		flags;
	unsigned	sp;		/* "saved context" */
	unsigned	fp;              
	unsigned	ra;
	struct page	*stack;		/* this thread's stack seg */
	unsigned	spte[2];	/* max CLSIZE for all machines */
	label_t		qsave;		/* save area for u.u_qsave */

	/* individual thread data follows */
	struct proc	*procp;
	caddr_t		wchan;		/* per-thread wait-channel */
	int		pri;		/* and prio, for cancellation */

	/* The following data is present to allow optimisation of async IO.  */
	auiotemp_t	auiotemp;
	aiodone_t	aiodone;

	unsigned	pad_1, pad_2;
};

typedef struct thread thread_t;

struct thead
{
	struct thead *next;
	struct thead *prev;
};

#define th_slpque_to_thread(hp) ((struct thread *)(hp-1))

#define TH_MAIN 	0x0001
#define TH_RUN  	0x0002
#define TH_WAIT 	0x0004
#define TH_ZOMB 	0x0008
#define TH_VM_CONTEXT	0x0010
#define	TH_SLEEPERS	0x0020
#define	TH_DIE		0x0040

#define RVOFFSET 8		/* offset in frame of %o0 */
#define FPOFFSET 14
#define RAOFFSET 15
#define THREAD_STACK_SIZE 8192

int thread_worker();

#define ALIGN_THSTACK(p) ((((unsigned)(p)))& (~0x7))

#define	HASH(x)	(((int)x >> 5) & (SQSIZE-1))
#define	SQSIZE 0100	/* Must be power of 2 */

extern int n_threads;
#define THREAD_WAKEUP(chan, one) \
    if (n_threads) { \
	thread_wakeup(chan, one); \
    }

#endif KERNEL
#endif _thread_h_
