/* @(#) smpdefs.h 1.2@(#) Solbourne id 3/10/94 21:12:06 */
/****************************************************************************
File: smpdefs.h - a series of handy macros which make SMP support appear
or disappear on command.  Source files with SMP changes should #include
this file.  
****************************************************************************/

#ifndef _machine_smpdefs_h
#define _machine_smpdefs_h_ 1

#include <smp.h>
#include <smpcheck.h>
#include <sys/proc.h>
#include <sys/user.h>
#include <sys/debug.h>

#if NCPUS > 1
!!!!!!!!!BLOW UP!!!!!!!!!!!!! + + + +
#else	NCPUS == 1

/*
 * XXX these don't belong here!
 *
 * this is a temporary fix for all the files who have #ifdef MASTER_SLAVE
 * around the include of multicpu.h and then use constants from that file
 * without using the same ifdefs...
 */
#define	MASTER_CPU	0	/* number of master CPU */

#ifdef lint
int lint_lock;
# define grab_vm_context(a)	{ (a) = lint_lock; (a)++; }
# define drop_vm_context(a)	{ lint_lock = (a); }
#else
# define simple_lock(a)
# define simple_unlock(a)
# define block_n_lock(lp)
# define unblock_n_unlock(lp)
# define simple_lock_spin(a, b) 0
# define simple_lock_nospin(a) 0
# define vm_simple_lock(a)
# define vm_simple_unlock(a)
# define vm_block_n_lock(lp)
# define vm_unblock_n_unlock(lp)
# define vm_simple_lock_spin(a, b) 0
# define vm_simple_lock_nospin(a) 0

# define simple_lock_init(a, b, c)

# define grab_vm_context_q(a)

# define holding_lock(a)	0
# define highest_lock(a)	0

# define check_lock(a)
# define check_vm_context(a)
# define check_stream(a)
# define check_if_lock(a)
# define check_mbuf_context(a)
# define check_domain_lock(a)

# define atomic(lp, op)		op
# define process_monitor(p, op) op
# define proc_mon_enter(p, s)
# define proc_mon_enter_sync(p, s)
# define proc_sync(p)
# define proc_mon_exit(p, s)

# define grab_vm_context(a)
# define drop_vm_context(a)
# define grab_if_lock()
# define drop_if_lock()
# define grab_mbuf_context(a)
# define drop_mbuf_context(a)

	/*
	 * Depending on the number of cpus (ncpus), this pointer is
	 * set to either splvme (ncpus > 1) or to splimp (ncpus == 1).
	 */
#define SET_SPLIMP_VMCONTEXT_FUNC() { \
	extern int splimp(); \
	splimp_vmcontext_func = splimp; \
}
extern int (*splimp_vmcontext_func)();

extern void
        rw_read_lock_nodbg(),
        rw_write_lock_nodbg(),
        rw_unlock_nodbg(),
        rw_write_to_read_upgrade_nodbg();

extern int
        rw_read_to_write_upgrade_nodbg(),
        rw_try_read_nodbg(),
        rw_try_write_nodbg(),
        rw_try_read_to_write_upgrade_nodbg();

# define rw_write_lock(lp)		  rw_write_lock_nodbg(lp)    
# define rw_read_lock(lp)		  rw_read_lock_nodbg(lp)        
# define rw_unlock(lp)			  rw_unlock_nodbg(lp)        
# define rw_read_to_write_upgrade(lp)	  rw_read_to_write_upgrade_nodbg(lp)
# define rw_write_to_read_upgrade(lp)	  rw_write_to_read_upgrade_nodbg(lp)
# define rw_try_read(lp)		  rw_try_read_nodbg(lp)      
# define rw_try_write(lp)		  rw_try_write_nodbg(lp)      
# define rw_try_read_to_write_upgrade(lp) rw_try_read_to_write_upgrade_nodbg(lp)

#endif /* lint */

#endif NCPUS
#endif _machine_smpdefs_h
