/* @(#) led.h 1.1@(#) Solbourne id 9/22/93 00:01:11 */
/*
 * These values are displayed to the diagnostic leds when the roms are
 * are starting
 */

/* These are used in idtrom.c */
#define LEDS_MAIN_BASE(x)	(0xff00|(x))
#define LEDS_MAIN_STARTED	LEDS_MAIN_BASE(1)
#define LEDS_INITING_NVRAM	LEDS_MAIN_BASE(2)
#define LEDS_INITING_SA		LEDS_MAIN_BASE(3)
#define LEDS_ROM_STATE_COLD	LEDS_MAIN_BASE(4)
#define LEDS_COMMAND_LOOP	LEDS_MAIN_BASE(5)

/* These are used in init.c */
#define LEDS_INIT_BASE(x)	(0xff10|(x))
#define LEDS_INITING_DEVS	LEDS_INIT_BASE(1)
#define LEDS_INITING_FS		LEDS_INIT_BASE(2)
#define LEDS_INITING_IOB	LEDS_INIT_BASE(3)
#define LEDS_INITING_IOE	LEDS_INIT_BASE(4)
#define LEDS_CONOPEN_FAILED	LEDS_INIT_BASE(5)

/* These are used in rrt0.s */
#define LEDS_RRT0_BASE(x)	(0xff20|(x))
#define LEDS_ROM_START		LEDS_RRT0_BASE(1)
#define LEDS_ROM_HALT		0xdead
#define LEDS_CONF_MEM		LEDS_RRT0_BASE(3)
#define LEDS_SIZE_MEM		LEDS_RRT0_BASE(4)
#define LEDS_MACH_COLD		LEDS_RRT0_BASE(5)
#define LEDS_MACH_WARM		LEDS_RRT0_BASE(6)

/* These are used in zs.c for debugging */
#define LEDS_ZS_BASE(x)		(0xff30|(x))
#define LEDS_ZS_INIT		LEDS_ZS_BASE(1)
#define LEDS_ZS_INIT_END	LEDS_ZS_BASE(2)
#define LEDS_ZS_MOUSEINIT	LEDS_ZS_BASE(3)
# define LEDS_DEV_ZS		LEDS_ZS_INIT	/* compatible with kbus */

/*
 * These values are displayed to the diagnostic leds when the kernel is running
 */

/* special values */
#define LEDS_ENTRY		0x0000	/* written in first few instructions */
#define LEDS_DTRAP		0xeeee	/* kernel double trap routine */

/* locore.s values */
#define LEDS_LOCORE(x)		(0x1000|(x))
