/* @(#) iGLU.h 1.1@(#) Solbourne id 9/22/93 00:00:56 */
/*
 * structure definitions for the iGLU.  This is mapped in at startup time
 * and is used by kernel folks needing to manipulate the iGLU directly.
 */

typedef struct eight_byte_register {
	u_char	data;
	u_char	pad[7];
	} iglu_reg;	/* used for some of the more obnoxious arrays */

struct iGLU {

	/* profile interrupt timing register */
	unsigned	:4,
			prof_speed:4,	/* profile select -- see iCU defn. */
			:24;
	unsigned	pad0;

	/* profile interrupt enable register */
	unsigned	:7,
			prof_enable:1,	/* enable profiling interrupt. */
			:24;

	/* clear profile interrupt register */
	u_char		prof_clr;	/* clear profiling interrupt */

	/* pad from 0xd to 0x800 */
	u_char		pad3[0x800 - 0xd];

	/* clear scheduling interrupt */
	u_char		sched_clr;	/* any write clears sched intrq. */

	/* pad from 0x801 to 0x1000 */
	u_char		pad4[0x1000 - 0x801];

	/* diagnostic LEDs connector */
	unsigned	:4,
			diag_leds:4,
			:24;

	/* pad from 0x1004 to 0x1800 */
	u_char		pad5[0x1800 - 0x1004];

	/* board status register 0 */
	unsigned	:2,
			NMI:1,		/* NMI switch hit? */
			reset:1,	/* software reset occurred. */
			debug:1,	/* debug mode enabled */
			led_ctrl:3,	/* LED control */
#define	LEDS_OFF	0
#define	LEDS_YELLOW	2
#define	LEDS_GREEN	4
#define	LEDS_BLINK	1
			:23,
			wd_intrq:1;	/* SCSI chip interrupting */
	unsigned	pad5a;

	/* board status registers 1-8 */
	iglu_reg	bsr[7];

	/* pad from 0x1844 to 0x2000 */
	u_char		pad6[0x2000 - 0x1840];

	/* interrupt control register */
	unsigned	:3,
			ien:1,		/* interrupt enable (0 == enabled) */
			sint:4,		/* software interrupt assert */
			:24;
	unsigned	pad7;

	/* Sbus interrupt level map registers (sbus1-7 and audio): */
	iglu_reg	sbus_intlevel[7];
	iglu_reg	audio_intlevel;

	/* pad from 0x2048 to 0x2800 */
	u_char		pad8[0x2800 - 0x2048];

	/* cold reset register */
	u_char		cold_reset;

	/* pad from 0x2801 to 0x3000 */
	u_char		pad9[0x3000 - 0x2801];

	/* I/O device reset register */
	iglu_reg	reset_clear,
			reset_scsi,
			reset_sbus,
			pad10,
			reset_scc,
			pad11[3],
			reset_floppy,
			pad12[7],
			reset_icuidp,
			pad13[15],
			reset_ether,
			pad14[31],
			reset_audio,
			pad15[63],
			reset_imc;

#define	iglu_reset(reg) { iglu.reg.data = 1; DELAY(30); iglu.reg.data = 0; }

	/* pad from 0x3408 to 0x3800 */
	u_char		pad16[0x3800 - 0x3408];

	/* I/O Decode register */
	unsigned	:4,
			decode_base:4,
			:24;
	unsigned	pad17;

	/* iGLU decode register */
	unsigned	:4,
			iglu_decode:4,
			:24;

	};

extern	struct iGLU	iglu;
