/* @(#) diag.h 1.1@(#) Solbourne id 9/22/93 00:00:25 */
 /*
 * diag.h
 *
 * Copyright 1989 Solbourne Computer, Inc.
 * All rights reserved.
 */

#ifndef lint
#ifdef sccs
static char sccsid[] = "@(#)diag.h	1.2 12/21/89 ";
#endif
#endif

#ifndef _machine_diag_h
#define _machine_diag_h
/*
 * Definitions for IDT Bootrom diagnostics
 *
 * miscellaneous registers:
 */
#define r_null		%g0	/* reads return zero. writes, no register modified */
#define	r_temp1		%g6	/* scratch register */
#define	r_temp2		%g7	/* scratch register */
#define r_frame_ptr	%i6	/* frame pointer */
#define r_ret_add	%i7	/* return address (if non-leaf routine) */
#define r_stack_ptr	%o6	/* stack pointer */
#define r_retl_add	%o7	/* return address (if leaf routine) */

/*
 * globals used by basic tests:
 */
#define	r_test_num	%g1	/* Currently executing test  */
#define	r_test_error	%g2	/* Error code from currently executing test */

/*
 * test type codes:
 */
#define A_TEST		0	/* Test written in assembly code */
#define B_TEST		1	/* Executed during Burn-in only */
#define C_TEST		2	/* Test written in C code */

/*
 * where core tests end and system tests begin
 */
#define SYS_TEST_START	6

/*
 * test list packet offsets
 */
#define TLIST_FLAGS	0	/* test flags */
#define TLIST_ENTRY	4	/* test entry point */
#define TLIST_NAME	8	/* ptr to test name */
#define TLIST_FRU	12	/* FRU number */
#define TLIST_SHIFT	4	/* left shift = x 16 */


/*
 * FRU numbers
 */
#define FRU_NULL	0
#define FRU_MOTHERCARD	1	/* cpu board */
#define FRU_MCSIMM	2	/* cpu board SIMM */
#define FRU_GRAPHICS	3	/* graphics card */
#define FRU_SBUS	4	/* sbus card */
#define FRU_MEMX	5	/* memory expansion board */
#define FRU_MXSIMM	6	/* memory expansion SIMM */
#define FRU_FDD		7	/* floppy disk drive */
#define FRU_HDD		8	/* SCSI disk drive */
#define FRU_SDD		8	/* SCSI disk drive */
#define FRU_STD		9	/* SCSI tape drive */
#define FRU_MON		10	/* Monitor */
#define	FRU_KBD		11	/* Keyboard */
#define FRU_MOUSE	12	/* Mouse */
#define FRU_L2          13      /* L2 cache */

/*
 * alternate FRU numbers
 */
#define CHECK_NULL		0
#define CHECK_SCSI_TERMINATOR	1
#define FRU_NO_MEMORY           2

/*
 * Diagnostic registers
 */

#if defined(PREPRO) && !defined(SIMULATOR)
#define DG_FLAGS	0x6000180c	/* test flags (BSR1) */
#else
#define DG_FLAGS	0x60001808	/* test flags (BSR1) */
#endif	/* PREPRO && ! SIMULATOR */

#define DG_TEST		DG_FLAGS+8	/* test number (BSR2) */
#define DG_ERROR	DG_TEST+8	/* error code (BSR3) */
#define DG_FAILURES	DG_ERROR+8	/* failure count (BSR4) */
#define DG_TTYPE	DG_FAILURES+8	/* expected trap type (BSR5) */
#define DG_MEM_CONFIG	DG_TTYPE+8	/* memory configuration (BSR6) */
#define DG_MEM_SIZE	DG_MEM_CONFIG+8	/* memory configuration (BSR7) */

/*
 * Alternate names for display loop variables:
 */
#define DG_LED1		DG_TEST		/* 1st LED value displayed */
#define DG_LED2		DG_ERROR	/* 2nd LED value displayed */

/*
 * Diagnostic flags
 */
#define SHORT		0x00		/* short self test (continue) */
#define HALT		0x01		/* halt on failure */
#define LOOP		0x02		/* loop on test */
#define LONG		0x04		/* long self test (continue) */
#define DATA_FLAG	0x08		/* data area initialized */
#define	EXP_MEM		0x10		/* expansion memory installed */
#define	CLK36		0x20		/* system clock is 36MHz else 33 MHZ */
#define L2_CACHE        0x40            /* L2 cache installed */
#define	BURNIN		0x80		/* burn-in mode */

/* miscellaneous */
#define DG_SEC		1000		/* number of 1 ms intervals in a second */
#define DG_MIN		(DG_SEC*60)	/* number of 1 ms intervals in a minute */
#define BLOCK_SIZE	0x08		/* size of KAP cache block */

/*
 * macros for accessing test parameters in diagnostic registers
 */
#define	SETFLAG(flag) \
	set	DG_FLAGS,r_temp1;		\
	ldub	[r_temp1],r_temp2;	\
	or	r_temp2,(flag),r_temp2;		\
	stb	r_temp2,[r_temp1]

#define	CLRFLAG(flag) \
	set	DG_FLAGS,r_temp1;		\
	ldub	[r_temp1],r_temp2;	\
	andn	r_temp2,flag,r_temp2;		\
	stb	r_temp2,[r_temp1]

#define	TSTFLAG(flag) \
	set	DG_FLAGS,r_temp1;		\
	ldub	[r_temp1],r_temp2;	\
	andcc	r_temp2,(flag),r_null

#define PUTDGB(addr,reg) \
	set	addr,r_temp2;		\
	stb	reg,[r_temp2]

#define GETDGB(addr,reg) \
	set	addr,r_temp2;		\
	ldub	[r_temp2],reg

/* macro for setting front panel LED */
#define	SETLED(state) \
	set	iGLU_BSR,r_temp1;	\
	ldub	[r_temp1],r_temp2;	\
	andn	r_temp2,BSR_LED,r_temp2;\
	or	r_temp2,(state),r_temp2;\
	stb	r_temp2,[r_temp1]

#define PIL(x)	(x<<8)

#ifndef LOCORE

/* Defines for IDT memory tests */

/*
 * The first 4 int arrays are potentially referenced using double
 * word accesses and therefore must be defined first.
 * The test will make sure that this struct is 8-byte aligned
 */
struct test_params {
	unsigned int pattern_B[2];	/* Background pattern */
	unsigned int pattern_C[2];	/* complement pattern */
	unsigned int exp[2];		/* expected data */
	unsigned int act[2];		/* actual data */
	int test;			/* ECC/MEM test */
	unsigned int low_addr;  	/* Start address */
	unsigned int high_addr; 	/* End address - block size */
	unsigned int pat_size;		/* address increment (4 or 8) */
	unsigned int end_inc;   	/* Ending addr inc */
	unsigned int count;		/* iteration count */
	unsigned int fault_flag;	/* data fault flag */
	unsigned int fault_addr;	/* failed address */
	unsigned char syndrome;		/* syndrome byte */
	int offset;			/* data offset within 8 byte line */
	int step;			/* sequence step */
	char *ram_name;			/* RAM name */
	char *pass_name;		/* pass name (forward/reverse) */
};

#define	TESTBASE 	0xF0000000	/* Base memory address */
#define	TESTBLOCK	0x00100000	/* Memory tested in 1 Mbytes chunks */
#define	RANGEMASK	0xFFF00000
#define	CBLCKMASK	0xFFFFFFF8	/* cache block/line mask */

#define	ECCTEST		1
#define	MEMTEST		2

#endif !LOCORE
#endif _machine_diag_h
