/* @(#) clock.h 1.1@(#) Solbourne id 9/22/93 00:00:12 */
/*
 * Copyright 1988 Solbourne Computer, Inc.
 * All rights reserved.
 */

/*      @(#)clock.h 1.6 88/09/22 SMI      */

/*
 * Copyright (c) 1985 by Sun Microsystems, Inc.
 */
#ifndef	_sun4_clock_h
#define	_sun4_clock_h

/*
 * Definitions for accessing the real time clock chip.
 * Kbus machines use the Statek RTC-58321.
 * The S4000 uses the OKI MSM62X42BRS.
 * The chip is used as the battery backed up time-of-day device.
 */

#define	SECDAY	((unsigned)(24*60*60))		/* seconds per day */
#define	SECYR	((unsigned)(365*SECDAY))	/* seconds per common year */

/*
 * The RTC-58321 uses year % 4 to figure out if
 * we have a leap year, we do the same here.
 * (*) The data sheet for the MSM62X42BRS doesn't specify the algorithm used
 *     for leap years but, does indicate that it handles them.
 *     Rick McNeal Oct-31-1989
 */
#define	SECYEAR(yr)	((((unsigned)(yr) % 4) == 0)? SECYR + SECDAY : SECYR)

/*
 * The year register counts from 0 to 99.
 * Unix time is the number of seconds
 * since the year YRREF.  The 2 digit year
 * value stored in the chip represents the 
 * the number of years beyond YRBASE.
 * Note that YRBASE must be < YRREF and
 * (YRBASE % 4) == 0 to do leap years correct.
 * Note that we can only keep time up to the year 2068.
 */
#define	YRREF		70	/* 1970 - where UNIX time begins */
#define	YRBASE		68	/* 1968 - what year 0 in chip represents */

#ifndef LOCORE
extern caddr_t	clock_reg_va;		/* virtual address of clock control register */
#endif !LOCORE

#if defined(Series4) || defined(Series5)
/*
 * Physical address to access RTC-58321 real time clock chip
 */
#define	OBIO_CLOCK_ADDR	0x17020000	/* address of clock in obio space */

/*
 * defines for RTC-58321 clock access
 */
#define	RTC_STOP	0x80		/* stop RTC clock */
#define	RTC_WRITE	0x40		/* write RTC clock */
#define	RTC_READ	0x20		/* read RTC clock */
#define	RTC_WRITEADDR	0x10		/* write RTC address register */
#define	RTC_SECLOW	0x00		/* RTC seconds, low nibble */
#define	RTC_SECHI	0x01		/* RTC seconds, high nibble */
#define	RTC_MINLOW	0x02		/* RTC minutes, low nibble */
#define	RTC_MINHI	0x03		/* RTC minutes, high nibble */
#define	RTC_HRLOW	0x04		/* RTC hours, low nibble */
#define	RTC_HRHI	0x05		/* RTC hours, high nibble */
#define	RTC_24HR	0x08		/* RTC 24 hour mode bit */
#define	RTC_PM		0x04		/* RTC p.m. bit */
#define	RTC_WDAY	0x06		/* RTC day of the week */
#define	RTC_DAYLOW	0x07		/* RTC day of the month, low nibble */
#define	RTC_DAYHI	0x08		/* RTC day of the month, high nibble */
#define	RTC_MONLOW	0x09		/* RTC month, low nibble */
#define	RTC_MONHI	0x0a		/* RTC month, high nibble */
#define	RTC_YRLOW	0x0b		/* RTC year - 1980, low nibble */
#define	RTC_YRHI	0x0c		/* RTC year - 1980, high nibble */
#endif Series4 || Series5

#ifdef S4000
#ifdef SIMULATOR
# define RTC_STOP	0x80	/* stop RTC clock */
# define RTC_WRITE	0x40	/* write RTC clock */
# define RTC_READ	0x20	/* read RTC clock */
# define RTC_WRITEADDR	0x10	/* write RTC address register */
# define RTC_SECLOW	0x00	/* RTC seconds, low nibble */
# define RTC_SECHI	0x01	/* RTC seconds, high nibble */
# define RTC_MINLOW	0x02	/* RTC minutes, low nibble */
# define RTC_MINHI	0x03	/* RTC minutes, high nibble */
# define RTC_HRLOW	0x04	/* RTC hours, low nibble */
# define RTC_HRHI	0x05	/* RTC hours, high nibble */
# define RTC_PM		0x04	/* RTC p.m. bit */
# define RTC_24HR	0x08	/* RTC 24 hour mode bit */
# define RTC_WDAY	0x06	/* RTC day of the week */
# define RTC_DAYLOW	0x07	/* RTC day of the month, low nibble */
# define RTC_DAYHI	0x08	/* RTC day of the month, high nibble */
# define RTC_MONLOW	0x09	/* RTC month, low nibble */
# define RTC_MONHI	0x0a	/* RTC month, high nibble */
# define RTC_YRLOW	0x0b	/* RTC year - 1980, low nibble */
# define RTC_YRHI	0x0c	/* RTC year - 1980, high nibble */
#else
/*
 * defines for MSM62X42BRS clock access
 */
# define RTC_SECLOW	0x00	/* RTC seconds, low nibble */
# define RTC_SECHI	0x08	/* RTC seconds, high nibble */
# define RTC_MINLOW	0x10	/* RTC minutes, low nibble */
# define RTC_MINHI	0x18	/* RTC minutes, high nibble */
# define RTC_HRLOW	0x20	/* RTC hours, low nibble */
# define RTC_HRHI	0x28	/* RTC hours, high nibble */
#  define RTC_PM	0x4	/* RTC p.m. bit */
# define RTC_DAYLOW	0x30	/* RTC day of the month, low BCD nibble */
# define RTC_DAYHI	0x38	/* RTC day of the month, high BCD nibble */
# define RTC_MONLOW	0x40	/* RTC month, low BCD nibble */
# define RTC_MONHI	0x48	/* RTC month, high BCD nibble */
# define RTC_YRLOW	0x50	/* RTC year, low BCD nibble */
# define RTC_YRHI	0x58	/* RTC year, high BCD nibble */
# define RTC_WDAY	0x60	/* RTC day of the week */
# define RTC_CREG_D	0x68	/* Control reg D */
#  define RTC_D_30	0x8	/* 30 sec adjust */
#  define RTC_D_IRQ	0x4	/* Interrupt sent */
#  define RTC_D_BUSY	0x2	/* Chip busy */
#  define RTC_D_HOLD	0x1	/* Hold clock for writting */
# define RTC_CREG_E	0x70	/* Control reg E */
#  define RTC_E_TMSK	0xc	/* Interrupt timing mask */
#  define RTC_E_XEN	0x2	/* Disable interrupts */
#  define RTC_E_OMSK	0x1	/* Output mask, should be 1 */
# define RTC_CREG_F	0x78	/* Control reg F */
#  define RTC_F_TEST	0x8	/* Seconds updated 5.4163KHZ */
#  define RTC_F_24HR	0x4	/* Set clock in 24HR mode */
#  define RTC_F_STOP	0x2	/* Stop clock */
#  define RTC_F_RESET	0x1	/* Reset clock counters */
#endif /* SIMULATOR */
#endif /* S4000 */

/* offsets into structure */
#define CLK_HOUR        0
#define CLK_MIN         1
#define CLK_SEC         2
#define CLK_MON         3
#define CLK_DAY         4
#define CLK_YEAR        5
#define CLK_WEEKDAY     6

#endif	_sun4_clock_h
