  @     	     NAME 	 >          tmpnam, tempnam - create a name for a temporary file >         SYNTAX            #include <stdio.h>               char *tmpnam (s)            char *s;     "          char *tempnam (dir, pfx) "           char *dir, *pfx;          DESCRIPTION  E          These functions generate file names that can safely be used E           for a temporary file.     C          Tmpnam always generates a file name using the path-prefix C D          defined as P_tmpdir in the <stdio.h> header file.  If s is D C          NULL, tmpnam leaves its result in an internal static area C F          and returns a pointer to that area.  The next call to tmpnam F                                                                        @  F          will destroy the contents of the area.  If s is not NULL, it F >          is assumed to be the address of an array of at least > A          L_tmpnam bytes, where L_tmpnam is a constant defined in A ?          <stdio.h>; tmpnam places its result in that array and ?           returns s.     <          Tempnam allows the user to control the choice of a < @          directory.  The argument dir points to the name of the @ B          directory in which the file is to be created.  If dir is B ?          NULL or points to a string which is not a name for an ? D          appropriate directory, the path-prefix defined as P_tmpdir D E          in the <stdio.h> header file is used.  If that directory is E                                             @  C          not accessible, /tmp will be used as a last resort.  This C F          entire sequence can be up-staged by providing an environment F C          variable TMPDIR in the user's environment, whose value is C ;          the name of the desired temporary-file directory. ;    @          Many applications prefer their temporary files to have @ C          certain initial letter sequences in their names.  Use the C D          pfx argument for this.  This argument may be NULL or point D F          to a string of up to five characters to be used as the first F 4          few characters of the temporary-file name. 4    @          Tempnam uses malloc() to get space for the constructed @                                                                  @  C          file name, and returns a pointer to this area.  Thus, any C F          pointer value returned from tempnam may serve as an argument F D          to free (refer to malloc.m).  If tempnam cannot return the D C          expected result for any reason, i.e.  malloc() failed, or C E          none of the above mentioned attempts to find an appropriate E D          directory was successful, a NULL pointer will be returned. D    
     NOTES 
 B          These functions generate a different file name each time B           they are called.     C          Files created using these functions and either fopen() or C E          creat() are temporary only in the sense that they reside in E                                                               @  E          a directory intended for temporary use, and their names are E E          unique.  It is the user's responsibility to use unlink() to E 0          remove the file when its use is ended. 0    
     SEE ALSO 
 C          creat.m, unlink.m, fopen.m, malloc.m, mktemp.m, tmpfile.m C         SPECIAL CONSIDERATIONS  E          If called more than 17,576 times in a single process, these E ?          functions will start recycling previously used names. ? A          Between the time a file name is created and the file is A C          opened, it is possible for some other process to create a C A          file with the same name.  This can never happen if that A C          other process is using these functions or mktemp, and the C                  @  D          file names are chosen so as to render duplication by other D           means unlikely.     *          (printed 07/30/92 - J B Systems) *                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                              