  @     	     NAME 	 ?          drand48, erand48, lrand48, nrand48, mrand48, jrand48, ? C          srand48, seed48, lcong48 - generate uniformly distributed C           pseudo-random numbers          SYNTAX            double drand48 ( )                double erand48 (xsubi)   "          unsigned short xsubi[3]; "              long lrand48 ( )               long nrand48 (xsubi)  "          unsigned short xsubi[3]; "              long mrand48 ( )               long jrand48 (xsubi)  "          unsigned short xsubi[3]; "               void srand48 (seedval)             long seedval;     *          unsigned short *seed48 (seed16v) * $          unsigned short seed16v[3]; $              void lcong48 (param)                     @  "          unsigned short param[7]; "         DESCRIPTION  B          This family of functions generates pseudo-random numbers B D          using the well-known linear congruential algorithm and 48- D !          bit integer arithmetic. !    C          Functions drand48 and erand48 return non-negative double- C D          precision floating-point values uniformly distributed over D "          the interval [0.0, 1.0]. "    @          Functions lrand48 and nrand48 return non-negative long @ B          integers uniformly distributed over the interval [0, 2]. B    C          Functions mrand48 and jrand48 return signed long integers C :          uniformly distributed over the interval [-2, 2]. :                                                     @  B          Functions srand48, seed48 and lcong48 are initialization B D          entry points, one of which should be invoked before either D E          drand48, lrand48 or mrand48 is called.  (Although it is not E C          recommended practice, constant default initializer values C ?          will be supplied automatically if drand48, lrand48 or ? E          mrand48 is called without a prior call to an initialization E E          entry point.) Functions erand48, nrand48 and jrand48 do not E C          require an initialization entry point to be called first. C    B          All the routines work by generating a sequence of 48-bit B B          integer values, Xi, according to the linear congruential B           formula                           @  0           Xn+1 = (aXn+c)mod m       for n >= 0. 0    D          The parameter m = 2^48; hence 48-bit integer arithmetic is D E          performed.  Unless lcong48 has been invoked, the multiplier E 5          value a and the addend value c are given by 5    ;                a = 5DEECE66D base 16 = 273673163155 base 8 ; *                c = B base 16 = 13 base 8. *    F          The value returned by any of the functions drand48, erand48, F C          lrand48, nrand48, mrand48 or jrand48 is computed by first C >          generating the next 48-bit Xi in the sequence.  Then > B          the appropriate number of bits, according to the type of B B          data item to be returned, are copied from the high-order B                                   @  H          (leftmost) bits of Xi and transformed into the returned value. H    C          The functions drand48, lrand48 and mrand48 store the last C <          48-bit Xi generated in an internal buffer; that is < C          why they must be initialized prior to being invoked.  The C D          functions erand48, nrand48 and jrand48 require the calling D :          program to provide storage for the successive Xi : ?          values in the array specified as an argument when the ? C          functions are invoked.  That is why these routines do not C C          have to be initialized; the calling program merely has to C >          place the desired initial value of Xi into the array >                                                                    @  D          and pass it as an argument.  By using different arguments, D ?          functions erand48, nrand48 and jrand48 allow separate ? D          modules of a large program to generate several independent D A          streams of pseudo-random numbers, i.e., the sequence of A D          numbers in each stream will not depend upon how many times D C          the routines have been called to generate numbers for the C           other streams.     F          The initializer function srand48 sets the high-order 32 bits F >          of Xi to the 32 bits contained in its argument.  The > :          low-order 16 bits of Xi are set to the arbitrary :           value 330E base 16.                                                                        @  >          The initializer function seed48 sets the value of Xi > B          to the 48-bit value specified in the argument array.  In B =          addition, the previous value of Xi is copied into a = D          48-bit internal buffer, used only by seed48, and a pointer D >          to this buffer is the value returned by seed48. This > D          returned pointer, which can just be ignored if not needed, D F          is useful if a program is to be restarted from a given point F C          at some future time - use the pointer to get at and store C 7          the last Xi value, and then use this value to 7 @          reinitialize via seed48 when the program is restarted. @    @          The initialization function lcong48 allows the user to @        @  9          specify the initial Xi, the multiplier value a, 9 D          and the addend value c. Argument array elements param[0-2] D :          specify Xi, param[3-5] specify the multiplier a, : C          and param[6] specifies the 16-bit addend c. After lcong48 C A          has been called, a subsequent call to either srand48 or A D          seed48 will restore the ``standard'' multiplier and addend D :          values, a and c, specified on the previous page. :    
     NOTES 
 F          These routines are coded in portable C.  The source code for F E          the portable version can even be used on computers which do E C          not have floating-point arithmetic.  In such a situation, C                                                          @  C          functions drand48 and erand48 do not exist; instead, they C 6          are replaced by the two new functions below. 6              long irand48 (m)            unsigned short m;     !          long krand48 (xsubi, m) ! %          unsigned short xsubi[3], m; %    @          Functions irand48 and krand48 return non-negative long @ D          integers uniformly distributed over the interval [0, m-1]. D    
     SEE ALSO 
           rand.m     *          (printed 07/29/92 - J B Systems) *                                                                                                                                                                                                                                                  