  @     	     Name 	 6          expr - Evaluates arguments as an expression. 6         Syntax            expr arguments          Description  F          The arguments are taken as an expression.  After evaluation, F E          the result is written on the standard output.  Terms of the E E          expression must be separated by blanks.  Characters special E F          to the shell must be escaped.  Note that zero is returned to F F          indicate a zero value, rather than the null string.  Strings F A          containing blanks or other special characters should be A F          quoted.  Integer-valued arguments may be preceded by a unary F F          minus sign.  Internally, integers are treated as 32-bit, 2's F                              @            complement numbers.     B          The operators and keywords are listed below. Expressions B E          should be quoted by the shell, since many of the characters E B          that have special meaning in the shell also have special B =          meaning in expr. The list is in order of increasing = D          precedence, with equal precedence operators grouped within D           braces ({ and }).                    expr | expr     =          Returns the first expr if it is neither null nor 0, = ,          otherwise returns the second expr. ,                   expr & expr     ?          Returns the first expr if neither expr is null nor 0, ?           otherwise returns 0.                                                  @  0               expr { =, >, >=, <, <=, != } expr 0    =          Returns the result of an integer comparison if both = A          arguments are integers, otherwise returns the result of A           a lexical comparison.     !               expr { +, - } expr !    >          Addition or subtraction of integer-valued arguments. >    $               expr { *, /, % } expr $    @          Multiplication, division, or remainder of the integer- @           valued arguments.                    expr : expr     =          The matching operator : compares the first argument = :          with the second argument which must be a regular : 3          expression;  except that all patterns are 3                                                      @  9          ``anchored'' (i.e., begin with a caret (^)) and 9 @          therefore the caret is not a special character in that @ >          context.  Normally the matching operator returns the > 9          number of characters matched (zero on failure). 9 @          Alternatively, the \(...\) pattern symbols can be used @ 4          to return a portion of the first argument. 4    
     Examples 
           1.   a=`expr $a + 1`     .               Adds 1 to the shell variable a. .    A          2.   #  'For $a equal to either "/usr/abc/file" or just A                "/file"'  '               expr  $a  :  '.*/\(.*\)' '    <               Returns the last segment of a pathname (i.e., <                                                            @  :               file).  Watch out for the slash alone as an : :               argument: expr will take it as the division : 5               operator (see Notes on the next page). 5    "          3.   expr  $VAR  :  '.*' "    8               Returns the number of characters in $VAR. 8    
     See Also 
           sed.m, sh.m          Diagnostics  E          As a side effect of expression evaluation, expr returns the E            following exit values:      9          0    If the expression is neither null nor zero 9 0          1    If the expression is null or zero 0 &          2    For invalid expressions &    $          Other diagnostics include: $              syntax error  *               For operator/operand errors *          @            nonnumeric argument  :               If arithmetic is attempted on such a string :    
     Notes 
 F          After argument processing by the shell, expr cannot tell the F E          difference between an operator and an operand except by the E ;          value.  If $a is an equals sign (=), the command: ;                   expr  $a  =  '='               looks like:                    expr  = =  =     F          Thus the arguments are passed to expr (and will all be taken F E          as the = operator).  The following permits comparing equals E           signs:                    expr  X$a  =  X=        )          (printed 4/29/94 - J B Systems) )                                                             