/*  The following #define statements may be used to more easily test the
    status returned from tape functions.  They are setup to test a 16 bit
    integer named 'ts'.  To use these functions,  you need to either name
    your tape status variable 'ts' or code a #define to equate ts to the
    name of your tape status variable.
*/
#define IONL    (0x8000 & ts)            /* Online                      */
#define ISPEED  (0x4000 & ts)            /* Speed/density               */
#define IDBY    (0x2000 & ts)            /* Data busy                   */
#define IFPT    (0x1000 & ts)            /* File protect                */
#define IREW    (0x0800 & ts)            /* Rewinding                   */
#define IRDY    (0x0400 & ts)            /* Ready                       */
#define ILOAD   (0x0200 & ts)            /* At load point               */
#define IFBY    (0x0100 & ts)            /* Formatter busy              */
#define IOVER (!(0x0010 & ts))           /* False = data overrun        */
#define IHER    (0x0008 & ts)            /* Hard error                  */
#define IFMK    (0x0004 & ts)            /* File mark detected          */
#define IEOT    (0x0002 & ts)            /* End of tape                 */
#define ICER    (0x0001 & ts)            /* Corrected error             */
 
/*  The following macros may be used to perform some of the common tape
    functions more easily.
*/
#define WTM(h)           ts = cetape(h,6);       /* Write tape mark           */
#define FSF(h,cnt)       ts = cetape(h,7,&cnt);  /* Forward space file marks  */
#define BSF(h,cnt)       ts = cetape(h,8,&cnt);  /* Back space file marks     */
#define FSB(h,cnt)       ts = cetape(h,9,&cnt);  /* Forward space tape blocks */
#define BSB(h,cnt)       ts = cetape(h,10,&cnt); /* Back space tape blocks    */
#define SETRETRY(h,cnt)  ts = cetape(h,21,&cnt); /* Set the retry count       */
#define REW(h)           ts = cetape(h,33);      /* Rewind (with wait)        */
#define RUN(h)           ts = cetape(h,12);      /* Rewind and unload         */
