; THIS MODULE IS CODED TO INTERFACE WITH MICROSOFT VERSION 3 AND ABOVE.
; TO PRODUCE A MODULE COMPATABLE WITH OTHER C COMPILERS, SOME MODIFICATIONS
; WILL NEED TO BE MADE.  CONSULT THE USERS MANUAL FOR THE COMPILER IN QUESTION
; TO DETERMINE WHAT CHANGES NEED TO BE MADE.  PARTICULARLY CHECK FOR:
;
; 1)  THE DATA AND CODE SEGMENT NAMES.
; 2)  GROUP NAMES WHICH MAY NEED TO BE DEFINED.
; 3)  THIS MODULE ALLOCATES LARGE MEMORY BUFFERS DIRECTLY FROM DOS.  THIS
;     DEPENDS ON THE FACT THAT MICROSOFT C INITITALIZATION PROPERLY FREES
;     ALL UNUSED SPACE.  IF THE C COMPILER IN QUESTION DOES NOT DO THIS, THEN
;     AN ALTERNATE METHOD MUST BE DEVISED TO ACQUIRE MEMORY BUFFERS.
;
; THIS MODULE MAY BE ASSEMBLED FOR EITHER SMALL OR LARGE MEMORY MODEL 'C'.
; TO ASSEMBLE FOR SMALL MEMORY MODEL, ASSEMBLE NORMALLY WITH NO PARAMETERS.
; TO ASSEMBLE FOR LARGE MEMORY MODEL, ASSEMBLE WITH /DLARGE.
;
;  C>MASM CETAPEL /DLARGE;
;
;  THE FOLLOWING MACROS ARE TO USE IN PLACE OF CONDITIONAL JUMP INSTRUCTIONS
;  WHEN THE JUMP DISTANCE EXCEEDS +/- 128 BYTES.  MOST ARE NAMED THE SAME AS
;  THE CORRESPONDING JUMP INSTRUCTION, EXCEPT THEY ARE Bxx INSTEAD OF Jxx.
;
BA MACRO ADDR
 LOCAL X
 JNA X
 JMP ADDR
X:
ENDM
BNBE MACRO ADDR
 LOCAL X
 JBE X
 JMP ADDR
X:
ENDM
BAE MACRO ADDR
 LOCAL X
 JNAE X
 JMP ADDR
X:
ENDM
BNB MACRO ADDR
 LOCAL X
 JB X
 JMP ADDR
X:
ENDM
BB MACRO ADDR
 LOCAL X
 JNB X
 JMP ADDR
X:
ENDM
BNAE MACRO ADDR
 LOCAL X
 JAE X
 JMP ADDR
X:
ENDM
BBE MACRO ADDR
 LOCAL X
 JNBE X
 JMP ADDR
X:
ENDM
BNA MACRO ADDR
 LOCAL X
 JA X
 JMP ADDR
X:
ENDM
BC MACRO ADDR
 LOCAL X
 JNC X
 JMP ADDR
X:
ENDM
BCXZ MACRO ADDR
 LOCAL W,X
 JCXZ W
 JMP SHORT X
W: JMP ADDR
X:
ENDM
BE MACRO ADDR
 LOCAL X
 JNE X
 JMP ADDR
X:
ENDM
BZ MACRO ADDR
 LOCAL X
 JNZ X
 JMP ADDR
X:
ENDM
BG MACRO ADDR
 LOCAL X
 JNG X
 JMP ADDR
X:
ENDM
BNLE MACRO ADDR
 LOCAL X
 JLE X
 JMP ADDR
X:
ENDM
BGE MACRO ADDR
 LOCAL X
 JNGE X
 JMP ADDR
X:
ENDM
BNL MACRO ADDR
 LOCAL X
 JL X
 JMP ADDR
X:
ENDM
BLOW MACRO ADDR
 LOCAL X
 JNL X
 JMP ADDR
X:
ENDM
BNGE MACRO ADDR
 LOCAL X
 JGE X
 JMP ADDR
X:
ENDM
BLE MACRO ADDR
 LOCAL X
 JNLE X
 JMP ADDR
X:
ENDM
BNG MACRO ADDR
 LOCAL X
 JG X
 JMP ADDR
X:
ENDM
BNC MACRO ADDR
 LOCAL X
 JC X
 JMP ADDR
X:
ENDM
BNE MACRO ADDR
 LOCAL X
 JE X
 JMP ADDR
X:
ENDM
BNZ MACRO ADDR
 LOCAL X
 JZ X
 JMP ADDR
X:
ENDM
BNO MACRO ADDR
 LOCAL X
 JO X
 JMP ADDR
X:
ENDM
BNS MACRO ADDR
 LOCAL X
 JS X
 JMP ADDR
X:
ENDM
BNP MACRO ADDR
 LOCAL X
 JP X
 JMP ADDR
X:
ENDM
BPO MACRO ADDR
 LOCAL X
 JPE X
 JMP ADDR
X:
ENDM
BO MACRO ADDR
 LOCAL X
 JNO X
 JMP ADDR
X:
ENDM
BPAR MACRO ADDR
 LOCAL X
 JNP X
 JMP ADDR
X:
ENDM
BPE MACRO ADDR
 LOCAL X
 JPO X
 JMP ADDR
X:
ENDM
BS MACRO ADDR
 LOCAL X
 JNS X
 JMP ADDR
X:
ENDM
;
ENTERL MACRO           ;ENTER MACRO FOR LARGE MEMORY MODEL
 PUSH BP
 MOV BP,SP
 ADD BP,6
 PUSH SI
 PUSH DI
 PUSH DS
 PUSH ES
 MOV AX,CET_DATA
 MOV DS,AX
 MOV ES,AX
 ENDM
;
LEAVEL MACRO           ;LEAVE MACRO FOR LARGE MEMORY MODEL
 POP ES
 POP DS
 POP DI
 POP SI
 POP BP
 RET
 ENDM
;
ENTERS MACRO           ;ENTER MACRO FOR SMALL MEMORY MODEL
 PUSH BP
 MOV BP,SP
 ADD BP,4
 PUSH SI
 PUSH DI
 PUSH DS
 POP ES
 ENDM
;
LEAVES MACRO           ;LEAVE MACRO FOR SMALL MEMORY MODEL
 POP DI
 POP SI
 POP BP
 RET
 ENDM
;
IFDEF LARGE
; ==================== LARGE MEMORY MODEL =================
CET_DATA SEGMENT PARA PUBLIC 'FAR_DATA'
 ASSUME DS:CET_DATA,ES:CET_DATA
ELSE
; ==================== SMALL MEMORY MODEL =================
_DATA SEGMENT WORD PUBLIC 'DATA'
DGROUP GROUP _DATA
ENDIF
; ==================== END CONDITIONAL ASSEMBLY ===========
;
;  TAPE FUNCTION CALL TABLE
;
FUNCTAB LABEL WORD
 DW FUNCT   ;00 RETURN STATUS
 DW WRITE   ;01 WRITE A BLOCK
 DW READ    ;02 READ A BLOCK
 DW WRITE   ;03 WRITE IN EDIT MODE
 DW READ    ;04 READ IN REVERSE EDIT MODE
 DW READ    ;05 READ IN REVERSE MODE
 DW FUNCT   ;06 WRITE TAPE MARK
 DW FUNCT   ;07 FORWARD SPACE FILE
 DW FUNCT   ;08 BACK SPACE FILE
 DW FUNCT   ;09 FORWARD SPACE RECORD
 DW FUNCT   ;10 BACK SPACE RECORD
 DW FUNCT   ;11 REWIND
 DW FUNCT   ;12 REWIND & UNLOAD
 DW FUNCT   ;13 SET 1600 BPI
 DW FUNCT   ;14 SET 3200 BPI
 DW FUNCT   ;15 SET FAST SPEED
 DW FUNCT   ;16 SET SLOW SPEED
 DW FUNCT   ;17 SET LONG GAP
 DW FUNCT   ;18 SET SHORT GAP
 DW FUNCT   ;19 ERASE FIXED
 DW FUNCT   ;20 ERASE TO EOT
 DW FUNCT   ;21 SET THE NUMBER OF RETRYS
 DW FUNCT   ;22 RESET ERROR COUNTS
 DW FUNCT   ;23 RETURN READ ERROR COUNT
 DW FUNCT   ;24 RETURN WRITE ERROR COUNT
 DW FUNCT   ;25 TAPE CARD PRESENT?
 DW FUNCT   ;26 TAPE UNIT ONLINE?
 DW SETADR  ;27 SET TAPE ADDRESS 0 - 7
 DW FBWRITE ;28 FIXED BLOCKED WRITE
 DW FBREAD  ;29 FIXED BLOCKED READ
 DW VBWRITE ;30 VARIABLE BLOCKED WRITE
 DW VBREAD  ;31 VARIABLE BLOCKED READ
 DW INIT    ;32 INITIALIZE MEMORY
 DW REWIND  ;33 REWIND WITH WAIT
 DW FSE     ;34 FORWARD SPACE TO END OF TAPE
 DW WRSHORT ;35 WRITE SHORT (UP TO 500 BYTES) RECORD DIRECT
 DW RDSHORT ;36 READ SHORT (UP TO 500 BYTES) RECORD DIRECT
 DW RETCONT ;37 RETURN THE READ/WRITE BLOCK COUNT
FUNCMAX EQU ($-FUNCTAB)/2
 
;
;  COUNT OF THE NUMBER OF PARAMETERS PASSED IN AND OUT FOR EACH FUNCTION
;
PCOUNTAB LABEL WORD
 DB 1,1     ;00 RETURN STATUS
 DB 3,1     ;01 WRITE A BLOCK
 DB 3,2     ;02 READ A BLOCK
 DB 3,1     ;03 WRITE IN EDIT MODE
 DB 3,2     ;04 READ IN REVERSE EDIT MODE
 DB 3,2     ;05 READ IN REVERSE MODE
 DB 1,1     ;06 WRITE TAPE MARK
 DB 2,1     ;07 FORWARD SPACE FILE
 DB 2,1     ;08 BACK SPACE FILE
 DB 2,1     ;09 FORWARD SPACE RECORD
 DB 2,1     ;10 BACK SPACE RECORD
 DB 1,1     ;11 REWIND
 DB 1,1     ;12 REWIND & UNLOAD
 DB 1,1     ;13 SET 1600 BPI
 DB 1,1     ;14 SET 3200 BPI
 DB 1,1     ;15 SET FAST SPEED
 DB 1,1     ;16 SET SLOW SPEED
 DB 1,1     ;17 SET LONG GAP
 DB 1,1     ;18 SET SHORT GAP
 DB 1,1     ;19 ERASE FIXED
 DB 1,1     ;20 ERASE TO EOT
 DB 2,1     ;21 SET THE NUMBER OF RETRYS
 DB 1,1     ;22 RESET ERROR COUNTS
 DB 1,2     ;23 RETURN READ ERROR COUNT
 DB 1,2     ;24 RETURN WRITE ERROR COUNT
 DB 1,2     ;25 TAPE CARD PRESENT?
 DB 1,2     ;26 TAPE UNIT ONLINE?
 DB 2,1     ;27 SET TAPE ADDRESS 0 - 7
 DB 4,1     ;28 FIXED BLOCKED WRITE
 DB 4,2     ;29 FIXED BLOCKED READ
 DB 4,1     ;30 VARIABLE BLOCKED WRITE
 DB 4,2     ;31 VARIABLE BLOCKED READ
 DB 4,2     ;31 VARIABLE BLOCKED READ
 DB 2,2     ;32 INITIALIZE MEMORY
 DB 1,1     ;33 REWIND WITH WAIT
 DB 1,1     ;34 FORWARD SPACE TO END OF TAPE
 DB 3,1     ;35 WRITE A SHORT RECORD DIRECT
 DB 3,2     ;36 READ A SHORT RECORD DIRECT
 DB 1,2     ;37 RETURN READ/WRITE BLOCK COUNT
;
SHORTLEN EQU 500       ;LENGTH OF THE DIRECT READ/WRITE BUFFER
SHORTBUF DW SB1        ;POINTER TO THE BUFFER
SB1 DB SHORTLEN DUP(?) ;TWO BUFFERS SO THAT AT LEAST ONE IS GURANTEED NOT
SB2 DB SHORTLEN DUP(?) ;TO CROSS A PHYSICAL 64K BOUNDARY
SHORTIND DB 0          ;1 = 'SHORTBUF' HAS BEEN SET TO AVOID 64K BOUNDARY
 
LENSIZE EQU 16384      ;SIZE OF THE BLOCK LENGTH TABLE FOR TAPE READ/WRITE
LENBUF DB LENSIZE DUP(?) ;BLOCK LENGTH TABLE
LENBYTES DW 0          ;SIZE OF BLOCK LENGTH TABLE FOR EACH HANDLE
RESPAR DW 0            ;NUMBER OF PARAGRAPHS TO RESERVE/NUMBER ALLOCATED
HANDMAX DW 1           ;NUMBER OF HANDLES BEING USED
HANDLE DW 0            ;CURRENT HANDLE
 
CURVAR LABEL BYTE      ;BEGIN VARIABLES CURRENTLY IN USE (FOR REQUESTED HANDLE)
BEGMEM DW 0,0          ;BEGINNING OF MEMORY BUFFER AREA
ENDMEM DW 0,0          ;END OF MEMORY BUFFER (+1)
MEM DW 0,0             ;CURRENT MEMORY POINTER
LENBASE DW 0           ;BEGINNING OF BLOCK LENGTH TABLE
LENPTR DW 0            ;POINTER INTO BLOCK LENGTH TABLE
RDEPTR DW 0            ;POINTER INTO BLOCK LENGTH TABLE (USED DURRING READS)
LENMAX DW 0            ;POINTER TO END OF BLOCK LENGTH TABLE
 
TAPEFUNC DW 0          ;CURRENT TAPE FUNCTION IN PROGRESS
COUNTADR DW 0,0        ;ADDRESS OF CALLER'S COUNT WORD
BUFFADDR DW 0,0        ;ADDRESS OF CALLER'S DATA BUFFER
TAPEADDR DW 0020H      ;TAPE UNIT ADDRESS (20H - 27H)
WRACT DB 0             ;0 = BUFFERED WRITE NOT ACTIVE/1 = ACTIVE/2=WITH BLOCKING
RDACT DB 0             ;0 = BUFFERED READ NOT ACTIVE/1 = ACTIVE/2=WITH BLOCKING
BFINIT DB 0            ;1 = MEMORY BUFFERS HAVE BEEN ALLOCATED
EOVPROC DB 0           ;1 = END OF VOLUME PROCESSING IN PROGRESS
RECL DW 0              ;RECORD LENGTH
MAXRECL DW 0           ;MAXIMUM RECORD LENGTH
BLKL DW 0              ;BLOCK LENGTH PASSED FROM CALLER
BLKREM DW 0            ;BYTES REMAINING IN THE BLOCK TO BE PROCESSED
BLKPTR DW 0            ;POINTER INTO THE BLOCK BEING BUILT/READ
BLKBASE DW 0,0         ;POINTER TO THE BEGINNING OF THE CURRENT BLOCK
BLKMAX DW 0            ;MAXIMUM BLOCK LENGTH
OVFLAG DB 0            ;READ OVERFLOW FLAG 10H = OK/0 = ERROR
TS DW 0                ;TAPE STATUS RETURNED FROM THE CURRENT FUNCTION
PARMIN DB 0            ;NUMBER OF INPUT PARAMETERS
PARMOUT DB 0           ;NUMBER OF PARAMETERS PASSED BACK
BLKCOUNT DW 0,0        ;RUNNING READ/WRITE BLOCK COUNT
VARLEN EQU $-CURVAR    ;LENGTH OF VARIABLES UNIQUE TO EACH HANDLE
 
;  ALLOW UP TO 4 (0 - 3) DIFFERENT HANDLES TO BE ACTIVE AT ONE TIME.
;  THE ABOVE SET OF VARIABLES ARE MAINTAINED FOR EACH HANDLE AND ARE
;  SWAPPED IN AND OUT OF FOLLOWING BUFFER AT ENTRY AND EXIT FROM THIS MODULE.
;
VARBUF DB 4*VARLEN DUP(0)
 
IFDEF LARGE
; ==================== LARGE MEMORY MODEL =================
CET_DATA ENDS
 
 PUBLIC _CETAPE
 EXTRN _TAPEOV:FAR
 
CET_TEXT SEGMENT BYTE PUBLIC 'CODE'
 ASSUME CS:CET_TEXT,DS:CET_DATA,ES:CET_DATA
_CETAPE PROC FAR
 JMP FT00
 DB 'CTAPE ROUTINE'
FT00:
 ENTERL
ELSE
; ==================== SMALL MEMORY MODEL =================
_DATA ENDS
 
 PUBLIC _CETAPE
 EXTRN _TAPEOV:NEAR
 
_TEXT SEGMENT BYTE PUBLIC 'CODE'
 ASSUME CS:_TEXT,DS:DGROUP,ES:DGROUP
_CETAPE PROC NEAR
 JMP FT00
 DB 'CTAPE ROUTINE'
 JMP WBFXXX
FT00:
 ENTERS
ENDIF
; ==================== END CONDITIONAL ASSEMBLY ===========
 MOV AX,[BP]           ;HANDLE
 CMP BYTE PTR [BP+2],32 ;INIT MEMORY?
 JNE MCT01
 CMP AX,1
 JB  RS00
 CMP AX,4
 JA  RS00
 MOV HANDMAX,AX
 JMP MCT02
MCT01:
 CMP AX,HANDMAX
 JAE RS00              ;COMMAND REJECT
 PUSH CX
 MOV HANDLE,AX
 MOV CX,VARLEN
 MUL CX
 LEA SI,VARBUF
 ADD SI,AX
 LEA DI,CURVAR
 REP MOVSB
 POP CX
MCT02:
 MOV AX,[BP+2]         ;FUNCTION
 DEC CX
 CMP AX,FUNCMAX
 MOV TAPEFUNC,AX
 JBE RS01
RS00:
 MOV DX,0040H          ;SET COMMAND REJECT
 JMP RS02
RS01:
 SHL AX,1
 MOV SI,AX
 MOV CX,PCOUNTAB[SI]
 MOV PARMIN,CL
 MOV PARMOUT,CH
 XOR CH,CH
 DEC CX
IFDEF LARGE
; ==================== LARGE MEMORY MODEL =================
 JCXZ RS018
 MOV AX,[BP+4]         ;GET ADDRESS OF COUNT WORD
 MOV COUNTADR,AX
 MOV AX,[BP+6]
 MOV COUNTADR+2,AX
 PUSH ES
 LES BX,DWORD PTR COUNTADR
 MOV AX,ES:[BX]
 MOV RECL,AX
 POP ES
 DEC CX
;
 JCXZ RS018
 MOV AX,[BP+8]         ;GET ADDRESS OF BUFFER
 MOV BUFFADDR,AX
 MOV AX,[BP+10]
 MOV BUFFADDR+2,AX
 DEC CX
;
 JCXZ RS018
 MOV AX,[BP+12]        ;GET BLOCK SIZE
 MOV BLKMAX,AX
ELSE
; ==================== SMALL MEMORY MODEL =================
 JCXZ RS018
 MOV AX,[BP+4]         ;GET ADDRESS OF COUNT WORD
 MOV COUNTADR,AX
 MOV AX,DS
 MOV COUNTADR+2,AX
 PUSH ES
 LES BX,DWORD PTR COUNTADR
 MOV AX,ES:[BX]
 MOV RECL,AX
 POP ES
 DEC CX
;
 JCXZ RS018
 MOV AX,[BP+6]         ;GET ADDRESS OF BUFFER
 MOV BUFFADDR,AX
 MOV AX,DS
 MOV BUFFADDR+2,AX
 DEC CX
;
 JCXZ RS018
 MOV AX,[BP+8]        ;GET BLOCK SIZE
 MOV BLKMAX,AX
ENDIF
; ==================== END CONDITIONAL ASSEMBLY ===========
RS018:
 MOV AX,TAPEFUNC
 XCHG AL,AH
 CALL FUNCTAB[SI]      ;CALL THE APPROPRIATE ROUTINE
RS02:                  ;COMES BACK W/DX=STATUS
 MOV AX,DX             ;RETURN STATUS TO CALLER
 CMP PARMOUT,2
 JB  RS03
 CMP TAPEFUNC,37
 JE  RS028
 MOV CX,RECL
 PUSH ES
 LES DI,DWORD PTR COUNTADR
 MOV ES:[DI],CX
 POP ES
 JMP RS03
RS028:
 MOV CX,BLKCOUNT
 MOV DX,BLKCOUNT+2
 PUSH ES
 LES DI,DWORD PTR COUNTADR
 MOV ES:[DI],CX
 MOV ES:[DI+2],DX
 POP ES
RS03:
 CMP TAPEFUNC,32
 JE  RS04
 PUSH AX
 MOV AX,HANDLE
 MOV CX,VARLEN
 MUL CX
 LEA DI,VARBUF
 ADD DI,AX
 LEA SI,CURVAR
 REP MOVSB
 POP AX
RS04:
IFDEF LARGE
; ==================== LARGE MEMORY MODEL =================
 LEAVEL
ELSE
; ==================== SMALL MEMORY MODEL =================
 LEAVES
ENDIF
; ==================== END CONDITIONAL ASSEMBLY ===========
_CETAPE ENDP
;
;  WRITE A BLOCK
;
WRITE PROC NEAR
 CMP WRACT,0
 JNE WRT01
 CALL RESETMEM         ;RESET BUFFER POINTERS IF JUST STARTING WRITE
WRT01:
 MOV AX,MEM            ;GET CURRENT MEMORY POINTER IN AX-DX
 MOV DX,MEM+2
 MOV CX,RECL
 JCXZ WRT02            ;CX = 0 MEANS 64K BLOCK
 ADD CX,AX             ;ELSE ADD IN LENGTH TO BE WRITTEN
 JNC WRT04             ;DOES NOT CROSS 64K
 JCXZ WRT04            ;DOES NOT CROSS 64K
 JMP WRT03             ;ELSE NEED TO ADJUST
WRT02:
 CMP AX,0              ;FOR 64K WRITE, CURRENT ADDRESS MUST BE ON 64K
 JE  WRT04             ;YES - OK
WRT03:
 INC DX                ;ADJUST MEMORY POINTER UP TO NEXT 64K BOUNDARY
 XOR AX,AX
WRT04:
 MOV CX,RECL           ;RECAPTURE LENGTH TO WRITE IN CX
 PUSH AX               ;SAVE THE MEMORY POINTER
 PUSH DX
 STC
 JCXZ WRT05            ;IF 64K WRITE, JUST ADD CY BIT TO DX
 ADD AX,CX             ;ELSE ADD REAL LENGTH INTO AX-DX
WRT05:
 ADC DX,0
 CMP DX,ENDMEM+2       ;NOW CHECK FOR GOING PAST END OF AVAILABLE MEMORY
 JB  WRT07             ;OK - IT FITS
 JA  WRT06             ;NO - IT DOES NOT FIT
 CMP AX,ENDMEM         ;CHECK LOW ORDER WORD
 JBE WRT07             ;OK - IT FITS
WRT06:                 ;NOT ENOUGH ROOM, MUST WRITE MEMORY TO TAPE
 POP DX                ;CLEAR THE STACK
 POP AX
 CALL WRTBUF           ;GO WRITE MEMORY TO TAPE
 JNC WRT01             ;ALL OK - GO BACK AND TRY THIS BLOCK AGAIN
 JMP WRT10             ;ERROR
WRT07:
 MOV SI,LENPTR         ;GET POINTER INTO THE BLOCK LENGTH BUFFER
 CMP SI,LENMAX         ;ARE WE AT THE END OF IT?
 JAE WRT06             ;IF SO, FORCE MEMORY WRITE TO TAPE
 MOV [SI],CX           ;ELSE INSERT LENGTH WORD FOR THIS BLOCK
 ADD LENPTR,2          ;INCREMENT POINTER TO NEXT ENTRY
 POP DX                ;RECOVER MEMORY BUFFER POINTER FROM STACK
 POP AX
 PUSH AX               ;SAVE THE POINTER AGAIN
 PUSH DX
 PUSH ES               ;SAVE SEGMENT REGISTERS
 PUSH DS
 MOV CX,16             ;CONVERT ABSOLUTE ADDRESS IN AX-DX INTO
 DIV CX                ;SEGMENT - OFFSET IN ES:DI
 MOV CX,RECL
 MOV ES,AX
 MOV DI,DX
 LDS SI,DWORD PTR BUFFADDR ;GET CALLER'S BUFFER ADDRESS IN DS:SI
 REP MOVSB             ;MOVE THE DATA TO OUR MEMORY BUFFER
 POP DS                ;RESTORE THE REGISTERS WE STORED ON THE STACK
 POP ES
 POP DX
 POP AX
 MOV CX,RECL
 STC
 JCXZ WRT08            ;IF 64K WRITE, JUST ADD CY BIT TO DX
 ADD AX,CX             ;ELSE UPDATE MEMORY POINTER BY ADDING REAL BLOCK SIZE
WRT08:
 ADC DX,0
 MOV MEM,AX            ;UPDATE THE MEMORY POINTER (MEM)
 MOV MEM+2,DX
 MOV WRACT,1           ;SHOW BUFERED WRITE IS ACTIVE
 MOV DX,TS             ;RETURN STATUS TO CALLER
 RET
WRT10:
 MOV DX,TS             ;ERROR COMES HERE - JUST RETURN BAD STATUS
 RET
WRITE ENDP
;
;  FIXED BLOCK WRITE
;
FBWRITE PROC NEAR
 CMP WRACT,0
 JNE WRFB01
 MOV BX,BLKMAX
 MOV BLKL,BX
 CALL RESETMEM
 MOV WRACT,2
 JMP WRFB02
WRFB01:
 MOV AX,RECL
 CMP AX,BLKREM
 BBE WRFB10            ;ROOM IN THIS BLOCK
 MOV BX,LENPTR
 MOV CX,BLKPTR
 MOV [BX],CX
 ADD LENPTR,2
 MOV AX,MEM
 MOV DX,MEM+2
 STC
 JCXZ WRFB017
 ADD AX,CX
WRFB017:
 ADC DX,0
 MOV MEM,AX
 MOV MEM+2,DX
 ADD BX,2
 CMP BX,LENMAX
 JAE WRFB08            ;FORCE WRITE TO TAPE
WRFB02:
 MOV AX,MEM
 MOV DX,MEM+2
 MOV CX,BLKL
 JCXZ WRFB03           ;64K BLOCK
 ADD CX,AX
 JNC WRFB05            ;BLOCK WILL FIT OK
 JCXZ WRFB05           ;BLOCK WILL FIT OK
 JMP  WRFB04
WRFB03:
 CMP AX,0              ;ALREADY ON 64K BOUNDARY?
 JE  WRFB05
WRFB04:
 INC DX
 XOR AX,AX
WRFB05:
 MOV MEM,AX
 MOV MEM+2,DX
 PUSH AX
 PUSH DX
 MOV CX,BLKL
 STC
 JCXZ WRFB06
 ADD AX,CX
WRFB06:
 ADC DX,0
 CMP DX,ENDMEM+2
 JA  WRFB07            ;NO MORE ROOM
 JB  WRFB09            ;ALL OK
 CMP AX,ENDMEM
 JBE WRFB09            ;ALL OK
WRFB07:
 POP DX
 POP AX
WRFB08:
 CALL BWRTBUF
 JNC WRFB02
 JMP WRFB12            ;ERROR
WRFB09:
 POP DX
 POP AX
 MOV CX,16
 DIV CX
 MOV BLKBASE,DX
 MOV BLKBASE+2,AX
 MOV BLKPTR,0
 MOV AX,BLKL
 MOV BLKREM,AX
WRFB10:
 PUSH ES
 PUSH DS
 MOV CX,RECL
 LES DI,DWORD PTR BLKBASE
 ADD DI,BLKPTR
 ADD BLKPTR,CX
 SUB BLKREM,CX
 LDS SI,DWORD PTR BUFFADDR
 REP MOVSB
 POP DS
 POP ES
 MOV AX,0
 MOV DX,TS
 RET
WRFB12:
 MOV AX,1
 MOV DX,TS
 RET
FBWRITE ENDP
 
;  IBM VARIABLE BLOCKED WRITE
;
VBWRITE PROC NEAR
 CMP WRACT,0
 JNE WRVB01
 MOV BX,BLKMAX
 MOV BLKL,BX
 CALL RESETMEM
 MOV WRACT,2
 JMP WRVB02
WRVB01:
 MOV AX,RECL
 ADD AX,4
 CMP AX,BLKREM
 BBE WRVB10            ;ROOM IN THIS BLOCK
 MOV BX,LENPTR
 MOV CX,BLKPTR
 PUSH ES
 LES DI,DWORD PTR BLKBASE
 MOV ES:[DI],CH
 MOV ES:[DI+1],CL
 MOV WORD PTR ES:[DI+2],0
 POP ES
 MOV [BX],CX
 ADD LENPTR,2
 MOV AX,MEM
 MOV DX,MEM+2
 STC
 JCXZ WRVB017
 ADD AX,CX
WRVB017:
 ADC DX,0
 MOV MEM,AX
 MOV MEM+2,DX
 ADD BX,2
 CMP BX,LENMAX
 JAE WRVB08            ;FORCE WRITE TO TAPE
WRVB02:
 MOV AX,MEM
 MOV DX,MEM+2
 MOV CX,BLKL
 JCXZ WRVB03           ;64K BLOCK
 ADD CX,AX
 JNC WRVB05            ;BLOCK WILL FIT OK
 JCXZ WRVB05           ;BLOCK WILL FIT OK
 JMP  WRVB04
WRVB03:
 CMP AX,0              ;ALREADY ON 64K BOUNDARY?
 JE  WRVB05
WRVB04:
 INC DX
 XOR AX,AX
WRVB05:
 MOV MEM,AX
 MOV MEM+2,DX
 PUSH AX
 PUSH DX
 MOV CX,BLKL
 STC
 JCXZ WRVB06
 ADD AX,CX
WRVB06:
 ADC DX,0
 CMP DX,ENDMEM+2
 JA  WRVB07            ;NO MORE ROOM
 JB  WRVB09            ;ALL OK
 CMP AX,ENDMEM
 JBE WRVB09            ;ALL OK
WRVB07:
 POP DX
 POP AX
WRVB08:
 CALL BWRTBUF
 JNC WRVB02
 JMP WRVB12            ;ERROR
WRVB09:
 POP DX
 POP AX
 MOV CX,16
 DIV CX
 MOV BLKBASE,DX
 MOV BLKBASE+2,AX
 MOV BLKPTR,4
 MOV AX,BLKL
 SUB AX,4
 MOV BLKREM,AX
WRVB10:
 PUSH ES
 PUSH DS
 MOV CX,RECL
 LES DI,DWORD PTR BLKBASE
 ADD DI,BLKPTR
 MOV AX,CX
 ADD AX,4
 MOV ES:[DI],AH
 MOV ES:[DI+1],AL
 MOV WORD PTR ES:[DI+2],0
 ADD DI,4
 ADD BLKPTR,AX
 SUB BLKREM,AX
 LDS SI,DWORD PTR BUFFADDR
 REP MOVSB
 POP DS
 POP ES
 MOV AX,0
 MOV DX,TS
 RET
WRVB12:
 MOV AX,1
 MOV DX,TS
 RET
VBWRITE ENDP
 
; BUFFERED READ
;
READ PROC NEAR
 CMP RDACT,0
 JNE RDE01
 CALL RESETMEM
 OR  TS,8010H
 AND TS,NOT 000CH
 MOV RDACT,1
 MOV AX,RECL
 MOV MAXRECL,AX
RDE01:
 MOV BX,RDEPTR
 CMP BX,LENPTR
 JNE RDE02
 TEST TS,000CH         ;TEST HER & EOT
 JNZ RDE10
 TEST TS,0010H         ;TEST FOR OVERRUN
 JZ  RDE10
 TEST TS,8000H         ;TEST FOR ON LINE
 JZ  RDE10
 CALL RDEBUF
 JMP RDE01
RDE02:
 MOV BX,RDEPTR
 MOV AX,MEM
 MOV DX,MEM+2
 MOV CX,AX
 CMP MAXRECL,0
 JNE RDE03
 CMP AX,0
 JNE RDE04
 JMP RDE05
RDE03:
 ADD CX,MAXRECL
 JNC RDE05
 JCXZ RDE05
RDE04:
 INC DX
 XOR AX,AX
RDE05:
 PUSH AX
 PUSH DX
 MOV CX,16
 DIV CX
 MOV CX,[BX]
 PUSH CX
 PUSH ES
 LES DI,DWORD PTR BUFFADDR
 PUSH DS
 MOV DS,AX
 MOV SI,DX
 REP MOVSB
 POP DS
 POP ES
 POP CX
 POP DX
 POP AX
 MOV RECL,CX
 STC
 JCXZ RDE06
 ADD AX,CX
RDE06:
 ADC DX,0
 MOV MEM,AX
 MOV MEM+2,DX
 ADD RDEPTR,2
 MOV DX,TS
 AND DX,NOT 000CH
 OR  DX,8010H
 MOV AX,0
 RET
RDE10:
 MOV DX,TS
 MOV RDACT,0
 MOV RECL,0
 MOV AX,1
 RET
READ ENDP
 
;  FIXED BLOCKED READ
;
FBREAD PROC
 CMP RDACT,0
 JNE FBRD01
 CALL RESETMEM
 MOV RDACT,2
 AND TS,NOT 000CH
 OR  TS,8010H
 MOV AX,BLKMAX
 MOV MAXRECL,AX
 JMP FBRD02
FBRD01:
 MOV AX,BLKPTR
 CMP AX,BLKL
 BNE FBRD07            ;MORE ...
FBRD02:
 MOV BX,RDEPTR
 CMP BX,LENPTR
 JNE FBRD03
 TEST TS,000CH         ;TEST HER & EOT
 BNZ FBRD10            ;ERROR
 TEST TS,0010H         ;TEST FOR OVERRUN
 BZ  FBRD10
 TEST TS,8000H         ;TEST FOR ON LINE
 BZ  FBRD10
 CALL RDEBUF
 JMP FBRD02
FBRD03:
 MOV BX,RDEPTR
 MOV AX,MEM
 MOV DX,MEM+2
 MOV CX,AX
 CMP MAXRECL,0
 JNE FBRD04
 CMP AX,0
 JNE FBRD05
 JMP FBRD06
FBRD04:
 ADD CX,MAXRECL
 JNC FBRD06
 JCXZ FBRD06
FBRD05:
 INC DX
 XOR AX,AX
FBRD06:
 PUSH AX
 PUSH DX
 MOV BX,RDEPTR
 MOV CX,16
 DIV CX
 MOV BLKBASE+2,AX
 MOV BLKBASE,DX
 MOV CX,[BX]
 POP DX
 POP AX
 STC
 JCXZ FBRD067
 ADD AX,CX
FBRD067:
 ADC DX,0
 MOV MEM,AX
 MOV MEM+2,DX
 MOV BLKL,CX
 MOV BLKPTR,0
 ADD RDEPTR,2
FBRD07:
 MOV CX,RECL
 MOV AX,BLKL
 SUB AX,BLKPTR
 JZ  FBRD08
 CMP CX,AX
 JBE FBRD08
 MOV CX,AX
FBRD08:
 MOV AX,BLKPTR
 ADD BLKPTR,CX
 MOV RECL,CX
 PUSH ES
 LES DI,DWORD PTR BUFFADDR
 PUSH DS
 LDS SI,DWORD PTR BLKBASE
 ADD SI,AX
 REP MOVSB
 POP DS
 POP ES
 MOV DX,TS
 AND DX,NOT 000CH
 OR  DX,8010H
 MOV AX,0
 RET
FBRD10:
 MOV DX,TS
 MOV RDACT,0
 MOV RECL,0
 MOV AX,1
 RET
FBREAD ENDP
 
;  IBM VARIABLE BLOCKED READ
;
VBREAD PROC
 MOV OVFLAG,10H
 CMP RDACT,0
 JNE VBRD01
 CALL RESETMEM
 MOV RDACT,2
 AND TS,NOT 000CH
 OR  TS,8010H
 MOV AX,BLKMAX
 MOV MAXRECL,AX
 JMP VBRD02
VBRD01:
 MOV AX,BLKPTR
 CMP AX,BLKL
 BNE VBRD07            ;MORE ...
VBRD02:
 MOV BX,RDEPTR
 CMP BX,LENPTR
 JNE VBRD03
 TEST TS,000CH         ;TEST HER & EOT
 BNZ VBRD10            ;ERROR
 TEST TS,0010H         ;TEST FOR OVERRUN
 BZ  VBRD10
 TEST TS,8000H         ;TEST FOR ON LINE
 BZ  VBRD10
 CALL RDEBUF
 JMP VBRD02
VBRD03:
 MOV BX,RDEPTR
 MOV AX,MEM
 MOV DX,MEM+2
 MOV CX,AX
 CMP MAXRECL,0
 JNE VBRD04
 CMP AX,0
 JNE VBRD05
 JMP VBRD06
VBRD04:
 ADD CX,MAXRECL
 JNC VBRD06
 JCXZ VBRD06
VBRD05:
 INC DX
 XOR AX,AX
VBRD06:
 PUSH AX
 PUSH DX
 MOV BX,RDEPTR
 MOV CX,16
 DIV CX
 MOV BLKBASE+2,AX
 MOV BLKBASE,DX
 MOV CX,[BX]
 POP DX
 POP AX
 STC
 JCXZ VBRD067
 ADD AX,CX
VBRD067:
 ADC DX,0
 MOV MEM,AX
 MOV MEM+2,DX
 MOV BLKL,CX
 MOV BLKPTR,4
 ADD RDEPTR,2
VBRD07:
 PUSH ES
 LES SI,DWORD PTR BLKBASE
 ADD SI,BLKPTR
 MOV CX,ES:[SI]
 XCHG CL,CH
 ADD BLKPTR,CX
 ADD SI,4
 SUB CX,4
 CMP CX,RECL
 JBE VBRD08
 MOV CX,RECL
 MOV OVFLAG,0
VBRD08:
 MOV RECL,CX
 PUSH DS
 LDS DI,DWORD PTR BUFFADDR
 PUSH DS
 PUSH ES
 POP DS
 POP ES
 REP MOVSB
 POP DS
 POP ES
 MOV DX,TS
 AND DX,NOT 000CH
 OR  DX,8000H
 OR  DL,OVFLAG
 MOV AX,0
 RET
VBRD10:
 MOV DX,TS
 MOV RDACT,0
 MOV RECL,0
 MOV AX,1
 RET
VBREAD ENDP
 
;
;  MOST NON-READ/WRITE FUNCTIONS COME HERE
;
FUNCT PROC NEAR
 CMP AH,0
 JE  FCT01
 CMP EOVPROC,0
 JNE FCT01
 MOV RDACT,0
 CMP WRACT,0
 JE  FCT01
 PUSH AX
 CALL BEOT
 POP AX
FCT01:
 MOV CX,RECL
 MOV DX,TAPEADDR
 INT 13H
 MOV RECL,CX
 RET
FUNCT ENDP
;
;  SET THE TAPE ADDRESS TO BE USED
;
SETADR PROC NEAR
 MOV CX,RECL
 CMP CX,7
 JA  STA01
 ADD CX,20H
 MOV TAPEADDR,CX
STA01:
 MOV AH,0
 CALL FUNCT
 RET
SETADR ENDP
;
INITMEM PROC NEAR
 MOV AH,48H
 MOV BX,0A000H
 INT 21H               ;REQUEST 640 K
 MOV AH,48H            ;NOW GO FOR THE REAL AMOUNT
 SUB BX,RESPAR         ;SUBTRACT THE PARAGRAPHS TO BE RESERVED
 MOV RESPAR,BX         ;SAVE THE NUMBER ACTUALLY ACQUIRED
 PUSH BX
 INT 21H
 POP BX
 MOV CX,16
 MUL CX
 MOV BEGMEM,AX
 MOV BEGMEM+2,DX
 MOV MEM,AX
 MOV MEM+2,DX
 MOV AX,BX
 MUL CX
 ADD AX,BEGMEM
 ADC DX,BEGMEM+2
 MOV ENDMEM,AX
 MOV ENDMEM+2,DX
 LEA AX,LENBUF
 MOV LENBASE,AX
 ADD AX,LENSIZE
 MOV LENMAX,AX
 MOV BFINIT,1
 MOV TAPEADDR,0020H
 
;  NOW SETUP THE VARIABLES FOR THE NUMBER OF HANDLES REQUESTED
;
 MOV AX,BEGMEM         ;HANDLE 0 BEGMEM = ORIGINAL BEGMEM ADDRESS
 MOV DX,BEGMEM+2
 MOV BEGMEM+VARLEN,AX
 MOV BEGMEM+VARLEN+2,DX
 MOV ENDMEM+VARLEN,AX
 MOV ENDMEM+VARLEN+2,DX
 
 MOV AX,LENBASE        ;HANDLE 0 LENBASE = ORIGINAL LENBASE
 MOV LENBASE+VARLEN,AX
 MOV LENMAX+VARLEN,AX
 
 MOV AX,LENSIZE
 MOV CX,HANDMAX
 XOR DX,DX
 DIV CX                ;AX = LENBUF BYTES FOR EACH HANDLE
 MOV LENBYTES,AX
 
 MOV AX,RESPAR
 MOV CX,HANDMAX
 XOR DX,DX
 DIV CX                ;AX = # PARAGRAPHS FOR EACH HANDLE
 MOV CX,16
 MUL CX                ;AX - DX = BYTES FOR EACH HANDLE
 MOV CX,HANDMAX
 MOV BX,VARLEN
ITX01:
 PUSH CX
 ADD ENDMEM[BX],AX
 ADC ENDMEM+2[BX],DX
 MOV CX,LENBYTES
 ADD LENMAX[BX],CX
 MOV CX,ENDMEM[BX]
 MOV BEGMEM+VARLEN[BX],CX
 MOV ENDMEM+VARLEN[BX],CX
 MOV CX,ENDMEM+2[BX]
 MOV BEGMEM+VARLEN+2[BX],CX
 MOV ENDMEM+VARLEN+2[BX],CX
 MOV CX,LENMAX[BX]
 MOV LENBASE+VARLEN[BX],CX
 MOV LENMAX+VARLEN[BX],CX
 MOV BFINIT[BX],1
 MOV TAPEADDR[BX],0020H
 POP CX
 DEC CX
 CMP CX,1
 JA  ITX01
 MOV AX,HANDMAX
 MOV CX,VARLEN
 MUL CX
 MOV BX,AX
 MOV AX,ENDMEM
 MOV DX,ENDMEM+2
 MOV ENDMEM[BX],AX
 MOV ENDMEM+2[BX],DX
 MOV AX,LENMAX
 MOV LENMAX[BX],AX
 MOV BFINIT[BX],1
 MOV TAPEADDR[BX],0020H
 RET
INITMEM ENDP
 
;
;  RESET MEMORY BUFFER POINTERS PRIOR TO STARTING BUFFERED READ/WRITE
;
RESETMEM PROC NEAR
 CMP BFINIT,0
 JNE RES01
 MOV RESPAR,0
 CALL INITMEM
RES01:
 CMP WRACT,0
 JNE RES02
 CMP RDACT,0
 JNE RES02
 MOV BLKCOUNT,0
 MOV BLKCOUNT+2,0
RES02:
 MOV AX,LENBASE
 MOV LENPTR,AX
 MOV RDEPTR,AX
 MOV AX,BEGMEM
 MOV DX,BEGMEM+2
 MOV MEM,AX
 MOV MEM+2,DX
 MOV BLKREM,0
 MOV BLKPTR,0
 XOR AX,AX
 RET
RESETMEM ENDP
;
;  WRITE MEMORY BUFFER WHEN FULL
;
WRTBUF PROC NEAR
 MOV AX,BEGMEM
 MOV DX,BEGMEM+2
 MOV SI,LENBASE
WBF01:
 CMP SI,LENPTR
 BE  WBF03 ;DONE
 MOV CX,AX
 CMP WORD PTR [SI],0
 JNE WBF012
 JCXZ WBF02
 JMP WBF014
WBF012:
 ADD CX,WORD PTR [SI]
 JNC WBF02
 JCXZ WBF02
WBF014:
 INC DX
 XOR AX,AX
WBF02:
 PUSH SI
 PUSH ES
 PUSH DX
 PUSH AX
 MOV CX,16
 DIV CX
 MOV ES,AX
 MOV BX,DX
 MOV CX,WORD PTR [SI]
 MOV AH,1
 MOV DL,BYTE PTR TAPEADDR
 INT 13H
 MOV TS,DX
 PUSH DS
 POP ES
 POP AX
 POP DX
 POP ES
 POP SI
 CMP WORD PTR [SI],0
 STC
 JE  WBF025
 ADD AX,WORD PTR [SI]
WBF025:
 ADC DX,0
 ADD SI,2
 TEST TS,0028H  ;HARD ERROR
 JNZ WBF027
 ADD BLKCOUNT,1
 ADC BLKCOUNT+2,0
 TEST TS,0002H  ;EOT
 JZ  WBF01
 MOV EOVPROC,1
 MOV AX,HANDLE
 MOV CX,VARLEN
 MUL CX
 LEA DI,VARBUF
 ADD DI,AX
 LEA SI,CURVAR
 REP MOVSB             ;SAVE CURRENT VARIABLE STATUS
 MOV BP,SP
 MOV AX,HANDLE
 PUSH AX
WBFXXX:
 CALL _TAPEOV
 MOV BX,AX             ;SAVE THE RETURN CODE
 POP AX                ;RETRIEVE THE HANDLE
 MOV CX,VARLEN
 MUL CX
 LEA SI,VARBUF
 ADD SI,AX
 LEA DI,CURVAR
 REP MOVSB             ;RESTORE VARIABLES
 MOV SP,BP
 MOV EOVPROC,0
 CMP BX,0              ;CHECK THE RETURN CODE
 BE  WBF01
WBF027:
 STC
 RET
WBF03:
 CALL RESETMEM
 CLC
 RET
WRTBUF ENDP
 
;
;  WRITE MEMORY BUFFER WHEN FULL (FOR BLOCKED ROUTINES)
;
BWRTBUF PROC NEAR
 MOV AX,BEGMEM
 MOV DX,BEGMEM+2
 MOV SI,LENBASE
FWBF01:
 CMP SI,LENPTR
 BE  FWBF03 ;DONE
 MOV CX,AX
 CMP BLKL,0
 JNE FWBF012
 JCXZ FWBF02
 JMP FWBF014
FWBF012:
 ADD CX,BLKL
 JNC FWBF02
 JCXZ FWBF02
FWBF014:
 INC DX
 XOR AX,AX
FWBF02:
 PUSH SI
 PUSH ES
 PUSH DX
 PUSH AX
 MOV CX,16
 DIV CX
 MOV ES,AX
 MOV BX,DX
 MOV CX,WORD PTR [SI]
 MOV AH,1
 MOV DL,BYTE PTR TAPEADDR
 INT 13H
 MOV TS,DX
 PUSH DS
 POP ES
 POP AX
 POP DX
 POP ES
 POP SI
 CMP WORD PTR [SI],0
 STC
 JE  FWBF025
 ADD AX,WORD PTR [SI]
FWBF025:
 ADC DX,0
 ADD SI,2
 TEST TS,0028H  ;HARD ERROR
 JNZ FWBF027
 ADD BLKCOUNT,1
 ADC BLKCOUNT+2,0
 TEST TS,0002H  ;EOT
 JZ  FWBF01
 MOV EOVPROC,1
 MOV AX,HANDLE
 MOV CX,VARLEN
 MUL CX
 LEA DI,VARBUF
 ADD DI,AX
 LEA SI,CURVAR
 REP MOVSB             ;SAVE CURRENT VARIABLE STATUS
 MOV BP,SP
 MOV AX,HANDLE
 PUSH AX
 CALL _TAPEOV
 MOV BX,AX             ;SAVE THE RETURN CODE
 POP AX                ;RETRIEVE THE HANDLE
 MOV CX,VARLEN
 MUL CX
 LEA SI,VARBUF
 ADD SI,AX
 LEA DI,CURVAR
 REP MOVSB             ;RESTORE VARIABLES
 MOV SP,BP
 MOV EOVPROC,0
 CMP BX,0              ;CHECK THE RETURN CODE
 BE  FWBF01
FWBF027:
 STC
 RET
FWBF03:
 CALL RESETMEM
 CLC
 RET
BWRTBUF ENDP
 
;
;  FORCE BUFFERED DATA OUT TO TAPE AT COMPLETION OF WRITING
;
BEOT PROC NEAR
 CMP WRACT,2
 JNE BOT01
 MOV BX,LENPTR
 MOV CX,BLKPTR
 PUSH ES
 LES DI,DWORD PTR BLKBASE
 MOV ES:[DI],CH
 MOV ES:[DI+1],CL
 MOV WORD PTR ES:[DI+2],0
 POP ES
 MOV [BX],CX
 ADD LENPTR,2
 CALL BWRTBUF
 JMP BOT02
BOT01:
 CALL WRTBUF
BOT02:
 MOV WRACT,0
 MOV AX,0
 RET
BEOT ENDP
 
;
;  READ DATA INTO MEMORY FROM TAPE
;
RDEBUF PROC NEAR
 CALL RESETMEM
 MOV AX,MEM
 MOV DX,MEM+2
 MOV SI,LENBASE
RBF01:
 MOV CX,AX
 CMP MAXRECL,0
 JNE RBF012
 JCXZ RBF02
 JMP RBF014
RBF012:
 ADD CX,MAXRECL
 JNC RBF02
 JCXZ RBF02
RBF014:
 INC DX
 XOR AX,AX
RBF02:
 PUSH AX
 PUSH DX
 CMP MAXRECL,0
 STC
 JE  RBF024
 ADD AX,MAXRECL
RBF024:
 ADC DX,0
 CMP DX,ENDMEM+2
 JB  RBF03 ;OK
 JA  RBF04 ;MEMORY FULL
 CMP AX,ENDMEM
 JA  RBF04 ;MEMORY FULL
RBF03:
 POP DX
 POP AX
 PUSH SI
 PUSH ES
 PUSH DX
 PUSH AX
 MOV CX,16
 DIV CX
 MOV ES,AX
 MOV BX,DX
 MOV CX,MAXRECL
 MOV AH,2
 MOV DL,BYTE PTR TAPEADDR
 INT 13H
 MOV TS,DX
 POP AX
 POP DX
 POP ES
 POP SI
 TEST TS,000CH
 JNZ RBF05             ;ERROR
 TEST TS,0010H
 JZ  RBF05             ;ERROR
 ADD BLKCOUNT,1
 ADC BLKCOUNT+2,0
 MOV WORD PTR [SI],CX
 STC
 JCXZ RBF038
 ADD AX,CX
RBF038:
 ADC DX,0
 ADD SI,2
 MOV LENPTR,SI
 CMP SI,LENMAX
 JAE RBF05
 JMP RBF01
RBF04:
 POP DX
 POP AX
RBF05:
 RET
RDEBUF ENDP
 
;
;  INITIALIZE MEMORY REQUEST FROM CALLER
;
INIT PROC NEAR
 CMP BFINIT,0
 JNE INT01
 MOV AX,RECL
 MOV RESPAR,AX
 CALL INITMEM
 MOV AX,RESPAR
 MOV RECL,AX
 MOV DX,0
 RET
INT01:
 MOV DX,1
 RET
INIT ENDP
 
;
;  REWIND AND WAIT FOR COMPLETION
;
REWIND PROC NEAR
RDW01:
 MOV AH,11
 MOV DX,TAPEADDR
 INT 13H               ;GO START THE REWIND
 MOV TS,DX
 TEST DX,8000H         ;TEST FOR ONLINE
 JZ  RDW03             ;ERROR
RWD02:
 TEST DX,0200H         ;TEST FOR LOAD POINT
 JNZ RDW03             ;DONE
 MOV AH,0
 MOV DX,TAPEADDR
 INT 13H
 MOV TS,DX
 TEST DX,0800H         ;TEST REWINDING
 JNZ RDW01
 JMP RWD02
RDW03:
 RET
REWIND ENDP
 
;  FORWARD SPACE TO LOGICAL END OF TAPE
;
FSE PROC NEAR
 CMP SHORTIND,0
 JNE FE01
 CALL SETSHORT
FE01:
 MOV AH,7
 MOV CX,1
 MOV DX,TAPEADDR
 INT 13H               ;FORWARD SPACE FILE
 MOV TS,DX
 TEST DX,8000H
 JZ  FE02              ;ERROR
 MOV AH,2
 MOV BX,SHORTBUF
 MOV CX,SHORTLEN
 MOV DX,TAPEADDR
 INT 13H               ;READ ONE BLOCK
 MOV TS,DX
 TEST DX,8000H
 JZ  FE02              ;ERROR
 TEST DX,0008H         ;TEST FOR HARD ERROR
 JNZ FE02              ;ERROR
 TEST DX,0004H         ;TEST FOR FILE MARK READ
 JZ  FE01              ;NO ... KEEP ON GOING
 MOV AH,8
 MOV CX,1
 MOV DX,TAPEADDR
 INT 13H               ;BACK SPACE ONE FILE MARK
 MOV TS,DX
FE02:
 RET
FSE ENDP
 
;
;  IMMEDIATELY READ AND PASS BACK A SINGLE BLOCK
;
RDSHORT PROC NEAR
 CMP SHORTIND,0
 JNE RDS00
 CALL SETSHORT
RDS00:
 MOV AH,2
 MOV BX,SHORTBUF
 MOV CX,SHORTLEN
 MOV DX,TAPEADDR
 INT 13H
 MOV TS,DX
 CMP CX,RECL
 JBE RDS01
 MOV CX,RECL
 AND TS,NOT 0010H      ;FORCE DATA OVERFLOW ERROR
RDS01:
 MOV RECL,CX
 MOV SI,SHORTBUF
 PUSH ES
 LES DI,DWORD PTR BUFFADDR
 REP MOVSB
 POP ES
 RET
RDSHORT ENDP
 
RETCONT PROC NEAR
 MOV DX,TS
 RET
RETCONT ENDP
 
;
; IMMEDIATELY WRITE A SINGLE BLOCK
;
WRSHORT PROC NEAR
 CMP SHORTIND,0
 JNE WRS00
 CALL SETSHORT
WRS00:
 MOV DI,SHORTBUF
 MOV CX,RECL
 CMP CX,SHORTLEN
 JBE WRS01
 MOV CX,SHORTLEN
WRS01:
 PUSH DS
 LDS SI,DWORD PTR BUFFADDR
 PUSH CX
 REP MOVSB
 POP CX
 POP DS
 MOV AH,1
 MOV BX,SHORTBUF
 MOV DX,TAPEADDR
 INT 13H
 MOV TS,DX
 RET
WRSHORT ENDP
 
;
;  SET THE POINTER TO THE INTERNAL BUFFER
;  BE SURE IT DOES NOT CROSS 64K BOUNDARY
;
SETSHORT PROC NEAR
 MOV AX,DS
 MOV CX,16
 MUL CX
 LEA CX,SB1
 ADD AX,CX
 ADC DX,0
 ADD AX,SHORTLEN
 JNC SST01
 JZ  SST01
 LEA CX,SB2
SST01:
 MOV SHORTBUF,CX
 MOV SHORTIND,1
 RET
SETSHORT ENDP
 
IFDEF LARGE
; ==================== LARGE MEMORY MODEL =================
CET_TEXT ENDS
ELSE
; ==================== SMALL MEMORY MODEL =================
_TEXT ENDS
ENDIF
; ==================== END CONDITIONAL ASSEMBLY ===========
 END
