/* ---------------------------------------------------------------------- */
/*              Terminal Abstraction Routines                             */
/* ---------------------------------------------------------------------- */

#include "pcstdio.h"
#include "pcdefs.h"
#include "pcglobal.h"

int color;

Tinit()         /* initialize the terminal */
{   
#ifdef UNIX
	ioctl(0, TIOCGETP, &sgttyb);
	sgttyb.sg_flags &= ~ECHO;
	sgttyb.sg_flags |= RAW;
	ioctl(0, TIOCSETP, &sgttyb);
#endif
        format(Tinstr);  
        Tpad(Tinnul);   
}

Tdeinit()       /* deinitialize the terminal */
{   
#ifdef UNIX
	sgttyb.sg_flags |= ECHO;
	sgttyb.sg_flags &= ~RAW;
	ioctl(0, TIOCSETP, &sgttyb);
#endif
        format(Tdeinstr);  
        Tpad(Tdeinnul);   
}

TCLEOS()                /* Clear to end of screen */
{   
        int x, oldx;
        if (finfp != NULL) return;
        if (Teosstr[0]) {
                format(Teosstr);  
                Tpad(Teosnul);
        } 
        else
                if (Tclsstr[0] && Tabsx == 1 && Tabsy == 1) /* can clear entire screen */
                {   
                        format(Tclsstr); 
                        Tpad(Tclsnul);  
                }
                else
                {   
                        oldx = Tabsx;
                        for (x=Tabsx; x<=Tlines; x++) {
                                Tposn(x, 1);  
                                TCLEOL();
                        }
                        Tposn(oldx, Tabsy);
                }
}

TCLEOL()                /* erase to end of line */
{   
        int y;
        if (finfp != NULL) return;
        if (Teolstr[0]) {
                format(Teolstr);  
                Tpad(Teolnul);
        } 
        else
        {   
                if (vid_mode) format(Tnvstr);  
                y = Tcols-Tabsy+2;  
                while (y--) Tputch(' ');
                Tposn(Tabsx, Tabsy);  
                if (vid_mode) format(Trvstr);
        }
}

Trev()          /* go into reverse video mode */
{   
        if (finfp == NULL) format(Trvstr);  
        vid_mode = 1;   
}

Tnorm()         /* go back to normal video mode */
{   
        if (finfp == NULL) format(Tnvstr);  
        vid_mode = 0;   
}

Tposn(x,y)      /* position the cursor at absolute <x,y> */
int x,y;
{   
        char *ps;  
        int spec;
        Tabsx = x;  
        Tabsy = y;  
        if (finfp != NULL || foutfp != NULL) return;
        ps = Tdcpstr-1;
        while (*++ps)
        {   
                switch (*ps)
                {   
                case '%':   
                        spec = x;  
                        break;
                case '&':   
                        spec = y;  
                        break;
                default:    
                        Tputch(*ps);  
                        continue;
                }
                switch (*++ps)
                {   
                case '+':   
                        Tputch(spec-1 + *++ps);  
                        break;
                case '@':   
                        format("%d");  
                        printf(spec);  
                        break;
                default:    
                        Tputch(spec-1);  
                        --ps;  
                        break;
                }
        }
        Tpad(Tdcpnul);
}

Tpad(n)         /* pad the terminal with 'n' NULs */
int n;
{   
        while (n--) Tputch(NULL);   
}

Tcolor(c)
int c;
{
}
