/* COMMTOO.C -- pf command interpeter, continued ******************************

	(C) 1982 Perfect Software, Inc.

	01/26/82	Version 1.00 by Barry A. Dobyns

******************************************************************************/

#include "pf.gbl"

FLAG
CheckEnv(tkn)				/* deal with environments */
	char *tkn;
{
	char which;
	int *indx;
	int ParaOut(), ParaEnum(), ParaItem(), ParaStan(), CloseSec();
#ifdef LARGE
	int ParaLevel(), CloseLevel();
#endif

	if (Test(tkn,"indent")) {
		env.eleft=env.cureleft+=HALFINCH;
		env.justifytype=sty.prefjust;
		env.isfill=TRUE;
		env.iswrap=TRUE;
		StartEnv();
		return(TRUE);
			}

	if ((which=MulTest(tkn,"address","flushleft")) || Test(tkn,"closing")) {
		env.isfill=FALSE;
		env.iswrap=FALSE;
		env.iswhiteintact=TRUE;
		if (which!=2) env.preveleft=env.eleft=env.cureleft=
			(pag.pright+pag.pleft)/2;
		StartEnv();
		return(TRUE);
		}
	if (which=MulTest(tkn,"center","flushright")) {
		env.isfill=FALSE;
		env.iswrap=FALSE;
		env.iswhiteintact=TRUE;
		env.justifytype= (which==1)? 'c' : 'r';
		StartEnv();
		return(TRUE);
		}
	if (which=MulTest(tkn,"description","undent")) {
		if (which==1) {
			env.eleft=env.cureleft+=(env.eright-env.cureleft)/4;
			env.linespacing=LINEHEIGHT;
			}
		else env.eleft=env.cureleft+=sty.indent * dev.stdhoriz;
		env.justifytype=sty.prefjust;
		env.paraproc=ParaOut;
		StartEnv();
		return(TRUE);
		}
	if (MulTest(tkn,"display","example")) {
		env.eleft=env.cureleft+=HALFINCH;
		env.eright-=HALFINCH/2;
		env.isfill=FALSE;
		env.iswhiteintact=TRUE;
		StartEnv();
		return(TRUE);
		}
	if (Test(tkn,"enumerate")) {
		env.preveleft=env.cureleft+2*CHARWIDTH;
		env.eleft=env.cureleft+=6*CHARWIDTH;
		env.justifytype=sty.prefjust;
		env.enumcount=1;
		env.paraproc=ParaEnum;
		StartEnv();
		return(TRUE);
		}
	if (MulTest(tkn,"format","verbatim")) {
		DoVerbatim();
		StartEnv();
		return(TRUE);
		}
	if (Test(tkn,"itemize")) {
		env.preveleft=env.cureleft+2*CHARWIDTH;
		env.eleft=env.cureleft+=5*CHARWIDTH;
		env.justifytype=sty.prefjust;
		env.paraproc=ParaItem;
		env.itemlevel++;
		StartEnv();
		return(TRUE);
		}
	if (Test(tkn,"level")) {
#ifdef OVERLAID
		OvlCall(DOLEVEL);
#else
		DoLevel();
#endif
		return(TRUE);
		}
	if (Test(tkn,"quotation")) {
		env.eleft=env.cureleft+=HALFINCH;
		env.eright-=HALFINCH;
		env.linespacing=LINEHEIGHT;
		env.justifytype=sty.prefjust;
		env.paraproc=ParaStan;
		StartEnv();
		return(TRUE);
		}
	if (Test(tkn,"text")) {
		env.justifytype=sty.prefjust;
		env.paraproc=ParaStan;
		env.linespacing=sty.spacing;
		StartEnv();
		return(TRUE);
		}
	if (Test(tkn,"verse")) {
		env.eleft=env.preveleft+=3*CHARWIDTH;
		env.cureleft=env.preveleft+2*CHARWIDTH;
		env.eright-=10*CHARWIDTH;
		env.linespacing=LINEHEIGHT;
		env.isfill=FALSE;
		env.paraproc=ParaOut;
		StartEnv();
		return(TRUE);
		}
	if ((which=MulTest(tkn,"unnumbered","majorheading")) ||
		 Test(tkn,"heading")) {
		env.isfill=FALSE;
		env.justifytype='c';
		env.closeproc=CloseSec;
		env.closechar=BOLDOFF;
		BreakLine();
		if (which==1) PNewPage();
		StartEnv();
		PPutVert((which ? 6 : 4)*LINEHEIGHT);
		PutOneCh(BOLDON);
		return(TRUE);
		}
	if (MulTest(tkn,"prefacesection","subheading")) {
		env.isfill=FALSE;
		env.closeproc=CloseSec;
		env.closechar=UNALLOFF;
		StartEnv();
		PPutVert(4*LINEHEIGHT);
		PutOneCh(UNALLON);
		return(TRUE);
		}
	return(FALSE);
	}

FLAG
CheckSec(tkn)			/* deal with sectioning commands */
	char *tkn;
{
	TITLELIST *tptr;
	STRING *token;
	char which;

	if (which=MulComp(tkn,"chapter","appendix")) {
		if (!sty.ischapter) {
			TError("@Chapter and @Appendix have been disabled.",NULL,NULL);
			return(TRUE);
			}
		tptr=AddToC();

		if (which==1) {
			tptr->enttype='c';
			tptr->entnum= ++(chapter->value);
			SetVar("chaptertitle",'s',SCToS(SSToC(tptr->entname)));
			}
		else {
			tptr->enttype='a';
			tptr->entnum= ++(appendix->value);
			/* if we are in the appendix, we want the appendix title. */
			SetVar("chaptertitle",'s',SCToS(SSToC(tptr->entname)));
			SetVar("appendixtitle",'s',SCToS(SSToC(tptr->entname)));
			}
		SecStart(tptr->enttype);

		BreakLine();
		PNewPage();
		PPutVert(6*LINEHEIGHT);

		tptr->entpage=pagenum;

		TPuts(" (");
		if (which==1) TPutn(chapter->value);
		else TPut('A'-1+appendix->value);
		TPut(')');

		EPush();
		env.isfill=FALSE;
		env.justifytype='c';
		PutInit();
		PutOneCh(BOLDON);
		if (which==1) {
			PutStr("Chapter ");
			Template('c');
			}
		else {
			PutStr("Appendix ");
			Template('a');
			}
		PutFini();
		BreakLine();
		PPutVert(LINEHEIGHT);
		PutInit();
		PutStr(SSToC(tptr->entname));
		PutOneCh(BOLDOFF);
		PutFini();
		BreakLine();
		PPutVert(3*LINEHEIGHT);
		EPop();
		return(TRUE);
		}
	if (which=MulComp(tkn,"section","appendixsection")) {
		tptr=AddToC();
		if (which==1) {
			tptr->enttype='s';
			tptr->entnum= ++(section->value);
			SetVar("sectiontitle",'s',SCToS(SSToC(tptr->entname)));
			}
		else {
			tptr->enttype='n';
			tptr->entnum= ++(asection->value);
			/* if we are in the appendix, we want the appendix title. */
			SetVar("sectiontitle",'s',SCToS(SSToC(tptr->entname)));
			SetVar("appendixsectiontitle",'s',SCToS(SSToC(tptr->entname)));
			}
		SecStart(tptr->enttype);

		BreakLine();
		PPutVert(4*LINEHEIGHT);
		EPush();
		env.isfill=FALSE;
		env.justifytype='l';
		PutInit();
		PutOneCh(UNALLON);
		Template((which==1) ? 's' : 'n');
		PutOneCh(SP);
		PutStr(SSToC(tptr->entname));
		PutOneCh(UNALLOFF);
		PutFini();
		BreakLine();

		tptr->entpage=pagenum;

		TPuts(" (");
		if (which==1) TPutn(chapter->value);
		else TPut('A'-1+appendix->value);
		TPut('.');
		TPutn((which==1) ? section->value : asection->value);
		TPut(')');

		PPutVert(2*LINEHEIGHT);
		EPop();
		return(TRUE);
		}
	if (which=MulComp(tkn,"subsection","paragraph")) {
		tptr=AddToC();
		if (which==1) {
			tptr->enttype='b';
			tptr->entnum= ++(subsection->value);
			SetVar("subsectiontitle",'s',SCToS(SSToC(tptr->entname)));
			paragraph->value=0;
			}
		else {
			tptr->enttype='p';
			tptr->entnum= ++(paragraph->value);
			SetVar("paragraphtitle",'s',SCToS(SSToC(tptr->entname)));
			}

		BreakLine();
		PPutVert(2*LINEHEIGHT);
		EPush();
		env.isfill=FALSE;
		env.justifytype='l';
		PutInit();
		Template((which==1) ? 'b' : 'p');
		PutOneCh(SP);
		PutStr(SSToC(tptr->entname));
		PutFini();
		BreakLine();

		tptr->entpage=pagenum;

		PPutVert(LINEHEIGHT);
		EPop();
		return(TRUE);
		}
	return(FALSE);
	}

DoVerbatim()
{
	env.linespacing=LINEHEIGHT;
	env.isfill=FALSE;
	env.iswrap=FALSE;
	env.iswhiteintact=TRUE;
	env.paraproc=NUL;
	}

/* END OF COMMTOO.C */
                                                                 