PAGE	,132
;	ANSI CONsole device driver for the Z-150 computer
;
;	Author:	RJM
;	Date: 1/11/84
;	File: Z150ANSI.ASM
;

;
;		RESTRICTED RIGHTS LEGEND
;		------------------------
;	
;	    "Use, duplication, or disclosure by the
;	Government is subject to restrictions as set forth
;	in paragraph (b) (3) (B) of the Rights in Technical
;	Data and Computer Software clause in DAR
;	7-104.9(a).  Contractor/manufacturer is Zenith
;	Data Systems Corporation of Hilltop Road, St.
;	Joseph, Michigan 49085.
;

	TITLE	ANSI - ANSI device driver for the Z-150

	.LFCOND
	.TFCOND		; Use the /X switch to cause FALSE conds not to list

	.XLIST
	INCLUDE ..\COMMONS\Z150ROM.DEF
	INCLUDE ..\COMMONS\Z150BIOS.DEF
	INCLUDE ..\COMMONS\DRIVERS.DEF
	INCLUDE ..\COMMONS\ASCII.DEF
	.LIST


FALSE	=	0
TRUE	=	NOT FALSE

	PAGE

CODE	SEGMENT	BYTE PUBLIC 'CODE'
	ASSUME	CS:CODE,DS:CODE,ES:CODE,SS:CODE

ZERO	=	$

BIOS_DEVS LABEL	BYTE
DVH_ANSI LABEL	NEAR
	DW	-1
	DW	-1
	DW	DVHA_CHR+13H
	DW	OFFSET STRATEGY
	DW	OFFSET INTR_ANSI
	DB	"CON     "

ANSITBL	LABEL	WORD
	DW	ANSI_INIT	; Initialization
	DW	EXIT_SUCC	; Media check 
	DW	EXIT_SUCC	; Build BPB 
	DW	EXIT_SUCC	; IOCTL input
	DW	ANSI_IN		; Input
	DW	ANSI_ICHK	; Non-destructive input no wait 
	DW	ANSI_ISTAT	; Input status 
	DW	ANSI_IFL	; Input flush 
	DW	ANSI_OUT	; Output
	DW	ANSI_OUT	; Output (write) with verify
	DW	EXIT_SUCC	; Output status 
	DW	ANSI_OFL	; Output flush 
	DW	EXIT_SUCC	; IOCTL output

PTRSAV		DD ?		; Request packet pointer

ESC     =	1BH             ;Escape character used in this implementation.

STATE   DW      ST1             ;Current ANSI character state.

TEN		DB	10
QUOTE_CHAR	DB	?	; Match character for quoted string
NXT_CHAR	DB	0	; Next character in the input stream
ATTRIBUTE	DB	7	; Attribute for character output
CURSOR_POS	DW	0	; Last saved cursor position
WRAP_FLAG	DB	TRUE	; Flag for screen wrap around (Init. false)
CRT_ROWS	=	25	; Number of rows on the CRT
CRT_COLS	DB	?	; Number of columns on the CRT
VPAGE		DB	0	; Current video page

;	Variables for key remapping
STRING_PTR	DW	0	; Pointer to next character in string
STRING_COUNT	DB	0	; Number of characters left in string

;	Corsor report string
REPORT	DB	CC_ESC, '[', 0, 0, ';', 0, 0, 'R', CC_CR
LREPORT	=	OFFSET $ - OFFSET REPORT

SS_SAVE	DW	?		; Stack of caller
SP_SAVE	DW	?
	DW	128 DUP(?)
STACK	LABEL	WORD

;	Cursor location of current cursor
CURSOR_LOC	LABEL	WORD
COL		DB	?
ROW		DB	?

PRMSTART	DW	PARAMS+4	; Start of parameter buffer
PRMPNT		DW      PARAMS+4	;Current parameter pointer.

;	Parameter table.  Filled with strings of the following form:
;		count,parm_1,...,parm_n  where count is a count of the
;		number of bytes the string takes. (i.e. n-1 params in a string)
;
PARAMS  DB      4,0,72H,10H, 252 DUP(0)	;Allow for parameters.
LASTPRM =	OFFSET ($-ZERO)

CMDTABL DB      'A'             ;Cursor up.  "esc","[",#,"A"
        DW      CUU
        DB      'B'             ;Cursor down. "esc","[",#,"B"
        DW      CUD
        DB      'C'             ;Cursor forward. "esc","[",#,"C"
        DW      CUF
        DB      'D'             ;Cursor back. "esc","[",#,"D"
        DW      CUB
        DB      'H'             ;Direct cursor posit. "esc","[",x,y,"H"
        DW      CUP
        DB      'J'             ;Erase. "esc","[",code,"J"
        DW      ED
        DB      'K'             ;Erase in line. "esc","[",code,"K"
        DW      EL
	DB	'R'		; Eat the escape seq. for cursor report
	DW	STSKIP
        DB      'f'             ;Direct cursor posit. "esc","[",x,y,"f"
        DW      CUP
        DB      'm'             ;Special video mode. "esc","[",code,"m"
        DW      SGR
        DB      's'             ;Save cursor posit. "esc","[","s"
        DW      PSCP
        DB      'u'             ;Move cursor to saved. "esc","[","u"
        DW      PRCP
	DB	'h'		;Set mode #2
	DW	QMARKH
	DB	'l'		;Reset mode #2
	DW	QMARKL
;	DB	'r'		;Ignore any ending in 'r'
;	DW	STSKIP
;	DB	'q'		;   or ending in 'q'
;	DW	STSKIP
;	DB	'w'		;   or ending in 'w'
;	DW	STSKIP
;	DB	'i'		;   or ending in 'i'
;	DW	STSKIP
;	DB	'g'		;   or ending in 'g'
;	DW	STSKIP
	DB	'n'		;   Report cursor position
	DW	DSR
	DB	'p'		;   Remap key
	DW	MAP_KBD
;	DB	'v'		;   or ending in 'v'
;	DW	STSKIP
;	DB	'x'		;   or ending in 'x'
;	DW	STSKIP
;	DB	'z'		;   or ending in 'z'
;	DW	STSKIP
;	DB	'}'		;   or ending in '}'
;	DW	STSKIP
        DB      00              ;End of table.


STRATEGY PROC	FAR
	MOV	WORD PTR CS:PTRSAV,BX
	MOV	WORD PTR CS:PTRSAV+2,ES
	RET
STRATEGY ENDP

; Get addr of dispatch table and join common code

INTRP	PROC	FAR

INTR_ANSI:
	
	PUSH	AX
	MOV	CS:SS_SAVE,SS
	MOV	CS:SP_SAVE,SP
	MOV	AX,CS
	CLI
	MOV	SS,AX
	MOV	SP,OFFSET STACK
	STI
	PUSH	BX
	PUSH	CX
	PUSH	DX
	PUSH	SI
	PUSH	DI
	PUSH	BP
	PUSH	DS
	PUSH	ES
	
	PUSH	CS
	POP	DS

; Check if command valid, and then dispatch to it

	LES	BX,PTRSAV	; Get packet addr
	MOV	CL,ES:SRH_CMD[BX]	; Get command
	CMP	CL,SRHC_MAX	; Is command valid ?
	JA	CMDERR		;   No, show error
	XOR	CH,CH		; Clear upper half
	SHL	CX,1		; Make into word offset
	MOV	SI,CX		; Compute table entry
	JMP	ANSITBL[SI]	; Dispatch to command


; Command error exit

CMDERR:
	MOV	AL,SRHS_EUKC	; Get UNKNOWN CODE
;	JMP	SHORT EXIT_ERR	; Join common code


; Error exit

EXIT_ERR:
	MOV	AH,SRHS_ERR OR SRHS_DON ; Mark error and done
	JMP	SHORT EXIT1	; Join code


; Success exit	

EXIT_SUCC:
	MOV	AH,SRHS_DON	; Mark as done
;	JMP	SHORT EXIT1	; Join common code

; Common exit code

EXIT1:
	LES	BX,CS:PTRSAV	; Get packet addr
	MOV	ES:SRH_STAT[BX],AX ; Store status

	POP	ES		; Restore regs
	POP	DS
	POP	BP
	POP	DI
	POP	SI
	POP	DX
	POP	CX
	POP	BX
	CLI
	MOV	SS,CS:SS_SAVE
	MOV	SP,CS:SP_SAVE
	STI
	POP	AX
	RET
INTRP	ENDP

;
; ANSI_INIT - Set up CON device
;

ANSI_INIT:

;	Install this driver for INT 29H output

	SUB	AX,AX
	MOV	ES,AX
	MOV	DI,29H SHL 2
	CLD
	MOV	AX,OFFSET SPECIAL
	STOSW
	MOV	AX,CS
	STOSW

;	Take keyboard break address

	MOV	DI,BREAK_INTR SHL 2
	MOV	AX,OFFSET KB_BREAK
	STOSW
	MOV	AX,CS
	STOSW

;	Return the length of the driver

	MOV	DX,OFFSET END_DRIVER		; DS:DX Points to end
	LES	BX,PTRSAV
	MOV	ES:WORD PTR CIN_KADDR[BX],DX
	MOV	ES:WORD PTR CIN_KADDR[BX+2],CS	
	JMP	EXIT_SUCC


;**	SPECIAL - This routine is the special console output routine.
;		It is accessed by INT 29H

SPECIAL	PROC	FAR
	STI
	PUSH	DS
	PUSH	AX
	PUSH	BX
	PUSH	CX
	PUSH	DX
	
	PUSH	CS
	POP	DS
	CALL	ANSI_CONFUNC

	POP	DX
	POP	CX
	POP	BX
	POP	AX
	POP	DS
	IRET
SPECIAL ENDP


; Busy exit

EXIT_BUS:
	MOV	AH,SRHS_BUI OR SRHS_DON ; Mark busy and done
	JMP	SHORT EXIT1	; Join common code


;
; Read from console
;

ANSI_IN:
	MOV	CX,ES:[BX+CRW_CNT]	; Get transfer count
	LES	DI,ES:[BX+CRW_TADDR]	; Get transfer address
	CLD

CI1:
	MOV	AL,0			; Clear out next character
	XCHG	NXT_CHAR,AL
	OR	AL,AL			; Was there a char in look-ahead
	JNZ	CI4			; Yes, return it.

;	Check if a string is being sent

	CMP	STRING_COUNT,0		; Any string left?
	JZ	CI2			; No, read a char.
CI1A:
	MOV	SI,STRING_PTR		; Yes, get next char in string
	MOV	AL,[SI]
	INC	STRING_PTR		; Prepare for next one
	DEC	STRING_COUNT
	JMP	SHORT CI4		; Got a good char

;	Read a character from the keyboard
	
CI2:
	MOV	AH,KIO_READ		; Code for input character
	INT	KEYBOARD_IO_INTR

;	Re-map the input key

	CALL	MATCH_KEY		; Try to match the key
	CMP	STRING_COUNT,0		; String now available?
	JNZ	CI1A			; Yes, get first char
CI3:
	CMP	AL,0			; If special key then
	JNZ	CI4
	MOV	NXT_CHAR,AH		; Save scan code
CI4:
	STOSB
	LOOP	CI1
	JMP	EXIT_SUCC


;
; Non-destructive read
;

ANSI_ICHK:
	MOV	AL,NXT_CHAR		; See if look ahead has a character
	OR	AL,AL
	JNZ	CL1

;	Check if a string is active

	CMP	STRING_COUNT,0
	JZ	CL2			; No, continue
	MOV	SI,STRING_PTR		; Yes, get char.
	MOV	AL,[SI]
	JMP	SHORT CL1		; Got lookahead char.

;	See if ROM has a character

CL2:
	MOV	AH,KIO_LOOK		; Get ROM keyboard status
	INT	KEYBOARD_IO_INTR
	JZ	EXIT_BUS		; No char., skip
	OR	AX,AX			; Check for remnants of Ctrl-break
	JNZ	CL0			; Nope, valid character
	MOV	AH,KIO_READ		; Yep, eat this character
	INT	KEYBOARD_IO_INTR
	JMP	ANSI_ICHK		; Check for another
CL0:
	CALL	MATCH_KEY		; Try to match the key
	CMP	STRING_COUNT,0		; Did it match
	JZ	CL1			; No, return this char.
	MOV	AH,KIO_READ		; Yes, eat this char and
	INT	KEYBOARD_IO_INTR
	MOV	SI,STRING_PTR		;  pass back string char.
	MOV	AL,[SI]
CL1:
	MOV	ES:[BX+CIC_CHAR],AL	; Pass character
	JMP	EXIT_SUCC


;
; Input status
;

ANSI_ISTAT:

	MOV	AL,NXT_CHAR		; See if look ahead has a character
	OR	AL,AL
	JNZ	CIS1
	CMP	STRING_PTR,0		; See if a string is active
	JNZ	CIS1
	MOV	AH,KIO_LOOK		; Get ROM keyboard status
	INT	KEYBOARD_IO_INTR
	JZ	CIS2			; No char., skip
CIS1:
	JMP	EXIT_BUS
CIS2:
	JMP	EXIT_SUCC


;
; Input flush
;

ANSI_IFL:
	MOV	NXT_CHAR,0		; Flush look ahead
	PUSH	AX			; Save registers (CON_FLUSH used in disk I/O)
	PUSH	DS
	MOV	AX,ROM_DATA		; Point to ROM data
	MOV	DS,AX

	ASSUME	DS:ROM_DATA

	MOV	AX,BUFFER_HEAD		; Get offset of beginning of buffer
	MOV	BUFFER_TAIL,AX		; Get pointer to buffer head
	POP	DS			; Restore all registers

	ASSUME	DS:CODE

	POP	AX
	JMP	EXIT_SUCC


;
; Write to console
;

ANSI_OUT:
	MOV	CX,ES:[BX+CRW_CNT]
	LDS	SI,ES:[BX+CRW_TADDR]	; Get the address of characters
CO1:
	CLD
	LODSB
	PUSH	SI
	PUSH	DS
	PUSH	CS
	POP	DS

	CALL	ANSI_CONFUNC

	POP	DS
	POP	SI

	LOOP	CO1
	JMP	EXIT_SUCC	; Join common code

;	ANSI_OFL
;		Flush output queue
;
ANSI_OFL:
	MOV	STRING_COUNT,0	; Flush any pending input string
	RET


;
;ANSI Info and routines. ANSI driver implemented as a finite state automata
;This ANSI driver translates the ANSI standard escape sequences into the
; Z-150 functions. This driver is not a full implementation of ANSI, but 
; rather a minimal implementation which implements all of the necessary
; ANSI functions.
;

;
; ANSI console output driver.
;

ANSI_CONFUNC:
        JMP     STATE           ;Jump to current state

;
; State one (1).
;   Looks for an Escape character.
;

ST1:    CMP     AL,ESC          ;See if this the first character is ESC.
        JNZ     ST1A	        ;No, treat as regular character output.
        MOV     WORD PTR STATE,OFFSET ST2        ;Yes, setup state two.
        RET
ST1A:
	MOV	STATE,OFFSET ST1
	JMP	NEAR PTR OUTCHAR

;
; State two (2).
;   Looks for the "[" character.
;

ST2:
        CMP     AL,'['          ;See if a valid state two.
        JNZ     ST1		; If an extra big one
	
        MOV     BX,PRMSTART	;Yes, get parameter pointer(flush previous).
	INC	BX		; Save spot for count of parms
        MOV     WORD PTR [PRMPNT],BX    ;Setup in pointer index.
        MOV     WORD PTR [BX],0 ;Clear first entry.
        MOV     STATE,OFFSET ST3;Setup for state three.
        RET

STSKIP:
	MOV	WORD PTR STATE,OFFSET ST1
	RET

;
; State three (3).
;   Entered one or more times for parameter passing.
;

ST3:    CMP     AL,';'          ;Look for decimal # seperator.
        JNZ     ST3A            ;No check phase A.
        INC     PRMPNT		;Yes, incr. pointer to next param.
        CMP     PRMPNT,LASTPRM	; At the end?
        JB	RETST3		;No, proceed with next parameter.
        DEC     PRMPNT		;Yes, treat as extentsion to old.
RETST3: MOV     DI,PRMPNT	;Setup for next parameter.
        MOV     BYTE PTR [DI],0 ;Pre-Initialize it to zero.
        RET

;
; State three A (3A).
;   Check for a ascii digit.
;

ST3A:   CMP     AL,'0'          ;Check for ASCII digit.
        JB      ST3A1           ;No, check for seconday command character.
        CMP     AL,'9'          ;Still checking for ASCII digit.
        JA      ST3A1           ;No, it must be a secondary.
        SUB     AL,'0'          ;Convert to binary.
        MOV     DI,PRMPNT	;Get the current parameter pointer.
        XCHG    [DI],AL         ;Get existing #.
        MOV     AH,10           ;Scale by 10.
        MUL     AH
        ADD     [DI],AL         ;Add to new digit.
        RET

;	Check for ?, =, ', and " characters
ST3A1:
	CMP	AL,'?'		; Nothing to do here
	JZ	ST3A3
	CMP	AL,'='		; Nothing to do here
	JZ	ST3A3
	CMP	AL,'"'		; Prepare for string processing
	JZ	ST3A2
	CMP	AL,"'"		; Prepare for string processing
	JNZ	ST3B
ST3A2:
	MOV	QUOTE_CHAR,AL	; Save qoute character for later match
	MOV	STATE,OFFSET ST4	; State for processing strings
ST3A3:
	RET

;	State 4 Process a string in an escape seq.
ST4:
	CMP	AL,QUOTE_CHAR		; End of string?
	JNZ	ST4A			; No, process character
	DEC	PRMPNT			; Back up pointer to correct pos.
	MOV	STATE,OFFSET ST3	; Yes, back to state 3 for more parameters
	RET
ST4A:
	MOV	DI,PRMPNT		; Get pointer
	MOV	[DI],AL			; Save character
	INC	DI
	CMP	DI,OFFSET LASTPRM
	JAE	ST4B
	MOV	BYTE PTR [DI],0
	INC	PRMPNT			; Prepare for next parm.
ST4B:
	RET


;
; State three B (3B).
;   Wasn't a ascii digit, so check for secondary command.
;

ST3B:   MOV	STATE,OFFSET ST1	;Preset STATE to state 1 just in case.
	MOV	BX,PRMPNT		;Get current pointer
	MOV	DI,PRMSTART		; Get start of parameter pointer
	SUB	BX,DI			; Get count of bytes in this string
	INC	BL
	MOV	[DI],BL			; Save as first thing at PRMSTART
	MOV	PRMPNT,DI		; Reset pointer to access parameters
        MOV     DI,OFFSET CMDTABL-3     ;Get start of Secondary command table.

ST3B1:  ADD     DI,3		;Update Command table pointer.
        CMP     BYTE PTR [DI],0	;Check for end of table.
        JNZ     ST3B2		;No, continue processing.
        JMP     OUTCHAR		;Yes, treat as regular character.
ST3B2:  CMP     AL,[DI]		;Check for valid. command.
        JNZ     ST3B1		;No, keep checking.
        JMP     [DI+1]		;Yes, transfer to that secondary command.

;
; Get binary parameter from storage and return a one if = 0
;

GETONE: CALL    GETPARM         ;Get parameter form list.
        OR      AL,AL           ;Verify for non-zero.
        JNZ     GETRET          ;Good, then return to caller.
        INC     AL              ;Bad, make it at least a one.
GETRET: CBW                     ;Sign extend AL.
        MOV     CX,AX           ;Copy of it to CX.
        RET

GETPARM:INC     WORD PTR [PRMPNT]       ;Increment parameter pointer.
GOTPARM:MOV     DI,[PRMPNT]     ;Get parameter pointer.
        MOV     AL,[DI]         ;Get parameter value.
        RET


;	NOP - Do nothing

NOP:
	RET

;	Set and Reset modes
QMARKH:
	CALL	GETPARM
	CMP	AL,7		; Check for wrap request
	JNZ	QM1
	MOV	WRAP_FLAG,TRUE	; Make wrap active
	RET
QMARKL:
	CALL	GETPARM
	CMP	AL,7		; Check for wrap request
	JNZ	QM1
	MOV	WRAP_FLAG,FALSE	; Make wrap inactive
	RET
QM1:
	CMP	AL,6		; Make sure parameter valid
	JBE	QM2
	RET
QM2:
	MOV	AH,VIO_MODE	; Set video mode
	INT	VIDEO_IO_INTR
	RET

;
; Enter/exit reverse video
;

ERV:
	MOV	ATTRIBUTE,07H
	RET
XRV:
	MOV	ATTRIBUTE,70H
	RET

;
; Direct cursor positioning routine.
;

CUP:
	CALL	GETONE
	MOV	DH,AL
	DEC	DH
	CALL	GETONE
	MOV	DL,AL
	DEC	DL
	JMP	SHORT MOVE_CURSOR

;	Move cursor up
CUU:
	CALL	CURRENT_CURSOR		; Get current cursor position
	CALL	GETONE
	SUB	DH,AL
	JNS	MOVE_CURSOR
	SUB	DH,DH
	JMP	SHORT MOVE_CURSOR

;	Move cursor down
CUD:
	CALL	CURRENT_CURSOR
	CALL	GETONE
	ADD	DH,AL
	CMP	DH,CRT_ROWS
	JB	MOVE_CURSOR
	MOV	DH,CRT_ROWS-1
	JMP	SHORT MOVE_CURSOR

;	Move cursor right
CUF:
	CALL	CURRENT_CURSOR
	CALL	GETONE
	ADD	DL,AL
	CMP	DL,CRT_COLS
	JB	MOVE_CURSOR
	MOV	DL,CRT_COLS
	DEC	DL
	JMP	SHORT MOVE_CURSOR

;	Move cursor left
CUB:
	CALL	CURRENT_CURSOR
	CALL	GETONE
	SUB	DL,AL
	JNS	MOVE_CURSOR
	SUB	DL,DL
	JMP	SHORT MOVE_CURSOR

;	Move the cursor to the values specified in DX
MOVE_CURSOR:
	MOV	AH,VIO_SCP
	INT	VIDEO_IO_INTR
	RET

;
; Erase all/part of screen.
;

ED:
	CALL	GETPARM
	MOV	AH,VIO_CVS		; Get current state
	INT	VIDEO_IO_INTR
	PUSH	BX			; Save page
	DEC	AH			; Set column
	MOV	DL,AH
	MOV	DH,CRT_ROWS-1		; Bottom right corner
	SUB	CX,CX			; Top left corner
	MOV	BH,ATTRIBUTE
	SUB	AL,AL			; Scroll entire window
	MOV	AH,VIO_SPU		; Erase screen
	INT	VIDEO_IO_INTR
	SUB	DX,DX			; Home the cursor
	POP	BX
	JMP	MOVE_CURSOR

;
; Erase all/part of a line.
;

EL:
	MOV	AH,VIO_CVS
	INT	VIDEO_IO_INTR
	PUSH	AX
	MOV	AH,VIO_RCP
	INT	VIDEO_IO_INTR
	POP	AX
	PUSH	DX
	SUB	AH,DL
	MOV	CL,AH
	SUB	CH,CH
	MOV	AL,' '
	MOV	BL,ATTRIBUTE
	MOV	AH,VIO_WAC
	INT	VIDEO_IO_INTR
	POP	DX
	JMP	MOVE_CURSOR

;
; Special video modes.
;

SGR:
	MOV	DI,PRMSTART	; Get the number of parameters
	MOV	CL,[DI]
	DEC	CL		; Number of parms is one less
	SUB	CH,CH
SGR1:
	PUSH	CX
	CALL	GETPARM		; Process all parameters
	CALL	SET_ATTR
	POP	CX
	LOOP	SGR1
	RET

;	Set the attribute byte according to given parameters
SET_ATTR	PROC	NEAR
;	Check for normal video
	CMP	AL,0
	JNZ	SA1
	MOV	ATTRIBUTE,7
	RET

;	Check for high intensity
SA1:
	CMP	AL,1
	JNZ	SA2
	OR	ATTRIBUTE,1 SHL 3
	RET

;	Check for blink
SA2:
	CMP	AL,5
	JNZ	SA3
	OR	ATTRIBUTE,1 SHL 7
	RET

;	Check for reverse video
SA3:
	CMP	AL,7
	JNZ	SA4
	AND	ATTRIBUTE,88H
	OR	ATTRIBUTE,70H
	RET

;	Check for invisible
SA4:
	CMP	AL,8
	JNZ	SA5
	MOV	ATTRIBUTE,0
	RET

;	Check foreground color
SA5:
	CMP	AL,30
	JB	SA6
	CMP	AL,37
	JA	SA6
	SUB	AL,30
	CALL	SWAP			; Swap bits around to get correct color map
	AND	ATTRIBUTE,NOT 7		; Get rid of old info.
	OR	ATTRIBUTE,AL		; Put in new info.
	RET

;	Check background color
SA6:
	CMP	AL,40
	JB	SA7
	CMP	AL,47
	JA	SA7
	SUB	AL,40
	CALL	SWAP
	AND	ATTRIBUTE,NOT 70H
	SHL	AL,1
	SHL	AL,1
	SHL	AL,1
	SHL	AL,1
	OR	ATTRIBUTE,AL
	RET
SA7:
	RET
SET_ATTR	ENDP

;	Reverse the order of the low three bits in AL
SWAP	PROC	NEAR
	SUB	AH,AH
	SHR	AL,1
	RCL	AH,1
	SHR	AL,1
	RCL	AH,1
	SHR	AL,1
	RCL	AH,1
	MOV	AL,AH
	RET
SWAP	ENDP

;
; Save / restore cursor position.
;

PSCP:
	MOV	AH,VIO_CVS
	INT	VIDEO_IO_INTR
	MOV	AH,VIO_RCP
	INT	VIDEO_IO_INTR
	MOV	CURSOR_POS,DX
	RET

PRCP:
	MOV	AH,VIO_CVS
	INT	VIDEO_IO_INTR
	MOV	DX,CURSOR_POS
	JMP	MOVE_CURSOR

;	Report cursor position
DSR:
	CALL	GETPARM
	CMP	AL,6
	JNZ	DSR_EXIT
	CALL	CURRENT_CURSOR		; Get the current cursor
	INC	DL
	INC	DH
	MOV	AL,DH			; Translate it into ASCII
	CBW
	DIV	TEN
	ADD	AX,'0' SHL 8 + '0'
	MOV	WORD PTR REPORT+2,AX	; Save row

	MOV	AL,DL			; Translate col into ASCII
	CBW
	DIV	TEN
	ADD	AX,'0' SHL 8 + '0'
	MOV	WORD PTR REPORT+5,AX	; Save it

	MOV	STRING_PTR,OFFSET REPORT	; Set up string output
	MOV	STRING_COUNT,LREPORT
DSR_EXIT:
	RET


;
;	Map the keyboard
;

MAP_KBD:
	MOV	DI,PRMSTART		; Get count of chars.
	MOV	AL,[DI]
	CMP	AL,2			; Two byte or less string is not valid
	JBE	MK_EXIT
	CMP	AL,3			; Check for 3 byte string
	JNZ	MK1			; Longer must be valid
	CMP	BYTE PTR [DI+1],0	; Key must not be special key
	JZ	MK_EXIT			; String invalid

;	Valid string found, enter it

MK1:
	PUSH	AX
	MOV	AL,BYTE PTR [DI+1]	; Get character
	CMP	AL,0			; Is it a special key?
	JNZ	MK2			; No, skip
	MOV	AX,WORD PTR [DI+1]	; Get extended code
MK2:
	CALL	MATCH_KEY		; See if its already defined
	CMP	STRING_COUNT,0		; Was it already defined?
	JZ	MK4			; No, install it
	MOV	CL,STRING_COUNT
	MOV	CH,0
	MOV	STRING_COUNT,CH
	MOV	DI,STRING_PTR
	SUB	DI,2			; Point to count (or 0 if special)
	ADD	CX,2			; Bump count
	CMP	BYTE PTR [DI],0		; Is it a special char?
	JNZ	MK3			; No, skip
	INC	CX
	DEC	DI
MK3:
	MOV	SI,DI
	ADD	SI,CX			; SI points to next string
	MOV	CX,PRMSTART
	MOV	BX,CX			; Point BX to count
	SUB	CX,SI			; Get length of remaining strings
	ADD	CL,BYTE PTR [BX]	; Add in current string length
	PUSH	DS
	POP	ES
	REP	MOVSB			; Delete old definition
	MOV	CX,SI			; Get # chars deleted
	SUB	CX,DI
	SUB	PRMSTART,CX		; Reflect move
MK4:
	POP	AX
	SUB	AH,AH
	ADD	AX,PRMSTART		; Find new pointer
	CMP	AX,LASTPRM-8		; Check if less than eight spaces are left
	JAE	MK_EXIT			; If so then do not allow mapping
	MOV	PRMSTART,AX		; else map key

MK_EXIT:
	RET

;	Attempt to match a key, set STRING_COUNT to a count if match made
MATCH_KEY PROC	NEAR

	PUSH	DI		; Save regs.
	PUSH	CX
	PUSH	AX
	
	MOV	DI,OFFSET PARAMS	; Get params
CK1:
	CMP	DI,PRMSTART		; At end of buffer
	JAE	CK_EXIT			; Yes exit
	MOV	CL,[DI]			; No, get the length of the string
	SUB	CH,CH
	INC	DI			; Skip past count
	DEC	CX

;	Check if a special key to match

	CMP	AL,0
	JNZ	CK2
	CMP	AX,[DI]			; Check special key
	JNZ	CK3			; No match try next entry
	INC	DI			; Match, do partial updating of pointers
	DEC	CX
	JMP	SHORT CK4
CK2:
	CMP	AL,[DI]			; Check normal key
	JZ	CK4
CK3:
	ADD	DI,CX			; Check next key
	JMP	CK1

;	Key matched, set up string remapping
CK4:
	INC	DI			; Update pointers
	DEC	CX
	MOV	STRING_PTR,DI		; Set up pointer to string
	MOV	STRING_COUNT,CL		; Count of chars. in string
CK_EXIT:
	POP	AX
	POP	CX
	POP	DI
	RET

MATCH_KEY	ENDP


;	Return the current cursor in DX the video_page in BH
;	Also save these in memory
CURRENT_CURSOR	PROC	NEAR

	PUSH	AX
	PUSH	BX
	CALL	SET_PARMS
	MOV	AH,VIO_RCP
	INT	VIDEO_IO_INTR
	MOV	CURSOR_LOC,DX
	POP	BX
	POP	AX
	RET

CURRENT_CURSOR	ENDP

;	Set the video page and the number of columns
SET_PARMS	PROC	NEAR

	MOV	AH,VIO_CVS
	INT	VIDEO_IO_INTR
	MOV	VPAGE,BH
	MOV	CRT_COLS,AH
	RET

SET_PARMS	ENDP

;	Stuff a CTRL-C in the look-ahead
KB_BREAK PROC	NEAR
	MOV	CS:NXT_CHAR,3
	IRET
KB_BREAK ENDP

;	Output a character
;
OUTCHAR	PROC	NEAR

	CALL	CURRENT_CURSOR

	CMP	AL,CC_BEL
	JNZ	OC0
	MOV	AH,VIO_WTT
	INT	VIDEO_IO_INTR
	RET

;	If a carraige return then reset column to 0 and position the cursor

OC0:
	CMP	AL,CC_CR
	JNZ	OC1
	MOV	COL,0
	JMP	MOVE_CSR

;	If a line feed, handle below
OC1:
	CMP	AL,CC_LF
	JZ	OC5

;	If a backspace then see if at beginning of line

OC2:
	CMP	AL,CC_BS
	JNZ	OC3
	CMP	COL,0			; At befinning of line?
	JNZ	OC2A
	RET				; Yes, nothing to do
OC2A:
	DEC	COL			; No, back up a column
	JMP	MOVE_CSR

;	Print the character
OC3:
	CMP	AL,CC_BEL
	JNZ	OC3A
	MOV	AH,VIO_WTT
	MOV	BL,3
	JMP	SHORT OC3B
OC3A:
	MOV	BH,VPAGE
	MOV	BL,ATTRIBUTE
	MOV	CX,1
	MOV	AH,VIO_WAC
OC3B:
	INT	VIDEO_IO_INTR

;	Character printed move to next column

	INC	COL
	MOV	AL,COL
	CMP	AL,CRT_COLS		; Past end of screen?
	JB	MOVE_CSR		; No, position cursor
	CMP	WRAP_FLAG,TRUE		; Yes, Check for wrap around active
	JZ	OC4			; Wrap around active
	DEC	COL			; No wrap, back up a column
	JMP	MOVE_CSR
OC4:
	MOV	COL,0			; Back to column 0
OC5:
	INC	ROW			; Next row
	CMP	ROW,CRT_ROWS		; Past last row?
	JB	MOVE_CSR		; No, position cursor
	DEC	ROW			; Back to last row
	CALL	SCROLL_ONE
	JMP	MOVE_CSR
OUTCHAR	ENDP

;	Move the cursor to the updated cursor location
MOVE_CSR	PROC	NEAR

	MOV	DX,CURSOR_LOC
	MOV	BH,VPAGE
	JMP	MOVE_CURSOR

MOVE_CSR	ENDP

;	Scroll the screen one line up
SCROLL_ONE	PROC	NEAR

	MOV	AL,1
	SUB	CX,CX
	MOV	DH,CRT_ROWS-1
	MOV	DL,CRT_COLS
	DEC	DL
	MOV	BH,ATTRIBUTE
	MOV	AH,VIO_SPU
	INT	VIDEO_IO_INTR
	RET

SCROLL_ONE	ENDP


END_DRIVER	LABEL	NEAR

CODE	ENDS
	END

