// 'Windows CE 3.0 Programming' Source Code Samples (Prentice Hall, 2000)
// Source Code Author: Nick Grattan (nick@softwarepaths.com)
// Version 1.00

// Database related functions for ActiveSync examples


#define DB_NAME _T("ActiveSynNotes")		// ActiveSynch notes database

extern CEOID g_oidDataBase;	// Object Identifier of our database

#define STRLEN_NOTE	256
#define STRLEN_TIME 20

typedef struct tagNOTE
{
	FILETIME ftOriginal;			// time when note was created
	FILETIME ftLastUpdate;			// time when note was last updated
	WCHAR szNote[STRLEN_NOTE];
} NOTE;

CEOID ASGetDBOID(LPTSTR lpDbName);
BOOL ASRecInDB(CEOID oidDataBase, CEOID oidRecord);
BOOL ASSerialiseRecord(CEOID oidRec, LPBYTE* lpByte, DWORD* dwByte);
CEOID ASDeserializeRecord(FILETIME* ftCreated, FILETIME* ftModified, LPTSTR szNote, 
						  DWORD dwNoteLen, BOOL bNewRecord, CEOID oidRecord);
BOOL ASDeleteRecord(CEOID recToDelete);

#define PROP_DATEADDED			1		// date note was added
#define PROP_NOTE				2		// the note (constrained to 255 bytes by desktop)
#define PROP_MODIFIED			3		// date when note was last modified
#define PROP_UPDATED			4		// has the record been updated?