// 'Windows CE 3.0 Programming' Source Code Samples (Prentice Hall, 2000)
// Source Code Author: Nick Grattan (nick@softwarepaths.com)
// Version 1.00

// ListDB.cpp: implementation of the CListDB class.
//
//////////////////////////////////////////////////////////////////////

#include "stdafx.h"
#include "cldevice.h"
#include "ListDB.h"

#ifdef _DEBUG
#undef THIS_FILE
static char THIS_FILE[]=__FILE__;
#define new DEBUG_NEW
#endif

//////////////////////////////////////////////////////////////////////
// Construction/Destruction
//////////////////////////////////////////////////////////////////////

CListDB::CListDB()
{  

}

CListDB::~CListDB()
{

}

// Opens database, creating it if necessary.
BOOL CListDB::OpenCreateDatabase(CWnd* pWnd)
{
	// Date added index
	CCeDBProp cePropIndex(CCeDBProp::Type_Filetime ,	// data type
			PROP_DATEADDED,							// property identifier
			CCeDBProp::Sort_Ascending);
	if(!CCeDBDatabase::Exists(DB_NAME)) // only create if it doesn't exist
	{
		// create the database
		if(Create(DB_NAME ,		// database name to create
				CE_DB_IDENT,	// database identifier
				1,				// number of sort orders
				&cePropIndex) == NULL)		// pointer to sort properties
			return FALSE;		// cannot create the database
	}
	// open the database
	return Open(DB_NAME, &cePropIndex, pWnd);
}

// Adds a note to the database
BOOL CListDB::AddNote(CString &sNote)
{
	// prepare the record for writing
	CCeDBRecord rec;
	CCeDBProp props[3];
	USHORT uiChanged = TRUE;

	// get today's date and time as a FILETIME
	SYSTEMTIME sysTime;
	FILETIME fileTime;
	GetSystemTime(&sysTime);
	sysTime.wMilliseconds = 0;
	SystemTimeToFileTime(&sysTime, &fileTime);
	props[0] = CCeDBProp(fileTime,  PROP_DATEADDED);
	props[1] = CCeDBProp((LPWSTR)(LPCTSTR)sNote, PROP_NOTE);
	props[2] = CCeDBProp(fileTime, PROP_MODIFIED);

	rec.AddProps(props, 3);
	if(!AddRecord(&rec))
	{
		AfxMessageBox(_T("Could not add Note record"));
		return FALSE;
	}
	return TRUE;
}

BOOL CListDB::ListNotes(CListCtrl& lstCtrl)
{
	CCeDBRecord rec;
	CCeDBProp* pPropRecordset;
	int nNote = 0;
	LV_ITEM lvi;

	lstCtrl.DeleteAllItems();
	SeekFirst();
	lvi.mask = LVIF_TEXT | LVIF_STATE;
	lvi.state = 0;
	lvi.stateMask = 0;

	while(ReadCurrRecord(&rec))
	{
		FILETIME ftDateAdded;

		pPropRecordset = rec.GetPropFromIdent(PROP_DATEADDED);
		ASSERT(pPropRecordset != NULL);
		ftDateAdded = pPropRecordset->GetFiletime();

		CTime ctime(ftDateAdded);
		TCHAR szBuffer[100];
		CString str;
		wsprintf(szBuffer, _T("%02d/%02d/%02d %02d:%02d:%02d"), 
			ctime.GetDay(), ctime.GetMonth(), ctime.GetYear(), 
			ctime.GetHour(), ctime.GetMinute(), ctime.GetSecond());
		lvi.iItem = nNote;
		lvi.iSubItem = 0;
		lvi.pszText = szBuffer;
		
		lstCtrl.InsertItem(&lvi);

		CString sNote;
		pPropRecordset = rec.GetPropFromIdent(PROP_NOTE);
		ASSERT(pPropRecordset != NULL);
		sNote = pPropRecordset->GetString();
		lstCtrl.SetItemText(nNote, 1, sNote);
		nNote++;

		if(SeekNext() == 0)
			break;
	}
	return TRUE;
}

// make the record with the given time stamp the current record.

BOOL CListDB::FindNote(CString& sNoteTime)
{
	FILETIME fileTime;
	SYSTEMTIME sysTime;
	TCHAR szBuffer[200];
	wcscpy(szBuffer, sNoteTime);

	// day 0/1
	sysTime.wDay = (WORD)_wtoi(szBuffer);
	// month 3/4
	sysTime.wMonth = (WORD)_wtoi(&szBuffer[3]);
	// year 6/9
	sysTime.wYear = (WORD)_wtoi(&szBuffer[6]);
	// hour 11/12
	sysTime.wHour = (WORD)_wtoi(&szBuffer[11]);
	// minute 14/15
	sysTime.wMinute = (WORD)_wtoi(&szBuffer[14]);
	// second 17/18
	sysTime.wSecond = (WORD)_wtoi(&szBuffer[17]);
	sysTime.wMilliseconds = 0;
	SystemTimeToFileTime(&sysTime, &fileTime);
	// attempt to locate the record
	CCeDBProp propInd(fileTime, PROP_DATEADDED);

	if(SeekFirstEqual(propInd) == 0)
	{
		AfxMessageBox(_T("Could not locate record to update"));
		return FALSE;
	}
	else
		return TRUE;
}

// update the note with the given time stamp
BOOL CListDB::UpdateNote(CString& sNoteTime, CString& sNote)
{
	CCeDBRecord rec;
	if(!FindNote(sNoteTime))
		return FALSE;
	// read the record
	if(!ReadCurrRecord(&rec))
	{
		AfxMessageBox(_T("Could not read record to update"));
		return FALSE;
	}
	else
	{
		// update the record
		CCeDBProp* pPropRecordset = rec.GetPropFromIdent(PROP_NOTE);
		pPropRecordset->SetString(sNote.GetBuffer(sNote.GetLength()));
		pPropRecordset = rec.GetPropFromIdent(PROP_MODIFIED);
		FILETIME fileTime;
		SYSTEMTIME sysTime;
		GetSystemTime(&sysTime);
		sysTime.wMilliseconds = 0;
		SystemTimeToFileTime(&sysTime, &fileTime);
		pPropRecordset->SetFiletime(fileTime);
		if(!WriteCurrRecord(&rec))
		{
			AfxMessageBox(_T("Could not write record to update"));
			return FALSE;
		}
	}
	return TRUE;
}

// delete all records from the notes database
BOOL CListDB::DeleteAll()
{
	while(SeekFirst())
		DeleteCurrRecord();
	return TRUE;
}

// delete the note with the given time stampe
BOOL CListDB::DeleteNote(CString& sNoteTime)
{
	if(!FindNote(sNoteTime))
		return FALSE;
	return DeleteCurrRecord();
}
