// 'Windows CE 3.0 Programming' Source Code Samples (Prentice Hall, 2000)
// Source Code Author: Nick Grattan (nick@softwarepaths.com)
// Version 1.00

// Component implmenentation

#include "stdafx.h"
#include "component.h"

LONG g_nComponents = 0;

//////////////////////////////////////////////////////////////////////////////
// CActiveSyncEg implemention

CActiveSyncEg::CActiveSyncEg() : m_nRef(0)
{ 
	m_bInitialized = FALSE;
	InterlockedIncrement(&g_nComponents);
	// Open our .DAT record file
	m_ListDB.OpenCreateDatabase();
	// set database for data handler
	m_DataHandler.SetDatabase(&m_ListDB);
}

CActiveSyncEg::~CActiveSyncEg() 
{ 
	InterlockedDecrement(&g_nComponents);
}

// Standard IUnknown methods

HRESULT __stdcall CActiveSyncEg::QueryInterface(const IID& iid, void** ppv)
{
	if(iid == IID_IUnknown)
		*ppv = (IReplStore*) (this);
	else if(iid == IID_IReplStore)
		*ppv = (IReplStore*) (this);
	else
	{
		*ppv = NULL;
		return E_NOINTERFACE;
	}
	((IUnknown*)(*ppv))->AddRef();
	return S_OK;
}

ULONG __stdcall CActiveSyncEg::AddRef ()
{
	return InterlockedIncrement((LONG*)&m_nRef);
}

ULONG __stdcall CActiveSyncEg::Release()
{
	if(InterlockedDecrement((LONG*)&m_nRef) == 0)
	{
		delete this;
		return 0;
	}
	return m_nRef;
}

