// 'Windows CE 3.0 Programming' Source Code Samples (Prentice Hall, 2000)
// Source Code Author: Nick Grattan (nick@softwarepaths.com)
// Version 1.00

// CustomBlock.cpp : Defines the entry point for the console application.
//
#include "stdafx.h"
#include <rapi.h>
#include <iostream.h>

int main(int argc, char* argv[])
{
	HRESULT hr;
	DWORD dwOut;
	BYTE* pOut;
	int nErr;

	hr = CeRapiInit();
	if(FAILED(hr))
	{
		cout << "Could not initialize RAPI:" << GetLastError() << endl;
		return 1;
	}
	LPWSTR lpAppname = L"\\windows\\cmd.exe";
	
	hr = CeRapiInvoke(L"CEBlock", L"WaitCreateProcess", 
			(wcslen(lpAppname) + 1) * sizeof(WCHAR), 
			(BYTE*)lpAppname, &dwOut, &pOut, NULL, 0);
	if(FAILED(hr))
	{
		nErr = CeGetLastError();
		switch(nErr)
		{
		case ERROR_FILE_NOT_FOUND :
			cout << "Library not found" << endl;
			break;
		case ERROR_CALL_NOT_IMPLEMENTED:
			cout << "Could not locate function in library" << endl;
			break;
		case ERROR_EXCEPTION_IN_SERVICE:
			cout << "Exception caught in function" << endl;
			break;
		default:
			cout << "Error in invoke: " << nErr << endl;
		}
	}
	if(pOut != NULL)
	{
		nErr = (int)*pOut;
		cout << "Error Return: " << nErr << endl;
		CeRapiFreeBuffer(pOut);
	}
	else
		cout << "Function failed to return error information" << endl;
	hr = CeRapiUninit();
	if(FAILED(hr))
		cout << "Could not un-initialize RAPI" << endl;

	return 0;
}



