// 'Windows CE 3.0 Programming' Source Code Samples (Prentice Hall, 2000)
// Source Code Author: Nick Grattan (nick@softwarepaths.com)
// Version 1.00

/ Chapter 7: Notifications. Sample Code

#include "stdafx.h"
#include "examples.h"

#include <notify.h>

// *** Listing 7.1
//
// Run an application at a specified time
// 

void Listing7_1()
{
	SYSTEMTIME sysTime;

	GetLocalTime(&sysTime);
	sysTime.wHour = 10;
	sysTime.wMinute = 22;
	if(!CeRunAppAtTime(_T("\\Notify.exe"), &sysTime))
		cout << _T("Cannot set application to run") << endl;
	else
		cout << _T("App set to run at specified time") << endl;
}

// *** Listing 7.2 & 3
//
// Notify.exe code, see project in \Notify directory.
// 

// *** Listing 7.4
//
// Run an application on an event
// 

void Listing7_4()
{
	if(!CeRunAppAtEvent(_T("\\Notify.exe"), NOTIFICATION_EVENT_SYNC_END))
		cout << _T("Cannot set application to run") << endl;
	else
		cout << _T("Notify.exe will run when sync finishes") << endl;
}

// *** Listing 7.5
//
// Removing an application event
// 

void Listing7_5()
{
	if(!CeRunAppAtEvent(_T("\\Notify.exe"), NOTIFICATION_EVENT_NONE))
		cout << _T("Cannot stop application event.") << endl;
	else
		cout << _T("Application event removed.") << endl;
}

// *** Listing 7.6
//
// Determine LED Capabilities
// 

#include <NLed.h>
extern "C" 
{
	BOOL NLedGetDeviceInfo(INT nId, PVOID pOutput);
	BOOL NLedSetDevice(INT nId, PVOID pOutput);
}

void Listing7_6()
{
	NLED_COUNT_INFO nci;
	NLED_SUPPORTS_INFO  nsup;

	if(!NLedGetDeviceInfo(NLED_COUNT_INFO_ID, (PVOID) &nci))
	{
		cout << _T("Could not get LED information") << endl;
		return;
	}
	cout << _T("Number of LEDs: ") << (int)nci.cLeds << endl;
	memset(&nsup, 0, sizeof(nsup));
	nsup.LedNum = 0; // get information on first LED
	if(!NLedGetDeviceInfo(NLED_SUPPORTS_INFO_ID, (PVOID) &nsup))
	{
		cout << _T("Could not get LED support options") << endl;
		return;
	}
	cout << _T("Cycle Adjust:") << nsup.lCycleAdjust << endl; // 0 == off, 1 == on, 2 == blink
	cout << _T("Adj. Total Cycle Time:") << nsup.fAdjustTotalCycleTime << endl;
	cout << _T("Separate On Time:") << nsup.fAdjustOnTime << endl;
	cout << _T("Separate Off Time:") << nsup.fAdjustOffTime << endl;
	cout << _T("Can Meta Cycle On:") << nsup.fMetaCycleOn << endl;
	cout << _T("Can Meta Cycle Off:") << nsup.fMetaCycleOff << endl;
}

// *** Listing 7.7
//
// Toggle LED on and off
// 

void Listing7_7()
{
	NLED_SETTINGS_INFO nsi;
	static int nLastSetting = 0;		// initially off

	if(nLastSetting == 0)
		nLastSetting = 2;	// blink
	else
		nLastSetting = 0;	// off
    nsi.LedNum = 0;	
	nsi.OffOnBlink = nLastSetting;
	if(!NLedSetDevice(NLED_SETTINGS_INFO_ID, &nsi))
		cout << _T("Could not set LED settings") << endl;
}

// *** Listing 7.8
//
// Set User Notification
// 

void Listing7_8()
{
	HANDLE hNotify;
	SYSTEMTIME sysTime;
	CE_USER_NOTIFICATION ceNot;

	GetLocalTime(&sysTime);
	sysTime.wHour = 7;
	sysTime.wMinute= 15;
	
	ceNot.ActionFlags = PUN_SOUND | PUN_REPEAT;
	ceNot.pwszSound = _T("\\Windows\\Alarm2.wav");
	hNotify = CeSetUserNotification(
			NULL,		// not modifying existing notification
			_T("\\Notify.exe"),
			&sysTime,
			&ceNot);
	if(hNotify == NULL)
		cout << _T("Could not set user notification") << endl;
	else
		cout << _T("User notification set") << endl;
}

// *** Listing 7.9
//
// Remove Annunciator
// 

void Listing7_9()
{
	if(CeHandleAppNotifications(_T("\\Notify.exe")))
		cout << _T("Annunciator cleared") << endl;
	else
		cout << _T("Annunciator could not be cleared") << endl;
}

// *** Listing 7.10
//
// User Notification Preferences
// 

void Listing7_10(HWND hWnd)
{
	CE_USER_NOTIFICATION ceNot;
	TCHAR szSound[MAX_PATH + 1];

	ceNot.ActionFlags = PUN_SOUND | PUN_REPEAT;
	ceNot.pwszSound = szSound;
	ceNot.nMaxSound  = MAX_PATH;

	if(!CeGetUserNotificationPreferences(hWnd, &ceNot))
		cout << _T("Could not get settings") << endl;
	else 
	{
		if(ceNot.ActionFlags & PUN_SOUND)
		{
			cout << _T("SOUND:") << endl;
			if(ceNot.ActionFlags & PUN_REPEAT)
				cout << _T("Repeat") << endl;
			else
				cout << _T("Don't repeat") << endl;
			cout << _T("Sound: ") << ceNot.pwszSound << endl;
		}
		if(ceNot.ActionFlags & PUN_LED)
			cout << _T("FLASH") << endl;
		if(ceNot.ActionFlags & PUN_VIBRATE)
			cout << _T("VIBRATE") << endl;
		if(ceNot.ActionFlags & PUN_DIALOG)
			cout << _T("DIALOG") << endl;
	}
}

// *** Listing 7.11
//
// CeSetUserNotificationEx
// 

void Listing7_11()
{
	CE_NOTIFICATION_TRIGGER unt;

	SYSTEMTIME sysTime;

	GetLocalTime(&sysTime);
	sysTime.wHour = 22;
	sysTime.wMinute = 15;

	memset(&unt, 0, sizeof(unt));
	unt.dwSize = sizeof(unt);
	unt.dwType = CNT_TIME;
	unt.lpszApplication = _T("\\windows\\pword.exe");
	unt.lpszArguments = NULL;
	unt.stStartTime = sysTime;
	unt.stEndTime = sysTime;

	HANDLE hNotify = CeSetUserNotificationEx(0, &unt, NULL);
	if(hNotify == NULL)
		cout << _T("Could not set notification") << endl;
	else
		cout << _T("Notification set") << endl;
}