
/*
 * $XConsortium$
 *
 * Copyright 1991 MIPS Computer Systems, Inc.
 *
 * Permission to use, copy, modify, distribute, and sell this software and its
 * documentation for any purpose is hereby granted without fee, provided that
 * the above copyright notice appear in all copies and that both that
 * copyright notice and this permission notice appear in supporting
 * documentation, and that the name of MIPS not be used in advertising or
 * publicity pertaining to distribution of the software without specific,
 * written prior permission.  MIPS makes no representations about the
 * suitability of this software for any purpose.  It is provided "as is"
 * without express or implied warranty.
 *
 * MIPS DISCLAIMS ALL WARRANTIES WITH REGARD TO THIS SOFTWARE, INCLUDING ALL
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS, IN NO EVENT SHALL MIPS
 * BE LIABLE FOR ANY SPECIAL, INDIRECT OR CONSEQUENTIAL DAMAGES OR ANY DAMAGES
 * WHATSOEVER RESULTING FROM LOSS OF USE, DATA OR PROFITS, WHETHER IN AN ACTION
 * OF CONTRACT, NEGLIGENCE OR OTHER TORTIOUS ACTION, ARISING OUT OF OR IN 
 * CONNECTION WITH THE USE OR PERFORMANCE OF THIS SOFTWARE.
 */
#ident	"$Header: mipsOsBSD.c,v 1.5 92/04/06 21:04:19 dd Exp $"

/*
 * OS support code which requires bsd43 include files
 */

#include <bsd43/sys/types.h>
#include <bsd43/syscall.h>
#include <bsd43/sysmips.h>
#include <bsd43/mips/cpu_board.h>
#if !defined(BRDTYPE_R4XXX) && defined(BRDTYPE_XXXXXX)
#define	BRDTYPE_R4XXX	BRDTYPE_XXXXXX
#endif
#undef FID
#include <bsd43/mips/debug.h>
#include <bsd43/mips/hwconf.h>

#include <bsd43/sys/file.h>

#include <bsd43/sys/time.h>

#include "mips.h"


#ifdef SYSV
#define	hwconf(option,conf) \
	(syscall(BSD43_(SYS_sysmips), BSD43_(MIPS_HWCONF), \
	BSD43_(option), (conf)))

#define	kopt(option,value,op) \
	(syscall(BSD43_(SYS_sysmips), BSD43_(MIPS_KOPT), \
	(option), (value), BSD43_(op), 0, 0))
#endif /* SYSV */


cpubd()
{
	struct bsd43_(hw_config) Conf;
	int type = -1;

	if (hwconf(HWCONF_GET,&Conf) < 0)
		return type;

	switch (Conf.cpubd_type) {
	case BRDTYPE_I2000:
	case BRDTYPE_I2000S:
		type = RS2030;
		break;
	case BRDTYPE_R3030:
		type = RS3230;
		break;
#ifdef BRDTYPE_R4XXX
	case BRDTYPE_R4XXX:
		type = RS4000;
		break;
#endif /* BRDTYPE_R4XXX */
	}
	return type;
}

char *
getkvar(name)
	char *name;
{
	int addr;
	int fd;
	char *bp = 0;
	static char buf[16];

	if ((addr = kopt(name, 0, KOPT_GET)) != -1 &&
		addr != 0 &&
		(fd = open("/dev/kmem", O_RDONLY)) >= 0) {
		addr &= 0x7fffffff;
		bzero(buf, sizeof buf);
		if (lseek(fd, (off_t) addr, L_SET) != (off_t) -1 &&
			read(fd, buf, sizeof buf - 1) >= 0) {
			bp = buf;
		}
		(void) close(fd);
	}

	return bp;
}

mipsUsleep(usec)
	int usec;
{
	struct timeval timeout;

	timeout.tv_sec = 0;
	timeout.tv_usec = usec;
	(void) select(1, (fd_set *) 0, (fd_set *) 0, (fd_set *) 0, &timeout);
}
