/*
 * $XConsortium$
 *
 * Copyright 1991 MIPS Computer Systems, Inc.
 *
 * Permission to use, copy, modify, distribute, and sell this software and its
 * documentation for any purpose is hereby granted without fee, provided that
 * the above copyright notice appear in all copies and that both that
 * copyright notice and this permission notice appear in supporting
 * documentation, and that the name of MIPS not be used in advertising or
 * publicity pertaining to distribution of the software without specific,
 * written prior permission.  MIPS makes no representations about the
 * suitability of this software for any purpose.  It is provided "as is"
 * without express or implied warranty.
 *
 * MIPS DISCLAIMS ALL WARRANTIES WITH REGARD TO THIS SOFTWARE, INCLUDING ALL
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS, IN NO EVENT SHALL MIPS
 * BE LIABLE FOR ANY SPECIAL, INDIRECT OR CONSEQUENTIAL DAMAGES OR ANY DAMAGES
 * WHATSOEVER RESULTING FROM LOSS OF USE, DATA OR PROFITS, WHETHER IN AN ACTION
 * OF CONTRACT, NEGLIGENCE OR OTHER TORTIOUS ACTION, ARISING OUT OF OR IN 
 * CONNECTION WITH THE USE OR PERFORMANCE OF THIS SOFTWARE.
 */
/* $Header: mipsMouse.h,v 1.6 92/08/11 16:38:15 dd Exp $ */
#ifndef __DDX_MIPSMOUSE_H
#define	__DDX_MIPSMOUSE_H

#define NBUTTONS	3

#define RAW_LEFT	4
#define RAW_MIDDLE	2
#define RAW_RIGHT	1

/* mouse device name */

#define	MOUSEDEV	"/dev/mouse"

/* motion buffer */
#ifdef X11R4
#define MOUSEQSIZE      100

typedef struct {
    int		time;
    int		scrn;
    int		dx, dy;
    int		bmask;
} mouseQ_t;
#endif /* X11R4 */

/* 5 byte format */
#define MS5_SYNCMASK	0xf8
#define MS5_SYNCVAL	0x80
#define MS5_BUTTON(s)	((~(s)[0]) & 7)
#define	MS5_XVAL(s)	((signed char) (s)[1] + (signed char)(s)[3])
#define	MS5_YVAL(s)	(-((signed char) (s)[2] + (signed char) (s)[4]))

/* 3 byte format */
#define	MS3_SYNCMASK	0x08
#define	MS3_BUTTON(s)	("\0\4\1\5\2\6\3\7"[(s)[0] & 7])
#define	MS3_XVAL(s)	(((s)[0] & 0x10 ? -256 : 0) | (unsigned char) (s)[1])
#define	MS3_YVAL(s)	(-(((s)[0] & 0x20 ? -256 : 0) | (unsigned char) (s)[2]))
#define	MS3_XBADOVF(s)	(((s)[0] & 0x40) && \
				(s)[1] != ((s)[0] & 0x10) ? 0xff : 0)
#define	MS3_YBADOVF(s)	(((s)[0] & 0x80) && \
				(s)[2] != ((s)[0] & 0x20) ? 0xff : 0)

/* mouse private structure */

typedef
struct _mousePriv {
	int fd;			/* File descriptor of the mouse */
	short unit;		/* unit number (not used) */
	short cap;		/* Device capabilities */
	short baud;		/* Baud rate */
	short rate;		/* Sampling rate */
	char type;		/* mouse type */
#define	MIPS_MOUSE_DEFAULT	0
#define	MIPS_MOUSE_MOUSEMAN	1
#define	MIPS_MOUSE_3BYTE	2
	char buttonstate;	/* Which buttons are down */
	struct {
		char mask;
		char val;
	} buttonmap[NBUTTONS];	/* Conversion between mouse and cursor
				 * buttons */
	INT16 rootX, rootY;	/* Current mouse position */
	void (*decode) ();	/* mouse character decode function */
	int decode_state;	/* for decode function */
	int decode_sync;	/* for decode function */
	char msbuf[8];		/* mouse buffer */
	PtrCtrl ctrl;		/* Pointer control */
#ifdef X11R4
	int scrn;		/* What screen the cursor is on */
#endif /* X11R4 */
} MousePriv, *MousePrivPtr;

/* keyboard and mouse defines */

extern MousePriv	mousePriv;

#endif /* __DDX_MIPSMOUSE_H */
