/*
 * $XConsortium$
 *
 * Copyright 1991 MIPS Computer Systems, Inc.
 *
 * Permission to use, copy, modify, distribute, and sell this software and its
 * documentation for any purpose is hereby granted without fee, provided that
 * the above copyright notice appear in all copies and that both that
 * copyright notice and this permission notice appear in supporting
 * documentation, and that the name of MIPS not be used in advertising or
 * publicity pertaining to distribution of the software without specific,
 * written prior permission.  MIPS makes no representations about the
 * suitability of this software for any purpose.  It is provided "as is"
 * without express or implied warranty.
 *
 * MIPS DISCLAIMS ALL WARRANTIES WITH REGARD TO THIS SOFTWARE, INCLUDING ALL
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS, IN NO EVENT SHALL MIPS
 * BE LIABLE FOR ANY SPECIAL, INDIRECT OR CONSEQUENTIAL DAMAGES OR ANY DAMAGES
 * WHATSOEVER RESULTING FROM LOSS OF USE, DATA OR PROFITS, WHETHER IN AN ACTION
 * OF CONTRACT, NEGLIGENCE OR OTHER TORTIOUS ACTION, ARISING OUT OF OR IN 
 * CONNECTION WITH THE USE OR PERFORMANCE OF THIS SOFTWARE.
 */
/* $Header: mipsIo.h,v 1.5 91/07/15 19:47:45 dd Exp $ */
#ifndef __DDX_MIPSIO_H
#define	__DDX_MIPSIO_H

#define MAXEVENTS       100

/* Device capabilities */

#define	DEV_TIMESTAMP	0x01	/* Timestamps enabled */
#define DEV_BUZZER	0x02	/* Buzzer enabled */
#define DEV_COLORMAP	0x04	/* Colormap enabled */
#define DEV_LIGHTS	0x08	/* lights enabled */
#define DEV_ASYNC	0x10	/* async io enabled */
#define DEV_READ	0x20	/* readable */
#define DEV_INIT	0x40	/* initable */
#define DEV_BLANK	0x80	/* Blanking enabled */

extern int		isItTimeToYield;
extern int		lastEventTime;
extern ScreenInfo	screenInfo;

#ifdef X11R4
extern int		screenIsSaved;
extern void		SaveScreens();
#endif /* X11R4 */

/* keyboard/mouse signal macros */
#include <sysv/sys/signal.h>		/* included here to avoid mistakes */
#ifdef SYSV
#define	SIGCATCH(f)	((void) sigset(SIGPOLL,(f)))
#define	SIGIGNORE	((void) sigignore(SIGPOLL))
#define	SIGHOLD_DCL
#define	SIGHOLD		((void) sighold(SIGPOLL))
#define	SIGRELEASE	((void) sigrelse(SIGPOLL))
#else /* SYSV */
#define	SIGCATCH(f)	((void) signal(SIGPOLL,(f)))
#define	SIGIGNORE	((void) signal(SIGPOLL, SIG_IGN))
#define	SIGHOLD_DCL	int __sigmask;
#define	SIGHOLD		((__sigmask = sigblock(sigmask(SIGPOLL))))
#define	SIGRELEASE	((void) sigsetmask(__sigmask))
#endif /* SYSV */


#endif /* __DDX_MIPSIO_H */
