/*
 * |-----------------------------------------------------------|
 * | Copyright (c) 1991, 1990 MIPS Computer Systems, Inc.      |
 * | All Rights Reserved                                       |
 * |-----------------------------------------------------------|
 * |          Restricted Rights Legend                         |
 * | Use, duplication, or disclosure by the Government is      |
 * | subject to restrictions as set forth in                   |
 * | subparagraph (c)(1)(ii) of the Rights in Technical        |
 * | Data and Computer Software Clause of DFARS 252.227-7013.  |
 * |         MIPS Computer Systems, Inc.                       |
 * |         950 DeGuigne Avenue                               |
 * |         Sunnyvale, California 94088-3650, USA             |
 * |-----------------------------------------------------------|
 */
/* $Header: kbd_ioctl.h,v 1.8 92/08/17 16:35:40 dd Exp $ */

#ifndef	_SYS_KBD_IOCTL_
#define	_SYS_KBD_IOCTL_	1


/*
 * Kbd ioctls
 *
 * $Source: /usr6/co/root/usr/src/uts/mips/sys/RCS/kbd_ioctl.h,v $
 * $Revision: 1.8 $
 * $Date: 92/08/17 16:35:40 $
 */
struct colorm {
	unsigned short cmstart;		/* starting register */
	unsigned short cmcount;		/* number of registers */
	unsigned char cmap[3*256];	/* register data */
};

#define	KTCSETTIMESTAMP		_IO(K,0x7f)	/* kbd input timestamped */
#define	KTCCLRTIMESTAMP		_IO(K,0x7e)	/* no kbd input timestamped */
#define	KTCPRGMBUZZER		_IOW(K,0x7d,struct buzzer)	
						/* program the buzzer */
#define	KTCRINGBELL		_IO(K,0x7c)	/* ring standard bell (^g) */

#define	KTCSETLIGHTS	_IOW(K,0x7b,int)	/* set keyboard lights */
#define	KTCGETLIGHTS	_IOR(K,0x7a,int)	/* get kbd lights last set */
#define KLNUMLOCK	0x2		/* light num lock light */
#define KLCAPSLOCK	0x4		/* light caps lock light */
#define KLSCRLLOCK	0x1		/* light scroll lock light */

#define KTCWRTCOLOR		_IOW(K,0x79,struct colorm)
						/* write the color map */

#define	KTMBLANK		_IOW(K,0x78,int)
						/* blank/unblank mono screen */

#define KMOUSEFMT	_IOR(K,0x77,int)	/* get mouse format code */
#define KMOUSE3BYTE	0			/* 3 byte mouse format */
#define KMOUSE5BYTE	1			/* 5 byte mouse format */

/* NOTE: KMOUSERST was completely broken in RISC/os 5.0B */
#define KMOUSERST	_IOR(K,0x76,int)	/* reset mouse	*/

#define KMOUSERESET	_IO(K,0x75)		/* reset mouse  */

/*
 *  Kbd Input Timestamping - when turned on all recieved characters
 *  that would normally be received as a single character are received
 *  eight characters in the format of the following structure.
 */

#define KBDSYNCCHAR 0xff
struct ktimestamp {
	unsigned char kt_sync[3];	/* 3 sync characters == 0xff */
	unsigned char kt_char;		/* actual timestamped character */
	time_t kt_time;			/* time in HZ since last boot */
};

#endif	_SYS_KBD_IOCTL_
