/*
 * |-----------------------------------------------------------|
 * | Copyright (c) 1991, 1992 MIPS Computer Systems, Inc.      |
 * | All Rights Reserved				       |
 * |-----------------------------------------------------------|
 * |	      Restricted Rights Legend			       |
 * | Use, duplication, or disclosure by the Government is      |
 * | subject to restrictions as set forth in		       |
 * | subparagraph (c)(1)(ii) of the Rights in Technical	       |
 * | Data and Computer Software Clause of DFARS 252.227-7013.  |
 * |	     MIPS Computer Systems, Inc.		       |
 * |	     950 DeGuigne Avenue			       |
 * |	     Sunnyvale, California 94088-3650, USA	       |
 * |-----------------------------------------------------------|
 */
/* $Header: fb_vdr1.h,v 1.6 92/06/17 09:47:40 dd Exp $ */
#ifndef _SYS_FB_VDR1_H
#define	_SYS_FB_VDR1_H

/*
 * "VDR1"/"VDR3" frame buffer description
 */

/* Inmos G364 video controller */

typedef struct {
#ifdef _MIPSEL
	volatile unsigned int r;
	int pad;
#else /* _MIPSEL */
	int pad;
	volatile unsigned int r;
#endif /* _MIPSEL */
} g364_reg;

struct g364 {
	g364_reg boot;		/* 0x000 */
	g364_reg pad021[0x20];
	g364_reg halfsync;	/* 0x021 */
	g364_reg backporch;	/* 0x022 */
	g364_reg display;	/* 0x023 */
	g364_reg shortdisplay;	/* 0x024 */
	g364_reg broadpulse;	/* 0x025 */
	g364_reg vsync;		/* 0x026 */
	g364_reg vpreeq;	/* 0x027 */
	g364_reg vposteq;	/* 0x028 */
	g364_reg vblank;	/* 0x029 */
	g364_reg vdisplay;	/* 0x02a */
	g364_reg linetime;	/* 0x02b */
	g364_reg linestart;	/* 0x02c */
	g364_reg meminit;	/* 0x02d */
	g364_reg xferdelay;	/* 0x02e */
	g364_reg pad040[0x11];
	g364_reg mask;		/* 0x040 */
	g364_reg pad060[0x1f];
	g364_reg control;	/* 0x060 */
	g364_reg pad070[0x0f];
	g364_reg controlb;	/* 0x070 */
	g364_reg pad080[0x0f];
	g364_reg top;		/* 0x080 */
	g364_reg pad0a1[0x20];
	g364_reg curcmap[3];	/* 0x0a1 .. 0x0a3 */
	g364_reg pad0c0[0x1c];
	g364_reg checksum[3];	/* 0x0c0 .. 0x0c2 */
	g364_reg pad0c7[4];
	g364_reg curpos;	/* 0x0c7 */
	g364_reg pad100[0x38];
	g364_reg cmap[256];	/* 0x100 .. 0x1ff */
	g364_reg curpat[512];	/* 0x200 .. 0x3ff */
};

/*
 * Register bit definitions, and normal values for MIPS use
 */

/*
 * boot register
 */
#define	G364_BOOT_64BIT			0x40
#define	G364_BOOT_PLL			0x20
#define	G364_BOOTVAL(mult)		(0x40 + 0x20 + (mult))

/*
 * control register A
 */
#define	G364_CONTROL_VTGON		0x000001
#define	G364_CONTROL_INTERLACE		0x000002
#define	G364_CONTROL_CCIR		0x000004
#define	G364_CONTROL_SLAVE		0x000008
#define	G364_CONTROL_PLAINSYNC		0x000010
#define	G364_CONTROL_DIG_SEPSYNC	0x000020
#define	G364_CONTROL_ANA_NOSYNC		0x000040
#define	G364_CONTROL_PEDESTAL		0x000080
#define	G364_CONTROL_CBLANKIN		0x000100
#define	G364_CONTROL_CLKDISOUT		0x000200
#define	G364_CONTROL_BLANK		0x000400
#define	G364_CONTROL_BLANKOFF		0x000800
#define	G364_CONTROL_VRAMINC_1		0x000000
#define	G364_CONTROL_VRAMINC_256	0x001000
#define	G364_CONTROL_VRAMINC_512	0x002000
#define	G364_CONTROL_VRAMINC_1024	0x003000
#define	G364_CONTROL_DMAOFF		0x004000
#define	G364_CONTROL_PIXDELAY(val)	((val) << 15)
#define	G364_CONTROL_PIXINTERLEAVE	0x040000
#define	G364_CONTROL_SAMPLEDELAY	0x080000
#define	G364_CONTROL_BPP_1		0x000000
#define	G364_CONTROL_BPP_2		0x100000
#define	G364_CONTROL_BPP_4		0x200000
#define	G364_CONTROL_BPP_8		0x300000
#define	G364_CONTROL_BPP_15		0x400000
#define	G364_CONTROL_BPP_16		0x500000
#define	G364_CONTROL_BPP_24		0x600000
#define	G364_CONTROL_CURSDIS		0x800000

#define	G364_CONTROL_INIT ( \
	G364_CONTROL_CURSDIS | \
	G364_CONTROL_BPP_8 | \
	G364_CONTROL_BLANK)

/* initial control register value for 2M video boards */
#define	G364_CONTROL_2M	( \
	G364_CONTROL_INIT | \
	G364_CONTROL_VRAMINC_1024)

/* initial control register value for 1M video boards with G332 */
#define	G332_CONTROL_1M	( \
	G364_CONTROL_INIT | \
	G364_CONTROL_VRAMINC_1024 | \
	G364_CONTROL_PIXINTERLEAVE | \
	G364_CONTROL_SAMPLEDELAY)

/* initial control register value for 1M video boards with G364 */
#define	G364_CONTROL_1M	( \
	G364_CONTROL_INIT | \
	G364_CONTROL_VRAMINC_1024)

/*
 * control register B (G335/G365 only)
 */
#define	G364_CONTROLB_EXTSAMP		0x000001
#define	G364_CONTROLB_SYNCGREEN		0x000002
#define	G364_CONTROLB_HSYNC_FLYBACK	0x000004
#define	G364_CONTROLB_SPLITSAM		0x000008
#define	G364_CONTROLB_COMP_BLUE		0x000010
#define	G364_CONTROLB_COMP_GREEN	0x000020
#define	G364_CONTROLB_COMP_RED		0x000040
#define	G364_CONTROLB_COMPON		0x000080
#define	G364_CONTROLB_CHKSUM_ZERO	0x000100
#define	G364_CONTROLB_SYNCDIS		0x000200
#define	G364_CONTROLB_VSYNC_ACTHIGH	0x000400
#define	G364_CONTROLB_SYNC_ACTHIGH	0x000800
#define	G364_CONTROLB_COMPCURS		0x001000
#define	G364_CONTROLB_XGACURS		0x002000
#define	G364_CONTROLB_EVEN_INTERLACE	0x004000


/* minimum transfer delay */
#define	G364_XFER_DELAY_33(pixel)	(((pixel) * 23) >> 6)	/* 1.35 us */
#define	G364_XFER_DELAY_50(pixel)	(((pixel) * 16) >> 6)	/* 0.95 us */
#define	G364_XFER_DELAY(pixel)		G364_XFER_DELAY_33(pixel)

/* cursor size, pixels and bytes */
#define	G364_CURSMAX	64
#define	G364_CURSBYTES	(64 * 64 * 2 / 8)

/* 8 bit register */
struct vdr_reg8 {
#ifdef _MIPSEL
	volatile unsigned char r;
	char pad[7];
#else /* _MIPSEL */
	char pad[7];
	volatile unsigned char r;
#endif /* _MIPSEL */
};

/*
 * VDR1 address map
 */
struct vdr1_reg {
	struct g364 ramdac;	/* 0x60000000 .. 0x60002000 */
	char pad1[0x10000 - sizeof (struct g364)];
	struct vdr_reg8 id;	/* 0x60010000 */
	char pad2[0x20000 - 0x10000 - 8];
	struct vdr_reg8 reset;	/* 0x60020000 */
	char pad3[4096 - 8];
};


/*
 * "Fission" color frame buffer address map
 */
struct vdr1f_reg {
	struct vdr_reg8 rom[65536];	/* 0x60000000 .. 0x6007ffff */
	struct g364 ramdac;		/* 0x60080000 .. 0x60081fff */
	char pad1[0x80000 - sizeof (struct g364)];
	struct vdr_reg8 little_end;	/* 0x60100000 */
	char pad2[0x2000 - 8];
	struct vdr_reg8 big_end;	/* 0x60102000 */
	char pad3[0x80000 - 0x2000 - 8];
	struct vdr_reg8 reset;		/* 0x60180000 */
	char pad4[0x2000 - 8];
	struct vdr_reg8 monitor;	/* 0x60182000 */
	char pad5[4096 - 8];
};

#endif /* _SYS_FB_VDR1_H */
