
# line 2 "to_wfont.y"
/* $XConsortium: to_wfont.y,v 5.3 91/04/04 16:00:26 gildea Exp $ */

/*****************************************************************
Copyright (c) 1989,1990, 1991 by Sun Microsystems, Inc. and the X Consortium.

                        All Rights Reserved

Permission to use, copy, modify, and distribute this software and its 
documentation for any purpose and without fee is hereby granted, 
provided that the above copyright notice appear in all copies and that
both that copyright notice and this permission notice appear in 
supporting documentation, and that the names of Sun Microsystems,
the X Consortium, and MIT not be used in advertising or publicity 
pertaining to distribution of the software without specific, written 
prior permission.  

SUN MICROSYSTEMS DISCLAIMS ALL WARRANTIES WITH REGARD TO THIS SOFTWARE, 
INCLUDING ALL IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS, IN NO EVENT 
SHALL SUN MICROSYSTEMS BE LIABLE FOR ANY SPECIAL, INDIRECT OR CONSEQUENTIAL 
DAMAGES OR ANY DAMAGES WHATSOEVER RESULTING FROM LOSS OF USE, DATA OR PROFITS,
WHETHER IN AN ACTION OF CONTRACT, NEGLIGENCE OR OTHER TORTIOUS ACTION,
ARISING OUT OF OR IN CONNECTION WITH THE USE OR PERFORMANCE OF THIS
SOFTWARE.

******************************************************************/


#define YYMAXDEPTH 10000

#include <X11/Xos.h>
#include <stdio.h>
#ifndef L_SET
#define L_SET SEEK_SET
#endif
#include "wfont.h"

#ifdef X_NOT_STDC_ENV
FILE *fopen();
#endif

typedef struct {

        float           std_left,      /* NCGA standard left spacing */
                        std_wide,      /* character width            */  
                        std_rght;      /* Right spacing              */  
}               Standard;


char            fname[80];
Dispatch        *table;    /* dispatch table */
Standard	*sp_table; /* NCGA font spacings */
Path            *strokes;  /* strokes of each character */
Property        *property; /* property list */

struct {
	int path, point, props;
} count, expect;

Path_subpath   *current_path;

Font_header     head;		/* font header */
int             tableindex;	/* which character */
int             yyerrno;	/* error number */


# line 68 "to_wfont.y"
typedef union  {
	int	nil;	/* void is reserved */
	int	ival;
	float	dval;
	char	*cval;
} YYSTYPE;
# define REAL 257
# define INTEGER 258
# define STRING 259
# define BOTTOM 260
# define CENTER 261
# define CLOSE 262
# define FONTNAME 263
# define PROPERTIES 264
# define NUM_CH 265
# define INDEX 266
# define L_SPACE 267
# define MAGIC 268
# define OPEN 269
# define RIGHT 270
# define R_SPACE 271
# define STROKE 272
# define TOP 273
# define VERTICES 274
# define BEARING 275
# define WIDTH 276
#define yyclearin yychar = -1
#define yyerrok yyerrflag = 0
extern int yychar;
extern short yyerrflag;
#ifndef YYMAXDEPTH
#define YYMAXDEPTH 150
#endif
YYSTYPE yylval, yyval;
# define YYERRCODE 256

# line 181 "to_wfont.y"


#define BYE(err)	yyerrno = (err), yyerror()

#define ERR_BASE	1000
#define OPEN_ERROR 	1001
#define WRITE_ERROR 	1002
#define WRONG_NAME 	1003
#define NO_MEMORY 	1004
#define EXCEED_PATH 	1005
#define EXCEED_POINT 	1006
#define PATH_MISMATCH	1007
#define POINT_MISMATCH	1008
#define PROP_MISMATCH   1009
#define EXCEED_PROPS 	1010

char	*prog;

main(argc, argv)
	int             argc;
	char           *argv[];

{
	/* Usage : to_wfont [-o outfile] [infile] */
	char           *s;

	fname[0] = 0;
	tableindex = 0;
	head.num_ch = -1;

	prog = *argv;
	while (--argc > 0 && *++argv != NULL) {
		s = *argv;
		if (*s++ == '-')
			switch (*s) {
			case 'o':
				if (*++argv != NULL)
				{
					--argc;
					(void) strcpy(fname, *argv);
				}
				break;
			default:      /* ignore other options */
				;
			}
		else {
			FILE           *fp;

			/* standard input redirection */
			fp = fopen(*argv, "r");
			if (fp != NULL) {
				if (close(fileno(stdin)) < 0)
				{
					perror(prog);
					return;
				}
				if (dup(fileno(fp)) < 0)
				{
					perror(prog);
					return;
				}
				(void) fclose(fp);
			}
		}
	}
	return (yyparse());
}

/* set number of characters */
set_num_ch(num_ch)
int num_ch;
{
	yyerrno = 0;
	head.num_ch = num_ch;
	if (num_ch > 0) {
	  table    = (Dispatch *) malloc(num_ch * sizeof(Dispatch));
	  sp_table = (Standard *) malloc(num_ch * sizeof(Standard));
	  strokes  = (Path *)     malloc(num_ch * sizeof(Path));
	}

	for (tableindex = 0; tableindex < num_ch; tableindex++) {
		table[tableindex].center = 0.0;
		table[tableindex].right = 0.0;
		table[tableindex].offset = 0;

		sp_table[tableindex].std_left = 0.0;
		sp_table[tableindex].std_wide = 0.0;
		sp_table[tableindex].std_rght = 0.0;

		strokes[tableindex].n_subpaths = 0;
		strokes[tableindex].n_vertices = 0;
		strokes[tableindex].subpaths = NULL;
	}
}

/* initialize the property info in the header */
init_properties(num_props)
	int             num_props;
{
	if (num_props > 0) {
	  head.properties = (Property *) 
	                      malloc (num_props * sizeof (Property));
	  head.num_props = expect.props = num_props;
	}
	else {
	  head.properties = NULL;
	  head.num_props = expect.props = 0;
	}
	count.props = -1;
	property = head.properties;  /* initialize the list pointer */
}

check_num_props()
{
        count.props++;
        if (count.props != expect.props)
	  BYE (PROP_MISMATCH);
}

/* add individual property info into the buffer */
add_property(name, value)
	char            *name,
			*value;
{
        /* check if the property exceeds allocated space */

        if (++count.props >= head.num_props)
	     BYE(EXCEED_PROPS);

	/* copy the strings into the buffer */

	(void) strcpy (property->propname, name);
	(void) strcpy (property->propvalue, value);

	/* increment the property pointer */

	property++;
}

check_num_ch()
{

  if (head.num_ch == -1)
	set_num_ch(128);

}

yyerror()
{
	extern int      yylineno;
#	define ERR_SIZE (sizeof(err_string) / sizeof(char *))
	static char    *err_string[] = {
		"Cannot open file",
		"Write fails",
		"Illegal font name",
		"Memory allocation failure",
		"Specified number of strokes exceeded",
		"Specified number of points exceeded",
		"Number of strokes do not match",
		"Number of points do not match",
		"Number of properties do not match",
		"Specified number of properties exceeded",
	0};
	char           *str;

	yyerrno -= ERR_BASE;
	if (yyerrno > 0 && yyerrno < ERR_SIZE)
		str = err_string[yyerrno-1];
	else
		str = "Syntax error";
		fprintf(stderr, "line %d: %s.\n", yylineno, str);
	freeall();
	(void) unlink(fname);
	exit(1);
}

/* create wfont header */
wf_header(name, top, bottom)
	char           *name;
	float           top,
	                bottom;
{

	if (name == NULL)
		BYE(WRONG_NAME);
	head.top = (float) top;
	head.bottom = (float) bottom;
	head.magic = WFONT_MAGIC_PEX;
	(void) strcpy(head.name, name);
	free(name);
}

/* create header for each glyph */
glyph_header(npath, center, right, npts)
	int             npath,
	                npts;
	float           center,
	                right;
{
     {
	register Path  *strk = strokes + tableindex;
	
        if (npath > 0)     /* Don't allocate space unless the character
			      has strokes associated with it. */
	{
		strk->subpaths = (Path_subpath *)
			malloc(npath * sizeof (Path_subpath));

		if (strk->subpaths == NULL)
			BYE(NO_MEMORY);

		strk->type = PATH_2DF;
		strk->n_subpaths = npath;
		strk->n_vertices = npts;
	}
	else {            /* Just initialize the entry */
	        strk->subpaths = NULL;
		strk->type = PATH_2DF;
		strk->n_subpaths = 0;
		strk->n_vertices = 0;
	}
      }
      {
		register Dispatch *tbl = table + tableindex;

		tbl->offset = 0;
		tbl->center = center;
		tbl->right = right;
      }
	count.path = -1;	       /* initialize path counter, not to
				        * exceed n_subpath */
}

/* create standard spacing info for each glyph  */
std_space(l_bear, wide, r_bear)

	float l_bear,
	      wide,
	      r_bear;
{
	register Standard *tbl = sp_table +tableindex;
	tbl->std_left = l_bear;
	tbl->std_wide = wide;
	tbl->std_rght = r_bear;
}

/* initialize each sub_path */
init_path(close, n)
	int             close,
	                n;
{
	register Path_subpath *path;

	if (++count.path >= strokes[tableindex].n_subpaths)
		BYE(EXCEED_PATH);
	path = current_path = strokes[tableindex].subpaths + count.path;
	path->n_pts = n;
	path->closed = close;
	if (n > 0) 
	  path->pts.pt2df = (Path_point2df *) 
	                     malloc(n * sizeof (Path_point2df));
	if (path->pts.pt2df == NULL)
		BYE(NO_MEMORY);
	expect.point = path->n_pts;
	count.point = -1;	       /* initialize point counter, not to
				        * exceed n_pts */
}

/* accumulating points for each sub_path */
add_point(x, y)
	float           x,
	                y;
{
	register Path_subpath   *path;
	register Path_point2df	*pt_ptr;

	path = current_path;
	if (++count.point >= path->n_pts)
		BYE(EXCEED_POINT);
	pt_ptr = path->pts.pt2df + count.point;
	pt_ptr->x = x;
	pt_ptr->y = y;
}

/* Path_type + n_subpaths + n_vertices */
#define STROKE_HEAD (sizeof (Path_type) + sizeof (int) + sizeof (int))

/* write out file, close everything, free everything */
fini()
{
	static long     zero = 0;

	/* pointers used to walk the arrays */
	register Path_subpath *spath;
	register Dispatch *tbl_ptr;
	register Path  *strptr;
	register Property *prop_ptr;

	FILE           *fp;
	long            offset;
	int             npath;
	register int    i,
	                j,
			k;
	Standard	*sp_ptr;
	Path_point2df	*pt;

	if (fname[0] == 0) {	       /* default output file name */
		(void) strcpy(fname, head.name);
		(void) strcat(fname, ".phont");
	}

	if ((fp = fopen(fname, "w")) == NULL)
		BYE(OPEN_ERROR);

#	define BY_BYE(err) fclose(fp), BYE(err)

	/* adjust the characters for spacing, note max char width */
	head.max_width = 0.0;
	for (i = 0, tbl_ptr = table, strptr = strokes, sp_ptr = sp_table;
             i < head.num_ch; i++, tbl_ptr++, strptr++, sp_ptr++) {
		tbl_ptr->center += sp_ptr->std_left;
		tbl_ptr->right += sp_ptr->std_left + sp_ptr->std_rght;
		if (tbl_ptr->right > head.max_width)
			head.max_width = tbl_ptr->right;
		npath = strptr->n_subpaths;
		if (npath > 0 || tbl_ptr->center != 0.0 ||
                    tbl_ptr->right != 0.0) {
			for (j = 0, spath = strptr->subpaths;
                             j < npath; j++, spath++) {
				for(k=0, pt = spath->pts.pt2df;
				     k<spath->n_pts; k++, pt++) {
					pt->x += sp_ptr->std_left;
				}
			}
		}
	}
	/* write the header info */
	if (fwrite(&head, sizeof (head), 1, fp) != 1)
		BY_BYE(WRITE_ERROR);

	(void) fseek(fp, START_PROPS, L_SET);

	/* write the property info, if any */
	if (head.num_props > 0) {
	  for (i=0, prop_ptr = head.properties; i < head.num_props;
	       i++, prop_ptr++) {

	       /* write the property name */
	       if (fwrite(prop_ptr->propname, 80, 1, fp) != 1)
		  BY_BYE(WRITE_ERROR);

	       /* write the property value */
	       if (fwrite(prop_ptr->propvalue, 80, 1, fp) != 1)
		  BY_BYE(WRITE_ERROR);
	     }
	}

	(void) fseek(fp, START_DISPATCH(head.num_props), L_SET);
	offset = START_PATH(head.num_ch, head.num_props);


	/* write the dispatch table */
	for (i = 0, tbl_ptr = table, strptr = strokes;
	     i < head.num_ch; i++, tbl_ptr++, strptr++) {
		if (fwrite(&tbl_ptr->center, sizeof (float), 1, fp) != 1 ||
		    fwrite(&tbl_ptr->right, sizeof (float), 1, fp) != 1)
			BY_BYE(WRITE_ERROR);
		npath = strptr->n_subpaths;
		if (npath > 0 || tbl_ptr->center != 0.0 ||
		    tbl_ptr->right != 0.0) {
			if (fwrite(&offset, sizeof (offset), 1, fp) != 1)
				BY_BYE(WRITE_ERROR);
			offset += STROKE_HEAD + npath * 2 * sizeof (int);
			for (j = 0, spath = strptr->subpaths;
			     j < npath; j++, spath++)
				offset += spath->n_pts * sizeof (Path_point2df);
		}
		else if (fwrite(&zero, sizeof (long), 1, fp) != 1)
			BY_BYE(WRITE_ERROR);
	}

	(void) fseek(fp, START_PATH(head.num_ch, head.num_props), L_SET);

	/* write the stroke table */
	for (i = 0, tbl_ptr = table, strptr = strokes;
	     i < head.num_ch; i++, tbl_ptr++, strptr++) {
		if (strptr->n_subpaths > 0 ||
		    tbl_ptr->center != 0.0 ||
		    tbl_ptr->right != 0.0) {
			if (fwrite(strptr, STROKE_HEAD, 1, fp) != 1)
				BY_BYE(WRITE_ERROR);

			for (j = 0, spath = strptr->subpaths;
			     j < strptr->n_subpaths; j++, spath++) {

				if (fwrite(&spath->n_pts,
				       sizeof (spath->n_pts), 1, fp) != 1 ||
				    fwrite(&spath->closed,
				      sizeof (spath->closed), 1, fp) != 1 ||
				    fwrite(spath->pts.pt2df,
					   sizeof (Path_point2df),
					   spath->n_pts, fp) != spath->n_pts)
					BY_BYE(WRITE_ERROR);
			}
		}
	}

	(void) fclose(fp);
	freeall();
#	undef BY_BYE
}

freeall()
{
	register Path  *path;
	register Path_subpath *spath;
	register int    i,
	                j,
	                n;

	path = strokes;
	for (i = 0; i < head.num_ch; i++, path++) {
		n = path->n_subpaths;
		if (n <= 0)
			continue;
		spath = path->subpaths;
		for (j = 0; j < n; j++, spath++)
			if (spath->pts.pt2df != NULL)
				free((char *) spath->pts.pt2df);
		if (path->subpaths != NULL)
			free((char *) path->subpaths);
	free(table);
	free(sp_table);
	free(strokes);
	}
	for (i=0; i < head.num_props; i++, head.properties++) {
	  if (head.properties != NULL)
	    free((char *) head.properties);
	}
}

check_nstroke()
{
	count.path++;
	if (expect.path != count.path)
		BYE(PATH_MISMATCH);
}

check_npts()
{
	count.point++;
	if (expect.point != count.point)
		BYE(POINT_MISMATCH);
}
short yyexca[] ={
-1, 1,
	0, -1,
	-2, 0,
	};
# define YYNPROD 45
# define YYLAST 93
short yyact[]={

  70,  42,  67,  13,  37,  74,  58,  23,  61,   7,
  11,  17,  11,   4,  24,  46,  28,  63,  53,  14,
  72,  50,  47,  34,  31,  26,  18,  76,  75,  71,
  68,  65,  56,  59,  38,  29,  54,  51,  39,  20,
   6,  49,  40,  55,  44,  21,  35,  25,   9,  19,
   8,  52,  43,  15,   2,  73,  30,  69,  60,  41,
  22,  32,   5,  10,  33,  66,  36,  57,  45,  27,
  12,  16,   3,   1,   0,   0,   0,   0,   0,  48,
   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
  62,   0,  64 };
short yypact[]={

-250,-1000,-256,-270,-240,-253,-1000,-232,-254,-255,
-1000,-233,-244,-222,-1000,-254,-1000,-234,-1000,-1000,
-1000,-255,-235,-1000,-1000,-268,-1000,-1000,-223,-1000,
-274,-1000,-1000,-1000,-1000,-1000,-246,-236,-1000,-1000,
-274,-1000,-237,-241,-225,-264,-224,-1000,-1000,-259,
-1000,-1000,-241,-242,-1000,-225,-226,-272,-227,-1000,
-276,-228,-1000,-1000,-1000,-1000,-1000,-238,-1000,-266,
-229,-1000,-1000,-1000,-230,-1000,-1000 };
short yypgo[]={

   0,  73,  72,  71,  70,  69,  68,  67,  66,  65,
  64,  63,  62,  60,  59,  58,  57,  55,  54,  53,
  40,  38,  52,  37,  51,  50,  48,  39,  47,  46,
  45,  44,  36,  43,  42,  41 };
short yyr1[]={

   0,   1,   1,  18,   2,   4,   5,  12,  19,  19,
  22,   3,  23,  23,  24,  20,  20,  25,  28,  26,
  29,  11,   8,   9,   9,   6,   7,  27,  27,  31,
  30,  32,  32,  13,  13,  10,  33,  21,  21,  35,
  34,  14,  15,  16,  17 };
short yyr2[]={

   0,   5,   2,   3,   2,   2,   2,   2,   0,   1,
   0,   4,   0,   2,   2,   0,   2,   2,   0,   3,
   4,   2,   2,   0,   2,   2,   2,   0,   2,   0,
   4,   0,   2,   1,   1,   1,   2,   0,   2,   0,
   5,   2,   2,   2,   2 };
short yychk[]={

-1000,  -1, -18,  -2, 263, -12, -20, 265, -25, -26,
 -11, 266,  -4, 273, 259, -19,  -3, 264, 258, -20,
 -27, -30, -13, 262, 269, -28, 258,  -5, 260, 257,
 -20, 258, -27, -10, 258, -29,  -8, 272, 257, -21,
 -34, -14, 275, -22, -31,  -6, 261, 258, -21, -35,
 258, -23, -24, 259, -32, -33, 257,  -7, 270, 257,
 -15, 267, -23, 259, -32, 257,  -9, 274, 257, -16,
 276, 257, 258, -17, 271, 257, 257 };
short yydef[]={

   0,  -2,  15,   0,   0,   8,   2,   0,  15,  27,
  18,   0,   0,   0,   4,  15,   9,   0,   7,  16,
  17,  27,   0,  33,  34,   0,  21,   3,   0,   5,
  37,  10,  28,  29,  35,  19,   0,   0,   6,   1,
  37,  39,   0,  12,  31,   0,   0,  22,  38,   0,
  41,  11,  12,   0,  30,  31,   0,  23,   0,  25,
   0,   0,  13,  14,  32,  36,  20,   0,  26,   0,
   0,  42,  24,  40,   0,  43,  44 };
/* --------------------------------------------------- */
/* | Copyright (c) 1986 MIPS Computer Systems, Inc.  | */
/* | All Rights Reserved.                            | */
/* --------------------------------------------------- */
/* $Header: yaccpar,v 1.1.1.1 89/11/26 13:31:38 wje Exp $ */

#ifndef lint
/* static char yaccpar_sccsid[] = "@(#)yaccpar	4.1	(Berkeley)	2/11/83"; */
#endif not lint

#
# define YYFLAG -1000
# define YYERROR goto yyerrlab
# define YYACCEPT return(0)
# define YYABORT return(1)

/*	parser for yacc output	*/

#ifdef YYDEBUG
int yydebug = 0; /* 1 for debugging */
#endif
YYSTYPE yyv[YYMAXDEPTH]; /* where the values are stored */
int yychar = -1; /* current input token number */
int yynerrs = 0;  /* number of errors */
short yyerrflag = 0;  /* error recovery flag */

yyparse() {

	short yys[YYMAXDEPTH];
	short yyj, yym;
	register YYSTYPE *yypvt;
	register short yystate, *yyps, yyn;
	register YYSTYPE *yypv;
	register short *yyxi;

	yystate = 0;
	yychar = -1;
	yynerrs = 0;
	yyerrflag = 0;
	yyps= &yys[-1];
	yypv= &yyv[-1];

 yystack:    /* put a state and value onto the stack */

#ifdef YYDEBUG
	if( yydebug  ) printf( "state %d, char 0%o\n", yystate, yychar );
#endif
		if( ++yyps> &yys[YYMAXDEPTH] ) { yyerror( "yacc stack overflow" ); return(1); }
		*yyps = yystate;
		++yypv;
		*yypv = yyval;

 yynewstate:

	yyn = yypact[yystate];

	if( yyn<= YYFLAG ) goto yydefault; /* simple state */

	if( yychar<0 ) if( (yychar=yylex())<0 ) yychar=0;
	if( (yyn += yychar)<0 || yyn >= YYLAST ) goto yydefault;

	if( yychk[ yyn=yyact[ yyn ] ] == yychar ){ /* valid shift */
		yychar = -1;
		yyval = yylval;
		yystate = yyn;
		if( yyerrflag > 0 ) --yyerrflag;
		goto yystack;
		}

 yydefault:
	/* default state action */

	if( (yyn=yydef[yystate]) == -2 ) {
		if( yychar<0 ) if( (yychar=yylex())<0 ) yychar = 0;
		/* look through exception table */

		for( yyxi=yyexca; (*yyxi!= (-1)) || (yyxi[1]!=yystate) ; yyxi += 2 ) ; /* VOID */

		while( *(yyxi+=2) >= 0 ){
			if( *yyxi == yychar ) break;
			}
		if( (yyn = yyxi[1]) < 0 ) return(0);   /* accept */
		}

	if( yyn == 0 ){ /* error */
		/* error ... attempt to resume parsing */

		switch( yyerrflag ){

		case 0:   /* brand new error */

			yyerror( "syntax error" );
		yyerrlab:
			++yynerrs;

		case 1:
		case 2: /* incompletely recovered error ... try again */

			yyerrflag = 3;

			/* find a state where "error" is a legal shift action */

			while ( yyps >= yys ) {
			   yyn = yypact[*yyps] + YYERRCODE;
			   if( yyn>= 0 && yyn < YYLAST && yychk[yyact[yyn]] == YYERRCODE ){
			      yystate = yyact[yyn];  /* simulate a shift of "error" */
			      goto yystack;
			      }
			   yyn = yypact[*yyps];

			   /* the current yyps has no shift onn "error", pop stack */

#ifdef YYDEBUG
			   if( yydebug ) printf( "error recovery pops state %d, uncovers %d\n", *yyps, yyps[-1] );
#endif
			   --yyps;
			   --yypv;
			   }

			/* there is no state on the stack with an error shift ... abort */

	yyabort:
			return(1);


		case 3:  /* no shift yet; clobber input char */

#ifdef YYDEBUG
			if( yydebug ) printf( "error recovery discards char %d\n", yychar );
#endif

			if( yychar == 0 ) goto yyabort; /* don't discard EOF, quit */
			yychar = -1;
			goto yynewstate;   /* try again in the same state */

			}

		}

	/* reduction by production yyn */

#ifdef YYDEBUG
		if( yydebug ) printf("reduce %d\n",yyn);
#endif
		yyps -= yyr2[yyn];
		yypvt = yypv;
		yypv -= yyr2[yyn];
		yyval = yypv[1];
		yym=yyn;
			/* consult goto table to find next state */
		yyn = yyr1[yyn];
		yyj = yypgo[yyn] + *yyps + 1;
		if( yyj>=YYLAST || yychk[ yystate = yyact[yyj] ] != -yyn ) yystate = yyact[yypgo[yyn]];
		switch(yym){
			
case 1:
# line 109 "to_wfont.y"
{ fini(); } break;
case 2:
# line 110 "to_wfont.y"
{ fini(); } break;
case 3:
# line 113 "to_wfont.y"
{ wf_header(yypvt[-2].cval, yypvt[-1].dval, yypvt[-0].dval); } break;
case 4:
# line 116 "to_wfont.y"
{ yyval.cval = yypvt[-0].cval; } break;
case 5:
# line 118 "to_wfont.y"
{ yyval.dval = yypvt[-0].dval;} break;
case 6:
# line 120 "to_wfont.y"
{ yyval.dval = yypvt[-0].dval;} break;
case 7:
# line 122 "to_wfont.y"
{ set_num_ch(yypvt[-0].ival);} break;
case 10:
# line 126 "to_wfont.y"
{ init_properties (yypvt[-0].ival); } break;
case 11:
# line 127 "to_wfont.y"
{ check_num_props (); } break;
case 14:
# line 131 "to_wfont.y"
{ add_property(yypvt[-1].cval, yypvt[-0].cval); } break;
case 17:
# line 137 "to_wfont.y"
{ check_nstroke(); } break;
case 18:
# line 139 "to_wfont.y"
{ tableindex = yypvt[-0].ival; } break;
case 20:
# line 142 "to_wfont.y"
{ glyph_header(yypvt[-3].ival, yypvt[-2].dval, yypvt[-1].dval, yypvt[-0].ival); } break;
case 21:
# line 144 "to_wfont.y"
{ check_num_ch(); yyval.ival = yypvt[-0].ival; } break;
case 22:
# line 146 "to_wfont.y"
{ yyval.ival = yypvt[-0].ival; expect.path = yypvt[-0].ival; } break;
case 23:
# line 148 "to_wfont.y"
{yyval.ival = 0;} break;
case 24:
# line 148 "to_wfont.y"
{ yyval.ival = yypvt[-0].ival; } break;
case 25:
# line 150 "to_wfont.y"
{ yyval.dval = yypvt[-0].dval; } break;
case 26:
# line 152 "to_wfont.y"
{ yyval.dval = yypvt[-0].dval; } break;
case 29:
# line 156 "to_wfont.y"
{ init_path(yypvt[-1].ival, yypvt[-0].ival); } break;
case 30:
# line 157 "to_wfont.y"
{ check_npts(); } break;
case 33:
# line 161 "to_wfont.y"
{ yyval.ival = yypvt[-0].nil == CLOSE; } break;
case 34:
# line 161 "to_wfont.y"
{ yyval.ival = yypvt[-0].nil == CLOSE; } break;
case 35:
# line 163 "to_wfont.y"
{ yyval.ival = yypvt[-0].ival; } break;
case 36:
# line 165 "to_wfont.y"
{ add_point(yypvt[-1].dval, yypvt[-0].dval); } break;
case 39:
# line 170 "to_wfont.y"
{tableindex = yypvt[-0].ival;} break;
case 40:
# line 171 "to_wfont.y"
{ std_space(yypvt[-2].dval, yypvt[-1].dval, yypvt[-0].dval); } break;
case 41:
# line 173 "to_wfont.y"
{yyval.ival = yypvt[-0].ival;} break;
case 42:
# line 175 "to_wfont.y"
{yyval.dval = yypvt[-0].dval;} break;
case 43:
# line 177 "to_wfont.y"
{yyval.dval = yypvt[-0].dval;} break;
case 44:
# line 179 "to_wfont.y"
{yyval.dval = yypvt[-0].dval;} break;
		}
		goto yystack;  /* stack new state and value */

	}
