.\" $XConsortium: Locale.man,v 1.2 91/10/08 15:24:15 rws Exp $
.\" Copyright 1990 by OMRON Corp.  All Rights Reserved.
.TH XLocale 3X11 "Release 5" "X Version 11" "XSI FUNCTIONS"
.SH NAME
XLocale \- all functions to access locale database
.SH SYNOPSIS
.B #include \f2"Xlocaleint.h"
.PP
.B int
.br
.B _Xmbtype\f2(xlocale)
.br
.B XLocale \f2xlocale\f3;
.PP
The _Xmbtype() returns the codeset type of the locale. Two
types will be returned:
.IP "" "    "
CDS_STATELESS -- state-independent codeset
.br
CDS_STATEFUL  -- state-dependent codeset
.PP
If application never calls the setting locale, the function returns -1,
no locale has been set.  With the _Xmbtype you can check if there is
locale.
.PP
.B int
.br
.B _Xmbcsnum\f2(xlocale)
.br
.B XLocale \f2xlocale\f3;
.PP
The _Xmbcsnum returns the number of charsets of the locale.
.PP
.B _CSID
.br
.B _Xmbcsid\f2(xlocale, mbstr)
.br
.B Xlocale \f2xlocale\f3;
.br
.B unsigned char *\f2mbstr\f3;
.PP
The function returns the charset id "CSi" of the multibyte character
encoded in the current locale.  The multibyte character is stored in
the null-terminated string "mbstr".  The charset id is ordered from
positive number 0.  The CSi is defined to a constant "i", e.g, CS1
is constant 1.
.PP
The _Xmbcsid returns constant ND for any error of the multibyte character
which maybe wrong code, or maybe terminated unexpectly.
.PP
For state-dependent codeset, _Xmbcsid keeps the track of the current
locking shift-state. In other word only this function _Xmbcsid would 
change the current state.   When the mbstr is passed as a NULL pointer,
the _Xmbcsid sets the initial state.
.IP "" "    "
_Xmbcsid(xlocale, NULL)
.PP
.B int
.br
.B _Xmblen\f2(xlocale)
.br 
.B XLocale \f2xlocale\f3;
.PP
The _Xmblen returns the number of bytes of the current charset in the xlocale.
The returned value is zero for wrong charset id.
.PP
.B char *
.br
.B _Xmbdsg\f2(xlocale)
.br
.B XLocale \f2xlocale\f3;
.PP
This function is for state-dependent codeset only.
The _Xmbdsg returns the designation of this charset. The NULL
returned is for wrong csid. The returned string is owned by
the locale, do not change or free it.
.PP
.B int 
.br
.B _Xmbdlen\f2(xlocale, mbstr)
.br
.B Xlocale \f2xlocale\f3;
.br
unsigned char *\f2mbstr\f3;
.PP
This function is for state-dependent codeset only.  If the mbstr
contains a complete designation sequence, the _Xmbdsg returns
the length of the sequence; otherwise returns zero.  The mbstr
is null-terminated string.
.PP
.B int
.br
.B _Xmbfsnum\f2(xlocale)
.br
.B XLocale \f2xlocale\f3;
.PP
The _Xmbfsnum returns the number of font charsets of the current locale.
This number is different from _Xmbcsnum().
.PP
.B char *
.br
.B _Xmbfsname\f2(xlocale)
.br
.B XLocale \f2xlocale\f3;
.PP
The _Xmbfsname returns the charset name with the current charset. 
The name is form of CharsetRegistry-CharsetEncoding registered by X
in the definition of XLFD.  The NULL returned is for the wrong charset.
The returned string is owned by the current locale, so do not
change and free this data.
.PP
.B int
.br
.B _Xmbfslen\f2(xlocale)
.br
.B XLocale \f2xlocale\f3;
.PP
The _Xmbfslen returns the number of bytes of the current charset of
font encoding. The zero returned is for wrong charset.
.PP
.B wchar 
.br
.B _Xmbfswf\f2(xlocale, csid)
.B XLocale \f2xlocale\f3;
.br
.B int  \f2csid\f3;
.PP
The _Xmbfswf returns the woffset of the font charset id.
This woffset is for the 4-byte wchar encoding. Refer to CTAndWC(3)
for WC definition.  The negative value -1 returned is for wrong csid.
.PP
.B char *
.br
.B _Xmbfsdsg\f2(xlocale)
.br
.B XLocale \f2xlocale\f3;
.PP
The _Xmbfsdsg returns the designation sequence, i.e., escape sequence
of font charset which is registered by X in the "Compound Text Encoding,
Version 1.1".  The returned value is owned by the locale, do not free
or change it.  The NULL returned is for wrong charset.
.PP
.B int
.br
.B _Xmbctocsc\f2(xlocale, mbstr, cscode)
.br
.B XLocale \f2xlocale\f3;
.br
.B unsigned char *\f2mbstr\f3;
.br
.B unsigned int  *\f2cscode\f3;
.PP
The _Xmbctocsc converts codepoint of multibyte character
to codepoing of charset. 
The csid is it's charset id.  The converted code
is stored in the cscode.
If wrong codepoint, use the first codepoint of csid as default,
and return negative value. if correct, return 0 meaning Success.
The _Xmbctocsc always supposes that the mbstr points to a codepoint,
not shift-state sequence if codeset is state-dependent. The caller
should note this, otherwise the _Xmbctocsc treats it as wrong codepoint.
.PP
.B int
.br
.B _Xcsctombc\f2(xlocale, cscode, code)
.br
.B XLocale \f2xlocale\f3;
.br
.B unsigned int  \f2cscode\f3;
.br
.B unsigned int *\f2code\f3;
.PP
The _Xcsctombc does the reverse conversion of _Xmbctocsc.
.PP
.B char *
.br
.B _Xsetlocale\f2(locale_category, locale_name)
.br
.B int   \f2locale_category\f3;
.br
.B char *\f2locale_name\f3;
.PP
.PP
The _Xsetlocale sets the current locale for the specified category.
If the operation was successful, _Xsetlocale returns a
pointer to the current locale name for the category
If the category is invalid or the locale is not
supported in the system, _Xsetlocale returns a NULL
pointer.
The returned locale name is owned by the system locale, do not change
or free it.
.PP
The category is defined to one of the following:
.IP "" "        "
LC_CTYPE
.br
LC_ALL
.PP
The locale name is allowed to the form:
.IP "" "        "
NULL
.br
""
.br
string
.PP
The value NULL means to query the current locale name, and _Xsetlocale
returns the locale name string.
.PP
The empty string sets the implementation-depedent locale. It
examines the enviroment $LANG.  If ${LANG} is set and con-
tains the name of a valid locale, that value is used to set
category. If the value is still not  obtained, _Xsetlocale 
sets the category to C-language "C" and return the locale
name. The C locale is ASCII codeset.
.PP
The locale name is accepted to the following form:
.IP "" "   "
language[_territory[.codeset]]
.PP
The language and territory are country codes defined in ISO 639 and
ISO 3166.
.SH SEE ALSO
X/Open Portability Guide, Volume 3, XSI Internationalization.
.br
IS0 639, ISO 3166.
