.\" $Header: XpexGetImpDepConstants.man,v 2.5 91/09/11 16:04:35 sinyaw Exp $
.\"
.\"
.\" Copyright 1991 by Sony Microsystems Company, San Jose, California
.\" 
.\"                   All Rights Reserved
.\"
.\" Permission to use, modify, and distribute this software and its
.\" documentation for any purpose and without fee is hereby granted,
.\" provided that the above copyright notice appear in all copies and
.\" that both that copyright notice and this permission notice appear
.\" in supporting documentation, and that the name of Sony not be used
.\" in advertising or publicity pertaining to distribution of the
.\" software without specific, written prior permission.
.\"
.\" SONY DISCLAIMS ANY AND ALL WARRANTIES WITH REGARD TO THIS SOFTWARE,
.\" INCLUDING ALL EXPRESS WARRANTIES AND ALL IMPLIED WARRANTIES OF
.\" MERCHANTABILITY AND FITNESS, FOR A PARTICULAR PURPOSE. IN NO EVENT
.\" SHALL SONY BE LIABLE FOR ANY DAMAGES OF ANY KIND, INCLUDING BUT NOT
.\" LIMITED TO SPECIAL, INDIRECT OR CONSEQUENTIAL DAMAGES RESULTING FROM
.\" LOSS OF USE, DATA OR LOSS OF ANY PAST, PRESENT, OR PROSPECTIVE PROFITS,
.\" WHETHER IN AN ACTION OF CONTRACT, NEGLIENCE OR OTHER TORTIOUS ACTION, 
.\" ARISING OUT OF OR IN CONNECTION WITH THE USE OR PERFORMANCE OF THIS 
.\" SOFTWARE.
.\"
.\"
.TH XpexGetImpDepConstants 3PEX "$Revision: 2.5 $" "Sony Microsystems"
.AT
.SH "Name"
XpexGetImpDepConstants, XpexGetAllImpDepConstants \- get one or more or all implementation dependent constants
.SH "Synopsis"
.nf
Status XpexGetImpDepConstants(dpy, drawable, names, num_names, values)
.br
	Display \fI*dpy\fP;
.br
	Drawable \fIdrawable\fP;
.br
	XpexImpDepConstantName \fI*names\fP;
.br
	int \fInum_names\fP;
.br
	unsigned long **values; /* RETURN */
.sp
Status XpexGetAllImpDepConstants(dpy, drawable, values)
.br
	Display *\fIdpy\fP;
.br
	Drawable \fIdrawable\fP;
.br
	XpexImpDepConstants *\fIvalues\fP; /* RETURN */
.fi
.SH "Arguments"
.IP \fIdpy\fP 1i
Specifies a pointer to the Display structure; 
returned from XOpenDisplay.
.IP \fIdrawable\fP 1i
Specifies the drawable.
.IP \fIvalues\fP 1i
To be added
.SH "Description"
This function allows a client to query all of the 
implementation-dependent constants in a PEX server extension.
.SH "Structures"
typedef struct {
.br
	unsigned long nominal_line_width;
.br
	unsigned long num_supported_line_widths;
.br
	unsigned long min_line_width;
.br
	unsigned long max_line_width;
.br
	unsigned long nominal_edge_width;
.br
	unsigned long num_supported_edge_widths;
.br
	unsigned long min_edge_width;
.br
	unsigned long max_edge_width;
.br
	unsigned long nominal_marker_size;
.br
	unsigned long num_supported_marker_sizes;
.br
	unsigned long min_marker_size;
.br
	unsigned long max_marker_size;
.br
	XpexFloat chromaticity_red_u;
.br
	XpexFloat chromaticity_red_v;
.br
	XpexFloat luminance_red;
.br
	XpexFloat chromaticity_green_u;
.br
	XpexFloat chromaticity_green_v;
.br
	XpexFloat luminance_green;
.br
	XpexFloat chromaticity_blue_u;
.br
	XpexFloat chromaticity_blue_v;
.br
	XpexFloat luminance_blue;
.br
	XpexFloat chromaticity_white_u;
.br
	XpexFloat chromaticity_white_v;
.br
 	XpexFloat luminance_white;
.br
	unsigned long max_nameset_names;
.br
	unsigned long max_model_clip_planes;
.br
	unsigned long transparency_supported;
.br
	unsigned long dithering_supported;
.br
	unsigned long max_non_ambient_lights;
.br
	unsigned long max_nurb_order;
.br
	unsigned long max_trim_curve_order;
.br
	unsigned long best_color_approx_values;
.br
	usigned long double_buffering_supported;
.br
} XpexAllImpDepConstants;
.SH "Errors"
BadValue, BadDrawable
.SH "Related Commands"
XpexInitialize, XpexQueryExtension, 
XpexGetExtensionInfo, XpexGetEnumTypeInfo,
XpexGetAllEnumTypeInfo.
.br
