.\" $Header: XpexCreateSC.man,v 2.4 91/09/11 16:01:57 sinyaw Exp $
.\"
.\" Copyright 1991 by Sony Microsystems Company, San Jose, California
.\" 
.\"                   All Rights Reserved
.\"
.\" Permission to use, modify, and distribute this software and its
.\" documentation for any purpose and without fee is hereby granted,
.\" provided that the above copyright notice appear in all copies and
.\" that both that copyright notice and this permission notice appear
.\" in supporting documentation, and that the name of Sony not be used
.\" in advertising or publicity pertaining to distribution of the
.\" software without specific, written prior permission.
.\"
.\" SONY DISCLAIMS ANY AND ALL WARRANTIES WITH REGARD TO THIS SOFTWARE,
.\" INCLUDING ALL EXPRESS WARRANTIES AND ALL IMPLIED WARRANTIES OF
.\" MERCHANTABILITY AND FITNESS, FOR A PARTICULAR PURPOSE. IN NO EVENT
.\" SHALL SONY BE LIABLE FOR ANY DAMAGES OF ANY KIND, INCLUDING BUT NOT
.\" LIMITED TO SPECIAL, INDIRECT OR CONSEQUENTIAL DAMAGES RESULTING FROM
.\" LOSS OF USE, DATA OR LOSS OF ANY PAST, PRESENT, OR PROSPECTIVE PROFITS,
.\" WHETHER IN AN ACTION OF CONTRACT, NEGLIENCE OR OTHER TORTIOUS ACTION, 
.\" ARISING OUT OF OR IN CONNECTION WITH THE USE OR PERFORMANCE OF THIS 
.\" SOFTWARE.
.\"
.\" 
.TH XpexCreateSC 3PEX "$Revision: 2.4 $" "Sony Microsystems"
.AT
.SH "Name"
XpexCreateSC, XpexCopySC, XpexFreeSC \- Functions that manage the 
creation, freeing, and copying of search contexts.
.SH "Synopsis"
.nf
XpexSC XpexCreateSC(dpy, valuemask, values)
.br
	Display  *\fIdpy\fP;
.br
	XpexBitmask \fIvaluemask\fP;
.br
	XpexSCValues  *\fIvalues\fP;
.sp
void XpexCopySC(dpy, src, dest, valuemask)
.br
	Display  *\fIdpy\fP;
.br
	XpexSC  \fIsrc_sc_id\fP;
.br
	XpexSC  \fIdest_sc_id\fP;
.br
	XpexBitmask \fIvaluemask\fP;
.sp
void XpexFreeSC(dpy, sc_id)
.br
	Display  *\fIdpy\fP;
.br
	XpexSC  \fIsc_id\fP;
.fi
.SH "Arguments"
.IP \fIdpy\fP 1i
Specifies a pointer to the Display structure;
returned from XOpenDisplay.
.IP \fIvaluemask\fP 1i	
Specifies those search context attributes that are to be
explicitly set at the time the resource is created.
.IP \fIvalues\fP 1i	
Specifies a pointer to a structure of type
XpexSCValues.  This structure will contain the
corresponding list of values used to modify the
newly-created search context.
.IP \fIsrc_sc_id\fP 1i	
[ To be added ]
.IP \fIdest_sc_id\fP 1i	
[ To be added ]
.IP \fIsc_id\fP 1i	
[ To be added ]
.SH "Description"
The \fIXpexCreateSC\fP function creates a search context 
resource for the specified search context identifier returned.
.sp
\fIXpexCreateSC\fP can generate \fIBadIDChoice\fP, 
\fIBadValue\fP, \fIBadFloatingPointFormat\fP, \fIBadAlloc\fP, 
\fIBadPath\fP, and \fIBadNameSet\fP errors.
.sp
The \fIXpexCopySC\fP function copies the search context 
\fIsrc_sc_id\fP to a destination search context \fIdest_sc_id\fP.
The \fIdest_sc_id\fP must already exist as a valid resource.  The
\fIvaluemask\fP indicates which values in the search context will
be copied.
.sp
\fIXpexCopySC\fP can generate \fIBadSearchContext\fP and 
\fIBadValue\fP errors.
.sp
The \fIXpexFreeSC\fP function deletes the specified search 
context resource and frees the storage associated with it.
.sp
\fIXpexFreeSC\fP can generate a \fIBadSearchContext\fP error.
.SH "Structures"
See XpexSCValues(3PEX).
.SH "Errors"
.IP \fIBadIDChoice\fP 1i
ID already in use or not in range assigned to client
.IP \fIBadValue\fP 1i
a value in \fI*values\fP structure is out of range
.br
illegal bit set in valuemask parameter
.IP \fIBadFloatingPointFormat\fP 1i
device does not support the specified fp format
.IP \fIBadAlloc\fP 1i
server failed to allocate the requested resource
.IP \fIBadPath\fP 1i
illegal or poorly-formed search path (includes invalid structure
ID's, invalid element offset values)
.IP \fIBadNameSet\fP 1i
specified name set resource ID is invalid
.IP \fIBadSearchContext\fP 1i
specified search context resource ID is invalid
.IP \fIBadValue\fP 1i
illegal bit set in valuemask parameter
.SH "Related Commands"
XpexGetSC, XpexChangeSC, XpexSearchNetwork.
