/* Copyright 1991 NEC Corporation, Tokyo, Japan.
 *
 * Permission to use, copy, modify, and distribute this software and its
 * documentation for any purpose and without fee is hereby granted,
 * provided that the above copyright notice appear in all copies and that
 * both that copyright notice and this permission notice appear in
 * supporting documentation, and that the name of NEC Corporation
 * not be used in advertising or publicity pertaining to distribution
 * of the software without specific, written prior permission.  NEC 
 * Corporation makes no representations about the suitability of this
 * software for any purpose.  It is provided "as is" without express
 * or implied warranty.
 *
 * NEC CORPORATION DISCLAIMS ALL WARRANTIES WITH REGARD TO THIS SOFTWARE,
 * INCLUDING ALL IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS, IN 
 * NO EVENT SHALL NEC CORPORATION BE LIABLE FOR ANY SPECIAL, INDIRECT OR
 * CONSEQUENTIAL DAMAGES OR ANY DAMAGES WHATSOEVER RESULTING FROM LOSS OF 
 * USE, DATA OR PROFITS, WHETHER IN AN ACTION OF CONTRACT, NEGLIGENCE OR 
 * OTHER TORTUOUS ACTION, ARISING OUT OF OR IN CONNECTION WITH THE USE OR 
 * PERFORMANCE OF THIS SOFTWARE. 
 */

static char kakutei_id[] = "@(#) 102.1 $Header: /work/nk.R3.1/lib/iroha/RCS/kakuteimap.c,v 3.2 91/09/02 14:02:07 kon Exp $";

extern EmptySelfInsert();
extern AlphaMode();
extern HenkanNyuryokuMode();
extern ZenHiraKakuteiMode();
extern ZenKataKakuteiMode();
extern HanKataKakuteiMode();
extern ZenAlphaKakuteiMode();
extern HanAlphaKakuteiMode();
extern HexMode();
extern BushuMode();
extern KigoIchiran();
extern DoFuncSequence();
extern UseOtherKeymap();

#define NONE IROHA_FN_Undefined

unsigned char kakutei_kmap[256] =
{               
/* C-@ */       IROHA_FN_SelfInsert,
/* C-a */       IROHA_FN_SelfInsert,
/* C-b */       IROHA_FN_SelfInsert,
/* C-c */       IROHA_FN_SelfInsert,
/* C-d */       IROHA_FN_SelfInsert,
/* C-e */       IROHA_FN_SelfInsert,
/* C-f */       IROHA_FN_SelfInsert,
/* C-g */       IROHA_FN_Quit,
/* C-h */       IROHA_FN_DeletePrevious,
/* C-i */       IROHA_FN_SelfInsert,
/* C-j */       IROHA_FN_Kakutei,
/* C-k */       IROHA_FN_SelfInsert,
/* C-l */       IROHA_FN_SelfInsert,
/* C-m */       IROHA_FN_Kakutei,
/* C-n */       IROHA_FN_SelfInsert,
/* C-o */       IROHA_FN_AlphaMode,
/* C-p */       IROHA_FN_SelfInsert,
/* C-q */       IROHA_FN_QuotedInsert,
/* C-r */       IROHA_FN_SelfInsert,
/* C-s */       IROHA_FN_SelfInsert,
/* C-t */       IROHA_FN_SelfInsert,
/* C-u */       IROHA_FN_SelfInsert,
/* C-v */       IROHA_FN_SelfInsert,
/* C-w */       IROHA_FN_SelfInsert,
/* C-x */       IROHA_FN_SelfInsert,
/* C-y */       IROHA_FN_SelfInsert,
/* C-z */       IROHA_FN_SelfInsert,
/* C-[ */       IROHA_FN_SelfInsert,
/* C-\ */       IROHA_FN_SelfInsert,
/* C-] */       IROHA_FN_SelfInsert,
/* C-^ */       IROHA_FN_SelfInsert,
/* C-_ */       IROHA_FN_SelfInsert,
/* space */     IROHA_FN_FunctionalInsert,
/* ! */         IROHA_FN_FunctionalInsert,
/* " */         IROHA_FN_FunctionalInsert,
/* # */         IROHA_FN_FunctionalInsert,
/* $ */         IROHA_FN_FunctionalInsert,
/* % */         IROHA_FN_FunctionalInsert,
/* & */         IROHA_FN_FunctionalInsert,
/* ' */         IROHA_FN_FunctionalInsert,
/* ( */         IROHA_FN_FunctionalInsert,
/* ) */         IROHA_FN_FunctionalInsert,
/* * */         IROHA_FN_FunctionalInsert,
/* + */         IROHA_FN_FunctionalInsert,
/* , */         IROHA_FN_FunctionalInsert,
/* - */         IROHA_FN_FunctionalInsert,
/* . */         IROHA_FN_FunctionalInsert,
/* / */         IROHA_FN_FunctionalInsert,
/* 0 */         IROHA_FN_FunctionalInsert,
/* 1 */         IROHA_FN_FunctionalInsert,
/* 2 */         IROHA_FN_FunctionalInsert,
/* 3 */         IROHA_FN_FunctionalInsert,
/* 4 */         IROHA_FN_FunctionalInsert,
/* 5 */         IROHA_FN_FunctionalInsert,
/* 6 */         IROHA_FN_FunctionalInsert,
/* 7 */         IROHA_FN_FunctionalInsert,
/* 8 */         IROHA_FN_FunctionalInsert,
/* 9 */         IROHA_FN_FunctionalInsert,
/*   : */       IROHA_FN_FunctionalInsert,
/* ; */         IROHA_FN_FunctionalInsert,
/* < */         IROHA_FN_FunctionalInsert,
/* = */         IROHA_FN_FunctionalInsert,
/* > */         IROHA_FN_FunctionalInsert,
/* ? */         IROHA_FN_FunctionalInsert,
/* @ */         IROHA_FN_FunctionalInsert,
/* A */         IROHA_FN_FunctionalInsert,
/* B */         IROHA_FN_FunctionalInsert,
/* C */         IROHA_FN_FunctionalInsert,
/* D */         IROHA_FN_FunctionalInsert,
/* E */         IROHA_FN_FunctionalInsert,
/* F */         IROHA_FN_FunctionalInsert,
/* G */         IROHA_FN_FunctionalInsert,
/* H */         IROHA_FN_FunctionalInsert,
/* I */         IROHA_FN_FunctionalInsert,
/* J */         IROHA_FN_FunctionalInsert,
/* K */         IROHA_FN_FunctionalInsert,
/* L */         IROHA_FN_FunctionalInsert,
/* M */         IROHA_FN_FunctionalInsert,
/* N */         IROHA_FN_FunctionalInsert,
/* O */         IROHA_FN_FunctionalInsert,
/* P */         IROHA_FN_FunctionalInsert,
/* Q */         IROHA_FN_FunctionalInsert,
/* R */         IROHA_FN_FunctionalInsert,
/* S */         IROHA_FN_FunctionalInsert,
/* T */         IROHA_FN_FunctionalInsert,
/* U */         IROHA_FN_FunctionalInsert,
/* V */         IROHA_FN_FunctionalInsert,
/* W */         IROHA_FN_FunctionalInsert,
/* X */         IROHA_FN_FunctionalInsert,
/* Y */         IROHA_FN_FunctionalInsert,
/* Z */         IROHA_FN_FunctionalInsert,
/* [ */         IROHA_FN_FunctionalInsert,
/* \ */         IROHA_FN_FunctionalInsert,
/* ] */         IROHA_FN_FunctionalInsert,
/* ^ */         IROHA_FN_FunctionalInsert,
/* _ */         IROHA_FN_FunctionalInsert,
/* ` */         IROHA_FN_FunctionalInsert,
/* a */         IROHA_FN_FunctionalInsert,
/* b */         IROHA_FN_FunctionalInsert,
/* c */         IROHA_FN_FunctionalInsert,
/* d */         IROHA_FN_FunctionalInsert,
/* e */         IROHA_FN_FunctionalInsert,
/* f */         IROHA_FN_FunctionalInsert,
/* g */         IROHA_FN_FunctionalInsert,
/* h */         IROHA_FN_FunctionalInsert,
/* i */         IROHA_FN_FunctionalInsert,
/* j */         IROHA_FN_FunctionalInsert,
/* k */         IROHA_FN_FunctionalInsert,
/* l */         IROHA_FN_FunctionalInsert,
/* m */         IROHA_FN_FunctionalInsert,
/* n */         IROHA_FN_FunctionalInsert,
/* o */         IROHA_FN_FunctionalInsert,
/* p */         IROHA_FN_FunctionalInsert,
/* q */         IROHA_FN_FunctionalInsert,
/* r */         IROHA_FN_FunctionalInsert,
/* s */         IROHA_FN_FunctionalInsert,
/* t */         IROHA_FN_FunctionalInsert,
/* u */         IROHA_FN_FunctionalInsert,
/* v */         IROHA_FN_FunctionalInsert,
/* w */         IROHA_FN_FunctionalInsert,
/* x */         IROHA_FN_FunctionalInsert,
/* y */         IROHA_FN_FunctionalInsert,
/* z */         IROHA_FN_FunctionalInsert,
/* { */         IROHA_FN_FunctionalInsert,
/* | */         IROHA_FN_FunctionalInsert,
/* } */         IROHA_FN_FunctionalInsert,
/* ~ */         IROHA_FN_FunctionalInsert,
/* DEL */       IROHA_FN_FunctionalInsert,
/* Nfer */      NONE,
/* Xfer */      IROHA_FN_AlphaMode,
/* Up */        NONE,
/* Left */      NONE,
/* Right */     NONE,
/* Down */      NONE,
/* Insert */    NONE,
/* Rollup */    NONE,
/* Rolldown */  NONE,
/* Home */      NONE,
/* Help */      NONE,
/* KeyPad */    NONE,
/* 8c */        NONE,
/* 8d */        NONE,
/* 8e */        NONE,
/* 8f */        NONE,
/* S-nfer */    NONE,
/* S-xfer */    NONE,
/* S-up */      NONE,
/* S-left */    NONE,
/* S-right */   NONE,
/* S-down */    NONE,
/* C-nfer */    NONE,
/* C-xfer */    NONE,
/* C-up */      NONE,
/* C-left */    NONE,
/* C-right */   NONE,
/* C-down */    NONE,
/* 9c */        NONE,
/* 9d */        NONE,
/* 9e */        NONE,
/* 9f */        NONE,
/* KANASPACE */ NONE,
/*  */        IROHA_FN_FunctionalInsert,
/*  */        IROHA_FN_FunctionalInsert,
/*  */        IROHA_FN_FunctionalInsert,
/*  */        IROHA_FN_FunctionalInsert,
/*  */        IROHA_FN_FunctionalInsert,
/*  */        IROHA_FN_FunctionalInsert,
/*  */        IROHA_FN_FunctionalInsert,
/*  */        IROHA_FN_FunctionalInsert,
/*  */        IROHA_FN_FunctionalInsert,
/*  */        IROHA_FN_FunctionalInsert,
/*  */        IROHA_FN_FunctionalInsert,
/*  */        IROHA_FN_FunctionalInsert,
/*  */        IROHA_FN_FunctionalInsert,
/*  */        IROHA_FN_FunctionalInsert,
/*  */        IROHA_FN_FunctionalInsert,
/*  */        IROHA_FN_FunctionalInsert,
/*  */        IROHA_FN_FunctionalInsert,
/*  */        IROHA_FN_FunctionalInsert,
/*  */        IROHA_FN_FunctionalInsert,
/*  */        IROHA_FN_FunctionalInsert,
/*  */        IROHA_FN_FunctionalInsert,
/*  */        IROHA_FN_FunctionalInsert,
/*  */        IROHA_FN_FunctionalInsert,
/*  */        IROHA_FN_FunctionalInsert,
/*  */        IROHA_FN_FunctionalInsert,
/*  */        IROHA_FN_FunctionalInsert,
/*  */        IROHA_FN_FunctionalInsert,
/*  */        IROHA_FN_FunctionalInsert,
/*  */        IROHA_FN_FunctionalInsert,
/*  */        IROHA_FN_FunctionalInsert,
/*  */        IROHA_FN_FunctionalInsert,
/*  */        IROHA_FN_FunctionalInsert,
/*  */        IROHA_FN_FunctionalInsert,
/*  */        IROHA_FN_FunctionalInsert,
/*  */        IROHA_FN_FunctionalInsert,
/*  */        IROHA_FN_FunctionalInsert,
/*  */        IROHA_FN_FunctionalInsert,
/*  */        IROHA_FN_FunctionalInsert,
/*  */        IROHA_FN_FunctionalInsert,
/*  */        IROHA_FN_FunctionalInsert,
/*  */        IROHA_FN_FunctionalInsert,
/*  */        IROHA_FN_FunctionalInsert,
/*  */        IROHA_FN_FunctionalInsert,
/*  */        IROHA_FN_FunctionalInsert,
/*  */        IROHA_FN_FunctionalInsert,
/*  */        IROHA_FN_FunctionalInsert,
/*  */        IROHA_FN_FunctionalInsert,
/*  */        IROHA_FN_FunctionalInsert,
/*  */        IROHA_FN_FunctionalInsert,
/*  */        IROHA_FN_FunctionalInsert,
/*  */        IROHA_FN_FunctionalInsert,
/*  */        IROHA_FN_FunctionalInsert,
/*  */        IROHA_FN_FunctionalInsert,
/*  */        IROHA_FN_FunctionalInsert,
/*  */        IROHA_FN_FunctionalInsert,
/*  */        IROHA_FN_FunctionalInsert,
/*  */        IROHA_FN_FunctionalInsert,
/*  */        IROHA_FN_FunctionalInsert,
/*  */        IROHA_FN_FunctionalInsert,
/*  */        IROHA_FN_FunctionalInsert,
/*  */        IROHA_FN_FunctionalInsert,
/*  */        IROHA_FN_FunctionalInsert,
/*  */        IROHA_FN_FunctionalInsert,
/* F1 */        NONE,
/* F2 */        NONE,
/* F3 */        NONE,
/* F4 */        NONE,
/* F5 */        NONE,
/* F6 */        NONE,
/* F7 */        NONE,
/* F8 */        NONE,
/* F9 */        NONE,
/* F10 */       NONE,
/* ea */        NONE,
/* eb */        NONE,
/* ec */        NONE,
/* ed */        NONE,
/* ee */        NONE,
/* ef */        NONE,
/* PF1 */       NONE,
/* PF2 */       NONE,
/* PF3 */       NONE,
/* PF4 */       NONE,
/* PF5 */       NONE,
/* PF6 */       NONE,
/* PF7 */       NONE,
/* PF8 */       NONE,
/* PF9 */       NONE,
/* PF10 */      NONE,
/* fa */        NONE,
/* fb */        NONE,
/* fc */        NONE,
/* fd */        NONE,
/* fe */        NONE,
/* ff */        NONE,
};

static int (*khal_funcs[])() = { /* Ⱦѥե٥åȳ */
/* ̤                           */    EmptySelfInsert,
/* ʬȤؿ           */    EmptySelfInsert,
/* ʤؿ         */    KakuteiHanAlphaInsert,
/* 			    */    KakuteiQuotedInsert,
/* ܸϥ⡼                 */    NONE,
/* ե٥åϥ⡼         */    AlphaMode,
/* Ѵϥ⡼                   */    HenkanNyuryokuMode,
/* ѤҤ餬ʳϥ⡼       */    ZenHiraKakuteiMode,
/* ѥʳϥ⡼       */    ZenKataKakuteiMode,
/* Ⱦѥʳϥ⡼       */    HanKataKakuteiMode,
/* ѥե٥åȳϥ⡼ */    ZenAlphaKakuteiMode,
/* Ⱦѥե٥åȳϥ⡼ */    HanAlphaKakuteiMode,
/* ϥ⡼		    */    HexMode,
/* ϥ⡼		    */    BushuMode,
/* ϥ⡼		    */    KigoIchiran,
/*                              */    NONE,
/*                              */    NONE,
/* ι                           */    NONE,
/* ι                           */    NONE,
/* Ƭ                             */    NONE,
/*                              */    NONE,
/*                        */    NONE,
/* ˺                         */    EmptySelfInsert,
/* ޤǺ                     */    NONE,
/* Ѵ                             */    NONE,
/*                              */    EmptySelfInsert,
/* Ф                           */    NONE,
/* ̤                             */    NONE,
/* ʸ῭̥⡼ɤ                 */    NONE, 		   
/*                          */    NONE,
/* Ͽ                             */    NONE,
/* ʥɤȤѴ           */    NONE,
/* ̾ȤѴ                 */    NONE,
/*                          */    NONE,
/* ʬ̵Ѵ                       */    NONE,
/* ѤؤѴ                     */    NONE,
/* ȾѤؤѴ                     */    NONE,
/* ʸؤѴ                   */    NONE,
/* ԥ饤                   */    NONE,
/* ʸؤѴ                   */    NONE,
/* Ҥ餬Ѵ			    */	  NONE,
/* Ѵ			    */	  NONE,
/* ޻Ѵ			    */	  NONE,
/* ʣΥγ             */    DoFuncSequence,
/* 󥹤ؤб           */    UseOtherKeymap,
};

static int (*khkt_funcs[])() = { /* Ⱦѥʳ */
/* ̤                           */    KakuteiEmptySelfInsert,
/* ʬȤؿ           */    KakuteiEmptySelfInsert,
/* ʤؿ         */    KakuteiHanKataInsert,
/* 			    */    KakuteiQuotedInsert,
/* ܸϥ⡼                 */    NONE,
/* ե٥åϥ⡼         */    KakuteiHanKataAlphaMode,
/* Ѵϥ⡼                   */    HenkanNyuryokuMode,
/* ѤҤ餬ʳϥ⡼       */    ZenHiraKakuteiMode,
/* ѥʳϥ⡼       */    ZenKataKakuteiMode,
/* Ⱦѥʳϥ⡼       */    HanKataKakuteiMode,
/* ѥե٥åȳϥ⡼ */    ZenAlphaKakuteiMode,
/* Ⱦѥե٥åȳϥ⡼ */    HanAlphaKakuteiMode,
/* ϥ⡼		    */    HexMode,
/* ϥ⡼		    */    BushuMode,
/* ϥ⡼		    */    KigoIchiran,
/*                              */    NONE,
/*                              */    NONE,
/* ι                           */    NONE,
/* ι                           */    NONE,
/* Ƭ                             */    NONE,
/*                              */    NONE,
/*                        */    NONE,
/* ˺                         */    KakuteiDeletePrevious,
/* ޤǺ                     */    NONE,
/* Ѵ                             */    NONE,
/*                              */    KakuteiHanKataKakutei,
/* Ф                           */    NONE,
/* ̤                             */    NONE,
/* ʸ῭̥⡼ɤ                 */    NONE, 		   
/*                          */    KakuteiRomQuit,
/* Ͽ                             */    NONE,
/* ʥɤȤѴ           */    NONE,
/* ̾ȤѴ                 */    NONE,
/*                          */    NONE,
/* ʬ̵Ѵ                       */    NONE,
/* ѤؤѴ                     */    NONE,
/* ȾѤؤѴ                     */    NONE,
/* ʸؤѴ                   */    NONE,
/* ԥ饤                   */    NONE,
/* ʸؤѴ                   */    NONE,
/* Ҥ餬Ѵ			    */	  NONE,
/* Ѵ			    */	  NONE,
/* ޻Ѵ			    */	  NONE,
/* ʣΥγ             */    DoFuncSequence,
/* 󥹤ؤб           */    UseOtherKeymap,
};

static int (*kzal_funcs[])() = { /* ѥե٥åȳ */
/* ̤                           */    EmptySelfInsert,
/* ʬȤؿ           */    EmptySelfInsert,
/* ʤؿ         */    KakuteiZenAlphaInsert,
/* 			    */    KakuteiQuotedInsert,
/* ܸϥ⡼                 */    NONE,
/* ե٥åϥ⡼         */    AlphaMode,
/* Ѵϥ⡼                   */    HenkanNyuryokuMode,
/* ѤҤ餬ʳϥ⡼       */    ZenHiraKakuteiMode,
/* ѥʳϥ⡼       */    ZenKataKakuteiMode,
/* Ⱦѥʳϥ⡼       */    HanKataKakuteiMode,
/* ѥե٥åȳϥ⡼ */    ZenAlphaKakuteiMode,
/* Ⱦѥե٥åȳϥ⡼ */    HanAlphaKakuteiMode,
/* ϥ⡼		    */    HexMode,
/* ϥ⡼		    */    BushuMode,
/* ϥ⡼		    */    KigoIchiran,
/*                              */    NONE,
/*                              */    NONE,
/* ι                           */    NONE,
/* ι                           */    NONE,
/* Ƭ                             */    NONE,
/*                              */    NONE,
/*                        */    NONE,
/* ˺                         */    EmptySelfInsert,
/* ޤǺ                     */    NONE,
/* Ѵ                             */    NONE,
/*                              */    EmptySelfInsert,
/* Ф                           */    NONE,
/* ̤                             */    NONE,
/* ʸ῭̥⡼ɤ                 */    NONE, 		   
/*                          */    NONE,
/* Ͽ                             */    NONE,
/* ʥɤȤѴ           */    NONE,
/* ̾ȤѴ                 */    NONE,
/*                          */    NONE,
/* ʬ̵Ѵ                       */    NONE,
/* ѤؤѴ                     */    NONE,
/* ȾѤؤѴ                     */    NONE,
/* ʸؤѴ                   */    NONE,
/* ԥ饤                   */    NONE,
/* ʸؤѴ                   */    NONE,
/* Ҥ餬Ѵ			    */	  NONE,
/* Ѵ			    */	  NONE,
/* ޻Ѵ			    */	  NONE,
/* ʣΥγ             */    DoFuncSequence,
/* 󥹤ؤб           */    UseOtherKeymap,
};

static int (*kzhr_funcs[])() = { /* ѤҤ餬ʳ */
/* ̤                           */    KakuteiEmptySelfInsert,
/* ʬȤؿ           */    KakuteiEmptySelfInsert,
/* ʤؿ         */    KakuteiZenHiraInsert,
/* 			    */    KakuteiQuotedInsert,
/* ܸϥ⡼                 */    NONE,
/* ե٥åϥ⡼         */    KakuteiZenHiraAlphaMode,
/* Ѵϥ⡼                   */    HenkanNyuryokuMode,
/* ѤҤ餬ʳϥ⡼       */    ZenHiraKakuteiMode,
/* ѥʳϥ⡼       */    ZenKataKakuteiMode,
/* Ⱦѥʳϥ⡼       */    HanKataKakuteiMode,
/* ѥե٥åȳϥ⡼ */    ZenAlphaKakuteiMode,
/* Ⱦѥե٥åȳϥ⡼ */    HanAlphaKakuteiMode,
/* ϥ⡼		    */    HexMode,
/* ϥ⡼		    */    BushuMode,
/* ϥ⡼		    */    KigoIchiran,
/*                              */    NONE,
/*                              */    NONE,
/* ι                           */    NONE,
/* ι                           */    NONE,
/* Ƭ                             */    NONE,
/*                              */    NONE,
/*                        */    NONE,
/* ˺                         */    KakuteiDeletePrevious,
/* ޤǺ                     */    NONE,
/* Ѵ                             */    NONE,
/*                              */    KakuteiZenHiraKakutei,
/* Ф                           */    NONE,
/* ̤                             */    NONE,
/* ʸ῭̥⡼ɤ                 */    NONE, 		   
/*                          */    KakuteiRomQuit,
/* Ͽ                             */    NONE,
/* ʥɤȤѴ           */    NONE,
/* ̾ȤѴ                 */    NONE,
/*                          */    NONE,
/* ʬ̵Ѵ                       */    NONE,
/* ѤؤѴ                     */    NONE,
/* ȾѤؤѴ                     */    NONE,
/* ʸؤѴ                   */    NONE,
/* ԥ饤                   */    NONE,
/* ʸؤѴ                   */    NONE,
/* Ҥ餬Ѵ			    */	  NONE,
/* Ѵ			    */	  NONE,
/* ޻Ѵ			    */	  NONE,
/* ʣΥγ             */    DoFuncSequence,
/* 󥹤ؤб           */    UseOtherKeymap,
};

static int (*kzkt_funcs[])() = { /* ѥʳ */
/* ̤                           */    KakuteiEmptySelfInsert,
/* ʬȤؿ           */    KakuteiEmptySelfInsert,
/* ʤؿ         */    KakuteiZenKataInsert,
/* 			    */    KakuteiQuotedInsert,
/* ܸϥ⡼                 */    NONE,
/* ե٥åϥ⡼         */    KakuteiZenKataAlphaMode,
/* Ѵϥ⡼                   */    HenkanNyuryokuMode,
/* ѤҤ餬ʳϥ⡼       */    ZenHiraKakuteiMode,
/* ѥʳϥ⡼       */    ZenKataKakuteiMode,
/* Ⱦѥʳϥ⡼       */    HanKataKakuteiMode,
/* ѥե٥åȳϥ⡼ */    ZenAlphaKakuteiMode,
/* Ⱦѥե٥åȳϥ⡼ */    HanAlphaKakuteiMode,
/* ϥ⡼		    */    HexMode,
/* ϥ⡼		    */    BushuMode,
/* ϥ⡼		    */    KigoIchiran,
/*                              */    NONE,
/*                              */    NONE,
/* ι                           */    NONE,
/* ι                           */    NONE,
/* Ƭ                             */    NONE,
/*                              */    NONE,
/*                        */    NONE,
/* ˺                         */    KakuteiDeletePrevious,
/* ޤǺ                     */    NONE,
/* Ѵ                             */    NONE,
/*                              */    KakuteiZenKataKakutei,
/* Ф                           */    NONE,
/* ̤                             */    NONE,
/* ʸ῭̥⡼ɤ                 */    NONE, 		   
/*                          */    KakuteiRomQuit,
/* Ͽ                             */    NONE,
/* ʥɤȤѴ           */    NONE,
/* ̾ȤѴ                 */    NONE,
/*                          */    NONE,
/* ʬ̵Ѵ                       */    NONE,
/* ѤؤѴ                     */    NONE,
/* ȾѤؤѴ                     */    NONE,
/* ʸؤѴ                   */    NONE,
/* ԥ饤                   */    NONE,
/* ʸؤѴ                   */    NONE,
/* Ҥ餬Ѵ			    */	  NONE,
/* Ѵ			    */	  NONE,
/* ޻Ѵ			    */	  NONE,
/* ʣΥγ             */    DoFuncSequence,
/* 󥹤ؤб           */    UseOtherKeymap,
};

KanjiModeRec khkt_mode = { /* Ⱦѥʳ */
  simplefunc,
  kakutei_kmap,
  IROHA_KANJIMODE_TABLE_SHARED | IROHA_KANJIMODE_EMPTY_MODE,
  khkt_funcs,
};

KanjiModeRec khal_mode = { /* Ⱦѥե٥åȳ */
  simplefunc,
  kakutei_kmap,
  IROHA_KANJIMODE_TABLE_SHARED | IROHA_KANJIMODE_EMPTY_MODE,
  khal_funcs,
};

KanjiModeRec kzal_mode = { /* ѥե٥åȳ */
  simplefunc,
  kakutei_kmap,
  IROHA_KANJIMODE_TABLE_SHARED | IROHA_KANJIMODE_EMPTY_MODE,
  kzal_funcs,
};

KanjiModeRec kzhr_mode = { /* ѤҤ餬ʳ */
  simplefunc,
  kakutei_kmap,
  IROHA_KANJIMODE_TABLE_SHARED | IROHA_KANJIMODE_EMPTY_MODE,
  kzhr_funcs,
};

KanjiModeRec kzkt_mode = { /* ѥʳ */
  simplefunc,
  kakutei_kmap,
  IROHA_KANJIMODE_TABLE_SHARED | IROHA_KANJIMODE_EMPTY_MODE,
  kzkt_funcs,
};
