/* Copyright 1991 NEC Corporation, Tokyo, Japan.
 *
 * Permission to use, copy, modify, and distribute this software and its
 * documentation for any purpose and without fee is hereby granted,
 * provided that the above copyright notice appear in all copies and that
 * both that copyright notice and this permission notice appear in
 * supporting documentation, and that the name of NEC Corporation
 * not be used in advertising or publicity pertaining to distribution
 * of the software without specific, written prior permission.  NEC 
 * Corporation makes no representations about the suitability of this
 * software for any purpose.  It is provided "as is" without express
 * or implied warranty.
 *
 * NEC CORPORATION DISCLAIMS ALL WARRANTIES WITH REGARD TO THIS SOFTWARE,
 * INCLUDING ALL IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS, IN 
 * NO EVENT SHALL NEC CORPORATION BE LIABLE FOR ANY SPECIAL, INDIRECT OR
 * CONSEQUENTIAL DAMAGES OR ANY DAMAGES WHATSOEVER RESULTING FROM LOSS OF 
 * USE, DATA OR PROFITS, WHETHER IN AN ACTION OF CONTRACT, NEGLIGENCE OR 
 * OTHER TORTUOUS ACTION, ARISING OUT OF OR IN CONNECTION WITH THE USE OR 
 * PERFORMANCE OF THIS SOFTWARE. 
 */

/*
 * @(#) 102.1 $Header: /work/nk.R3.1/lib/iroha/RCS/iroha.h,v 3.4 91/09/03 18:54:16 kon Exp $
 * $Revision: 3.4 $
 * $Author: kon $
 */
     
#include <stdio.h>
#include "sglobal.h"
#include <iroha/RK.h>
#include <iroha/jrkanji.h>

#include <memory.h>
#define bzero(buf, size) memset((char *)(buf), 0x00, (size))
#define bcopy(src, dst, size) memcpy((char *)(dst), (char *)(src), (size))

/*
 * LIBDIR  -- ƥΥޥե޻Ѵơ֥뤬
 *            ֤ǥ쥯ȥꡣ
 */

#ifndef LIBDIR
#define LIBDIR "/usr/lib/iroha"
#endif

#define XKanjiStatus          jrKanjiStatus
#define XKanjiStatusWithValue jrKanjiStatusWithValue

/*
 * glineinfo -- ɽΤǼƤι¤Ρ
 * 줾ΥФϰʲΰ̣ġ
 *
 * glkosu -- ιԤˤο
 * glhead -- ιԤƬ䤬kouhoinfoβܤ(0)
 * gllen  -- ιԤɽ뤿ʸĹ
 * gldata -- ιԤɽ뤿ʸؤΥݥ
 */

typedef struct {
  int glkosu;
  int glhead;
  int gllen;
  unsigned char *gldata;
} glineinfo;

/*
 * kouhoinfo -- ΤǼƤι¤
 * 줾ΥФϰʲΰ̣ġ
 *
 * khretsu -- θ䤬
 * khpoint -- θιԤΤʤǤΰ
 * khdata -- θʸؤΥݥ
 */

typedef struct {
  int khretsu;
  int khpoint;
  unsigned char *khdata;
} kouhoinfo;

#define ROMEBUFSIZE 	1024
#define	BANGOSIZE	4	/* γƸֹΥХȿ */
#define	REVSIZE		2	/* ֹΥСΥХȿ */
#define	BANGOMAX   	9	/* κ */
#define KIGOSIZE	2	/* ΥХȿ */
#define GL_KUHAKUSIZE	2	/* ֹζʸΥХȿ */
#define KG_KUHAKUSIZE	2	/* δ֤ζʸΥХȿ */
#define KIGOCOL		(KIGOSIZE + KG_KUHAKUSIZE)
					/* bangomax׻뤿ο */
#define	KIGOBANGOMAX   	16	/* κ */
#define HINSHISUU	14
#define HINSHIBUF	256
#define GOBISUU		9

#define	ON		1
#define	OFF		0

#define ZENHIRA		IROHA_MODE_ZenHiraKakuteiMode	/* 5 ϥ⡼ */
#define ZENKATA		IROHA_MODE_ZenKataKakuteiMode	/* 6 ϥ⡼ */
#define HANKATA		IROHA_MODE_HanKataKakuteiMode	/* 7 ϥ⡼ */

#define	NG		-1

#define NO_CALLBACK	0
#define NCALLBACK	4

#define	JISHU_HIRA	0
#define JISHU_ZEN_KATA	1
#define JISHU_HAN_KATA	2
#define JISHU_ZEN_ALPHA	3
#define JISHU_HAN_ALPHA	4
#define MAX_JISHU	5

#define  SENTOU        1
#define  HENKANSUMI    2
#define  WARIKOMIMOJI  4
#define  SHIRIKIRE     8
#define  ATAMAKIRE    16

typedef char *mode_context;

struct callback {
  int (*func[NCALLBACK])();
  mode_context    env;
  struct callback *next;
};

/* identifier for each context structures */
#define CORE_CONTEXT       (char)0
#define YOMI_CONTEXT       (char)1
#define JISHU_CONTEXT      (char)2
#define HENKAN_CONTEXT     (char)3
#define ICHIRAN_CONTEXT    (char)4
#define FORICHIRAN_CONTEXT (char)5
#define MOUNT_CONTEXT      (char)6
#define TOUROKU_CONTEXT    (char)7
#define ADJUST_CONTEXT     (char)8

typedef struct _coreContextRec {
  char id;
  char majorMode, minorMode;
  struct callback c;
  KanjiMode	  prevMode; /* Υ⡼ */
  mode_context    next;
} coreContextRec, *coreContext;

typedef struct  _yomiContextRec {
  /* core Ʊ */
  char id;
  char majorMode, minorMode;
  struct callback c;
  KanjiMode	  prevMode;	/* Υ⡼ */
  mode_context    next;

  /* ޻Ѵط */
  unsigned char   romaji_buffer[ROMEBUFSIZE];
  /* ޻Хåե rStartp, rEndp ΣĤΥǥåˤäƴ
   * 롣rStartp ϥʤѴǤʤä޻κǽʸؤΥǥ
   * ǤꡢrEndp Ͽ˥޻ϤˡǼ٤ 
   * romaji_buffer ΥǥåǤ롣Ϥ޻ϡ
   * romaji_buffer + rEndp ˳Ǽ졢Υ޻򥫥ʤѴ
   * ϡromaji_buffer + rStartp  rEndp - rStartp ХȤʸ
   * оݤȤʤ롣 */
  int		  rEndp, rStartp, rCurs; /* ޻ХåեΥݥ */
  unsigned char   kana_buffer[ROMEBUFSIZE];
  unsigned char   rAttr[ROMEBUFSIZE], kAttr[ROMEBUFSIZE];
  int		  kEndp; /* ʥХåեκǸ򲡤ݥ */
  int             kRStartp, kCurs;

  /* ¾Υץ */
  char		  generalFlags;		/* see below */
  char		  allowedChars;		/* see jrkanji.h */
  char		  henkanInhibition;	/* see below */
  char		  baseChar;		/* see below */
  int		  (*henkanCallback)();	/* ѴԤˤѿ˥ɥ쥹
             ꤵƤʤФΥɥ쥹δؿ̾δؿ
             Ƥ֡ꤵƤʤ̾δؿƤ֡
               ѴʤɤѴ줿üʽԤΤ
             б뤿դ
	       ѴХåϰȤƤɤѴؿƤФ줿Τ򼨤
	     ֹȼ*/

  /* ѿ */
  char		  *retbuf, *retbufp;
  int		  retbufsize;
} yomiContextRec, *yomiContext;

#define IROHA_YOMI_BREAK_ROMAN		1
#define IROHA_YOMI_CHGMODE_INHIBITTED	2
#define IROHA_YOMI_END_IF_KAKUTEI	4
#define IROHA_YOMI_DELETE_DONT_QUIT	8

#define IROHA_YOMI_INHIBIT_NONE		0
#define IROHA_YOMI_INHIBIT_HENKAN	1
#define IROHA_YOMI_INHIBIT_JISHU	2
#define IROHA_YOMI_INHIBIT_ASHEX	4
#define IROHA_YOMI_INHIBIT_ASBUSHU	8
#define IROHA_YOMI_INHIBIT_ALL		15

/* ΤΥե饰 */
#define NUMBERING 			1
#define CHARINSERT			2

#define IROHA_JISHU_UPPER		1
#define IROHA_JISHU_CAPITALIZE		2

typedef struct _jishuContextRec {
  char id;
  char majorMode, minorMode;
  struct callback c;
  KanjiMode	  prevMode;	/* Υ⡼ */
  mode_context    next;

  unsigned char	 inhibition;
  unsigned char  jishu_buffer[ROMEBUFSIZE];
  int            jishu_len, jishu_kEndp, jishu_rEndp;
  unsigned char  kc, jishu_case;
  yomiContext    ycx;
} jishuContextRec, *jishuContext;

typedef struct _henkanContextRec {
  char id;
  char majorMode, minorMode;
  struct callback c;
  KanjiMode	  prevMode;	/* Υ⡼ */
  mode_context    next;

  /* ʴѴط */
  int            context;
  int		 kouhoCount;	/*  henkanNext Ϣ³Ʋ줿 */
  unsigned char  yomi_buffer[ROMEBUFSIZE];
  unsigned char  echo_buffer[ROMEBUFSIZE];
  unsigned char  **allkouho; /* RkGetKanjiListʸˤ
				ȤäƤȤ */
  int            yomilen;    /* ɤߤĹɤ߼Ȥ kana_buffer 
			         */
  int            curbun;     /* ʸ */
  int		 curIkouho;  /* ȸ */
  int            nbunsetsu;  /* ʸο */
#define MAXNBUNSETSU	256
  int            kugiri[MAXNBUNSETSU]; /* ʸʬԤʸ᤯
					  ξ */
  int		 *kanaKugiri, *romajiKugiri, *jishubun;
  yomiContext    ycx;
/* ifdef MEASURE_TIME */
  long		 proctime;   /* (ѴǷ¬) */
  long		 rktime;     /* (RKˤ) */
/* endif MEASURE_TIME */
} henkanContextRec, *henkanContext;

typedef struct _ichiranContextRec {
  char id;
  char majorMode, minorMode;
  struct callback c;
  KanjiMode	  prevMode;	/* Υ⡼ */
  mode_context    next;

  int            svIkouho;   /* ȸȤäƤ(ɽ) */
  int            *curIkouho; /* ȸ */
  int            nIkouho;    /* ο(ɽ) */
  int		 tooSmall;   /* ƸФʤե饰 */
  int            curIchar;   /* ̤ʸ󤢤ñϿñϤ
    							Ƭʸΰ */
  unsigned char  inhibit;
  unsigned char  flags;	     /* 򸫤Ƥ */
  unsigned char  **allkouho; /* RkGetKanjiListʸˤ
				ȤäƤȤ */
  unsigned char  *glinebufp; /* ΤԤɽ뤿ʸ
				ؤΥݥ */
  kouhoinfo      *kouhoifp;  /* طξǼƤ¤
				ؤΥݥ */
  glineinfo      *glineifp;  /* طξǼƤ¤
				ؤΥݥ */
} ichiranContextRec, *ichiranContext;

/* ե饰ΰ̣ */
#define ICHIRAN_ALLOW_CALLBACK 1 /* Хå򤷤Ƥɤ */


typedef struct _forichiranContextRec {
  char id;
  char majorMode, minorMode;
  struct callback c;
  KanjiMode	  prevMode;	/* Υ⡼ */
  mode_context    next;

  int            curIkouho;  /* ȸ */
  unsigned char  **allkouho; /* RkGetKanjiListʸˤ
				ȤäƤȤ */
} forichiranContextRec, *forichiranContext;

typedef struct _mountContextRec {
  char id;
  char majorMode, minorMode;
  struct callback c;
  KanjiMode	  prevMode;	/* Υ⡼ */
  mode_context    next;

  unsigned char   *mountOldStatus; /* ޥȤƤ뤫ʤ */
  unsigned char   *mountNewStatus; /* ޥȤƤ뤫ʤ */
  unsigned char  **mountList;   /* ޥȲǽʼΰ */
  int            curIkouho;     /* ȸ */
} mountContextRec, *mountContext;

typedef struct _tourokuContextRec {
  char id;
  char majorMode, minorMode;
  struct callback c;
  KanjiMode	  prevMode;	/* Υ⡼ */
  mode_context    next;

  unsigned char  genbuf[ROMEBUFSIZE];
  unsigned char  qbuf[ROMEBUFSIZE];
  unsigned char  tango_buffer[ROMEBUFSIZE];
  int            tango_len;  /* ñϿñʸĹ */
  unsigned char  yomi_buffer[ROMEBUFSIZE];
  int            yomi_len;   /* ñϿɤߤʸĹ */
  int            curHinshi;  /* ʻ */
  char		 hcode[16];   /* ñϿʻ */
  int		 katsuyou;   /* ñϿưγѷ */
  unsigned char  **udic;     /* ñϿǤ뼭 (̾) */
  int            delContext; /* ñǣĤμޥȤ */
} tourokuContextRec, *tourokuContext;

typedef struct _adjustContextRec {
  char id;
  char majorMode, minorMode;
  struct callback c;
  KanjiMode	  prevMode;	/* Υ⡼ */
  mode_context    next;

  yomiContext    ycx;
  henkanContext  hcx;

  unsigned char  genbuf[ROMEBUFSIZE];
  int            kanjilen, strlen, bunlen; /* ʬΡʸĹ */
} adjustContextRec, *adjustContext;

struct moreTodo {
  char          todo; /* äȤΡ򼨤 */
  char          fnum; /* ؿֹ档ʤ鼡ʸǼ뤳Ȥ򤹤 */
  unsigned char ch;   /* ʸ */
};

/* ⡼̾Ǽǡη */

struct ModeNameRecs {
  int           alloc;
  unsigned char *name;
};

/* 

  uiContext ϥ޻ѴʴѴ˻Ȥ빽¤ΤǤ롣
  XLookupKanjiString ʤɤˤѴϡɥʬΥ줿ʣ
  ϥݡȤбƤΤǡΥ޻ξ䡢ʴѴ
  ͻҤʤɤ򤽤줾ΥɥʬΥݻƤʤФ
  ʤι¤ΤϤΤ˻Ȥ빽¤ΤǤ롣
 
  ¤ΤΥФɤΤ褦ʤΤ뤫ϡ򻲾Ȥ뤳
 
 */

typedef struct {

  /* XLookupKanjiStringΥѥ᥿ */
  unsigned char  *buffer_return;
  int            bytes_buffer;
  jrKanjiStatus  *kanji_status_return;

  /* XLookupKanjiStringͤǤʸĹ */
  int		 nbytes;

  /* 饯 */
  unsigned char  ch;

  /* ߥХǡ */
  int		 contextCache;	 /* Ѵƥȥå */
  int		 bushuContext;	 /* Ѵƥ */
  KanjiMode      current_mode;
  char		 majorMode, minorMode;	 /* ľΤ */

  short		 curkigo;	 /* ȵ() */
  char           currussia;	 /* ȵ(ʸ) */
  char           curgreek;	 /* ȵ(ꥷʸ) */
  char           curkeisen;	 /* ȵ() */
  short          curbushu;       /* ̾ */
  int            ncolumns;	 /* ԤΥλѤ */
  unsigned char  genbuf[ROMEBUFSIZE];	/* ѥХåե */

  /* ꥹȥХåϢ */
  char           *client_data;   /* ץꥱѥǡ */
  void           (*list_func)(); /* ꥹȥХåؿ */

  /* ¾ */
  char		 flags;		 /* 򸫤Ƥ */
  char		 status;	 /* ɤΤ褦ʾ֤֤äΤ򼨤
				    Υ⡼ɤ
				     
				     λ
				     
				     ¾
				    ʤɤͤ롣(򸫤) */

  /* Хå */
  struct callback *cb;

  /* äȤȤȤ¤ */
  struct moreTodo more;

  /* ֥ƥȤؤΥ */
  mode_context   modec;		/* ˤĤʤͽ */
} uiContextRec, *uiContext;

/* uiContext  flags ΥӥåȤΰ̣ */
#define PLEASE_CLEAR_GLINE	1	/* GLine äƤ */
#define PCG_RECOGNIZED		2	/* GLine 򼡤Ͼäޤ */
#define MULTI_SEQUENCE_EXECUTED	4	/* äޥ󥹤Ԥ줿 */

int defaultContext, defaultBushuContext;

#define EVERYTIME_CALLBACK	0
#define EXIT_CALLBACK		1
#define QUIT_CALLBACK		2
#define AUX_CALLBACK		3

/* ޻Ѵ */
/*
 * ޻Ѵơ֥ϣĤɤǤ礦ʣɬפʤΤ
 *  RomeStruct ΥФȤƤɬפ⤢ޤ礦...
 * λϤλǹͤޤ礦
 */
     
extern struct RkRxDic *romajidic, *RkOpenRoma();

/*
 * ̾Ƥѿ
 */

#define MAX_DICS 16

extern char *kanjidicname[];
extern int  nkanjidics;

extern char *userdicname[];
extern int  nuserdics;
extern char userdicstatus[];

extern char *bushudicname[];
extern int nbushudics;

extern char *localdicname[];
extern int nlocaldics;

/*
 * 顼ΥåƤѿ
 */

extern char *necKanjiError;

/*
 * ǥХʸɽ뤫ɤΥե饰
 */

extern iroha_debug;

/*
 * 16ʥϤԤɽ뤫ɤĴ٤
 */

#define hexGLine(plen) (d->ncolumns >= plen + 4)

/*
 * 󥹤ȯ褦ʥ
 */

#define IrohaFunctionKey(key) \
  ((0x80 <= (int)(unsigned char)(key) &&  \
    (int)(unsigned char)(key) <= 0x8b) || \
   (0x90 <= (int)(unsigned char)(key) &&  \
    (int)(unsigned char)(key) <= 0x9b) || \
   (0xe0 <= (int)(unsigned char)(key) &&  \
    (int)(unsigned char)(key) <= 0xff) )

/* selectOne ǥХåȼɤɽޥ */

#define WITHOUT_LIST_CALLBACK 0
#define WITH_LIST_CALLBACK    1

/*
 * Rk ؿȥ졼뤿̾ν񤭴
 */

#ifdef DEBUG
#include "traceRK.h"
#endif /* DEBUG */

/*
 * ǥХåѤΥޥ
 */

#ifdef DEBUG
#define debug_message(fmt, x, y, z)	dbg_msg(fmt, x, y, z)
#else /* !DEBUG */
#define debug_message(fmt, x, y, z)
#endif /* !DEBUG */

/*
 * malloc ΥǥХ
 */

#ifdef DEBUG_ALLOC
extern int fail_malloc;
#define malloc(n) debug_malloc(n)
#endif /* DEBUG_MALLOC */
