/* $XConsortium: pm_ui.c,v 5.1 91/02/16 09:32:54 rws Exp $ */

/***********************************************************
Copyright (c) 1989-1991 by Sun Microsystems, Inc. and the X Consortium.

                        All Rights Reserved

Permission to use, copy, modify, and distribute this software and its 
documentation for any purpose and without fee is hereby granted, 
provided that the above copyright notice appear in all copies and that
both that copyright notice and this permission notice appear in 
supporting documentation, and that the names of Sun Microsystems,
the X Consortium, and MIT not be used in advertising or publicity 
pertaining to distribution of the software without specific, written 
prior permission.  

SUN MICROSYSTEMS DISCLAIMS ALL WARRANTIES WITH REGARD TO THIS SOFTWARE, 
INCLUDING ALL IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS, IN NO EVENT 
SHALL SUN MICROSYSTEMS BE LIABLE FOR ANY SPECIAL, INDIRECT OR CONSEQUENTIAL 
DAMAGES OR ANY DAMAGES WHATSOEVER RESULTING FROM LOSS OF USE, DATA OR PROFITS,
WHETHER IN AN ACTION OF CONTRACT, NEGLIGENCE OR OTHER TORTIOUS ACTION,
ARISING OUT OF OR IN CONNECTION WITH THE USE OR PERFORMANCE OF THIS
SOFTWARE.

******************************************************************/

/*
 * pm_ui.c - User interface object initialization functions.
 * This file was generated by `gxv' from `pm.G'.
 * DO NOT EDIT BY HAND.
 */

#include <stdio.h>
#include <sys/param.h>
#include <sys/types.h>
#include <xview/xview.h>
#include <xview/canvas.h>
#include <xview/icon_load.h>
#include <xview/panel.h>
#include <xview/scrollbar.h>
#include <xview/svrimage.h>
#include <xview/termsw.h>
#include <xview/text.h>
#include <xview/tty.h>
#include "pm_ui.h"

/*
 * Create object `view_menu' in the specified instance.
 */
Xv_opaque
pm_view_menu_create(ip, owner)
	caddr_t		*ip;
	Xv_opaque	owner;
{
	extern Menu_item	toggle_grid();
	extern Menu_item	pu_light_sources();
	extern Menu_item	pu_rot_panel();
	extern Menu_item	pu_light_panel();
	extern Menu_item	pu_orient_panel();
	extern Menu_item	pu_viewmap_panel();
	extern void		pinned_menu_notify();
	Xv_opaque	obj;
	
	obj = xv_create(owner, MENU_COMMAND_MENU,
		XV_KEY_DATA, INSTANCE, ip,
		MENU_ITEM,
			XV_KEY_DATA, INSTANCE, ip,
			MENU_STRING, "Hide Grid",
			MENU_GEN_PROC, toggle_grid,
			MENU_NOTIFY_PROC, pinned_menu_notify,
			0,
		MENU_ITEM,
			XV_KEY_DATA, INSTANCE, ip,
			MENU_STRING, "Show Light Sources",
			MENU_GEN_PROC, pu_light_sources,
			MENU_NOTIFY_PROC, pinned_menu_notify,
			0,
		MENU_ITEM,
			XV_KEY_DATA, INSTANCE, ip,
			MENU_STRING, "Rotation and Scaling...",
			MENU_GEN_PROC, pu_rot_panel,
			MENU_NOTIFY_PROC, pinned_menu_notify,
			0,
		MENU_ITEM,
			XV_KEY_DATA, INSTANCE, ip,
			MENU_STRING, "Lighting....",
			MENU_GEN_PROC, pu_light_panel,
			MENU_NOTIFY_PROC, pinned_menu_notify,
			0,
		MENU_ITEM,
			XV_KEY_DATA, INSTANCE, ip,
			MENU_STRING, "View Orientation...",
			MENU_GEN_PROC, pu_orient_panel,
			MENU_NOTIFY_PROC, pinned_menu_notify,
			0,
		MENU_ITEM,
			XV_KEY_DATA, INSTANCE, ip,
			MENU_STRING, "View Mapping...",
			MENU_GEN_PROC, pu_viewmap_panel,
			MENU_NOTIFY_PROC, pinned_menu_notify,
			0,
		MENU_GEN_PIN_WINDOW, (Xv_opaque **) ip[0], "",
		0);
	return obj;
}

/*
 * Create object `edit_menu' in the specified instance.
 */
Xv_opaque
pm_edit_menu_create(ip, owner)
	caddr_t		*ip;
	Xv_opaque	owner;
{
	extern Menu_item	cmd_build();
	extern Menu_item	pu_object_panel();
	Xv_opaque	obj;
	
	obj = xv_create(owner, MENU_COMMAND_MENU,
		XV_KEY_DATA, INSTANCE, ip,
		MENU_ITEM,
			XV_KEY_DATA, INSTANCE, ip,
			MENU_STRING, "Build",
			MENU_GEN_PROC, cmd_build,
			0,
		MENU_ITEM,
			XV_KEY_DATA, INSTANCE, ip,
			MENU_STRING, "Build Settings...",
			MENU_GEN_PROC, pu_object_panel,
			0,
		MENU_DEFAULT, 1,
		0);
	return obj;
}

/*
 * Create object `props_menu' in the specified instance.
 */
Xv_opaque
pm_props_menu_create(ip, owner)
	caddr_t		*ip;
	Xv_opaque	owner;
{
	extern Menu_item	pu_prop_panel();
	Xv_opaque	obj;
	
	obj = xv_create(owner, MENU_COMMAND_MENU,
		XV_KEY_DATA, INSTANCE, ip,
		MENU_ITEM,
			XV_KEY_DATA, INSTANCE, ip,
			MENU_STRING, "Surface Properties...",
			MENU_GEN_PROC, pu_prop_panel,
			0,
		MENU_DEFAULT, 1,
		0);
	return obj;
}

/*
 * Initialize an instance of object `pyr_frame'.
 */
pm_pyr_frame_objects *
pm_pyr_frame_objects_initialize(ip, owner)
	pm_pyr_frame_objects	*ip;
	Xv_opaque	owner;
{
	if (!ip && !(ip = (pm_pyr_frame_objects *) calloc(1, sizeof (pm_pyr_frame_objects))))
		return (pm_pyr_frame_objects *) NULL;
	if (!ip->pyr_frame)
		ip->pyr_frame = pm_pyr_frame_pyr_frame_create(ip, owner);
	if (!ip->main_panel)
		ip->main_panel = pm_pyr_frame_main_panel_create(ip, ip->pyr_frame);
	if (!ip->obj_button)
		ip->obj_button = pm_pyr_frame_obj_button_create(ip, ip->main_panel);
	if (!ip->view_button)
		ip->view_button = pm_pyr_frame_view_button_create(ip, ip->main_panel);
	if (!ip->props_button)
		ip->props_button = pm_pyr_frame_props_button_create(ip, ip->main_panel);
	if (!ip->canvas)
		ip->canvas = pm_pyr_frame_canvas_create(ip, ip->pyr_frame);
	return ip;
}

/*
 * Create object `pyr_frame' in the specified instance.
 */
Xv_opaque
pm_pyr_frame_pyr_frame_create(ip, owner)
	caddr_t		*ip;
	Xv_opaque	owner;
{
	Xv_opaque	obj;
	
	obj = xv_create(owner, FRAME,
		XV_KEY_DATA, INSTANCE, ip,
                XV_X, 1, XV_Y, 1,
		XV_WIDTH, 550,
		XV_HEIGHT, 600,
		XV_LABEL, "Pyramid",
		XV_SHOW, TRUE,
		FRAME_SHOW_FOOTER, TRUE,
		0);
	return obj;
}

/*
 * Create object `main_panel' in the specified instance.
 */
Xv_opaque
pm_pyr_frame_main_panel_create(ip, owner)
	caddr_t		*ip;
	Xv_opaque	owner;
{
	Xv_opaque	obj;
	
	obj = xv_create(owner, PANEL,
		XV_KEY_DATA, INSTANCE, ip,
		XV_X, 0, XV_Y, 0,
		XV_WIDTH, WIN_EXTEND_TO_EDGE,
		XV_HEIGHT, 48,
		OPENWIN_SHOW_BORDERS, TRUE,
		0);
	return obj;
}

/*
 * Create object `obj_button' in the specified instance.
 */
Xv_opaque
pm_pyr_frame_obj_button_create(ip, owner)
	caddr_t		*ip;
	Xv_opaque	owner;
{
	Xv_opaque	obj;
	
	obj = xv_create(owner, PANEL_BUTTON,
		XV_KEY_DATA, INSTANCE, ip,
		XV_HELP_DATA, "pm:obj_button",
		XV_X, 8,
		XV_Y, 8,
		XV_WIDTH, 0,
		XV_HEIGHT, 0,
		PANEL_LABEL_STRING, "Object",
		PANEL_ITEM_MENU, pm_edit_menu_create(ip, NULL),
		0);
	return obj;
}

/*
 * Create object `view_button' in the specified instance.
 */
Xv_opaque
pm_pyr_frame_view_button_create(ip, owner)
	caddr_t		*ip;
	Xv_opaque	owner;
{
	Xv_opaque	obj;
	
	obj = xv_create(owner, PANEL_BUTTON,
		XV_KEY_DATA, INSTANCE, ip,
		XV_HELP_DATA, "pm:view_button",
		XV_X, 88,
		XV_Y, 8,
		XV_WIDTH, 0,
		XV_HEIGHT, 0,
		PANEL_LABEL_STRING, "View",
		PANEL_ITEM_MENU, pm_view_menu_create(ip, NULL),
		0);
	return obj;
}

/*
 * Create object `props_button' in the specified instance.
 */
Xv_opaque
pm_pyr_frame_props_button_create(ip, owner)
	caddr_t		*ip;
	Xv_opaque	owner;
{
	Xv_opaque	obj;
	
	obj = xv_create(owner, PANEL_BUTTON,
		XV_KEY_DATA, INSTANCE, ip,
		XV_HELP_DATA, "pm:props_button",
		XV_X, 160,
		XV_Y, 8,
		XV_WIDTH, 0,
		XV_HEIGHT, 0,
		PANEL_LABEL_STRING, "Props",
		PANEL_ITEM_MENU, pm_props_menu_create(ip, NULL),
		0);
	return obj;
}

/*
 * Create object `canvas' in the specified instance.
 */
Xv_opaque
pm_pyr_frame_canvas_create(ip, owner)
	caddr_t		*ip;
	Xv_opaque	owner;
{
	Xv_opaque	obj;
	
	obj = xv_create(owner, CANVAS,
		XV_KEY_DATA, INSTANCE, ip,
		XV_X, 0,
		XV_Y, 50,
		XV_WIDTH, WIN_EXTEND_TO_EDGE,
		XV_HEIGHT, WIN_EXTEND_TO_EDGE,
		0);
	return obj;
}

/*
 * Initialize an instance of object `rot_panel_frame'.
 */
pm_rot_panel_frame_objects *
pm_rot_panel_frame_objects_initialize(ip, owner)
	pm_rot_panel_frame_objects	*ip;
	Xv_opaque	owner;
{
	if (!ip && !(ip = (pm_rot_panel_frame_objects *) calloc(1, sizeof (pm_rot_panel_frame_objects))))
		return (pm_rot_panel_frame_objects *) NULL;
	if (!ip->rot_panel_frame)
		ip->rot_panel_frame = pm_rot_panel_frame_rot_panel_frame_create(ip, owner);
	if (!ip->rot_panel)
		ip->rot_panel = pm_rot_panel_frame_rot_panel_create(ip, ip->rot_panel_frame);
	if (!ip->pn_x_rotation)
		ip->pn_x_rotation = pm_rot_panel_frame_pn_x_rotation_create(ip, ip->rot_panel);
	if (!ip->pn_y_rotation)
		ip->pn_y_rotation = pm_rot_panel_frame_pn_y_rotation_create(ip, ip->rot_panel);
	if (!ip->pn_z_rotation)
		ip->pn_z_rotation = pm_rot_panel_frame_pn_z_rotation_create(ip, ip->rot_panel);
	if (!ip->pn_scale)
		ip->pn_scale = pm_rot_panel_frame_pn_scale_create(ip, ip->rot_panel);
	if (!ip->pn_auto_rotate_toggle)
		ip->pn_auto_rotate_toggle = pm_rot_panel_frame_pn_auto_rotate_toggle_create(ip, ip->rot_panel);
	return ip;
}

/*
 * Create object `rot_panel_frame' in the specified instance.
 */
Xv_opaque
pm_rot_panel_frame_rot_panel_frame_create(ip, owner)
	caddr_t		*ip;
	Xv_opaque	owner;
{
	Xv_opaque	obj;
	
	obj = xv_create(owner, FRAME_CMD,
		XV_KEY_DATA, INSTANCE, ip,
                XV_X, 575, XV_Y, 350,
		XV_WIDTH, 336,
		XV_HEIGHT, 192,
		XV_LABEL, "Pyramid: Rotation and Scaling",
		XV_SHOW, FALSE,
		FRAME_SHOW_FOOTER, FALSE,
		FRAME_SHOW_RESIZE_CORNER, FALSE,
		FRAME_CMD_PUSHPIN_IN, TRUE,
		0);
	xv_set(xv_get(obj, FRAME_CMD_PANEL), WIN_SHOW, FALSE, 0);
	return obj;
}

/*
 * Create object `rot_panel' in the specified instance.
 */
Xv_opaque
pm_rot_panel_frame_rot_panel_create(ip, owner)
	caddr_t		*ip;
	Xv_opaque	owner;
{
	Xv_opaque	obj;
	
	obj = xv_create(owner, PANEL,
		XV_KEY_DATA, INSTANCE, ip,
		XV_X, 0,
		XV_Y, 0,
		XV_WIDTH, WIN_EXTEND_TO_EDGE,
		XV_HEIGHT, WIN_EXTEND_TO_EDGE,
		OPENWIN_SHOW_BORDERS, FALSE,
		0);
	return obj;
}

/*
 * Create object `pn_x_rotation' in the specified instance.
 */
Xv_opaque
pm_rot_panel_frame_pn_x_rotation_create(ip, owner)
	caddr_t		*ip;
	Xv_opaque	owner;
{
	extern void		sliderRotateProc();
	Xv_opaque	obj;
	
	obj = xv_create(owner, PANEL_SLIDER,
		XV_KEY_DATA, INSTANCE, ip,
		XV_X, 16,
		XV_Y, 16,
		XV_WIDTH, 0,
		XV_HEIGHT, 0,
		PANEL_VALUE_X, 97,
		PANEL_VALUE_Y, 16,
		PANEL_SLIDER_WIDTH, 100,
		PANEL_LABEL_STRING, "X Rotation:",
		PANEL_LAYOUT, PANEL_HORIZONTAL,
		PANEL_SHOW_RANGE, TRUE,
		PANEL_SHOW_VALUE, TRUE,
		PANEL_MIN_VALUE, 0,
		PANEL_MAX_VALUE, 360,
		PANEL_NOTIFY_PROC, sliderRotateProc,
		0);
	return obj;
}

/*
 * Create object `pn_y_rotation' in the specified instance.
 */
Xv_opaque
pm_rot_panel_frame_pn_y_rotation_create(ip, owner)
	caddr_t		*ip;
	Xv_opaque	owner;
{
	extern void		sliderRotateProc();
	Xv_opaque	obj;
	
	obj = xv_create(owner, PANEL_SLIDER,
		XV_KEY_DATA, INSTANCE, ip,
		XV_X, 16,
		XV_Y, 48,
		XV_WIDTH, 0,
		XV_HEIGHT, 0,
		PANEL_VALUE_X, 97,
		PANEL_VALUE_Y, 48,
		PANEL_SLIDER_WIDTH, 100,
		PANEL_LABEL_STRING, "Y Rotation:",
		PANEL_LAYOUT, PANEL_HORIZONTAL,
		PANEL_SHOW_RANGE, TRUE,
		PANEL_SHOW_VALUE, TRUE,
		PANEL_MIN_VALUE, 0,
		PANEL_MAX_VALUE, 360,
		PANEL_NOTIFY_PROC, sliderRotateProc,
		0);
	return obj;
}

/*
 * Create object `pn_z_rotation' in the specified instance.
 */
Xv_opaque
pm_rot_panel_frame_pn_z_rotation_create(ip, owner)
	caddr_t		*ip;
	Xv_opaque	owner;
{
	extern void		sliderRotateProc();
	Xv_opaque	obj;
	
	obj = xv_create(owner, PANEL_SLIDER,
		XV_KEY_DATA, INSTANCE, ip,
		XV_X, 16,
		XV_Y, 80,
		XV_WIDTH, 0,
		XV_HEIGHT, 0,
		PANEL_VALUE_X, 96,
		PANEL_VALUE_Y, 80,
		PANEL_SLIDER_WIDTH, 100,
		PANEL_LABEL_STRING, "Z Rotation:",
		PANEL_LAYOUT, PANEL_HORIZONTAL,
		PANEL_SHOW_RANGE, TRUE,
		PANEL_SHOW_VALUE, TRUE,
		PANEL_MIN_VALUE, 0,
		PANEL_MAX_VALUE, 360,
		PANEL_NOTIFY_PROC, sliderRotateProc,
		0);
	return obj;
}

/*
 * Create object `pn_scale' in the specified instance.
 */
Xv_opaque
pm_rot_panel_frame_pn_scale_create(ip, owner)
	caddr_t		*ip;
	Xv_opaque	owner;
{
	extern void		sliderRotateProc();
	Xv_opaque	obj;
	
	obj = xv_create(owner, PANEL_SLIDER,
		XV_KEY_DATA, INSTANCE, ip,
		XV_X, 16,
		XV_Y, 112,
		XV_WIDTH, 0,
		XV_HEIGHT, 0,
		PANEL_VALUE_X, 108,
		PANEL_VALUE_Y, 112,
		PANEL_SLIDER_WIDTH, 100,
		PANEL_LABEL_STRING, "Scale Factor:",
		PANEL_LAYOUT, PANEL_HORIZONTAL,
		PANEL_SHOW_RANGE, TRUE,
		PANEL_SHOW_VALUE, TRUE,
		PANEL_MIN_VALUE, 1,
		PANEL_MAX_VALUE, 20,
		PANEL_NOTIFY_PROC, sliderRotateProc,
		0);
	return obj;
}

/*
 * Create object `pn_auto_rotate_toggle' in the specified instance.
 */
Xv_opaque
pm_rot_panel_frame_pn_auto_rotate_toggle_create(ip, owner)
	caddr_t		*ip;
	Xv_opaque	owner;
{
	extern void		select_auto_rotate();
	Xv_opaque	obj;
	
	obj = xv_create(owner, PANEL_TOGGLE,
		XV_KEY_DATA, INSTANCE, ip,
		XV_X, 16,
		XV_Y, 144,
		XV_WIDTH, 0,
		XV_HEIGHT, 0,
		PANEL_VALUE_X, 105,
		PANEL_VALUE_Y, 144,
		PANEL_LAYOUT, PANEL_HORIZONTAL,
		PANEL_CHOICE_STRINGS,
			"x",
			"y",
			"z",
			"Scale",
			0,
		PANEL_LABEL_STRING, "Auto Rotate:",
		PANEL_NOTIFY_PROC, select_auto_rotate,
		0);
	return obj;
}

/*
 * Initialize an instance of object `prop_panel_frame'.
 */
pm_prop_panel_frame_objects *
pm_prop_panel_frame_objects_initialize(ip, owner)
	pm_prop_panel_frame_objects	*ip;
	Xv_opaque	owner;
{
	if (!ip && !(ip = (pm_prop_panel_frame_objects *) calloc(1, sizeof (pm_prop_panel_frame_objects))))
		return (pm_prop_panel_frame_objects *) NULL;
	if (!ip->prop_panel_frame)
		ip->prop_panel_frame = pm_prop_panel_frame_prop_panel_frame_create(ip, owner);
	if (!ip->prop_panel)
		ip->prop_panel = pm_prop_panel_frame_prop_panel_create(ip, ip->prop_panel_frame);
	if (!ip->ambcoef_item)
		ip->ambcoef_item = pm_prop_panel_frame_ambcoef_item_create(ip, ip->prop_panel);
	if (!ip->diffcoef_item)
		ip->diffcoef_item = pm_prop_panel_frame_diffcoef_item_create(ip, ip->prop_panel);
	if (!ip->speccoef_item)
		ip->speccoef_item = pm_prop_panel_frame_speccoef_item_create(ip, ip->prop_panel);
	if (!ip->specexp_item)
		ip->specexp_item = pm_prop_panel_frame_specexp_item_create(ip, ip->prop_panel);
	if (!ip->transpar_item)
		ip->transpar_item = pm_prop_panel_frame_transpar_item_create(ip, ip->prop_panel);
	if (!ip->msg1)
		ip->msg1 = pm_prop_panel_frame_msg1_create(ip, ip->prop_panel);
	if (!ip->diffcolr_item)
		ip->diffcolr_item = pm_prop_panel_frame_diffcolr_item_create(ip, ip->prop_panel);
	if (!ip->diffcolg_item)
		ip->diffcolg_item = pm_prop_panel_frame_diffcolg_item_create(ip, ip->prop_panel);
	if (!ip->diffcolb_item)
		ip->diffcolb_item = pm_prop_panel_frame_diffcolb_item_create(ip, ip->prop_panel);
	if (!ip->msg2)
		ip->msg2 = pm_prop_panel_frame_msg2_create(ip, ip->prop_panel);
	if (!ip->speccolr_item)
		ip->speccolr_item = pm_prop_panel_frame_speccolr_item_create(ip, ip->prop_panel);
	if (!ip->speccolg_item)
		ip->speccolg_item = pm_prop_panel_frame_speccolg_item_create(ip, ip->prop_panel);
	if (!ip->speccolb_item)
		ip->speccolb_item = pm_prop_panel_frame_speccolb_item_create(ip, ip->prop_panel);
	return ip;
}

/*
 * Create object `prop_panel_frame' in the specified instance.
 */
Xv_opaque
pm_prop_panel_frame_prop_panel_frame_create(ip, owner)
	caddr_t		*ip;
	Xv_opaque	owner;
{
	Xv_opaque	obj;
	
	obj = xv_create(owner, FRAME_CMD,
		XV_KEY_DATA, INSTANCE, ip,
                XV_X, 575, XV_Y, 350,
		XV_WIDTH, 400,
		XV_HEIGHT, 432,
		XV_LABEL, "Pyramid: Surface Properties",
		XV_SHOW, FALSE,
		FRAME_SHOW_FOOTER, FALSE,
		FRAME_SHOW_RESIZE_CORNER, FALSE,
		FRAME_CMD_PUSHPIN_IN, TRUE,
		0);
	xv_set(xv_get(obj, FRAME_CMD_PANEL), WIN_SHOW, FALSE, 0);
	return obj;
}

/*
 * Create object `prop_panel' in the specified instance.
 */
Xv_opaque
pm_prop_panel_frame_prop_panel_create(ip, owner)
	caddr_t		*ip;
	Xv_opaque	owner;
{
	Xv_opaque	obj;
	
	obj = xv_create(owner, PANEL,
		XV_KEY_DATA, INSTANCE, ip,
		XV_X, 0,
		XV_Y, 0,
		XV_WIDTH, WIN_EXTEND_TO_EDGE,
		XV_HEIGHT, WIN_EXTEND_TO_EDGE,
		OPENWIN_SHOW_BORDERS, FALSE,
		0);
	return obj;
}

/*
 * Create object `ambcoef_item' in the specified instance.
 */
Xv_opaque
pm_prop_panel_frame_ambcoef_item_create(ip, owner)
	caddr_t		*ip;
	Xv_opaque	owner;
{
	extern void		set_prop_proc();
	Xv_opaque	obj;
	
	obj = xv_create(owner, PANEL_SLIDER,
		XV_KEY_DATA, INSTANCE, ip,
		XV_X, 14,
		XV_Y, 14,
		XV_WIDTH, 0,
		XV_HEIGHT, 0,
		PANEL_VALUE_X, 166,
		PANEL_VALUE_Y, 14,
		PANEL_SLIDER_WIDTH, 100,
		PANEL_LABEL_STRING, "Ambient Coefficent:",
		PANEL_LAYOUT, PANEL_HORIZONTAL,
		PANEL_SHOW_RANGE, TRUE,
		PANEL_SHOW_VALUE, TRUE,
		PANEL_MIN_VALUE, 0,
		PANEL_MAX_VALUE, 100,
		PANEL_NOTIFY_PROC, set_prop_proc,
		0);
	return obj;
}

/*
 * Create object `diffcoef_item' in the specified instance.
 */
Xv_opaque
pm_prop_panel_frame_diffcoef_item_create(ip, owner)
	caddr_t		*ip;
	Xv_opaque	owner;
{
	extern void		set_prop_proc();
	Xv_opaque	obj;
	
	obj = xv_create(owner, PANEL_SLIDER,
		XV_KEY_DATA, INSTANCE, ip,
		XV_X, 30,
		XV_Y, 46,
		XV_WIDTH, 0,
		XV_HEIGHT, 0,
		PANEL_VALUE_X, 166,
		PANEL_VALUE_Y, 46,
		PANEL_SLIDER_WIDTH, 100,
		PANEL_LABEL_STRING, "Diffuse Coefficient:",
		PANEL_LAYOUT, PANEL_HORIZONTAL,
		PANEL_SHOW_RANGE, TRUE,
		PANEL_SHOW_VALUE, TRUE,
		PANEL_MIN_VALUE, 0,
		PANEL_MAX_VALUE, 100,
		PANEL_NOTIFY_PROC, set_prop_proc,
		0);
	return obj;
}

/*
 * Create object `speccoef_item' in the specified instance.
 */
Xv_opaque
pm_prop_panel_frame_speccoef_item_create(ip, owner)
	caddr_t		*ip;
	Xv_opaque	owner;
{
	extern void		set_prop_proc();
	Xv_opaque	obj;
	
	obj = xv_create(owner, PANEL_SLIDER,
		XV_KEY_DATA, INSTANCE, ip,
		XV_X, 14,
		XV_Y, 78,
		XV_WIDTH, 0,
		XV_HEIGHT, 0,
		PANEL_VALUE_X, 165,
		PANEL_VALUE_Y, 78,
		PANEL_SLIDER_WIDTH, 100,
		PANEL_LABEL_STRING, "Specular Coefficient:",
		PANEL_LAYOUT, PANEL_HORIZONTAL,
		PANEL_SHOW_RANGE, TRUE,
		PANEL_SHOW_VALUE, TRUE,
		PANEL_MIN_VALUE, 0,
		PANEL_MAX_VALUE, 100,
		PANEL_NOTIFY_PROC, set_prop_proc,
		0);
	return obj;
}

/*
 * Create object `specexp_item' in the specified instance.
 */
Xv_opaque
pm_prop_panel_frame_specexp_item_create(ip, owner)
	caddr_t		*ip;
	Xv_opaque	owner;
{
	extern void		set_prop_proc();
	Xv_opaque	obj;
	
	obj = xv_create(owner, PANEL_SLIDER,
		XV_KEY_DATA, INSTANCE, ip,
		XV_X, 30,
		XV_Y, 110,
		XV_WIDTH, 0,
		XV_HEIGHT, 0,
		PANEL_VALUE_X, 166,
		PANEL_VALUE_Y, 110,
		PANEL_SLIDER_WIDTH, 100,
		PANEL_LABEL_STRING, "Specular Exponent:",
		PANEL_LAYOUT, PANEL_HORIZONTAL,
		PANEL_SHOW_RANGE, TRUE,
		PANEL_SHOW_VALUE, TRUE,
		PANEL_MIN_VALUE, 0,
		PANEL_MAX_VALUE, 100,
		PANEL_NOTIFY_PROC, set_prop_proc,
		0);
	return obj;
}

/*
 * Create object `transpar_item' in the specified instance.
 */
Xv_opaque
pm_prop_panel_frame_transpar_item_create(ip, owner)
	caddr_t		*ip;
	Xv_opaque	owner;
{
	Xv_opaque	obj;
	
	obj = xv_create(owner, PANEL_SLIDER,
		XV_KEY_DATA, INSTANCE, ip,
		XV_X, 62,
		XV_Y, 142,
		XV_WIDTH, 0,
		XV_HEIGHT, 0,
		PANEL_VALUE_X, 166,
		PANEL_VALUE_Y, 142,
		PANEL_SLIDER_WIDTH, 100,
		PANEL_LABEL_STRING, "Transparency:",
		PANEL_LAYOUT, PANEL_HORIZONTAL,
		PANEL_SHOW_RANGE, TRUE,
		PANEL_SHOW_VALUE, TRUE,
		PANEL_MIN_VALUE, 0,
		PANEL_MAX_VALUE, 100,
		0);
	return obj;
}

/*
 * Create object `msg1' in the specified instance.
 */
Xv_opaque
pm_prop_panel_frame_msg1_create(ip, owner)
	caddr_t		*ip;
	Xv_opaque	owner;
{
	Xv_opaque	obj;
	
	obj = xv_create(owner, PANEL_MESSAGE,
		XV_KEY_DATA, INSTANCE, ip,
		XV_X, 16,
		XV_Y, 173,
		XV_WIDTH, 0,
		XV_HEIGHT, 0,
		PANEL_LABEL_STRING, "Diffuse Color:",
		PANEL_LABEL_BOLD, TRUE,
		0);
	return obj;
}

/*
 * Create object `diffcolr_item' in the specified instance.
 */
Xv_opaque
pm_prop_panel_frame_diffcolr_item_create(ip, owner)
	caddr_t		*ip;
	Xv_opaque	owner;
{
	extern void		set_prop_proc();
	Xv_opaque	obj;
	
	obj = xv_create(owner, PANEL_SLIDER,
		XV_KEY_DATA, INSTANCE, ip,
		XV_X, 78,
		XV_Y, 206,
		XV_WIDTH, 0,
		XV_HEIGHT, 0,
		PANEL_VALUE_X, 115,
		PANEL_VALUE_Y, 206,
		PANEL_SLIDER_WIDTH, 100,
		PANEL_LABEL_STRING, "Red:",
		PANEL_LAYOUT, PANEL_HORIZONTAL,
		PANEL_SHOW_RANGE, TRUE,
		PANEL_SHOW_VALUE, TRUE,
		PANEL_MIN_VALUE, 0,
		PANEL_MAX_VALUE, 100,
		PANEL_NOTIFY_PROC, set_prop_proc,
		0);
	return obj;
}

/*
 * Create object `diffcolg_item' in the specified instance.
 */
Xv_opaque
pm_prop_panel_frame_diffcolg_item_create(ip, owner)
	caddr_t		*ip;
	Xv_opaque	owner;
{
	extern void		set_prop_proc();
	Xv_opaque	obj;
	
	obj = xv_create(owner, PANEL_SLIDER,
		XV_KEY_DATA, INSTANCE, ip,
		XV_X, 62,
		XV_Y, 238,
		XV_WIDTH, 0,
		XV_HEIGHT, 0,
		PANEL_VALUE_X, 115,
		PANEL_VALUE_Y, 238,
		PANEL_SLIDER_WIDTH, 100,
		PANEL_LABEL_STRING, "Green:",
		PANEL_LAYOUT, PANEL_HORIZONTAL,
		PANEL_SHOW_RANGE, TRUE,
		PANEL_SHOW_VALUE, TRUE,
		PANEL_MIN_VALUE, 0,
		PANEL_MAX_VALUE, 100,
		PANEL_NOTIFY_PROC, set_prop_proc,
		0);
	return obj;
}

/*
 * Create object `diffcolb_item' in the specified instance.
 */
Xv_opaque
pm_prop_panel_frame_diffcolb_item_create(ip, owner)
	caddr_t		*ip;
	Xv_opaque	owner;
{
	extern void		set_prop_proc();
	Xv_opaque	obj;
	
	obj = xv_create(owner, PANEL_SLIDER,
		XV_KEY_DATA, INSTANCE, ip,
		XV_X, 78,
		XV_Y, 270,
		XV_WIDTH, 0,
		XV_HEIGHT, 0,
		PANEL_VALUE_X, 120,
		PANEL_VALUE_Y, 270,
		PANEL_SLIDER_WIDTH, 100,
		PANEL_LABEL_STRING, "Blue:",
		PANEL_LAYOUT, PANEL_HORIZONTAL,
		PANEL_SHOW_RANGE, TRUE,
		PANEL_SHOW_VALUE, TRUE,
		PANEL_MIN_VALUE, 0,
		PANEL_MAX_VALUE, 100,
		PANEL_NOTIFY_PROC, set_prop_proc,
		0);
	return obj;
}

/*
 * Create object `msg2' in the specified instance.
 */
Xv_opaque
pm_prop_panel_frame_msg2_create(ip, owner)
	caddr_t		*ip;
	Xv_opaque	owner;
{
	Xv_opaque	obj;
	
	obj = xv_create(owner, PANEL_MESSAGE,
		XV_KEY_DATA, INSTANCE, ip,
		XV_X, 16,
		XV_Y, 301,
		XV_WIDTH, 0,
		XV_HEIGHT, 0,
		PANEL_LABEL_STRING, "Specular Color:",
		PANEL_LABEL_BOLD, TRUE,
		0);
	return obj;
}

/*
 * Create object `speccolr_item' in the specified instance.
 */
Xv_opaque
pm_prop_panel_frame_speccolr_item_create(ip, owner)
	caddr_t		*ip;
	Xv_opaque	owner;
{
	extern void		set_prop_proc();
	Xv_opaque	obj;
	
	obj = xv_create(owner, PANEL_SLIDER,
		XV_KEY_DATA, INSTANCE, ip,
		XV_X, 78,
		XV_Y, 334,
		XV_WIDTH, 0,
		XV_HEIGHT, 0,
		PANEL_VALUE_X, 115,
		PANEL_VALUE_Y, 334,
		PANEL_SLIDER_WIDTH, 100,
		PANEL_LABEL_STRING, "Red:",
		PANEL_LAYOUT, PANEL_HORIZONTAL,
		PANEL_SHOW_RANGE, TRUE,
		PANEL_SHOW_VALUE, TRUE,
		PANEL_MIN_VALUE, 0,
		PANEL_MAX_VALUE, 100,
		PANEL_NOTIFY_PROC, set_prop_proc,
		0);
	return obj;
}

/*
 * Create object `speccolg_item' in the specified instance.
 */
Xv_opaque
pm_prop_panel_frame_speccolg_item_create(ip, owner)
	caddr_t		*ip;
	Xv_opaque	owner;
{
	extern void		set_prop_proc();
	Xv_opaque	obj;
	
	obj = xv_create(owner, PANEL_SLIDER,
		XV_KEY_DATA, INSTANCE, ip,
		XV_X, 62,
		XV_Y, 366,
		XV_WIDTH, 0,
		XV_HEIGHT, 0,
		PANEL_VALUE_X, 115,
		PANEL_VALUE_Y, 366,
		PANEL_SLIDER_WIDTH, 100,
		PANEL_LABEL_STRING, "Green:",
		PANEL_LAYOUT, PANEL_HORIZONTAL,
		PANEL_SHOW_RANGE, TRUE,
		PANEL_SHOW_VALUE, TRUE,
		PANEL_MIN_VALUE, 0,
		PANEL_MAX_VALUE, 100,
		PANEL_NOTIFY_PROC, set_prop_proc,
		0);
	return obj;
}

/*
 * Create object `speccolb_item' in the specified instance.
 */
Xv_opaque
pm_prop_panel_frame_speccolb_item_create(ip, owner)
	caddr_t		*ip;
	Xv_opaque	owner;
{
	extern void		set_prop_proc();
	Xv_opaque	obj;
	
	obj = xv_create(owner, PANEL_SLIDER,
		XV_KEY_DATA, INSTANCE, ip,
		XV_X, 78,
		XV_Y, 398,
		XV_WIDTH, 0,
		XV_HEIGHT, 0,
		PANEL_VALUE_X, 115,
		PANEL_VALUE_Y, 398,
		PANEL_SLIDER_WIDTH, 100,
		PANEL_LABEL_STRING, "Blue:",
		PANEL_LAYOUT, PANEL_HORIZONTAL,
		PANEL_SHOW_RANGE, TRUE,
		PANEL_SHOW_VALUE, TRUE,
		PANEL_MIN_VALUE, 0,
		PANEL_MAX_VALUE, 100,
		PANEL_NOTIFY_PROC, set_prop_proc,
		0);
	return obj;
}

/*
 * Initialize an instance of object `light_panel_frame'.
 */
pm_light_panel_frame_objects *
pm_light_panel_frame_objects_initialize(ip, owner)
	pm_light_panel_frame_objects	*ip;
	Xv_opaque	owner;
{
	if (!ip && !(ip = (pm_light_panel_frame_objects *) calloc(1, sizeof (pm_light_panel_frame_objects))))
		return (pm_light_panel_frame_objects *) NULL;
	if (!ip->light_panel_frame)
		ip->light_panel_frame = pm_light_panel_frame_light_panel_frame_create(ip, owner);
	if (!ip->light_panel)
		ip->light_panel = pm_light_panel_frame_light_panel_create(ip, ip->light_panel_frame);
	if (!ip->lnum_item)
		ip->lnum_item = pm_light_panel_frame_lnum_item_create(ip, ip->light_panel);
	if (!ip->lonoff_item)
		ip->lonoff_item = pm_light_panel_frame_lonoff_item_create(ip, ip->light_panel);
	if (!ip->ltype_item)
		ip->ltype_item = pm_light_panel_frame_ltype_item_create(ip, ip->light_panel);
	if (!ip->message4)
		ip->message4 = pm_light_panel_frame_message4_create(ip, ip->light_panel);
	if (!ip->lcolr_item)
		ip->lcolr_item = pm_light_panel_frame_lcolr_item_create(ip, ip->light_panel);
	if (!ip->lcolg_item)
		ip->lcolg_item = pm_light_panel_frame_lcolg_item_create(ip, ip->light_panel);
	if (!ip->lcolb_item)
		ip->lcolb_item = pm_light_panel_frame_lcolb_item_create(ip, ip->light_panel);
	if (!ip->ldir_item)
		ip->ldir_item = pm_light_panel_frame_ldir_item_create(ip, ip->light_panel);
	if (!ip->ldirx_item)
		ip->ldirx_item = pm_light_panel_frame_ldirx_item_create(ip, ip->light_panel);
	if (!ip->ldiry_item)
		ip->ldiry_item = pm_light_panel_frame_ldiry_item_create(ip, ip->light_panel);
	if (!ip->ldirz_item)
		ip->ldirz_item = pm_light_panel_frame_ldirz_item_create(ip, ip->light_panel);
	if (!ip->lpos_item)
		ip->lpos_item = pm_light_panel_frame_lpos_item_create(ip, ip->light_panel);
	if (!ip->latten_item)
		ip->latten_item = pm_light_panel_frame_latten_item_create(ip, ip->light_panel);
	if (!ip->lexp_item)
		ip->lexp_item = pm_light_panel_frame_lexp_item_create(ip, ip->light_panel);
	if (!ip->lspread_item)
		ip->lspread_item = pm_light_panel_frame_lspread_item_create(ip, ip->light_panel);
	if (!ip->labutton)
		ip->labutton = pm_light_panel_frame_labutton_create(ip, ip->light_panel);
	if (!ip->lrbutton)
		ip->lrbutton = pm_light_panel_frame_lrbutton_create(ip, ip->light_panel);
	return ip;
}

/*
 * Create object `light_panel_frame' in the specified instance.
 */
Xv_opaque
pm_light_panel_frame_light_panel_frame_create(ip, owner)
	caddr_t		*ip;
	Xv_opaque	owner;
{
	Xv_opaque	obj;
	
	obj = xv_create(owner, FRAME_CMD,
		XV_KEY_DATA, INSTANCE, ip,
                XV_X, 575, XV_Y, 350,
		XV_WIDTH, 436,
		XV_HEIGHT, 488,
		XV_LABEL, "Pyramid: Lighting",
		XV_SHOW, FALSE,
		FRAME_SHOW_FOOTER, FALSE,
		FRAME_SHOW_RESIZE_CORNER, FALSE,
		FRAME_CMD_PUSHPIN_IN, FALSE,
		0);
	xv_set(xv_get(obj, FRAME_CMD_PANEL), WIN_SHOW, FALSE, 0);
	return obj;
}

/*
 * Create object `light_panel' in the specified instance.
 */
Xv_opaque
pm_light_panel_frame_light_panel_create(ip, owner)
	caddr_t		*ip;
	Xv_opaque	owner;
{
	Xv_opaque	obj;
	
	obj = xv_create(owner, PANEL,
		XV_KEY_DATA, INSTANCE, ip,
		XV_X, 0,
		XV_Y, 0,
		XV_WIDTH, WIN_EXTEND_TO_EDGE,
		XV_HEIGHT, WIN_EXTEND_TO_EDGE,
		OPENWIN_SHOW_BORDERS, FALSE,
		0);
	return obj;
}

/*
 * Create object `lnum_item' in the specified instance.
 */
Xv_opaque
pm_light_panel_frame_lnum_item_create(ip, owner)
	caddr_t		*ip;
	Xv_opaque	owner;
{
	extern void		light_num_proc();
	Xv_opaque	obj;
	
	obj = xv_create(owner, PANEL_CHOICE, PANEL_DISPLAY_LEVEL, PANEL_CURRENT,
		XV_KEY_DATA, INSTANCE, ip,
		XV_X, 16,
		XV_Y, 16,
		XV_WIDTH, 0,
		XV_HEIGHT, 0,
		PANEL_VALUE_X, 91,
		PANEL_VALUE_Y, 16,
		PANEL_LAYOUT, PANEL_HORIZONTAL,
		PANEL_CHOICE_STRINGS,
			"0",
			"1",
			"2",
			"3",
			"4",
			"5",
			0,
		PANEL_LABEL_STRING, "Light No. :",
		PANEL_NOTIFY_PROC, light_num_proc,
		0);
	return obj;
}

/*
 * Create object `lonoff_item' in the specified instance.
 */
Xv_opaque
pm_light_panel_frame_lonoff_item_create(ip, owner)
	caddr_t		*ip;
	Xv_opaque	owner;
{
	extern void		light_onoff_proc();
	Xv_opaque	obj;
	
	obj = xv_create(owner, PANEL_CHOICE,
		XV_KEY_DATA, INSTANCE, ip,
		XV_X, 144,
		XV_Y, 16,
		XV_WIDTH, 0,
		XV_HEIGHT, 0,
		PANEL_VALUE_X, 144,
		PANEL_VALUE_Y, 16,
		PANEL_LAYOUT, PANEL_HORIZONTAL,
		PANEL_CHOICE_STRINGS,
			"Off",
			"On",
			0,
		PANEL_NOTIFY_PROC, light_onoff_proc,
		0);
	return obj;
}

/*
 * Create object `ltype_item' in the specified instance.
 */
Xv_opaque
pm_light_panel_frame_ltype_item_create(ip, owner)
	caddr_t		*ip;
	Xv_opaque	owner;
{
	extern void		light_type_proc();
	Xv_opaque	obj;
	
	obj = xv_create(owner, PANEL_CHOICE, PANEL_DISPLAY_LEVEL, PANEL_CURRENT,
		XV_KEY_DATA, INSTANCE, ip,
		XV_X, 240,
		XV_Y, 16,
		XV_WIDTH, 0,
		XV_HEIGHT, 0,
		PANEL_VALUE_X, 324,
		PANEL_VALUE_Y, 16,
		PANEL_LAYOUT, PANEL_HORIZONTAL,
		PANEL_CHOICE_STRINGS,
			"Ambient",
			"Directional",
			"Positional",
			"Spot",
			0,
		PANEL_LABEL_STRING, "Light Type:",
		PANEL_NOTIFY_PROC, light_type_proc,
		0);
	return obj;
}

/*
 * Create object `message4' in the specified instance.
 */
Xv_opaque
pm_light_panel_frame_message4_create(ip, owner)
	caddr_t		*ip;
	Xv_opaque	owner;
{
	Xv_opaque	obj;
	
	obj = xv_create(owner, PANEL_MESSAGE,
		XV_KEY_DATA, INSTANCE, ip,
		XV_X, 16,
		XV_Y, 48,
		XV_WIDTH, 0,
		XV_HEIGHT, 0,
		PANEL_LABEL_STRING, "Color:",
		PANEL_LABEL_BOLD, TRUE,
		0);
	return obj;
}

/*
 * Create object `lcolr_item' in the specified instance.
 */
Xv_opaque
pm_light_panel_frame_lcolr_item_create(ip, owner)
	caddr_t		*ip;
	Xv_opaque	owner;
{
	extern void		set_light_proc();
	Xv_opaque	obj;
	
	obj = xv_create(owner, PANEL_SLIDER,
		XV_KEY_DATA, INSTANCE, ip,
		XV_X, 48,
		XV_Y, 80,
		XV_WIDTH, 0,
		XV_HEIGHT, 0,
		PANEL_VALUE_X, 91,
		PANEL_VALUE_Y, 80,
		PANEL_SLIDER_WIDTH, 100,
		PANEL_LABEL_STRING, "Red:",
		PANEL_LAYOUT, PANEL_HORIZONTAL,
		PANEL_SHOW_RANGE, TRUE,
		PANEL_SHOW_VALUE, TRUE,
		PANEL_MIN_VALUE, 0,
		PANEL_MAX_VALUE, 100,
		PANEL_NOTIFY_PROC, set_light_proc,
		0);
	return obj;
}

/*
 * Create object `lcolg_item' in the specified instance.
 */
Xv_opaque
pm_light_panel_frame_lcolg_item_create(ip, owner)
	caddr_t		*ip;
	Xv_opaque	owner;
{
	extern void		set_light_proc();
	Xv_opaque	obj;
	
	obj = xv_create(owner, PANEL_SLIDER,
		XV_KEY_DATA, INSTANCE, ip,
		XV_X, 48,
		XV_Y, 112,
		XV_WIDTH, 0,
		XV_HEIGHT, 0,
		PANEL_VALUE_X, 91,
		PANEL_VALUE_Y, 112,
		PANEL_SLIDER_WIDTH, 100,
		PANEL_LABEL_STRING, "Green:",
		PANEL_LAYOUT, PANEL_HORIZONTAL,
		PANEL_SHOW_RANGE, TRUE,
		PANEL_SHOW_VALUE, TRUE,
		PANEL_MIN_VALUE, 0,
		PANEL_MAX_VALUE, 100,
		PANEL_NOTIFY_PROC, set_light_proc,
		0);
	return obj;
}

/*
 * Create object `lcolb_item' in the specified instance.
 */
Xv_opaque
pm_light_panel_frame_lcolb_item_create(ip, owner)
	caddr_t		*ip;
	Xv_opaque	owner;
{
	extern void		set_light_proc();
	Xv_opaque	obj;
	
	obj = xv_create(owner, PANEL_SLIDER,
		XV_KEY_DATA, INSTANCE, ip,
		XV_X, 48,
		XV_Y, 144,
		XV_WIDTH, 0,
		XV_HEIGHT, 0,
		PANEL_VALUE_X, 91,
		PANEL_VALUE_Y, 144,
		PANEL_SLIDER_WIDTH, 100,
		PANEL_LABEL_STRING, "Blue:",
		PANEL_LAYOUT, PANEL_HORIZONTAL,
		PANEL_SHOW_RANGE, TRUE,
		PANEL_SHOW_VALUE, TRUE,
		PANEL_MIN_VALUE, 0,
		PANEL_MAX_VALUE, 100,
		PANEL_NOTIFY_PROC, set_light_proc,
		0);
	return obj;
}

/*
 * Create object `ldir_item' in the specified instance.
 */
Xv_opaque
pm_light_panel_frame_ldir_item_create(ip, owner)
	caddr_t		*ip;
	Xv_opaque	owner;
{
	Xv_opaque	obj;
	
	obj = xv_create(owner, PANEL_MESSAGE,
		XV_KEY_DATA, INSTANCE, ip,
		XV_X, 16,
		XV_Y, 176,
		XV_WIDTH, 0,
		XV_HEIGHT, 0,
		PANEL_LABEL_STRING, "Direction:",
		PANEL_LABEL_BOLD, TRUE,
		0);
	return obj;
}

/*
 * Create object `ldirx_item' in the specified instance.
 */
Xv_opaque
pm_light_panel_frame_ldirx_item_create(ip, owner)
	caddr_t		*ip;
	Xv_opaque	owner;
{
	extern void		set_light_proc();
	Xv_opaque	obj;
	
	obj = xv_create(owner, PANEL_SLIDER,
		XV_KEY_DATA, INSTANCE, ip,
		XV_X, 48,
		XV_Y, 208,
		XV_WIDTH, 0,
		XV_HEIGHT, 0,
		PANEL_VALUE_X, 68,
		PANEL_VALUE_Y, 208,
		PANEL_SLIDER_WIDTH, 100,
		PANEL_LABEL_STRING, "X:",
		PANEL_LAYOUT, PANEL_HORIZONTAL,
		PANEL_SHOW_RANGE, TRUE,
		PANEL_SHOW_VALUE, TRUE,
		PANEL_MIN_VALUE, -10,
		PANEL_MAX_VALUE, 10,
		PANEL_NOTIFY_PROC, set_light_proc,
		0);
	return obj;
}

/*
 * Create object `ldiry_item' in the specified instance.
 */
Xv_opaque
pm_light_panel_frame_ldiry_item_create(ip, owner)
	caddr_t		*ip;
	Xv_opaque	owner;
{
	extern void		set_light_proc();
	Xv_opaque	obj;
	
	obj = xv_create(owner, PANEL_SLIDER,
		XV_KEY_DATA, INSTANCE, ip,
		XV_X, 48,
		XV_Y, 240,
		XV_WIDTH, 0,
		XV_HEIGHT, 0,
		PANEL_VALUE_X, 68,
		PANEL_VALUE_Y, 240,
		PANEL_SLIDER_WIDTH, 100,
		PANEL_LABEL_STRING, "Y:",
		PANEL_LAYOUT, PANEL_HORIZONTAL,
		PANEL_SHOW_RANGE, TRUE,
		PANEL_SHOW_VALUE, TRUE,
		PANEL_MIN_VALUE, -10,
		PANEL_MAX_VALUE, 10,
		PANEL_NOTIFY_PROC, set_light_proc,
		0);
	return obj;
}

/*
 * Create object `ldirz_item' in the specified instance.
 */
Xv_opaque
pm_light_panel_frame_ldirz_item_create(ip, owner)
	caddr_t		*ip;
	Xv_opaque	owner;
{
	extern void		set_light_proc();
	Xv_opaque	obj;
	
	obj = xv_create(owner, PANEL_SLIDER,
		XV_KEY_DATA, INSTANCE, ip,
		XV_X, 48,
		XV_Y, 272,
		XV_WIDTH, 0,
		XV_HEIGHT, 0,
		PANEL_VALUE_X, 67,
		PANEL_VALUE_Y, 272,
		PANEL_SLIDER_WIDTH, 100,
		PANEL_LABEL_STRING, "Z:",
		PANEL_LAYOUT, PANEL_HORIZONTAL,
		PANEL_SHOW_RANGE, TRUE,
		PANEL_SHOW_VALUE, TRUE,
		PANEL_MIN_VALUE, -10,
		PANEL_MAX_VALUE, 10,
		PANEL_NOTIFY_PROC, set_light_proc,
		0);
	return obj;
}

/*
 * Create object `lpos_item' in the specified instance.
 */
Xv_opaque
pm_light_panel_frame_lpos_item_create(ip, owner)
	caddr_t		*ip;
	Xv_opaque	owner;
{
	extern void	set_light_proc();
	Xv_opaque	obj;
	
	obj = xv_create(owner, PANEL_TEXT,
		XV_KEY_DATA, INSTANCE, ip,
		XV_X, 16,
		XV_Y, 320,
		XV_WIDTH, 0,
		XV_HEIGHT, 0,
		PANEL_LABEL_STRING, "Position:",
		PANEL_VALUE_X, 83,
		PANEL_VALUE_Y, 320,
		PANEL_LAYOUT, PANEL_HORIZONTAL,
		PANEL_VALUE_DISPLAY_LENGTH, 8,
		PANEL_MAX_VALUE, 0,
		PANEL_MIN_VALUE, 0,
		PANEL_READ_ONLY, FALSE,
		PANEL_NOTIFY_PROC, set_light_proc,
		0);
	return obj;
}

/*
 * Create object `latten_item' in the specified instance.
 */
Xv_opaque
pm_light_panel_frame_latten_item_create(ip, owner)
	caddr_t		*ip;
	Xv_opaque	owner;
{
	extern void	set_light_proc();
	Xv_opaque	obj;
	
	obj = xv_create(owner, PANEL_TEXT,
		XV_KEY_DATA, INSTANCE, ip,
		XV_X, 16,
		XV_Y, 352,
		XV_WIDTH, 0,
		XV_HEIGHT, 0,
		PANEL_LABEL_STRING, "Attenuation Coefficients:",
		PANEL_VALUE_X, 195,
		PANEL_VALUE_Y, 352,
		PANEL_LAYOUT, PANEL_HORIZONTAL,
		PANEL_VALUE_DISPLAY_LENGTH, 8,
		PANEL_MAX_VALUE, 0,
		PANEL_MIN_VALUE, 0,
		PANEL_READ_ONLY, FALSE,
		PANEL_NOTIFY_PROC, set_light_proc,
		0);
	return obj;
}

/*
 * Create object `lexp_item' in the specified instance.
 */
Xv_opaque
pm_light_panel_frame_lexp_item_create(ip, owner)
	caddr_t		*ip;
	Xv_opaque	owner;
{
	extern void	set_light_proc();
	Xv_opaque	obj;
	
	obj = xv_create(owner, PANEL_TEXT,
		XV_KEY_DATA, INSTANCE, ip,
		XV_X, 16,
		XV_Y, 384,
		XV_WIDTH, 0,
		XV_HEIGHT, 0,
		PANEL_LABEL_STRING, "Concentration Exponent:",
		PANEL_VALUE_X, 190,
		PANEL_VALUE_Y, 384,
		PANEL_LAYOUT, PANEL_HORIZONTAL,
		PANEL_VALUE_DISPLAY_LENGTH, 8,
		PANEL_MAX_VALUE, 0,
		PANEL_MIN_VALUE, 0,
		PANEL_READ_ONLY, FALSE,
		PANEL_NOTIFY_PROC, set_light_proc,
		0);
	return obj;
}

/*
 * Create object `lspread_item' in the specified instance.
 */
Xv_opaque
pm_light_panel_frame_lspread_item_create(ip, owner)
	caddr_t		*ip;
	Xv_opaque	owner;
{
	extern void	set_light_proc();
	Xv_opaque	obj;
	
	obj = xv_create(owner, PANEL_TEXT,
		XV_KEY_DATA, INSTANCE, ip,
		XV_X, 16,
		XV_Y, 416,
		XV_WIDTH, 0,
		XV_HEIGHT, 0,
		PANEL_LABEL_STRING, "Spread Angle:",
		PANEL_VALUE_X, 117,
		PANEL_VALUE_Y, 416,
		PANEL_LAYOUT, PANEL_HORIZONTAL,
		PANEL_VALUE_DISPLAY_LENGTH, 8,
		PANEL_MAX_VALUE, 0,
		PANEL_MIN_VALUE, 0,
		PANEL_READ_ONLY, FALSE,
		PANEL_NOTIFY_PROC, set_light_proc,
		0);
	return obj;
}

/*
 * Create object `labutton' in the specified instance.
 */
Xv_opaque
pm_light_panel_frame_labutton_create(ip, owner)
	caddr_t		*ip;
	Xv_opaque	owner;
{
	extern void		make_lights_effective();
	Xv_opaque	obj;
	
	obj = xv_create(owner, PANEL_BUTTON,
		XV_KEY_DATA, INSTANCE, ip,
		XV_X, 160,
		XV_Y, 448,
		XV_WIDTH, 0,
		XV_HEIGHT, 0,
		PANEL_LABEL_STRING, "Apply",
		PANEL_NOTIFY_PROC, make_lights_effective,
		0);
	return obj;
}

/*
 * Create object `lrbutton' in the specified instance.
 */
Xv_opaque
pm_light_panel_frame_lrbutton_create(ip, owner)
	caddr_t		*ip;
	Xv_opaque	owner;
{
	extern void		rs_light_panel();
	Xv_opaque	obj;
	
	obj = xv_create(owner, PANEL_BUTTON,
		XV_KEY_DATA, INSTANCE, ip,
		XV_X, 224,
		XV_Y, 448,
		XV_WIDTH, 0,
		XV_HEIGHT, 0,
		PANEL_LABEL_STRING, "Reset",
		PANEL_NOTIFY_PROC, rs_light_panel,
		0);
	return obj;
}

/*
 * Initialize an instance of object `orient_panel_frame'.
 */
pm_orient_panel_frame_objects *
pm_orient_panel_frame_objects_initialize(ip, owner)
	pm_orient_panel_frame_objects	*ip;
	Xv_opaque	owner;
{
	if (!ip && !(ip = (pm_orient_panel_frame_objects *) calloc(1, sizeof (pm_orient_panel_frame_objects))))
		return (pm_orient_panel_frame_objects *) NULL;
	if (!ip->orient_panel_frame)
		ip->orient_panel_frame = pm_orient_panel_frame_orient_panel_frame_create(ip, owner);
	if (!ip->vieworient_panel)
		ip->vieworient_panel = pm_orient_panel_frame_vieworient_panel_create(ip, ip->orient_panel_frame);
	if (!ip->message1)
		ip->message1 = pm_orient_panel_frame_message1_create(ip, ip->vieworient_panel);
	if (!ip->pn_vpn_x)
		ip->pn_vpn_x = pm_orient_panel_frame_pn_vpn_x_create(ip, ip->vieworient_panel);
	if (!ip->pn_vpn_y)
		ip->pn_vpn_y = pm_orient_panel_frame_pn_vpn_y_create(ip, ip->vieworient_panel);
	if (!ip->pn_vpn_z)
		ip->pn_vpn_z = pm_orient_panel_frame_pn_vpn_z_create(ip, ip->vieworient_panel);
	if (!ip->message2)
		ip->message2 = pm_orient_panel_frame_message2_create(ip, ip->vieworient_panel);
	if (!ip->pn_vup_x)
		ip->pn_vup_x = pm_orient_panel_frame_pn_vup_x_create(ip, ip->vieworient_panel);
	if (!ip->pn_vup_y)
		ip->pn_vup_y = pm_orient_panel_frame_pn_vup_y_create(ip, ip->vieworient_panel);
	if (!ip->pn_vup_z)
		ip->pn_vup_z = pm_orient_panel_frame_pn_vup_z_create(ip, ip->vieworient_panel);
	if (!ip->message3)
		ip->message3 = pm_orient_panel_frame_message3_create(ip, ip->vieworient_panel);
	if (!ip->pn_vrp_x)
		ip->pn_vrp_x = pm_orient_panel_frame_pn_vrp_x_create(ip, ip->vieworient_panel);
	if (!ip->pn_vrp_y)
		ip->pn_vrp_y = pm_orient_panel_frame_pn_vrp_y_create(ip, ip->vieworient_panel);
	if (!ip->pn_vrp_z)
		ip->pn_vrp_z = pm_orient_panel_frame_pn_vrp_z_create(ip, ip->vieworient_panel);
	return ip;
}

/*
 * Create object `orient_panel_frame' in the specified instance.
 */
Xv_opaque
pm_orient_panel_frame_orient_panel_frame_create(ip, owner)
	caddr_t		*ip;
	Xv_opaque	owner;
{
	Xv_opaque	obj;
	
	obj = xv_create(owner, FRAME_CMD,
		XV_KEY_DATA, INSTANCE, ip,
                XV_X, 575, XV_Y, 350,
		XV_WIDTH, 348,
		XV_HEIGHT, 404,
		XV_LABEL, "Pyramid: View Orientation",
		XV_SHOW, FALSE,
		FRAME_SHOW_FOOTER, FALSE,
		FRAME_SHOW_RESIZE_CORNER, FALSE,
		FRAME_CMD_PUSHPIN_IN, TRUE,
		0);
	xv_set(xv_get(obj, FRAME_CMD_PANEL), WIN_SHOW, FALSE, 0);
	return obj;
}

/*
 * Create object `vieworient_panel' in the specified instance.
 */
Xv_opaque
pm_orient_panel_frame_vieworient_panel_create(ip, owner)
	caddr_t		*ip;
	Xv_opaque	owner;
{
	Xv_opaque	obj;
	
	obj = xv_create(owner, PANEL,
		XV_KEY_DATA, INSTANCE, ip,
		XV_X, 0,
		XV_Y, 0,
		XV_WIDTH, WIN_EXTEND_TO_EDGE,
		XV_HEIGHT, WIN_EXTEND_TO_EDGE,
		OPENWIN_SHOW_BORDERS, FALSE,
		0);
	return obj;
}

/*
 * Create object `message1' in the specified instance.
 */
Xv_opaque
pm_orient_panel_frame_message1_create(ip, owner)
	caddr_t		*ip;
	Xv_opaque	owner;
{
	Xv_opaque	obj;
	
	obj = xv_create(owner, PANEL_MESSAGE,
		XV_KEY_DATA, INSTANCE, ip,
		XV_X, 16,
		XV_Y, 16,
		XV_WIDTH, 0,
		XV_HEIGHT, 0,
		PANEL_LABEL_STRING, "View Plane Normal:",
		PANEL_LABEL_BOLD, TRUE,
		0);
	return obj;
}

/*
 * Create object `pn_vpn_x' in the specified instance.
 */
Xv_opaque
pm_orient_panel_frame_pn_vpn_x_create(ip, owner)
	caddr_t		*ip;
	Xv_opaque	owner;
{
	extern void		sliderVPNProc();
	Xv_opaque	obj;
	
	obj = xv_create(owner, PANEL_SLIDER,
		XV_KEY_DATA, INSTANCE, ip,
		XV_X, 16,
		XV_Y, 48,
		XV_WIDTH, 0,
		XV_HEIGHT, 0,
		PANEL_VALUE_X, 101,
		PANEL_VALUE_Y, 48,
		PANEL_SLIDER_WIDTH, 100,
		PANEL_LABEL_STRING, "vpn.x * 100:",
		PANEL_LAYOUT, PANEL_HORIZONTAL,
		PANEL_SHOW_RANGE, TRUE,
		PANEL_SHOW_VALUE, TRUE,
		PANEL_MIN_VALUE, 0,
		PANEL_MAX_VALUE, 100,
		PANEL_NOTIFY_PROC, sliderVPNProc,
		0);
	return obj;
}

/*
 * Create object `pn_vpn_y' in the specified instance.
 */
Xv_opaque
pm_orient_panel_frame_pn_vpn_y_create(ip, owner)
	caddr_t		*ip;
	Xv_opaque	owner;
{
	extern void		sliderVPNProc();
	Xv_opaque	obj;
	
	obj = xv_create(owner, PANEL_SLIDER,
		XV_KEY_DATA, INSTANCE, ip,
		XV_X, 16,
		XV_Y, 80,
		XV_WIDTH, 0,
		XV_HEIGHT, 0,
		PANEL_VALUE_X, 102,
		PANEL_VALUE_Y, 80,
		PANEL_SLIDER_WIDTH, 100,
		PANEL_LABEL_STRING, "vpn.y * 100:",
		PANEL_LAYOUT, PANEL_HORIZONTAL,
		PANEL_SHOW_RANGE, TRUE,
		PANEL_SHOW_VALUE, TRUE,
		PANEL_MIN_VALUE, 0,
		PANEL_MAX_VALUE, 100,
		PANEL_NOTIFY_PROC, sliderVPNProc,
		0);
	return obj;
}

/*
 * Create object `pn_vpn_z' in the specified instance.
 */
Xv_opaque
pm_orient_panel_frame_pn_vpn_z_create(ip, owner)
	caddr_t		*ip;
	Xv_opaque	owner;
{
	extern void		sliderVPNProc();
	Xv_opaque	obj;
	
	obj = xv_create(owner, PANEL_SLIDER,
		XV_KEY_DATA, INSTANCE, ip,
		XV_X, 16,
		XV_Y, 112,
		XV_WIDTH, 0,
		XV_HEIGHT, 0,
		PANEL_VALUE_X, 101,
		PANEL_VALUE_Y, 112,
		PANEL_SLIDER_WIDTH, 100,
		PANEL_LABEL_STRING, "vpn.z * 100:",
		PANEL_LAYOUT, PANEL_HORIZONTAL,
		PANEL_SHOW_RANGE, TRUE,
		PANEL_SHOW_VALUE, TRUE,
		PANEL_MIN_VALUE, 0,
		PANEL_MAX_VALUE, 100,
		PANEL_NOTIFY_PROC, sliderVPNProc,
		0);
	return obj;
}

/*
 * Create object `message2' in the specified instance.
 */
Xv_opaque
pm_orient_panel_frame_message2_create(ip, owner)
	caddr_t		*ip;
	Xv_opaque	owner;
{
	Xv_opaque	obj;
	
	obj = xv_create(owner, PANEL_MESSAGE,
		XV_KEY_DATA, INSTANCE, ip,
		XV_X, 16,
		XV_Y, 144,
		XV_WIDTH, 0,
		XV_HEIGHT, 0,
		PANEL_LABEL_STRING, "View Up Vector:",
		PANEL_LABEL_BOLD, TRUE,
		0);
	return obj;
}

/*
 * Create object `pn_vup_x' in the specified instance.
 */
Xv_opaque
pm_orient_panel_frame_pn_vup_x_create(ip, owner)
	caddr_t		*ip;
	Xv_opaque	owner;
{
	extern void		sliderVPNProc();
	Xv_opaque	obj;
	
	obj = xv_create(owner, PANEL_SLIDER,
		XV_KEY_DATA, INSTANCE, ip,
		XV_X, 16,
		XV_Y, 176,
		XV_WIDTH, 0,
		XV_HEIGHT, 0,
		PANEL_VALUE_X, 93,
		PANEL_VALUE_Y, 176,
		PANEL_SLIDER_WIDTH, 100,
		PANEL_LABEL_STRING, "vup.x * 10:",
		PANEL_LAYOUT, PANEL_HORIZONTAL,
		PANEL_SHOW_RANGE, TRUE,
		PANEL_SHOW_VALUE, TRUE,
		PANEL_MIN_VALUE, 0,
		PANEL_MAX_VALUE, 100,
		PANEL_NOTIFY_PROC, sliderVPNProc,
		0);
	return obj;
}

/*
 * Create object `pn_vup_y' in the specified instance.
 */
Xv_opaque
pm_orient_panel_frame_pn_vup_y_create(ip, owner)
	caddr_t		*ip;
	Xv_opaque	owner;
{
	extern void		sliderVPNProc();
	Xv_opaque	obj;
	
	obj = xv_create(owner, PANEL_SLIDER,
		XV_KEY_DATA, INSTANCE, ip,
		XV_X, 16,
		XV_Y, 208,
		XV_WIDTH, 0,
		XV_HEIGHT, 0,
		PANEL_VALUE_X, 94,
		PANEL_VALUE_Y, 208,
		PANEL_SLIDER_WIDTH, 100,
		PANEL_LABEL_STRING, "vup.y * 10:",
		PANEL_LAYOUT, PANEL_HORIZONTAL,
		PANEL_SHOW_RANGE, TRUE,
		PANEL_SHOW_VALUE, TRUE,
		PANEL_MIN_VALUE, 0,
		PANEL_MAX_VALUE, 100,
		PANEL_NOTIFY_PROC, sliderVPNProc,
		0);
	return obj;
}

/*
 * Create object `pn_vup_z' in the specified instance.
 */
Xv_opaque
pm_orient_panel_frame_pn_vup_z_create(ip, owner)
	caddr_t		*ip;
	Xv_opaque	owner;
{
	extern void		sliderVPNProc();
	Xv_opaque	obj;
	
	obj = xv_create(owner, PANEL_SLIDER,
		XV_KEY_DATA, INSTANCE, ip,
		XV_X, 16,
		XV_Y, 240,
		XV_WIDTH, 0,
		XV_HEIGHT, 0,
		PANEL_VALUE_X, 93,
		PANEL_VALUE_Y, 240,
		PANEL_SLIDER_WIDTH, 100,
		PANEL_LABEL_STRING, "vup.z * 10:",
		PANEL_LAYOUT, PANEL_HORIZONTAL,
		PANEL_SHOW_RANGE, TRUE,
		PANEL_SHOW_VALUE, TRUE,
		PANEL_MIN_VALUE, 0,
		PANEL_MAX_VALUE, 100,
		PANEL_NOTIFY_PROC, sliderVPNProc,
		0);
	return obj;
}

/*
 * Create object `message3' in the specified instance.
 */
Xv_opaque
pm_orient_panel_frame_message3_create(ip, owner)
	caddr_t		*ip;
	Xv_opaque	owner;
{
	Xv_opaque	obj;
	
	obj = xv_create(owner, PANEL_MESSAGE,
		XV_KEY_DATA, INSTANCE, ip,
		XV_X, 16,
		XV_Y, 272,
		XV_WIDTH, 0,
		XV_HEIGHT, 0,
		PANEL_LABEL_STRING, "View Reference Point:",
		PANEL_LABEL_BOLD, TRUE,
		0);
	return obj;
}

/*
 * Create object `pn_vrp_x' in the specified instance.
 */
Xv_opaque
pm_orient_panel_frame_pn_vrp_x_create(ip, owner)
	caddr_t		*ip;
	Xv_opaque	owner;
{
	extern void		sliderVPNProc();
	Xv_opaque	obj;
	
	obj = xv_create(owner, PANEL_SLIDER,
		XV_KEY_DATA, INSTANCE, ip,
		XV_X, 16,
		XV_Y, 304,
		XV_WIDTH, 0,
		XV_HEIGHT, 0,
		PANEL_VALUE_X, 90,
		PANEL_VALUE_Y, 304,
		PANEL_SLIDER_WIDTH, 100,
		PANEL_LABEL_STRING, "vrp.x * 10:",
		PANEL_LAYOUT, PANEL_HORIZONTAL,
		PANEL_SHOW_RANGE, TRUE,
		PANEL_SHOW_VALUE, TRUE,
		PANEL_MIN_VALUE, 0,
		PANEL_MAX_VALUE, 100,
		PANEL_NOTIFY_PROC, sliderVPNProc,
		0);
	return obj;
}

/*
 * Create object `pn_vrp_y' in the specified instance.
 */
Xv_opaque
pm_orient_panel_frame_pn_vrp_y_create(ip, owner)
	caddr_t		*ip;
	Xv_opaque	owner;
{
	extern void		sliderVPNProc();
	Xv_opaque	obj;
	
	obj = xv_create(owner, PANEL_SLIDER,
		XV_KEY_DATA, INSTANCE, ip,
		XV_X, 16,
		XV_Y, 336,
		XV_WIDTH, 0,
		XV_HEIGHT, 0,
		PANEL_VALUE_X, 91,
		PANEL_VALUE_Y, 336,
		PANEL_SLIDER_WIDTH, 100,
		PANEL_LABEL_STRING, "vrp.y * 10:",
		PANEL_LAYOUT, PANEL_HORIZONTAL,
		PANEL_SHOW_RANGE, TRUE,
		PANEL_SHOW_VALUE, TRUE,
		PANEL_MIN_VALUE, 0,
		PANEL_MAX_VALUE, 100,
		PANEL_NOTIFY_PROC, sliderVPNProc,
		0);
	return obj;
}

/*
 * Create object `pn_vrp_z' in the specified instance.
 */
Xv_opaque
pm_orient_panel_frame_pn_vrp_z_create(ip, owner)
	caddr_t		*ip;
	Xv_opaque	owner;
{
	extern void		sliderVPNProc();
	Xv_opaque	obj;
	
	obj = xv_create(owner, PANEL_SLIDER,
		XV_KEY_DATA, INSTANCE, ip,
		XV_X, 16,
		XV_Y, 368,
		XV_WIDTH, 0,
		XV_HEIGHT, 0,
		PANEL_VALUE_X, 90,
		PANEL_VALUE_Y, 368,
		PANEL_SLIDER_WIDTH, 100,
		PANEL_LABEL_STRING, "vrp.z * 10:",
		PANEL_LAYOUT, PANEL_HORIZONTAL,
		PANEL_SHOW_RANGE, TRUE,
		PANEL_SHOW_VALUE, TRUE,
		PANEL_MIN_VALUE, 0,
		PANEL_MAX_VALUE, 100,
		PANEL_NOTIFY_PROC, sliderVPNProc,
		0);
	return obj;
}

/*
 * Initialize an instance of object `viewmap_panel_frame'.
 */
pm_viewmap_panel_frame_objects *
pm_viewmap_panel_frame_objects_initialize(ip, owner)
	pm_viewmap_panel_frame_objects	*ip;
	Xv_opaque	owner;
{
	if (!ip && !(ip = (pm_viewmap_panel_frame_objects *) calloc(1, sizeof (pm_viewmap_panel_frame_objects))))
		return (pm_viewmap_panel_frame_objects *) NULL;
	if (!ip->viewmap_panel_frame)
		ip->viewmap_panel_frame = pm_viewmap_panel_frame_viewmap_panel_frame_create(ip, owner);
	if (!ip->viewmap_panel)
		ip->viewmap_panel = pm_viewmap_panel_frame_viewmap_panel_create(ip, ip->viewmap_panel_frame);
	if (!ip->message5)
		ip->message5 = pm_viewmap_panel_frame_message5_create(ip, ip->viewmap_panel);
	if (!ip->pn_win_xmin)
		ip->pn_win_xmin = pm_viewmap_panel_frame_pn_win_xmin_create(ip, ip->viewmap_panel);
	if (!ip->pn_win_xmax)
		ip->pn_win_xmax = pm_viewmap_panel_frame_pn_win_xmax_create(ip, ip->viewmap_panel);
	if (!ip->pn_win_ymin)
		ip->pn_win_ymin = pm_viewmap_panel_frame_pn_win_ymin_create(ip, ip->viewmap_panel);
	if (!ip->pn_win_ymax)
		ip->pn_win_ymax = pm_viewmap_panel_frame_pn_win_ymax_create(ip, ip->viewmap_panel);
	if (!ip->message6)
		ip->message6 = pm_viewmap_panel_frame_message6_create(ip, ip->viewmap_panel);
	if (!ip->pn_viewp_xmin)
		ip->pn_viewp_xmin = pm_viewmap_panel_frame_pn_viewp_xmin_create(ip, ip->viewmap_panel);
	if (!ip->pn_viewp_xmax)
		ip->pn_viewp_xmax = pm_viewmap_panel_frame_pn_viewp_xmax_create(ip, ip->viewmap_panel);
	if (!ip->pn_viewp_ymin)
		ip->pn_viewp_ymin = pm_viewmap_panel_frame_pn_viewp_ymin_create(ip, ip->viewmap_panel);
	if (!ip->pn_viewp_ymax)
		ip->pn_viewp_ymax = pm_viewmap_panel_frame_pn_viewp_ymax_create(ip, ip->viewmap_panel);
	if (!ip->pn_viewp_zmin)
		ip->pn_viewp_zmin = pm_viewmap_panel_frame_pn_viewp_zmin_create(ip, ip->viewmap_panel);
	if (!ip->pn_viewp_zmax)
		ip->pn_viewp_zmax = pm_viewmap_panel_frame_pn_viewp_zmax_create(ip, ip->viewmap_panel);
	if (!ip->message7)
		ip->message7 = pm_viewmap_panel_frame_message7_create(ip, ip->viewmap_panel);
	if (!ip->pn_prp_x)
		ip->pn_prp_x = pm_viewmap_panel_frame_pn_prp_x_create(ip, ip->viewmap_panel);
	if (!ip->pn_prp_y)
		ip->pn_prp_y = pm_viewmap_panel_frame_pn_prp_y_create(ip, ip->viewmap_panel);
	if (!ip->pn_prp_z)
		ip->pn_prp_z = pm_viewmap_panel_frame_pn_prp_z_create(ip, ip->viewmap_panel);
	if (!ip->pn_proj_type)
		ip->pn_proj_type = pm_viewmap_panel_frame_pn_proj_type_create(ip, ip->viewmap_panel);
	if (!ip->message8)
		ip->message8 = pm_viewmap_panel_frame_message8_create(ip, ip->viewmap_panel);
	if (!ip->pn_pln_front)
		ip->pn_pln_front = pm_viewmap_panel_frame_pn_pln_front_create(ip, ip->viewmap_panel);
	if (!ip->pn_pln_back)
		ip->pn_pln_back = pm_viewmap_panel_frame_pn_pln_back_create(ip, ip->viewmap_panel);
	if (!ip->pn_pln_view)
		ip->pn_pln_view = pm_viewmap_panel_frame_pn_pln_view_create(ip, ip->viewmap_panel);
	return ip;
}

/*
 * Create object `viewmap_panel_frame' in the specified instance.
 */
Xv_opaque
pm_viewmap_panel_frame_viewmap_panel_frame_create(ip, owner)
	caddr_t		*ip;
	Xv_opaque	owner;
{
	Xv_opaque	obj;
	
	obj = xv_create(owner, FRAME_CMD,
		XV_KEY_DATA, INSTANCE, ip,
                XV_X, 575, XV_Y, 350,
		XV_WIDTH, 577,
		XV_HEIGHT, 468,
		XV_LABEL, "Pyramid: View Mapping",
		XV_SHOW, FALSE,
		FRAME_SHOW_FOOTER, FALSE,
		FRAME_SHOW_RESIZE_CORNER, FALSE,
		FRAME_CMD_PUSHPIN_IN, TRUE,
		0);
	xv_set(xv_get(obj, FRAME_CMD_PANEL), WIN_SHOW, FALSE, 0);
	return obj;
}

/*
 * Create object `viewmap_panel' in the specified instance.
 */
Xv_opaque
pm_viewmap_panel_frame_viewmap_panel_create(ip, owner)
	caddr_t		*ip;
	Xv_opaque	owner;
{
	Xv_opaque	obj;
	
	obj = xv_create(owner, PANEL,
		XV_KEY_DATA, INSTANCE, ip,
		XV_X, 0,
		XV_Y, 0,
		XV_WIDTH, WIN_EXTEND_TO_EDGE,
		XV_HEIGHT, WIN_EXTEND_TO_EDGE,
		OPENWIN_SHOW_BORDERS, FALSE,
		0);
	return obj;
}

/*
 * Create object `message5' in the specified instance.
 */
Xv_opaque
pm_viewmap_panel_frame_message5_create(ip, owner)
	caddr_t		*ip;
	Xv_opaque	owner;
{
	Xv_opaque	obj;
	
	obj = xv_create(owner, PANEL_MESSAGE,
		XV_KEY_DATA, INSTANCE, ip,
		XV_X, 16,
		XV_Y, 16,
		XV_WIDTH, 0,
		XV_HEIGHT, 0,
		PANEL_LABEL_STRING, "Window ( * 100):",
		PANEL_LABEL_BOLD, TRUE,
		0);
	return obj;
}

/*
 * Create object `pn_win_xmin' in the specified instance.
 */
Xv_opaque
pm_viewmap_panel_frame_pn_win_xmin_create(ip, owner)
	caddr_t		*ip;
	Xv_opaque	owner;
{
	extern void		viewMapProc();
	Xv_opaque	obj;
	
	obj = xv_create(owner, PANEL_SLIDER,
		XV_KEY_DATA, INSTANCE, ip,
		XV_X, 16,
		XV_Y, 48,
		XV_WIDTH, 0,
		XV_HEIGHT, 0,
		PANEL_VALUE_X, 77,
		PANEL_VALUE_Y, 48,
		PANEL_SLIDER_WIDTH, 100,
		PANEL_LABEL_STRING, "X:   Min:",
		PANEL_LAYOUT, PANEL_HORIZONTAL,
		PANEL_SHOW_RANGE, TRUE,
		PANEL_SHOW_VALUE, TRUE,
		PANEL_MIN_VALUE, 0,
		PANEL_MAX_VALUE, 100,
		PANEL_NOTIFY_PROC, viewMapProc,
		0);
	return obj;
}

/*
 * Create object `pn_win_xmax' in the specified instance.
 */
Xv_opaque
pm_viewmap_panel_frame_pn_win_xmax_create(ip, owner)
	caddr_t		*ip;
	Xv_opaque	owner;
{
	extern void		viewMapProc();
	Xv_opaque	obj;
	
	obj = xv_create(owner, PANEL_SLIDER,
		XV_KEY_DATA, INSTANCE, ip,
		XV_X, 304,
		XV_Y, 48,
		XV_WIDTH, 0,
		XV_HEIGHT, 0,
		PANEL_VALUE_X, 342,
		PANEL_VALUE_Y, 48,
		PANEL_SLIDER_WIDTH, 100,
		PANEL_LABEL_STRING, "Max:",
		PANEL_LAYOUT, PANEL_HORIZONTAL,
		PANEL_SHOW_RANGE, TRUE,
		PANEL_SHOW_VALUE, TRUE,
		PANEL_MIN_VALUE, 0,
		PANEL_MAX_VALUE, 100,
		PANEL_NOTIFY_PROC, viewMapProc,
		0);
	return obj;
}

/*
 * Create object `pn_win_ymin' in the specified instance.
 */
Xv_opaque
pm_viewmap_panel_frame_pn_win_ymin_create(ip, owner)
	caddr_t		*ip;
	Xv_opaque	owner;
{
	extern void		viewMapProc();
	Xv_opaque	obj;
	
	obj = xv_create(owner, PANEL_SLIDER,
		XV_KEY_DATA, INSTANCE, ip,
		XV_X, 16,
		XV_Y, 80,
		XV_WIDTH, 0,
		XV_HEIGHT, 0,
		PANEL_VALUE_X, 77,
		PANEL_VALUE_Y, 80,
		PANEL_SLIDER_WIDTH, 100,
		PANEL_LABEL_STRING, "Y:   Min:",
		PANEL_LAYOUT, PANEL_HORIZONTAL,
		PANEL_SHOW_RANGE, TRUE,
		PANEL_SHOW_VALUE, TRUE,
		PANEL_MIN_VALUE, 0,
		PANEL_MAX_VALUE, 100,
		PANEL_NOTIFY_PROC, viewMapProc,
		0);
	return obj;
}

/*
 * Create object `pn_win_ymax' in the specified instance.
 */
Xv_opaque
pm_viewmap_panel_frame_pn_win_ymax_create(ip, owner)
	caddr_t		*ip;
	Xv_opaque	owner;
{
	extern void		viewMapProc();
	Xv_opaque	obj;
	
	obj = xv_create(owner, PANEL_SLIDER,
		XV_KEY_DATA, INSTANCE, ip,
		XV_X, 304,
		XV_Y, 80,
		XV_WIDTH, 0,
		XV_HEIGHT, 0,
		PANEL_VALUE_X, 342,
		PANEL_VALUE_Y, 80,
		PANEL_SLIDER_WIDTH, 100,
		PANEL_LABEL_STRING, "Max:",
		PANEL_LAYOUT, PANEL_HORIZONTAL,
		PANEL_SHOW_RANGE, TRUE,
		PANEL_SHOW_VALUE, TRUE,
		PANEL_MIN_VALUE, 0,
		PANEL_MAX_VALUE, 100,
		PANEL_NOTIFY_PROC, viewMapProc,
		0);
	return obj;
}

/*
 * Create object `message6' in the specified instance.
 */
Xv_opaque
pm_viewmap_panel_frame_message6_create(ip, owner)
	caddr_t		*ip;
	Xv_opaque	owner;
{
	Xv_opaque	obj;
	
	obj = xv_create(owner, PANEL_MESSAGE,
		XV_KEY_DATA, INSTANCE, ip,
		XV_X, 16,
		XV_Y, 112,
		XV_WIDTH, 0,
		XV_HEIGHT, 0,
		PANEL_LABEL_STRING, "Viewport (* 100):",
		PANEL_LABEL_BOLD, TRUE,
		0);
	return obj;
}

/*
 * Create object `pn_viewp_xmin' in the specified instance.
 */
Xv_opaque
pm_viewmap_panel_frame_pn_viewp_xmin_create(ip, owner)
	caddr_t		*ip;
	Xv_opaque	owner;
{
	extern void		viewMapProc();
	Xv_opaque	obj;
	
	obj = xv_create(owner, PANEL_SLIDER,
		XV_KEY_DATA, INSTANCE, ip,
		XV_X, 16,
		XV_Y, 144,
		XV_WIDTH, 0,
		XV_HEIGHT, 0,
		PANEL_VALUE_X, 77,
		PANEL_VALUE_Y, 144,
		PANEL_SLIDER_WIDTH, 100,
		PANEL_LABEL_STRING, "X:   Min:",
		PANEL_LAYOUT, PANEL_HORIZONTAL,
		PANEL_SHOW_RANGE, TRUE,
		PANEL_SHOW_VALUE, TRUE,
		PANEL_MIN_VALUE, 0,
		PANEL_MAX_VALUE, 100,
		PANEL_NOTIFY_PROC, viewMapProc,
		0);
	return obj;
}

/*
 * Create object `pn_viewp_xmax' in the specified instance.
 */
Xv_opaque
pm_viewmap_panel_frame_pn_viewp_xmax_create(ip, owner)
	caddr_t		*ip;
	Xv_opaque	owner;
{
	extern void		viewMapProc();
	Xv_opaque	obj;
	
	obj = xv_create(owner, PANEL_SLIDER,
		XV_KEY_DATA, INSTANCE, ip,
		XV_X, 304,
		XV_Y, 144,
		XV_WIDTH, 0,
		XV_HEIGHT, 0,
		PANEL_VALUE_X, 342,
		PANEL_VALUE_Y, 144,
		PANEL_SLIDER_WIDTH, 100,
		PANEL_LABEL_STRING, "Max:",
		PANEL_LAYOUT, PANEL_HORIZONTAL,
		PANEL_SHOW_RANGE, TRUE,
		PANEL_SHOW_VALUE, TRUE,
		PANEL_MIN_VALUE, 0,
		PANEL_MAX_VALUE, 100,
		PANEL_NOTIFY_PROC, viewMapProc,
		0);
	return obj;
}

/*
 * Create object `pn_viewp_ymin' in the specified instance.
 */
Xv_opaque
pm_viewmap_panel_frame_pn_viewp_ymin_create(ip, owner)
	caddr_t		*ip;
	Xv_opaque	owner;
{
	extern void		viewMapProc();
	Xv_opaque	obj;
	
	obj = xv_create(owner, PANEL_SLIDER,
		XV_KEY_DATA, INSTANCE, ip,
		XV_X, 16,
		XV_Y, 176,
		XV_WIDTH, 0,
		XV_HEIGHT, 0,
		PANEL_VALUE_X, 77,
		PANEL_VALUE_Y, 176,
		PANEL_SLIDER_WIDTH, 100,
		PANEL_LABEL_STRING, "Y:   Min:",
		PANEL_LAYOUT, PANEL_HORIZONTAL,
		PANEL_SHOW_RANGE, TRUE,
		PANEL_SHOW_VALUE, TRUE,
		PANEL_MIN_VALUE, 0,
		PANEL_MAX_VALUE, 100,
		PANEL_NOTIFY_PROC, viewMapProc,
		0);
	return obj;
}

/*
 * Create object `pn_viewp_ymax' in the specified instance.
 */
Xv_opaque
pm_viewmap_panel_frame_pn_viewp_ymax_create(ip, owner)
	caddr_t		*ip;
	Xv_opaque	owner;
{
	extern void		viewMapProc();
	Xv_opaque	obj;
	
	obj = xv_create(owner, PANEL_SLIDER,
		XV_KEY_DATA, INSTANCE, ip,
		XV_X, 304,
		XV_Y, 176,
		XV_WIDTH, 0,
		XV_HEIGHT, 0,
		PANEL_VALUE_X, 342,
		PANEL_VALUE_Y, 176,
		PANEL_SLIDER_WIDTH, 100,
		PANEL_LABEL_STRING, "Max:",
		PANEL_LAYOUT, PANEL_HORIZONTAL,
		PANEL_SHOW_RANGE, TRUE,
		PANEL_SHOW_VALUE, TRUE,
		PANEL_MIN_VALUE, 0,
		PANEL_MAX_VALUE, 100,
		PANEL_NOTIFY_PROC, viewMapProc,
		0);
	return obj;
}

/*
 * Create object `pn_viewp_zmin' in the specified instance.
 */
Xv_opaque
pm_viewmap_panel_frame_pn_viewp_zmin_create(ip, owner)
	caddr_t		*ip;
	Xv_opaque	owner;
{
	extern void		viewMapProc();
	Xv_opaque	obj;
	
	obj = xv_create(owner, PANEL_SLIDER,
		XV_KEY_DATA, INSTANCE, ip,
		XV_X, 16,
		XV_Y, 208,
		XV_WIDTH, 0,
		XV_HEIGHT, 0,
		PANEL_VALUE_X, 76,
		PANEL_VALUE_Y, 208,
		PANEL_SLIDER_WIDTH, 100,
		PANEL_LABEL_STRING, "Z:   Min:",
		PANEL_LAYOUT, PANEL_HORIZONTAL,
		PANEL_SHOW_RANGE, TRUE,
		PANEL_SHOW_VALUE, TRUE,
		PANEL_MIN_VALUE, 0,
		PANEL_MAX_VALUE, 100,
		PANEL_NOTIFY_PROC, viewMapProc,
		0);
	return obj;
}

/*
 * Create object `pn_viewp_zmax' in the specified instance.
 */
Xv_opaque
pm_viewmap_panel_frame_pn_viewp_zmax_create(ip, owner)
	caddr_t		*ip;
	Xv_opaque	owner;
{
	extern void		viewMapProc();
	Xv_opaque	obj;
	
	obj = xv_create(owner, PANEL_SLIDER,
		XV_KEY_DATA, INSTANCE, ip,
		XV_X, 304,
		XV_Y, 208,
		XV_WIDTH, 0,
		XV_HEIGHT, 0,
		PANEL_VALUE_X, 342,
		PANEL_VALUE_Y, 208,
		PANEL_SLIDER_WIDTH, 100,
		PANEL_LABEL_STRING, "Max:",
		PANEL_LAYOUT, PANEL_HORIZONTAL,
		PANEL_SHOW_RANGE, TRUE,
		PANEL_SHOW_VALUE, TRUE,
		PANEL_MIN_VALUE, 0,
		PANEL_MAX_VALUE, 100,
		PANEL_NOTIFY_PROC, viewMapProc,
		0);
	return obj;
}

/*
 * Create object `message7' in the specified instance.
 */
Xv_opaque
pm_viewmap_panel_frame_message7_create(ip, owner)
	caddr_t		*ip;
	Xv_opaque	owner;
{
	Xv_opaque	obj;
	
	obj = xv_create(owner, PANEL_MESSAGE,
		XV_KEY_DATA, INSTANCE, ip,
		XV_X, 16,
		XV_Y, 240,
		XV_WIDTH, 0,
		XV_HEIGHT, 0,
		PANEL_LABEL_STRING, "Projection Reference Point:",
		PANEL_LABEL_BOLD, TRUE,
		0);
	return obj;
}

/*
 * Create object `pn_prp_x' in the specified instance.
 */
Xv_opaque
pm_viewmap_panel_frame_pn_prp_x_create(ip, owner)
	caddr_t		*ip;
	Xv_opaque	owner;
{
	extern void		viewMapProc();
	Xv_opaque	obj;
	
	obj = xv_create(owner, PANEL_SLIDER,
		XV_KEY_DATA, INSTANCE, ip,
		XV_X, 14,
		XV_Y, 272,
		XV_WIDTH, 0,
		XV_HEIGHT, 0,
		PANEL_VALUE_X, 64,
		PANEL_VALUE_Y, 272,
		PANEL_SLIDER_WIDTH, 100,
		PANEL_LABEL_STRING, "x * 10:",
		PANEL_LAYOUT, PANEL_HORIZONTAL,
		PANEL_SHOW_RANGE, TRUE,
		PANEL_SHOW_VALUE, TRUE,
		PANEL_MIN_VALUE, 0,
		PANEL_MAX_VALUE, 100,
		PANEL_NOTIFY_PROC, viewMapProc,
		0);
	return obj;
}

/*
 * Create object `pn_prp_y' in the specified instance.
 */
Xv_opaque
pm_viewmap_panel_frame_pn_prp_y_create(ip, owner)
	caddr_t		*ip;
	Xv_opaque	owner;
{
	extern void		viewMapProc();
	Xv_opaque	obj;
	
	obj = xv_create(owner, PANEL_SLIDER,
		XV_KEY_DATA, INSTANCE, ip,
		XV_X, 304,
		XV_Y, 272,
		XV_WIDTH, 0,
		XV_HEIGHT, 0,
		PANEL_VALUE_X, 353,
		PANEL_VALUE_Y, 272,
		PANEL_SLIDER_WIDTH, 100,
		PANEL_LABEL_STRING, "y * 10:",
		PANEL_LAYOUT, PANEL_HORIZONTAL,
		PANEL_SHOW_RANGE, TRUE,
		PANEL_SHOW_VALUE, TRUE,
		PANEL_MIN_VALUE, 0,
		PANEL_MAX_VALUE, 100,
		PANEL_NOTIFY_PROC, viewMapProc,
		0);
	return obj;
}

/*
 * Create object `pn_prp_z' in the specified instance.
 */
Xv_opaque
pm_viewmap_panel_frame_pn_prp_z_create(ip, owner)
	caddr_t		*ip;
	Xv_opaque	owner;
{
	extern void		viewMapProc();
	Xv_opaque	obj;
	
	obj = xv_create(owner, PANEL_SLIDER,
		XV_KEY_DATA, INSTANCE, ip,
		XV_X, 48,
		XV_Y, 304,
		XV_WIDTH, 0,
		XV_HEIGHT, 0,
		PANEL_VALUE_X, 64,
		PANEL_VALUE_Y, 304,
		PANEL_SLIDER_WIDTH, 100,
		PANEL_LABEL_STRING, "z:",
		PANEL_LAYOUT, PANEL_HORIZONTAL,
		PANEL_SHOW_RANGE, TRUE,
		PANEL_SHOW_VALUE, TRUE,
		PANEL_MIN_VALUE, 0,
		PANEL_MAX_VALUE, 100,
		PANEL_NOTIFY_PROC, viewMapProc,
		0);
	return obj;
}

/*
 * Create object `pn_proj_type' in the specified instance.
 */
Xv_opaque
pm_viewmap_panel_frame_pn_proj_type_create(ip, owner)
	caddr_t		*ip;
	Xv_opaque	owner;
{
	extern void		viewMapProc();
	Xv_opaque	obj;
	
	obj = xv_create(owner, PANEL_CHOICE,
		XV_KEY_DATA, INSTANCE, ip,
		XV_X, 16,
		XV_Y, 336,
		XV_WIDTH, 0,
		XV_HEIGHT, 0,
		PANEL_VALUE_X, 134,
		PANEL_VALUE_Y, 336,
		PANEL_LAYOUT, PANEL_HORIZONTAL,
		PANEL_CHOICE_STRINGS,
			"Parallel",
			"Perspective",
			0,
		PANEL_LABEL_STRING, "Projection Type:",
		PANEL_NOTIFY_PROC, viewMapProc,
		0);
	return obj;
}

/*
 * Create object `message8' in the specified instance.
 */
Xv_opaque
pm_viewmap_panel_frame_message8_create(ip, owner)
	caddr_t		*ip;
	Xv_opaque	owner;
{
	Xv_opaque	obj;
	
	obj = xv_create(owner, PANEL_MESSAGE,
		XV_KEY_DATA, INSTANCE, ip,
		XV_X, 16,
		XV_Y, 368,
		XV_WIDTH, 0,
		XV_HEIGHT, 0,
		PANEL_LABEL_STRING, "Planes (* 10):",
		PANEL_LABEL_BOLD, TRUE,
		0);
	return obj;
}

/*
 * Create object `pn_pln_front' in the specified instance.
 */
Xv_opaque
pm_viewmap_panel_frame_pn_pln_front_create(ip, owner)
	caddr_t		*ip;
	Xv_opaque	owner;
{
	extern void		viewMapProc();
	Xv_opaque	obj;
	
	obj = xv_create(owner, PANEL_SLIDER,
		XV_KEY_DATA, INSTANCE, ip,
		XV_X, 16,
		XV_Y, 400,
		XV_WIDTH, 0,
		XV_HEIGHT, 0,
		PANEL_VALUE_X, 61,
		PANEL_VALUE_Y, 400,
		PANEL_SLIDER_WIDTH, 100,
		PANEL_LABEL_STRING, "Front:",
		PANEL_LAYOUT, PANEL_HORIZONTAL,
		PANEL_SHOW_RANGE, TRUE,
		PANEL_SHOW_VALUE, TRUE,
		PANEL_MIN_VALUE, 0,
		PANEL_MAX_VALUE, 100,
		PANEL_NOTIFY_PROC, viewMapProc,
		0);
	return obj;
}

/*
 * Create object `pn_pln_back' in the specified instance.
 */
Xv_opaque
pm_viewmap_panel_frame_pn_pln_back_create(ip, owner)
	caddr_t		*ip;
	Xv_opaque	owner;
{
	extern void		viewMapProc();
	Xv_opaque	obj;
	
	obj = xv_create(owner, PANEL_SLIDER,
		XV_KEY_DATA, INSTANCE, ip,
		XV_X, 304,
		XV_Y, 400,
		XV_WIDTH, 0,
		XV_HEIGHT, 0,
		PANEL_VALUE_X, 347,
		PANEL_VALUE_Y, 400,
		PANEL_SLIDER_WIDTH, 100,
		PANEL_LABEL_STRING, "Back:",
		PANEL_LAYOUT, PANEL_HORIZONTAL,
		PANEL_SHOW_RANGE, TRUE,
		PANEL_SHOW_VALUE, TRUE,
		PANEL_MIN_VALUE, 0,
		PANEL_MAX_VALUE, 100,
		PANEL_NOTIFY_PROC, viewMapProc,
		0);
	return obj;
}

/*
 * Create object `pn_pln_view' in the specified instance.
 */
Xv_opaque
pm_viewmap_panel_frame_pn_pln_view_create(ip, owner)
	caddr_t		*ip;
	Xv_opaque	owner;
{
	extern void		viewMapProc();
	Xv_opaque	obj;
	
	obj = xv_create(owner, PANEL_SLIDER,
		XV_KEY_DATA, INSTANCE, ip,
		XV_X, 16,
		XV_Y, 432,
		XV_WIDTH, 0,
		XV_HEIGHT, 0,
		PANEL_VALUE_X, 60,
		PANEL_VALUE_Y, 432,
		PANEL_SLIDER_WIDTH, 100,
		PANEL_LABEL_STRING, "View:",
		PANEL_LAYOUT, PANEL_HORIZONTAL,
		PANEL_SHOW_RANGE, TRUE,
		PANEL_SHOW_VALUE, TRUE,
		PANEL_MIN_VALUE, 0,
		PANEL_MAX_VALUE, 100,
		PANEL_NOTIFY_PROC, viewMapProc,
		0);
	return obj;
}

/*
 * Initialize an instance of object `object_panel_frame'.
 */
pm_object_panel_frame_objects *
pm_object_panel_frame_objects_initialize(ip, owner)
	pm_object_panel_frame_objects	*ip;
	Xv_opaque	owner;
{
	if (!ip && !(ip = (pm_object_panel_frame_objects *) calloc(1, sizeof (pm_object_panel_frame_objects))))
		return (pm_object_panel_frame_objects *) NULL;
	if (!ip->object_panel_frame)
		ip->object_panel_frame = pm_object_panel_frame_object_panel_frame_create(ip, owner);
	if (!ip->object_panel)
		ip->object_panel = pm_object_panel_frame_object_panel_create(ip, ip->object_panel_frame);
	if (!ip->pn_pyr_type)
		ip->pn_pyr_type = pm_object_panel_frame_pn_pyr_type_create(ip, ip->object_panel);
	if (!ip->pn_pyr_depth)
		ip->pn_pyr_depth = pm_object_panel_frame_pn_pyr_depth_create(ip, ip->object_panel);
	if (!ip->pn_pyr_children)
		ip->pn_pyr_children = pm_object_panel_frame_pn_pyr_children_create(ip, ip->object_panel);
	if (!ip->pn_pyr_random)
		ip->pn_pyr_random = pm_object_panel_frame_pn_pyr_random_create(ip, ip->object_panel);
	if (!ip->pn_pyr_probability)
		ip->pn_pyr_probability = pm_object_panel_frame_pn_pyr_probability_create(ip, ip->object_panel);
	if (!ip->pn_build_button)
		ip->pn_build_button = pm_object_panel_frame_pn_build_button_create(ip, ip->object_panel);
	if (!ip->pn_pyr_reset)
		ip->pn_pyr_reset = pm_object_panel_frame_pn_pyr_reset_create(ip, ip->object_panel);
	if (!ip->pn_cube_row0)
		ip->pn_cube_row0 = pm_object_panel_frame_pn_cube_row0_create(ip, ip->object_panel);
	if (!ip->pn_cube_row1)
		ip->pn_cube_row1 = pm_object_panel_frame_pn_cube_row1_create(ip, ip->object_panel);
	if (!ip->pn_cube_row2)
		ip->pn_cube_row2 = pm_object_panel_frame_pn_cube_row2_create(ip, ip->object_panel);
	return ip;
}

/*
 * Create object `object_panel_frame' in the specified instance.
 */
Xv_opaque
pm_object_panel_frame_object_panel_frame_create(ip, owner)
	caddr_t		*ip;
	Xv_opaque	owner;
{
	Xv_opaque	obj;
	
	obj = xv_create(owner, FRAME_CMD,
		XV_KEY_DATA, INSTANCE, ip,
                XV_X, 575, XV_Y, 350,
		XV_WIDTH, 500,
		XV_HEIGHT, 184,
		XV_LABEL, "Pyramid: Create Object",
		XV_SHOW, FALSE,
		FRAME_SHOW_FOOTER, FALSE,
		FRAME_SHOW_RESIZE_CORNER, FALSE,
		FRAME_CMD_PUSHPIN_IN, FALSE,
		0);
	xv_set(xv_get(obj, FRAME_CMD_PANEL), WIN_SHOW, FALSE, 0);
	return obj;
}

/*
 * Create object `object_panel' in the specified instance.
 */
Xv_opaque
pm_object_panel_frame_object_panel_create(ip, owner)
	caddr_t		*ip;
	Xv_opaque	owner;
{
	Xv_opaque	obj;
	
	obj = xv_create(owner, PANEL,
		XV_KEY_DATA, INSTANCE, ip,
		XV_X, 0,
		XV_Y, 0,
		XV_WIDTH, WIN_EXTEND_TO_EDGE,
		XV_HEIGHT, WIN_EXTEND_TO_EDGE,
		OPENWIN_SHOW_BORDERS, FALSE,
		0);
	return obj;
}

/*
 * Create object `pn_pyr_type' in the specified instance.
 */
Xv_opaque
pm_object_panel_frame_pn_pyr_type_create(ip, owner)
	caddr_t		*ip;
	Xv_opaque	owner;
{
	extern void		objTypeProc();
	Xv_opaque	obj;
	
	obj = xv_create(owner, PANEL_CHOICE,
		XV_KEY_DATA, INSTANCE, ip,
		XV_X, 16,
		XV_Y, 16,
		XV_WIDTH, 0,
		XV_HEIGHT, 0,
		PANEL_VALUE_X, 110,
		PANEL_VALUE_Y, 16,
		PANEL_LAYOUT, PANEL_HORIZONTAL,
		PANEL_CHOICE_STRINGS,
			"Pyramid",
			"Cube",
			0,
		PANEL_LABEL_STRING, "Object Type:",
		PANEL_NOTIFY_PROC, objTypeProc,
		0);
	return obj;
}

/*
 * Create object `pn_pyr_depth' in the specified instance.
 */
Xv_opaque
pm_object_panel_frame_pn_pyr_depth_create(ip, owner)
	caddr_t		*ip;
	Xv_opaque	owner;
{
	Xv_opaque	obj;
	
	obj = xv_create(owner, PANEL_CHOICE, PANEL_DISPLAY_LEVEL, PANEL_CURRENT,
		XV_KEY_DATA, INSTANCE, ip,
		XV_X, 272,
		XV_Y, 16,
		XV_WIDTH, 0,
		XV_HEIGHT, 0,
		PANEL_VALUE_X, 324,
		PANEL_VALUE_Y, 16,
		PANEL_LAYOUT, PANEL_HORIZONTAL,
		PANEL_CHOICE_STRINGS,
			"0",
			"1",
			"2",
			"3",
			"4",
			"5",
			0,
		PANEL_LABEL_STRING, "Depth:",
		0);
	return obj;
}

/*
 * Create object `pn_pyr_children' in the specified instance.
 */
Xv_opaque
pm_object_panel_frame_pn_pyr_children_create(ip, owner)
	caddr_t		*ip;
	Xv_opaque	owner;
{
	Xv_opaque	obj;
	
	obj = xv_create(owner, PANEL_TOGGLE,
		XV_KEY_DATA, INSTANCE, ip,
		XV_X, 25,
		XV_Y, 46,
		XV_WIDTH, 0,
		XV_HEIGHT, 0,
		PANEL_VALUE_X, 83,
		PANEL_VALUE_Y, 46,
		PANEL_LAYOUT, PANEL_HORIZONTAL,
		PANEL_CHOICE_STRINGS,
			"Front Left",
			"Front Right",
			"Back Left",
			"Back Right",
			"Top",
			0,
		PANEL_LABEL_STRING, "Create:",
		0);
	return obj;
}

/*
 * Create object `pn_pyr_random' in the specified instance.
 */
Xv_opaque
pm_object_panel_frame_pn_pyr_random_create(ip, owner)
	caddr_t		*ip;
	Xv_opaque	owner;
{
	Xv_opaque	obj;
	
	obj = xv_create(owner, PANEL_TOGGLE,
		XV_KEY_DATA, INSTANCE, ip,
		XV_X, 16,
		XV_Y, 80,
		XV_WIDTH, 0,
		XV_HEIGHT, 0,
		PANEL_VALUE_X, 82,
		PANEL_VALUE_Y, 80,
		PANEL_LAYOUT, PANEL_HORIZONTAL,
		PANEL_CHOICE_STRINGS,
			"Front Left",
			"Front Right",
			"Back Left",
			"Back Right",
			"Top",
			0,
		PANEL_LABEL_STRING, "Random:",
		0);
	return obj;
}

/*
 * Create object `pn_pyr_probability' in the specified instance.
 */
Xv_opaque
pm_object_panel_frame_pn_pyr_probability_create(ip, owner)
	caddr_t		*ip;
	Xv_opaque	owner;
{
	Xv_opaque	obj;
	
	obj = xv_create(owner, PANEL_SLIDER,
		XV_KEY_DATA, INSTANCE, ip,
		XV_X, 16,
		XV_Y, 112,
		XV_WIDTH, 0,
		XV_HEIGHT, 0,
		PANEL_VALUE_X, 103,
		PANEL_VALUE_Y, 112,
		PANEL_SLIDER_WIDTH, 100,
		PANEL_LABEL_STRING, "Probability:",
		PANEL_LAYOUT, PANEL_HORIZONTAL,
		PANEL_SHOW_RANGE, TRUE,
		PANEL_SHOW_VALUE, TRUE,
		PANEL_MIN_VALUE, 0,
		PANEL_MAX_VALUE, 100,
		0);
	return obj;
}

/*
 * Create object `pn_build_button' in the specified instance.
 */
Xv_opaque
pm_object_panel_frame_pn_build_button_create(ip, owner)
	caddr_t		*ip;
	Xv_opaque	owner;
{
	extern void		mainObject();
	Xv_opaque	obj;
	
	obj = xv_create(owner, PANEL_BUTTON,
		XV_KEY_DATA, INSTANCE, ip,
		XV_X, 163,
		XV_Y, 144,
		XV_WIDTH, 0,
		XV_HEIGHT, 0,
		PANEL_LABEL_STRING, "Build Object",
		PANEL_NOTIFY_PROC, mainObject,
		0);
	return obj;
}

/*
 * Create object `pn_pyr_reset' in the specified instance.
 */
Xv_opaque
pm_object_panel_frame_pn_pyr_reset_create(ip, owner)
	caddr_t		*ip;
	Xv_opaque	owner;
{
	extern void		rs_object_panel();
	Xv_opaque	obj;
	
	obj = xv_create(owner, PANEL_BUTTON,
		XV_KEY_DATA, INSTANCE, ip,
		XV_X, 275,
		XV_Y, 144,
		XV_WIDTH, 0,
		XV_HEIGHT, 0,
		PANEL_LABEL_STRING, "Reset",
		PANEL_NOTIFY_PROC, rs_object_panel,
		0);
	return obj;
}

/*
 * Create object `pn_cube_row0' in the specified instance.
 */
Xv_opaque
pm_object_panel_frame_pn_cube_row0_create(ip, owner)
	caddr_t		*ip;
	Xv_opaque	owner;
{
	Xv_opaque	obj;
	
	obj = xv_create(owner, PANEL_TOGGLE,
		XV_KEY_DATA, INSTANCE, ip,
		XV_X, 16,
		XV_Y, 192,
		XV_WIDTH, 0,
		XV_HEIGHT, 0,
		PANEL_VALUE_X, 101,
/*		PANEL_VALUE_Y, 192, */
                PANEL_VALUE_Y, 46,
		PANEL_LAYOUT, PANEL_HORIZONTAL,
		PANEL_CHOICE_STRINGS,
			"FL",
			"FC",
			"FR",
			"ML",
			"MC",
			"MR",
			"BL",
			"MC",
			"BR",
			0,
		PANEL_LABEL_STRING, "Top Row:",
		0);
	return obj;
}

/*
 * Create object `pn_cube_row1' in the specified instance.
 */
Xv_opaque
pm_object_panel_frame_pn_cube_row1_create(ip, owner)
	caddr_t		*ip;
	Xv_opaque	owner;
{
	Xv_opaque	obj;
	
	obj = xv_create(owner, PANEL_TOGGLE,
		XV_KEY_DATA, INSTANCE, ip,
		XV_X, 16,
		XV_Y, 224,
		XV_WIDTH, 0,
		XV_HEIGHT, 0,
		PANEL_VALUE_X, 101,
/*		PANEL_VALUE_Y, 224, */
                PANEL_VALUE_Y, 80,
		PANEL_LAYOUT, PANEL_HORIZONTAL,
		PANEL_CHOICE_STRINGS,
			"FL",
			"FC",
			"FR",
			"ML",
			"MC",
			"MR",
			"BL",
			"MC",
			"BR",
			0,
		PANEL_LABEL_STRING, "Middle Row:",
		0);
	return obj;
}

/*
 * Create object `pn_cube_row2' in the specified instance.
 */
Xv_opaque
pm_object_panel_frame_pn_cube_row2_create(ip, owner)
	caddr_t		*ip;
	Xv_opaque	owner;
{
	Xv_opaque	obj;
	
	obj = xv_create(owner, PANEL_TOGGLE,
		XV_KEY_DATA, INSTANCE, ip,
		XV_X, 16,
		XV_Y, 256,
		XV_WIDTH, 0,
		XV_HEIGHT, 0,
		PANEL_VALUE_X, 101,
/*		PANEL_VALUE_Y, 256, */
		PANEL_VALUE_Y, 112,
		PANEL_LAYOUT, PANEL_HORIZONTAL,
		PANEL_CHOICE_STRINGS,
			"FL",
			"FC",
			"FR",
			"ML",
			"MC",
			"MR",
			"BL",
			"MC",
			"BR",
			0,
		PANEL_LABEL_STRING, "Bottom Row:",
		0);
	return obj;
}

/*
 * Initialize an instance of object `light_sources_frame'.
 */
pm_light_sources_frame_objects *
pm_light_sources_frame_objects_initialize(ip, owner)
	pm_light_sources_frame_objects	*ip;
	Xv_opaque	owner;
{
	if (!ip && !(ip = (pm_light_sources_frame_objects *) calloc(1, sizeof (pm_light_sources_frame_objects))))
		return (pm_light_sources_frame_objects *) NULL;
	if (!ip->light_sources_frame)
		ip->light_sources_frame = pm_light_sources_frame_light_sources_frame_create(ip, owner);
	return ip;
}

/*
 * Create object `light_sources_frame' in the specified instance.
 */
Xv_opaque
pm_light_sources_frame_light_sources_frame_create(ip, owner)
	caddr_t		*ip;
	Xv_opaque	owner;
{
	Xv_opaque	obj;
	
	obj = xv_create(owner, FRAME_CMD,
		XV_KEY_DATA, INSTANCE, ip,
                XV_X, 575, XV_Y, 0,
		XV_WIDTH, 300,
		XV_HEIGHT, 300,
		XV_LABEL, "Pyramid: Light Sources",
		XV_SHOW, TRUE,
		FRAME_SHOW_FOOTER, FALSE,
		FRAME_SHOW_RESIZE_CORNER, FALSE,
		FRAME_CMD_PUSHPIN_IN, TRUE,
		0);
	xv_set(xv_get(obj, FRAME_CMD_PANEL), WIN_SHOW, FALSE, 0);
	return obj;
}

