/*
  hzfont2bdf.c -- program to convert Chinese fonts in hz format to
                  X window bdf format

  Written by Ricky Yeung

  Copyright (c) 1989, 1991 Ricky Yeung

  All rights reserved.
  Permission to copy and distribute verbatim copies of this
  document for non-commercial purposes is granted, but changing
  it is not allowed.
  There is absolutely no warranty for this program.

  Please send your comments and suggestions to the author:
  	Ricky Yeung	yeung@decwrl.dec.com or yeung@atd.dec.com
  Copyright (1989) Ricky Yeung (yeung@june.cs.washington.edu)
*/


#include <stdio.h>
#include <ctype.h>
#include <string.h>

#define	GBDEFAULT	55290
#define	BIG5DEFAULT	41280

#define NAMELEN	100

char *getenv();

char *GBbitmap(), *BIGbitmap();
void loadGBfont(), loadBIGfont();
extern int bn;

int hzbyte;	/* number of bytes per hanzi image */
int GBmode;	/* GB or BIG5 */

char hzdir[NAMELEN], fontdir[NAMELEN];
int HZbm;

static char HZDIR[] = "HZDIR";
char hzfont[NAMELEN], hzName[NAMELEN];

#define DB(hi,lo)	(((hi)&0xFF) << 8 | (lo)&0xFF)
#define isGB(c)		((c)>=0x21 && (c)<=0x7E)


int index2GB (index)
    int index;
{
    int hi,lo;

    hi = index / 0x5e + 0x21;
    lo = index % 0x5e + 0x21;
    return(DB(hi,lo));
}

int index2BIG (index)
    int index;
{
    int hi,lo;

    hi = index / 157 + 0xA1;
    lo = index % 157 + 0x40;
    if (lo >= 0x7F)
	lo += 0xA1 - 0x7F;
    return(DB(hi,lo));
}

AllBlank (p)
    char *p;
{
    int i;
    
    for (i=0;i<hzbyte;i++)
	if (p[i]) return(0);
    return(1);
}


hexchar(i)
    int i;
{
    if (i<10) return('0'+i);
    else if (i<16) return('a'+i-10);
}
   
byte2chars (c, byte)
    char c, *byte;
{
    int hi,lo;

    hi = (c >> 4) & 0xf;
    lo = c & 0xf;
    byte[0] = hexchar(hi);
    byte[1] = hexchar(lo);
}


WriteBitmap (p,isodd,oddbyte,nibbles,n)
    char *p;
    int isodd,oddbyte,nibbles,n;
{
    char byte[2];
    int i;
    
    for (i=1;i<=hzbyte;i++)
    {
	byte2chars(*p, byte);
	p++;
	if (isodd && ((i+oddbyte)%nibbles)==0)
	    printf("%c0\n%c",byte[0],byte[1]);
	else if ((i%n)==0)
	{
	    if (isodd) printf("%c%c0\n",byte[0],byte[1]);
	    else printf("%c%c\n",byte[0],byte[1]);
	}
	else printf("%c%c",byte[0],byte[1]);
    }
}

usage(name)
    char *name;
{
    fprintf(stderr, "usage: %s mode hzName size [all_zero_char_code]\n", name);
    fprintf(stderr, "        mode is either -gb or -big5\n");
    exit(1);
}    

main(argc, argv)
     int argc;
     char *argv[];
{
    char s[NAMELEN], *p;
    int i,j,code,n,isodd,oddbyte,nibbles,rcode;
    int total = 0, b_char = -1, ntotal = 0;

    if (getenv(HZDIR) != NULL)
    {
	strcpy(hzdir, getenv(HZDIR));
	strcat(hzdir, "/");
	strcpy(fontdir, hzdir);
    }
    else
    {
	fprintf(stderr, "Please setenv %s appropriately.\n", HZDIR);
	exit(1);
    }
  
    switch (argc)
    {
      case 5:
	sscanf(argv[4], "%d", &b_char);
      case 4:
	if ((strcmp(argv[1],"-big5")&&strcmp(argv[1],"-gb")))
	    usage(argv[0]);
	GBmode = strcmp(argv[1], "-big5");
	strcpy(hzName, argv[2]);
	sscanf(argv[3], "%d", &HZbm);
	break;
      default:
	usage(argv[0]);
    }

    if (b_char<0)
	b_char = GBmode ? GBDEFAULT : BIG5DEFAULT;
  
    sprintf(s, "%d", HZbm);
    strcpy(hzfont, hzName);
    strcat(hzfont, s);
  
    hzbyte = HZbm * HZbm / 8;
    if (GBmode)
	loadGBfont();
    else
	loadBIGfont();

    for (i=0;i<(bn/hzbyte);i++)
    {
	code = GBmode ? index2GB(i) : index2BIG(i);
	p = GBmode ? GBbitmap(code) : BIGbitmap(code);

	++total;
	if (!AllBlank(p)) ++ntotal;
    }

    nibbles = HZbm/4;
    isodd = nibbles % 2;
        
    if (isodd) n = nibbles;
    else n = nibbles / 2;

    if (isodd) oddbyte = nibbles / 2;

    /* ad hoc */
    printf("STARTFONT 2.1\n");
    printf("FONT %s\n", hzfont);
    printf("SIZE %d 80 80\n", HZbm);
    printf("FONTBOUNDINGBOX %d %d 0 0\n",HZbm+2, HZbm+2);
    printf("STARTPROPERTIES 8\n");
    printf("FONTNAME_REGISTRY \"\"\n");
    printf("FAMILY_NAME \"Chinese Character\"\n");
    printf("FOUNDRY \"Generated by hzfont2bdf\"\n");
    printf("CHARSET_REGISTRY \"GB2312-80\"\n");
    printf("COPYRIGHT \"Generated by hzfont2bdf, please edit this line and FOUNDRY\"\n");
    printf("FONT_ASCENT %d\n",HZbm);
    printf("FONT_DESCENT 0\n");
    printf("DEFAULT_CHAR %d\n",b_char);
    printf("ENDPROPERTIES\n");

    printf("CHARS %d\n",++ntotal); /* plus default char */

    /* default char */
    printf("STARTCHAR hanzi_default_%x\n", b_char);
    printf("ENCODING %d\n",b_char);
    printf("SWIDTH 461 0\n");
    printf("DWIDTH %d 0\n",HZbm);
    printf("BBX %d %d 0 0\n",HZbm,HZbm);
    printf("BITMAP\n");
    for (i=0;i<HZbm;i++)
    {
	for (j=0;j<nibbles+isodd;j++)
	    putchar('0');
	putchar('\n');
    }
    printf("ENDCHAR\n");

    ntotal = 0;
    for (i=0;i<(bn/hzbyte);i++)
    {
	code = GBmode ? index2GB(i) : index2BIG(i);
	p = GBmode ? GBbitmap(code) : BIGbitmap(code);

	if (!AllBlank(p))
	{
	    ++ntotal;
	    rcode = GBmode ? (code | 0x8080) : code;
	    printf("STARTCHAR %x\nENCODING %d\nSWIDTH 461 0\nDWIDTH %d 0\nBBX %d %d 0 0\nBITMAP\n", rcode, rcode, HZbm, HZbm, HZbm);
	    WriteBitmap(p,isodd,oddbyte,nibbles,n); 
	    printf("ENDCHAR\n");
	}
    }
    printf("ENDFONT\n");
    fprintf(stderr,"Total characters: %d\n", total);
    fprintf(stderr,"Total non-empty characters: %d\n", ntotal);
}
