/*
 * |-----------------------------------------------------------|
 * | Copyright (c) 1990 MIPS Computer Systems, Inc.            |
 * | All Rights Reserved                                       |
 * |-----------------------------------------------------------|
 * |          Restricted Rights Legend                         |
 * | Use, duplication, or disclosure by the Government is      |
 * | subject to restrictions as set forth in                   |
 * | subparagraph (c)(1)(ii) of the Rights in Technical        |
 * | Data and Computer Software Clause of DFARS 52.227-7013.   |
 * |         MIPS Computer Systems, Inc.                       |
 * |         928 Arques Avenue                                 |
 * |         Sunnyvale, CA 94086                               |
 * |-----------------------------------------------------------|
 */
/* $Header: idtab.h,v 1.6.4.2 90/05/10 06:22:16 wje Exp $ */

#ifndef	_SYS_IDTAB_
#define	_SYS_IDTAB_	1


/*	Copyright (c) 1984 AT&T	*/
/*	  All Rights Reserved  	*/

/*	THIS IS UNPUBLISHED PROPRIETARY SOURCE CODE OF AT&T	*/
/*	The copyright notice above does not evidence any   	*/
/*	actual or intended publication of such source code.	*/

/*
 *
 *    defines for uid/gid translation.
 *
 */
#define MAXSNAME	20
#define OTHERID		MAXUID+1
#define CFREE		0
#define CINUSE		1
#define CINTER		2
#define GLOBAL_CH	'.'	/* name of the "global" table	*/
#define UID_DEV		0	/* minor device number for uid device	*/
#define	GID_DEV		1	/* minor device number for gid device	*/
#define UID_MAP		UID_DEV
#define GID_MAP		GID_DEV

struct idtab	{
	unsigned short	i_rem;
	unsigned short	i_loc;
};
#define i_defval i_rem
#define i_tblsiz i_loc

struct idhead {
	unsigned short	i_default;
	unsigned short	i_size;
	unsigned short	i_cend;
	unsigned short	i_next;
	unsigned long	i_tries;
	unsigned long	i_hits;
};
#define HEADSIZE	(sizeof(struct idhead)/sizeof(struct idtab))
#ifdef INKERNEL
extern ushort	glid();
extern char	rfheap[];
extern int	rfsize;

#define	gluid(a,b)	glid(UID_DEV,a,b)
#define glgid(a,b)	glid(GID_DEV,a,b)
#endif

#endif
