/*ident	"@(#)C++env:incl-master/proto-headers/stdio.h	1.3" */

#ifndef __STDIO_H
#define __STDIO_H

#ifndef __ERRNO_H
#include <errno.h>
#endif

#define putspent ______putspent
#define fgetspent ______fgetspent

#define ctermid ______ctermid
#define cuserid ______cuserid
#define fdopen ______fdopen
#define fopen ______fopen
#define freopen ______freopen
#define fgets ______fgets
#define ftell ______ftell
#define gets ______gets
#define popen ______popen
#define rewind ______rewind
#define setbuf ______setbuf
#define tempnam ______tempnam
#define tmpfile ______tmpfile
#define tmpnam ______tmpnam
#define sprintf ______sprintf
#define fclose ______fclose
#define fflush ______fflush
#define fgetc ______fgetc
#define fprintf ______fprintf
#define fputc ______fputc
#define fputs ______fputs
#define fread ______fread
#define fscanf ______fscanf
#define fseek ______fseek
#define fwrite ______fwrite
#define getw ______getw
#define pclose ______pclose
#define printf ______printf
#define puts ______puts
#define putw ______putw
#define scanf ______scanf
#define setvbuf ______setvbuf
#define sscanf ______sscanf
#define system ______system
#define ungetc ______ungetc
#define utmpname ______utmpname
#define vfprintf ______vfprintf
#define vprintf ______vprintf
#define vsprintf ______vsprintf

/* need stddef.h for size_t */
#ifndef __STDDEF_H
#include <stddef.h>
#endif

#ifdef NULL
#undef NULL
#endif

/* --------------------------------------------------- */
/* | Copyright (c) 1986 MIPS Computer Systems, Inc.  | */
/* | All Rights Reserved.                            | */
/* --------------------------------------------------- */
/* $Header: stdio.h,v 1.10 88/03/30 15:15:15 dce Exp $ */

#ifndef	_STDIO_
#define	_STDIO_	1


/*	Copyright (c) 1984 AT&T	*/
/*	  All Rights Reserved  	*/

/*	THIS IS UNPUBLISHED PROPRIETARY SOURCE CODE OF AT&T	*/
/*	The copyright notice above does not evidence any   	*/
/*	actual or intended publication of such source code.	*/

#ifndef _NFILE
#define _NFILE	100

#if __u370__
#define BUFSIZ	4096
#endif
#if __vax__ || __u3b__ || __M32__ || __u3b15__ || __u3b5__ || __u3b2__ || __mips__
#define BUFSIZ	1024
#endif
#if __pdp11__
#define BUFSIZ	512
#endif

/* buffer size for multi-character output to unbuffered files */
#define _SBFSIZ 8

typedef struct {
#if __vax__ || __u3b__ || __M32__ || __u3b15__ || __u3b5__ || __u3b2__ || __mips__
	int	_cnt;
	unsigned char	*_ptr;
#else
	unsigned char	*_ptr;
	int	_cnt;
#endif
	unsigned char	*_base;
	char	_flag;
	char	_file;
} FILE;

/*
 * _IOLBF means that a file's output will be buffered line by line
 * In addition to being flags, _IONBF, _IOLBF and _IOFBF are possible
 * values for "type" in setvbuf.
 */
#define _IOFBF		0000
#define _IOREAD		0001
#define _IOWRT		0002
#define _IONBF		0004
#define _IOMYBUF	0010
#define _IOEOF		0020
#define _IOERR		0040
#define _IOLBF		0100
#define _IORW		0200

#ifndef NULL
		#undef NULL
#define NULL		0
#endif
#ifndef EOF
#define EOF		(-1)
#endif

#define stdin		(&_iob[0])
#define stdout		(&_iob[1])
#define stderr		(&_iob[2])

#define _bufend(p)	_bufendtab[(p)->_file]
#define _bufsiz(p)	(_bufend(p) - (p)->_base)

#ifndef lint
#define getc(p)		(--(p)->_cnt < 0 ? _filbuf(p) : (int) *(p)->_ptr++)
#define putc(x, p)	(--(p)->_cnt < 0 ? \
			_flsbuf((unsigned char) (x), (p)) : \
			(int) (*(p)->_ptr++ = (unsigned char) (x)))
#define getchar()	getc(stdin)
#define putchar(x)	putc((x), stdout)
#define clearerr(p)	((void) ((p)->_flag &= ~(_IOERR | _IOEOF)))
#define feof(p)		((p)->_flag & _IOEOF)
#define ferror(p)	((p)->_flag & _IOERR)
#define fileno(p)	(p)->_file
#endif

extern FILE	_iob[];
extern FILE	*fopen(), *fdopen(), *freopen(), *popen(), *tmpfile();
extern long	ftell();
extern void	rewind(), setbuf();
extern char	*ctermid(), *cuserid(), *fgets(), *gets(), *tempnam(), *tmpnam();
extern int	fclose(), fflush(), fread(), fwrite(), fseek(), fgetc(),
		getw(), pclose(), printf(), fprintf(), sprintf(),
		vprintf(), vfprintf(), vsprintf(), fputc(), putw(),
		puts(), fputs(), scanf(), fscanf(), sscanf(),
		setvbuf(), system(), ungetc();
extern unsigned char *_bufendtab[];

#define L_ctermid	9
#define L_cuserid	9
#define P_tmpdir	"/usr/tmp/"
#define L_tmpnam	(sizeof(P_tmpdir) + 15)
#endif

#endif
 

#undef utmpname
#undef cuserid
#undef scanf
#undef tempnam
#undef fscanf
#undef ungetc
#undef pclose
#undef fseek
#undef fgetspent
#undef ftell
#undef fputc
#undef fopen
#undef sscanf
#undef printf
#undef putspent
#undef fgetc
#undef freopen
#undef tmpnam
#undef popen
#undef fdopen
#undef vprintf
#undef fwrite
#undef fflush
#undef vfprintf
#undef rewind
#undef fprintf
#undef vsprintf
#undef fputs
#undef fread
#undef sprintf
#undef ctermid
#undef system
#undef fgets
#undef puts
#undef tmpfile
#undef putw
#undef gets
#undef fclose
#undef setvbuf
#undef getw
#undef setbuf

extern "C" {
	int _filbuf(FILE *);
	int fclose(FILE *);
	FILE *fdopen(int, const char *);
	int fflush(FILE *);
	int fgetc(FILE *);
	char *fgets(char *, int, FILE *);
	FILE *fopen(const char *, const char *);
	int fprintf(FILE *, const char * ...);
	int fputc(int, FILE *);
	int fputs(const char *, FILE *);
	FILE *freopen(const char *, const char *, FILE *);
	int fscanf(FILE *, const char * ...);
	int fseek(FILE *, long, int);
	long ftell(const FILE *);
	char *gets(char *);
	int getw(FILE *);
	int pclose(FILE *);
	FILE *popen(const char *, const char *);
	int printf(const char * ...);
	int puts(const char *);
	int putw(int, FILE *);
	void rewind(FILE *);
	int scanf(const char * ...);
	void setbuf(FILE *, char *);
	int sscanf(const char *, const char * ...);
	int ungetc(int, FILE *);
	int setvbuf(FILE *, char *, int, size_t);
	FILE *tmpfile();
	int putspent(struct spwd *, FILE*);
	struct spwd *fgetspent(FILE *);
	int _flsbuf(unsigned, FILE *);
        int fread(void *, int, int, FILE *);
        int fwrite(const void *, int, int, FILE *);
	int sprintf(char *, const char * ...);
}

/* ANSI C says tmpnam belongs in stdio.h. It is also declared in stdlib.h */

extern "C" {
	char *tmpnam(char*);  
}

#endif
