/*ident	"@(#)C++env:incl-master/const-headers/stdarg.h	1.3" */
/**************************************************************************
			Copyright (c) 1984 AT&T
	  		  All Rights Reserved  	

	THIS IS UNPUBLISHED PROPRIETARY SOURCE CODE OF AT&T
	
	The copyright notice above does not evidence any   	
	actual or intended publication of such source code.

*****************************************************************************/
/* stdarg.h */
/* ADAPTED FROM: */
/*	@(#)varargs.h	1.2	*/

#ifndef STDARGH
#define STDARGH

/*
	USAGE:
		f( arg-declarations ... ) {
			va_list ap;
			va_start(ap, parmN);	/* parmN == last named arg*/
			/* ...*/
			type arg = va_arg(ap, type);
			/* ...*/
			va_end(ap);
		}
*/

typedef char *va_list;
#define va_end(list)

#ifdef __host_mips__
#define va_start(list, parmN) (list = \
	(char *) (sizeof(parmN) > 4 ? ((int)&parmN + 2*8 - 1) & -8 \
				    : ((int)&parmN + 2*4 - 1) & -4))

#define va_arg(list, mode) ((mode *)(list = \
	(char *) (sizeof(mode) > 4 ? ((int)list + 2*8 - 1) & -8 \
				   : ((int)list + 2*4 - 1) & -4)))[-1]
#endif

#endif
