/*ident	"@(#)C++env:incl-master/proto-headers/search.h	1.1" */

#ifndef __SEARCH_H
#define __SEARCH_H

#define bsearch ______bsearch
#define hcreate ______hcreate
#define hdestroy ______hdestroy
#define hsearch ______hsearch
#define lfind ______lfind
#define lsearch ______lsearch
#define tdelete ______tdelete
#define tfind ______tfind
#define tsearch ______tsearch
#define twalk ______twalk

/* --------------------------------------------------- */
/* | Copyright (c) 1986 MIPS Computer Systems, Inc.  | */
/* | All Rights Reserved.                            | */
/* --------------------------------------------------- */
/* $Header: search.h,v 1.7 88/01/22 13:34:01 dce Exp $ */

#ifndef	_SEARCH_
#define	_SEARCH_	1


/*	Copyright (c) 1984 AT&T	*/
/*	  All Rights Reserved  	*/

/*	THIS IS UNPUBLISHED PROPRIETARY SOURCE CODE OF AT&T	*/
/*	The copyright notice above does not evidence any   	*/
/*	actual or intended publication of such source code.	*/

/* HSEARCH(3C) */
typedef struct entry { char *key, *data; } ENTRY;
typedef enum { FIND, ENTER } ACTION;

/* TSEARCH(3C) */
typedef enum { preorder, postorder, endorder, leaf } VISIT;

#endif
 

#undef tdelete
#undef hsearch
#undef lfind
#undef hcreate
#undef bsearch
#undef hdestroy
#undef tfind
#undef tsearch
#undef twalk
#undef lsearch

extern "C" {
    /* BSEARCH(3C) */
	void *bsearch(const void *, void *, unsigned, unsigned, int(*)(const void *, const void *));

    /* HSEARCH(3C) */
	ENTRY *hsearch(ENTRY, ACTION);
	int hcreate(unsigned);
	void hdestroy();

    /* TSEARCH(3C) */
	void *tsearch(const void*, void**, int(*)(const void *, const void *));
	void *tfind(const void*, void**, int(*)(const void *, const void *));
	void *tdelete(const void*, void**, int(*)(const void *, const void *));
	void twalk(void*,void (*)(void *, VISIT, int));

    /* LSEARCH(3C) */
	void *lsearch(const void *, void *, unsigned *, unsigned, int(*)(const void *, const void *));
	void *lfind(const void *, void *, unsigned *, unsigned, int(*)(const void *, const void *));
}

#endif
