#ifndef __RCOMPLEX_H__
#define __RCOMPLEX_H__

/*
 * rcomplex.h --- Declarations for the Rogue Wave complex class DComplex
 *
 * $Id: rcomplex.h,v 3.4.2.1 90/10/22 15:52:30 keffer Rel $
 *
 ****************************************************************************
 *
 * Rogue Wave 
 * P.O. Box 2328
 * Corvallis, OR 97339
 *
 * Copyright (C) 1989. This software is subject to copyright protection under 
 * the laws of the United States and other countries.
 *
 ***************************************************************************
 *
 */

STARTWRAP
#include <math.h>
ENDWRAP

class istream;
class ostream;

class DComplex {
	double	re, im;
public:
	DComplex()                    {re=0; im=0;}
	DComplex(double r)            {re=r; im=0; }
	DComplex(double r, double i)  {re=r; im=i; }

	/* Following 3 lines should not be necessary, but*/
	/* the class a bug in the Zortech optimizer requires them:*/
	DComplex(const DComplex& c)   {re=c.re; im=c.im;}
	DComplex& operator=(const DComplex&);
	DComplex& operator=(double);

	friend	double	real(const DComplex& a) {return a.re;}
	friend	double	imag(const DComplex& a) {return a.im;}

	friend	double	abs(DComplex);
	friend  double  norm(DComplex);
	friend  double	arg(DComplex);
	friend  DComplex conj(DComplex a){
	  return DComplex(a.re, -a.im);
	}
	friend  DComplex cos(DComplex);
	friend  DComplex cosh(DComplex);
	friend	DComplex exp(DComplex);
	friend  DComplex log(DComplex);
	friend  DComplex pow(double, DComplex);
	friend	DComplex pow(DComplex, int);
	friend	DComplex pow(DComplex, double);
	friend	DComplex pow(DComplex, DComplex);
	friend  DComplex polar(double, double = 0);
	friend  DComplex sin(DComplex);
	friend  DComplex sinh(DComplex);
	friend	DComplex sqrt(DComplex);

	friend	DComplex	operator+(DComplex a1, DComplex a2)
	  { return DComplex(a1.re+a2.re, a1.im+a2.im); }
	friend	DComplex	operator+(double s, DComplex a2)
	  { return DComplex(s+a2.re, a2.im); }
	friend	DComplex	operator+(DComplex a1, double s)
	  { return DComplex(a1.re+s, a1.im); }
	friend	DComplex	operator-(DComplex a)
	  { return DComplex(-a.re, -a.im); }
	friend	DComplex operator-(DComplex a1, DComplex a2)
	  { return DComplex(a1.re-a2.re, a1.im-a2.im); }
	friend	DComplex operator-(double s, DComplex a2)
	  { return DComplex(s-a2.re, -a2.im); }
	friend	DComplex operator-(DComplex a1, double s)
	  { return DComplex(a1.re-s, a1.im); }
	friend	DComplex operator*(DComplex, DComplex);
	friend	DComplex operator*(DComplex, double);
	friend	DComplex operator*(double, DComplex);
	friend 	DComplex operator/(DComplex, DComplex);
	friend 	int	operator==(DComplex a, DComplex b)
	  { return (a.re==b.re && a.im==b.im); }
	friend 	int	operator!=(DComplex a, DComplex b)
	  { return (a.re!=b.re || a.im!=b.im); }
	
	void operator+=(DComplex);            
	void operator-=(DComplex);
	void operator*=(DComplex);
	void operator/=(DComplex);

	friend  ostream& operator<<(ostream&, DComplex);
	friend  istream& operator>>(istream&, DComplex&);
};

/* Assignment operators:*/
inline DComplex&
DComplex::operator=(const DComplex& c)
{
  re=c.re; im=c.im;
  return *this;
}

inline DComplex&
DComplex::operator=(double d)
{
  re=d; im=0;
  return *this;
}

/* multiplication of DComplex * DComplex*/
inline DComplex  operator*(DComplex a1, DComplex a2)
{
  return DComplex( (a1.re*a2.re-a1.im*a2.im), 
	(a1.re*a2.im+a1.im*a2.re) );
}

/* multiplication of DComplex * double*/
inline DComplex
operator*(DComplex a, double s)
{
  return DComplex( s*a.re, s*a.im );
}

/* multiplication of double * DComplex*/
inline DComplex
operator*(double s, DComplex a)
{
  return DComplex( s*a.re, s*a.im );
}

inline void
DComplex::operator+=(DComplex a)
{
  re += a.re;
  im += a.im;
}

inline void
DComplex::operator-=(DComplex a)
{
  re -= a.re;
  im -= a.im;
}

#endif /* __RCOMPLEX_H__ */
