#ifndef __RAND_GAMMA_H__
#define __RAND_GAMMA_H__

/*
 * Declarations for RandBinomial: Gamma distributed random numbers.
 *
 * $Id: randgama.h,v 3.4.2.1 90/10/22 15:52:25 keffer Rel $
 *
 ****************************************************************************
 *
 * Rogue Wave 
 * P.O. Box 2328
 * Corvallis, OR 97339
 *
 * Copyright (C) 1989. This software is subject to copyright protection under 
 * the laws of the United States and other countries.
 *
 ***************************************************************************
 *
 */

#include "randunif.h"

class RandGamma : public RandUniform {
protected:
  unsigned 		orderOfDistribution;
public:
  RandGamma(unsigned i)		: RandUniform()  {orderOfDistribution = i;}
  RandGamma(unsigned n, unsigned i)	: RandUniform(n) {orderOfDistribution = i;}
 
  unsigned 		order() Const {return orderOfDistribution;}

  double    		randValue();           /* Return a random number */
  void    		randValue(double*, unsigned n);	/* Return an array of random numbers.*/
  DoubleVec 		randValue(unsigned n); /* Return a vector of n random numbers */
  DGEMatrix 		randValue(unsigned nr, unsigned nc);  /* Return a matrix of random numbers*/
};
  
#endif
                                

