#ifndef __RAND_EXP_H__
#define __RAND_EXP_H__

/*
 * Declarations for RandBinomial: Exponentially distributed random numbers.
 *
 * $Id: randexp.h,v 3.4.2.1 90/10/22 15:52:24 keffer Rel $
 *
 ****************************************************************************
 *
 * Rogue Wave 
 * P.O. Box 2328
 * Corvallis, OR 97339
 *
 * Copyright (C) 1989. This software is subject to copyright protection under 
 * the laws of the United States and other countries.
 *
 ***************************************************************************
 *
 */

#include "randunif.h"
STARTWRAP
#include <math.h>
ENDWRAP

class RandExp : public RandUniform {
public:
  RandExp()		: RandUniform()  { }
  RandExp(unsigned n)	: RandUniform(n) { }
 
  double    		randValue() {return -(::log(RandUniform::randValue()));}
  void    		randValue(double*, unsigned n);	/* Return an array of random numbers.*/
  DoubleVec 		randValue(unsigned n); 
  DGEMatrix 		randValue(unsigned nr, unsigned nc);
};

#endif
  

