#ifndef __RAND_BINOMIAL_H__
#define __RAND_BINOMIAL_H__

/*
 * Declarations for RandBinomial: Binomially distributed random numbers.
 *
 * $Id: randbino.h,v 3.4.2.1 90/10/22 15:52:23 keffer Rel $
 *
 ****************************************************************************
 *
 * Rogue Wave 
 * P.O. Box 2328
 * Corvallis, OR 97339
 *
 * Copyright (C) 1989. This software is subject to copyright protection under 
 * the laws of the United States and other countries.
 *
 ***************************************************************************
 *
 */

#include "randunif.h"

class RandBinomial : public RandUniform {
private:		/* Private data used in the algorithms.*/
  double 		prb, g, am, pc, plog, pclog, sq;
protected:
  unsigned 		tries;
  double   		prob;
public:
  RandBinomial(unsigned Ntries, double probability);            
  RandBinomial(unsigned n, unsigned Ntries, double probability);            
 
  unsigned  		trials()  Const		{return tries;}
  double    		probability() Const	{return prob;}
  void      		setTrials(unsigned Ntries);
  void      		setProbability(double probability);

  double    		randValue();			/* Return a random number.*/
  void     		randValue(double*, unsigned n);	/* Return an array of random numbers.*/
  DoubleVec 		randValue(unsigned n);		/* Return a vector of n random numbers.*/
  DGEMatrix 		randValue(unsigned nr, unsigned nc); /* Return a matrix of random numbers*/

};

#endif

