#ifndef __LEAST_SQUARE_FIT__
#define __LEAST_SQUARE_FIT__

/*
 * Declarations for class LeastSqFit: linear least squares fit.
 *
 * $Id: lsqfit.h,v 3.4.2.1 90/10/22 15:52:21 keffer Rel $
 *
 ****************************************************************************
 *
 * Rogue Wave 
 * P.O. Box 2328
 * Corvallis, OR 97339
 * 
 * Copyright (C) 1989. This software is subject to copyright protection under 
 * the laws of the United States and other countries.
 * 
 ***************************************************************************
 *
 */

#include "dvec.h"

class LeastSqFit {
private:
   unsigned 		npts;
protected:
   double 		LSq_slope;
   double 		LSq_intercept;
   double 		SD_slope;
   double 		SD_intercept;
   double 		correlation_coeff;
public:
   /* Construct least squares fit without weights:*/
   LeastSqFit(const DoubleVec& x, const DoubleVec& y);
   /* Construct least squares fit with weights:*/
   LeastSqFit(const DoubleVec& x, const DoubleVec& y, const DoubleVec& sigmay);   

   double 		correlationCoeff() 	Const	{return correlation_coeff;}
   double 		intercept()        	Const	{return LSq_intercept;}
   double 		interceptStandardDev()  Const	{return SD_intercept;}
   double 		slope()	 		Const	{return LSq_slope;}
   double 		slopeStandardDev() 	Const	{return SD_slope;}
   double 		xPosition(double y)  	Const	{return (y-LSq_intercept)/LSq_slope;}
   double 		yPosition(double x) 	Const	{return x*LSq_slope+LSq_intercept;} 
   unsigned		binaryStoreSize() 		Const;	/* Storage requirements.*/
  
friend ostream&		operator<<(ostream&, const LeastSqFit&);  /* prints a summary*/
};

#endif
