#ifndef __FLUDECOMP_H__
#define __FLUDECOMP_H__

/*
 * Declarations for Float LU Decomposition
 *
 * $Id: fludecmp.h,v 3.4.2.1 90/10/22 15:52:14 keffer Rel $
 *
 ****************************************************************************
 *
 * Rogue Wave 
 * P.O. Box 2328
 * Corvallis, OR 97339
 *
 * Copyright (C) 1989. This software is subject to copyright protection under 
 * the laws of the United States and other countries.
 *
 ***************************************************************************
 *
 */

#include "fgemat.h"

class FLUDecomp {
  FGEMatrix 		theLUdecomposition;
  int*			ipvt;	/* Pivot indices*/
  int			info;
  int			the_order;
protected:
  void			assertSquare(const FGEMatrix&) Const;
  void			assertDefined() Const;
  void			assertPivots() Const;
  void			assertOrder(unsigned) Const;
public:
  FLUDecomp(const FGEMatrix&);
  ~FLUDecomp();

  unsigned		order() Const  {return (unsigned)the_order;}
  int			isSingular() Const;
  unsigned		binaryStoreSize() Const;		/* Storage requirements.*/

  /* Matrix algebra declarations:*/

friend Float		determinant(const FLUDecomp&);
friend FGEMatrix	inverse(const FLUDecomp&);
friend FloatVec		solve(const FLUDecomp&, const FloatVec&);

};

/*	Declarations for Float LINPACK and BLAS routines.*/

/* special absolute value function for linpack complex*/
Inline Float ABS1 (Float a) {return ABS(a);} 

#endif /* __FLUDECOMP_H__ */
