#ifndef __COMPILER_H__
#define __COMPILER_H__

/*
 * Compiler related directives
 *
 * $Id: compiler.h,v 3.1.1.4 90/10/22 15:47:54 keffer Rel $
 *
 ****************************************************************************
 *
 * Rogue Wave 
 * P.O. Box 2328
 * Corvallis, OR 97339
 *
 * Copyright (C) 1989. This software is subject to copyright protection under 
 * the laws of the United States and other countries.
 *
 ***************************************************************************
 *
 * This file depends on a manifest constant being present for your compiler.
 * Most compilers have one built in.  For others, you will have to supply
 * one by using a -D flag:
 *
 *   AT&T Version 1.2:			-D__ATT1__
 *   AT&T Version 2.X:			-D__ATT2__
 *   Glockenspiel:			-D__GLOCK__
 *   Oregon (early versions only):	-D__OREGON__
 *
 * There are a few other constants you may have to define or undefine.
 */

/************************************************************************/

/*
 * Depending on your compiler, you may or may not have to uncomment
 * one of the following:
 */

/* #define SYSV 1 */		/* For System V Unix */
/* #define BSD 1 */		/* For Berkeley Unix */
/* #define __MSDOS__ 1 */	/* For MS-DOS */

/************************************************************************/

/*
 * Uncomment the following if your compiler has trouble with
 * base class access adjustments using the "::baseFunctionName;" 
 * construct (early versions of cfront ca. Summer '89):
 */

/* #define NO_ACCESS_ADJUSTMENT 1 */

/************************************************************************/

/*
 * Uncomment the following if your compiler is using Microsoft C
 * as a backend (e.g., Glockenspiel under MS-DOS).
 */

/* #define MSC_BACKEND 1 */

/*************************************************************************
**************************************************************************
**									**
**		From here on, it's pretty much boilerplate		**
**		and rarely requires any tuning.				**
**									**
**************************************************************************
**************************************************************************/


#if defined(MSDOS) && !defined(__MSDOS__)
#  define __MSDOS__ 1
#endif

/****************** Various Glockenspiel foibles. ***********************/

#if defined(__GLOCK__)

  /* We assume Glockenspiel folks are using Version 2.0*/
#  define __ATT2__ 1

  /* We assume that if the Glock folks are running under MS-DOS,*/
  /* then they're using Microsoft C as the backend:*/
#  if defined(__MSDOS__) && !defined(MSC_BACKEND)
#    define MSC_BACKEND 1
#  endif

  /* Glock has bug in base class access adjustments:*/
#  ifndef NO_ACCESS_ADJUSTMENT
#    define NO_ACCESS_ADJUSTMENT 1
#  endif

  /* Glock emits "const structs", then attempts to assign to them:*/
#  define CONST_EMIT_BUG 1

   /*
    * Glockenspiel was too lazy to provide type-safe linkage include
    * files, preferring to use the backend C compiler include files.
    * These require a "C" wrapper:
    */
#  define STARTWRAP	extern "C" {
#  define ENDWRAP	}

#else	/* Not Glock */

#  define STARTWRAP
#  define ENDWRAP

#endif

/********************** Various Zortech foibles **************************/

#if defined(__ZTC__)

   /* Define __MSDOS__ for Zortech (already defined for TC++)*/
#  if !defined(__MSDOS__)
#    define __MSDOS__ 1
#  endif

   /* Rename Pi for Zortech:*/
#  define M_PI  PI

#if __ZTC__ < 0x0210
   /* Early Zortech had bug in pointers to overloaded functions:*/
#  define POINTER_TO_OVERLOAD_BUG 1
   /* Early Zortech did not have unary plus:*/
#  define NO_UNARY_PLUS 1
#endif

   /* Zortech has a type conversion bug:*/
#  define ZTC_TYPE_CONVERSION_BUG 1

   /* Zortech takes "constness" too literally:*/
#  define PARANOID_CONST_BUG 1

#endif

/********************** Borland's Turbo C++ **************************/

#if defined(__TURBOC__)

   /* Turbo C++ V1.00 forgets the segment address when passing */
   /* a class as a far reference if the class has not been defined.*/
#  if __TURBOC__ <= 0x0295
#    define UNDEFINED_REFERENCE_BUG 1
#  endif

   /*
    * Turbo won't inline code with while loops or
    * that generate temporaries requiring destructors:
    */
#  define NO_INLINED_WHILES 1
#  define NO_INLINED_TEMP_DESTRUCTORS 1

   /* Turbo C++ left out this definition:*/
#  define name2 _Paste2

#endif

/********************** Oregon Software C++ ***************************/

#if defined(_OREGON_) && !defined(__OREGON__)

   /* Early version of Oregon use single underscore:*/
#  define __OREGON__ _OREGON_

#endif

/********************** Miscellaneous *********************************/

/* Either version 1 or 2 defines AT&T compatible compiler*/
#if defined(__ATT1__) || defined(__ATT2__)
#  define __ATT__ 1
#endif

/* Version 2 compilers require extern "C" declarations*/
/* and "const" member functions.*/
#if defined(__ATT1__)
   /* Not version 2 compatible*/
#  define Cdecl
#  define Fdecl
#  define Const
#  define NEEDS_OVERLOAD	1
#  define NO_OVERLOAD_NEW	1
#else
   /* Version 2 compatible:*/
#  define Cdecl			"C"
#  define Fdecl			"C"
#  define MULTIPLE_INHERITANCE	1
#  define TYPE_SAFE_LINKAGE	1
#  define Const			const
#endif

/* No Pi for these compilers:*/
#if defined(MSC_BACKEND) || defined(__OREGON__)
#  ifndef M_PI
#    define M_PI 3.14159265358979323846
#  endif
#endif

/*
 * With these compilers, a friend class is not considered to have
 * access to a private base class.
 */
#if defined(__GNUG__) || defined(__ATT__)
#  define NO_FRIENDLY_CLASS_ACCESS_TO_BASECLASS 1
#endif

/*
 * With these compilers, a friend function is not considered to have
 * access to a private base class.
 */
#if defined(__GNUG__) || defined(__ATT1__)
#  define NO_FRIENDLY_ACCESS_TO_BASECLASS 1
#endif

/*
 * These compilers allow a reference to be recast to something 
 * else.
 */
#if defined(__TURBOC__) || (defined(__ZTC__) && __ZTC__ > 0x206)
#  define HAS_CAST_TO_REFERENCE 1
#endif

/*
 * With these compilers, a formal argument of type "char"
 * exactly matches a formal argument of type "unsigned char".
 */
#ifdef __OREGON__
#  define CHAR_MATCHES_UCHAR 1
#endif

/*
 * With these compilers, a member function declared "const" is
 * considered different from one without the "const" modifier.
 */
#if defined(__GNUG__) || defined(__ATT2__) || defined(__OREGON__) || defined(__TURBOC__)
#  define CONST_OVERLOADS 1
#endif

/*
 * These compilers have new-style iostreams available.
 */
#if defined(__GNUG__) || defined(__ATT2__) || defined(__OREGON__) || defined(__TURBOC__)
#  define HAS_IOSTREAMS	1
#endif

/*
 * All known compilers have old-style streams:
 */
#define HAS_STREAMS	1

#endif /* __COMPILER_H__ */
