#ifndef __CLUDECOMP_H__
#define __CLUDECOMP_H__

/*
 * Declarations for DComplex LU Decomposition
 *
 * $Id: cludecmp.h,v 3.4.2.1 90/10/22 15:52:00 keffer Rel $
 *
 ****************************************************************************
 *
 * Rogue Wave 
 * P.O. Box 2328
 * Corvallis, OR 97339
 *
 * Copyright (C) 1989. This software is subject to copyright protection under 
 * the laws of the United States and other countries.
 *
 ***************************************************************************
 *
 */

#include "cgemat.h"

class CLUDecomp {
  CGEMatrix 		theLUdecomposition;
  int*			ipvt;	/* Pivot indices*/
  int			info;
  int			the_order;
protected:
  void			assertSquare(const CGEMatrix&) Const;
  void			assertDefined() Const;
  void			assertPivots() Const;
  void			assertOrder(unsigned) Const;
public:
  CLUDecomp(const CGEMatrix&);
  ~CLUDecomp();

  unsigned		order() Const  {return (unsigned)the_order;}
  int			isSingular() Const;
  unsigned		binaryStoreSize() Const;		/* Storage requirements.*/

  /* Matrix algebra declarations:*/

friend DComplex		determinant(const CLUDecomp&);
friend CGEMatrix	inverse(const CLUDecomp&);
friend DComplexVec	solve(const CLUDecomp&, const DComplexVec&);

};

/*
 * Special absolute value function for linpack complex;
 * Linpack defines the absolute value of a complex number as 
 * abs(re) + abs(im) instead of  sqrt( re*re + im*im ):
 */

Inline  Double 
ABS1 (DComplex a) {return(ABS(real(a))+ABS(imag(a)));}

#endif /* __CLUDECOMP_H__ */
