#ifndef __CFFT2D_H__
#define __CFFT2D_H__

/*
 * Double Precision 2-Dimensional Complex FFT server
 *
 * $Id: cfft2d.h,v 3.4.2.1 90/10/22 15:51:58 keffer Rel $
 *
 ****************************************************************************
 *
 * Rogue Wave 
 * P.O. Box 2328
 * Corvallis, OR 97339
 *
 * Copyright (C) 1989	This software is subject to copyright protection under 
 * the laws of the United States and other countries.
 *
 ***************************************************************************
 *
 */

#include "cfft.h"
#include "cgemat.h"
     
class DComplexFFT2DServer {
  DComplexFFTServer	FFTrow;
  DComplexFFTServer	FFTcol;
  unsigned		Nrows;
  unsigned		Ncols;
public:
  /* Constructors*/
  DComplexFFT2DServer();
  DComplexFFT2DServer(unsigned nrows, unsigned ncols);
  DComplexFFT2DServer(unsigned nrows);		/* Assumes square matrix*/
  DComplexFFT2DServer(const DComplexFFT2DServer&);

  /* Assignment  */
  void			  operator=(const DComplexFFT2DServer&);

  unsigned		rows() Const {return Nrows;}
  unsigned		cols() Const {return Ncols;}
  void			  setRows(unsigned);  /* set new Nrows*/
  void			  setCols(unsigned);  /* set new Ncols*/

  /* Returns DFT of a complex matrix:*/
  CGEMatrix		fourier(const CGEMatrix&);

  /* Returns IDFT of a complex matrix:*/
  CGEMatrix		ifourier(const CGEMatrix&);
};
#endif /* __CFFT2D_H__ */
