#ifndef __CFFT_H__
#define __CFFT_H__

/*
 * Double Precision Complex FFT server
 *
 * $Id: cfft.h,v 3.4.2.1 90/10/22 15:51:57 keffer Rel $
 *
 ****************************************************************************
 * 
 * Rogue Wave 
 * P.O. Box 2328
 * Corvallis, OR 97339
 *
 * Copyright (C) 1989	This software is subject to copyright protection under 
 * the laws of the United States and other countries.
 *
 ***************************************************************************
 *
 */

/*
 * This class does complex fourier transforms of a series of a specified
 * length.  It can serve as the nucleus by which to do a wide variety of
 * transforms and, indeed, is inherited by several other servers.  The
 * NCAR FFT routines are used to perform the actual calculations.  This
 * can easily be replaced by specialized hardware or another algorithm.
 * 
 * The DFT calculated is:
 * 
 *                N-1
 *         A(n) = sum X(j) exp(-2 * pi * n * j * I / N);      n=0,...,N-1
 *                j=0
 * 
 * The IDFT calculated is similar:
 * 
 *                N-1
 *         X(j) = sum A(n) exp( 2 * pi * n * j * I / N);      j=0,...,N-1
 *                n=0
 * 
 * where A and X are complex.  Note that the sum is NOT normalized: a
 * call to fourier(), followed by a call to ifourier() will result in
 * the original series multiplied by N.
 * 
 * It precalculates the weights necessary to do the transform.  If it is
 * handed a series of a different length, it will reconfigure, an
 * expensive calculation.  Hence, it is most efficient to call it
 * repeatedly for series of the same length.  Construct several servers
 * to handle a variety of lengths.
 * 
 */

#include "cvec.h"

class DComplexFFTServer {
  unsigned		server_N;
  DComplexVec		the_weights;
  void			fourTrans(DComplex*, unsigned, DComplex*);
  unsigned		radix(unsigned);
  void			split(DComplex*, unsigned, unsigned, DComplex*);
  void			join(DComplex*, unsigned, unsigned, DComplex*);
public:
  DComplexFFTServer();
  DComplexFFTServer(unsigned oforder);
  DComplexFFTServer(const DComplexFFTServer&);

  void			operator=(const DComplexFFTServer&);

  unsigned		order() Const {return server_N;}
  void			setOrder(unsigned); /* Set new N*/

  /***********  TRANSFORMS ***********/

  /* Returns DFT of a complex sequence:*/
  DComplexVec		fourier(const DComplexVec&);

  /* Returns IDFT of a complex sequence:*/
  DComplexVec		ifourier(const DComplexVec&);
};

/* Other useful functions:*/
double			spectralVariance(const DComplexVec&);
#endif /* __CFFT_H__ */
